/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.PrepareRecord;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class PrepareJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = 5;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    public PrepareJob(Transaction transaction, TaskManager taskManager, WakeupManager wakeupManager, ClientLog clientLog, ParticipantHandle[] participantHandleArray) {
        super(taskManager, wakeupManager);
        if (clientLog == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: log is null");
        }
        this.log = clientLog;
        if (!(transaction instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)transaction;
        if (participantHandleArray == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (participantHandleArray.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = participantHandleArray;
    }

    Object doWork(TaskManager.Task task, Object object) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareJob.class.getName(), "doWork", new Object[]{task, object});
        }
        ParticipantHandle participantHandle = (ParticipantHandle)object;
        TransactionParticipant transactionParticipant = null;
        int n = participantHandle.getPrepState();
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareJob.class.getName(), "doWork", new Integer(n));
                }
                return new Integer(n);
            }
        }
        if (transactionParticipant == null) {
            transactionParticipant = participantHandle.getPreParedParticipant();
        }
        try {
            if (this.attempt(task) > this.maxtries) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareJob.class.getName(), "doWork", new Integer(6));
                }
                return new Integer(6);
            }
        }
        catch (JobException jobException) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
            }
            return null;
        }
        if (transactionParticipant == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
            }
            return null;
        }
        Integer n2 = null;
        try {
            n = transactionParticipant.prepare(this.tr.mgr, this.tr.id);
            n2 = new Integer(n);
        }
        catch (TransactionException transactionException) {
            n = 6;
            n2 = new Integer(n);
        }
        catch (RemoteException remoteException) {
        }
        catch (RuntimeException runtimeException) {
            n = 6;
            n2 = new Integer(n);
        }
        if (n2 != null) {
            block22: {
                participantHandle.setPrepState(n);
                try {
                    this.log.write(new PrepareRecord(participantHandle, n));
                }
                catch (LogException logException) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block22;
                    persistenceLogger.log(Level.WARNING, "Problem writing PrepareRecord.", logException);
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", n2);
            }
            return n2;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
        }
        return null;
    }

    TaskManager.Task[] createTasks() {
        TaskManager.Task[] taskArray = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            taskArray[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return taskArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object computeResult() throws JobException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareJob.class.getName(), "computeResult");
        }
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jobNotStartedException) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int n = 4;
        int n2 = 0;
        block7: for (int i = 0; i < this.results.length; ++i) {
            n2 = (Integer)this.results[i];
            switch (n2) {
                case 4: {
                    break;
                }
                case 6: {
                    n = 6;
                    break block7;
                }
                case 3: {
                    if (n != 4) break;
                    n = 3;
                }
            }
        }
        Integer n3 = new Integer(n);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareJob.class.getName(), "computeResult", n3);
        }
        return n3;
    }
}

