/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.vrd;

import com.mathworks.mde.licensing.borrowing.BorrowUI;
import com.mathworks.mde.vrd.LicenseActions;
import com.mathworks.mde.vrd.LicenseActionsFactory;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;

public class LicenseToolSetFactory {
    private static TSToolSet sToolSet = null;

    private LicenseToolSetFactory() {
    }

    public static TSToolSet getToolSet() {
        if (sToolSet == null) {
            sToolSet = new TSToolSet(new TSToolSetContents("license_toolset"));
        }
        return sToolSet;
    }

    public static void populateToolSet(ResourceBundle resourceBundle) {
        LicenseActions licenseActions;
        if (sToolSet == null) {
            LicenseToolSetFactory.getToolSet();
        }
        if ((licenseActions = LicenseActionsFactory.getLicenseActions()).isEnabled()) {
            TSToolSetContents tSToolSetContents = sToolSet.getContents();
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("licensing").setType(TSToolSetContents.ToolType.DROP_DOWN).setLabel(resourceBundle.getString("Tool.licensing.Label")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("help", "home_toolset").setReferenceToolName("terms_of_use").setReferenceToolSetName("home_toolset").setReferencePosition(TSToolSetContents.Position.BEFORE)});
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters().setType(TSToolSetContents.ToolType.SEPARATOR), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("help", "home_toolset").setReferenceToolName("licensing").setReferenceToolSetName("license_toolset")});
            for (Action action : licenseActions.getActions(resourceBundle)) {
                String string = (String)action.getValue("Name");
                tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setLabel(string), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("licensing")});
                sToolSet.configureAndAdd(string, action);
                if (!licenseActions.doesSeparatorFollow(action)) continue;
                tSToolSetContents.addSeparator(new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("licensing")});
            }
            if (BorrowUI.getInstance().isBorrowingEnabled()) {
                tSToolSetContents.addSeparator(new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("licensing")});
                tSToolSetContents.addTool(new TSToolSetContents.ToolParameters("borrow").setLabel(resourceBundle.getString("menuitem.LicenseBorrow")), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("licensing")});
                sToolSet.configureAndAdd("borrow", (Action)((Object)new BorrowAction()));
            }
        }
    }

    private static class BorrowAction
    extends MJAbstractAction {
        private BorrowAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = BorrowAction.getFrame((ActionEvent)actionEvent);
            if (frame != null) {
                GlobalCursor.setWait((Window)frame);
            }
            try {
                BorrowUI.getInstance().showGUI();
            }
            finally {
                if (frame != null) {
                    GlobalCursor.clear((Window)frame);
                }
            }
        }
    }
}

