/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.vrd;

import com.mathworks.mde.vrd.LicenseActions;
import com.mathworks.mde.vrd.NoOpLicenseActions;
import com.mathworks.mde.vrd.ProxyLicenseActions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class LicenseActionsFactory {
    private static final Logger LOG = Logger.getLogger(LicenseActionsFactory.class.getName());
    private static final String REAL_FACTORY_CLASS_NAME = "com.mathworks.webintegration.vrd.LicenseActionsFactory";
    private static Class realFactoryClass;
    private static Object realFactory;

    private LicenseActionsFactory() {
    }

    public static LicenseActions getLicenseActions() {
        LicenseActions licenseActions = new NoOpLicenseActions();
        try {
            Method method;
            if (realFactoryClass != null && (method = realFactoryClass.getMethod("getInstance", new Class[0])) != null) {
                Object object = method.invoke(realFactory, new Object[0]);
                licenseActions = new ProxyLicenseActions(object);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.fine(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.fine(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.fine(invocationTargetException.getMessage());
        }
        return licenseActions;
    }

    static {
        try {
            realFactoryClass = Class.forName(REAL_FACTORY_CLASS_NAME);
            realFactory = realFactoryClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            LOG.fine(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.fine(illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.fine(classNotFoundException.getMessage());
        }
    }
}

