/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.SearchPanelActionFactory;
import com.mathworks.mde.help.search.SearchResultsPanel;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public enum SearchPanelAction {
    HIDE_PREVIEWS("hide-previews"),
    SHOW_PREVIEWS("show-previews");

    private static SearchResultsPanel sPanel;
    private String fKeybindingId;
    private SearchPanelActionImpl fAction;

    private SearchPanelAction(String string2) {
        this.fKeybindingId = string2;
        this.fAction = new SearchPanelActionImpl();
    }

    public ExtendedAction getAction() {
        return this.fAction;
    }

    private Action getUnderlyingAction() {
        if (sPanel == null || sPanel.getResultsDisplay() == null) {
            return null;
        }
        SearchPanelActionFactory searchPanelActionFactory = sPanel.getResultsDisplay().getActionFactory();
        switch (this) {
            case HIDE_PREVIEWS: {
                return searchPanelActionFactory.getHidePreviewsAction();
            }
            case SHOW_PREVIEWS: {
                return searchPanelActionFactory.getShowPreviewsAction();
            }
        }
        return null;
    }

    public boolean isSupported() {
        return this.getUnderlyingAction() != null;
    }

    String getKeybindingId() {
        return this.fKeybindingId;
    }

    static void setResultsPanel(SearchResultsPanel searchResultsPanel) {
        sPanel = searchResultsPanel;
    }

    private class SearchPanelActionImpl
    extends MJAbstractAction {
        private SearchPanelActionImpl() {
            super(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchPanelAction.this.getUnderlyingAction() != null) {
                SearchPanelAction.this.getUnderlyingAction().actionPerformed(actionEvent);
            }
        }

        public boolean isEnabled() {
            return SearchPanelAction.this.getUnderlyingAction() != null && SearchPanelAction.this.getUnderlyingAction().isEnabled();
        }
    }
}

