/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.jmi.Matlab;
import com.mathworks.services.Prefs;

public class HelpBrowserSearchPrefs {
    private static final String MAX_SEARCH_RESULTS = "_MaxSearchResults";
    private static final int MAX_SEARCH_RESULTS_DEFAULT = 500;
    private static final String SHOW_SEARCH_HIGHLIGHTS = "ShowSearchPreviews";
    private static SearchPrefsDependencyProvider sDependencyProvider = new DefaultDependencyProvider();

    private HelpBrowserSearchPrefs() {
    }

    static int getMaxSearchResults() {
        return sDependencyProvider.isMatlabAvailable() ? Prefs.getIntegerPref((String)"Help_MaxSearchResults", (int)500) : 500;
    }

    static void setShouldShowHighlights(boolean bl) {
        if (sDependencyProvider.isMatlabAvailable()) {
            Prefs.setBooleanPref((String)"HelpShowSearchPreviews", (boolean)bl);
        }
    }

    static boolean shouldShowHighlights(boolean bl) {
        return !sDependencyProvider.isMatlabAvailable() || Prefs.getBooleanPref((String)"HelpShowSearchPreviews", (boolean)bl);
    }

    static boolean shouldShowHighlights() {
        return HelpBrowserSearchPrefs.shouldShowHighlights(false);
    }

    private static synchronized void setDependencyProvider(SearchPrefsDependencyProvider searchPrefsDependencyProvider) {
        sDependencyProvider = searchPrefsDependencyProvider;
    }

    private static synchronized SearchPrefsDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static class DefaultDependencyProvider
    implements SearchPrefsDependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public boolean isMatlabAvailable() {
            return Matlab.isMatlabAvailable();
        }
    }

    public static interface SearchPrefsDependencyProvider {
        public boolean isMatlabAvailable();
    }
}

