/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.help.ContentsTree;
import com.mathworks.mde.help.ContentsTreeUICallback;
import com.mathworks.mde.help.HelpBrowserStateManager;
import com.mathworks.mde.help.HelpBrowserToolBar;
import com.mathworks.mde.help.HelpLocator;
import com.mathworks.mde.help.HelpNavigator;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.SearchInputPanel;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.ClassicHelpPanel;
import com.mathworks.mlwidgets.help.HelpPanelAddressNavigation;
import com.mathworks.mlwidgets.help.HelpPanelBreadCrumbTrail;
import com.mathworks.mlwidgets.help.HelpPanelSyncEvent;
import com.mathworks.mlwidgets.help.HelpSyncListener;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsOrganizer;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class HelpBrowser
extends DTClientBase {
    private static HelpBrowser sHelpBrowser;
    private static final int NARROW_DISPLAY_WIDTH = 450;
    static final String CLASSIC_HELP_BROWSER_NAME = "Help";
    static final String CLASSIC_HELP_BROWSER_TITLE = "Supplemental Software";
    private HelpNavigator fNavigator;
    private ClassicHelpPanel fHelpPanel;
    private HelpBrowserToolBar fBrowserToolBar;
    private MJStatusBar fStatusBar;
    private MJSplitPane fSplitPane;
    private MJCheckBoxMenuItem fShowHelpNavMenuItem;
    private int fPrevDividerLocation = -1;
    private MJMenu fFavMenu;
    private MJMenuBar fMenu;
    private MJAbstractAction fNewFavAction;
    private MJAbstractAction fOrgFavAction;
    private MJAbstractAction fHelpLocatorAction;
    private ShowHelpNavigatorAction fShowNavAction;
    private HelpSynchronizer fHelpSynchronizer;
    public static final String HELP_BROWSER_CONTEXT = "HelpBrowser";
    private boolean fConfigured = false;
    private MJToolBar fSearchToolbar = null;
    private BreadCrumbHelpSyncListener fBreadCrumbHelpSyncListener;
    private BreadCrumbUICallback fBreadCrumbUICallback;
    private int fNavigatorWidth = 0;
    private int fNavigatorHeight = 0;

    private HelpBrowser(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setName("Help Browser");
        this.setClientName(CLASSIC_HELP_BROWSER_NAME);
        this.setTitle(CLASSIC_HELP_BROWSER_TITLE);
        this.setCursor(Cursor.getPredefinedCursor(3));
        sHelpBrowser = this;
        if (PlatformInfo.isWindows()) {
            this.setIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP_32x32.getIcon(), (ImageIcon)ApplicationIcon.MATLAB.getIcon(), (int)15, (int)15, (int)18, (int)18));
        } else {
            this.setIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP_48x48.getIcon(), (ImageIcon)ApplicationIcon.MATLAB_32x32.getIcon(), (int)18, (int)20));
        }
        this.setSmallIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP.getIcon(), (ImageIcon)ApplicationIcon.MATLAB.getIcon(), (int)5, (int)6, (int)11, (int)11));
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("Help Browser Status Bar");
        this.setStatusBar(this.fStatusBar);
        this.setOnTopWhenUndocked(false);
        this.setIsGuest(true);
        this.setOfferToolBarToggles(false);
        this.fNavigator = new HelpNavigator();
        this.fHelpPanel = new ClassicHelpPanel();
        this.fHelpSynchronizer = new HelpSynchronizer();
        PageChangedListener pageChangedListener = this.fHelpSynchronizer.getPageChangedListener();
        this.fHelpPanel.addPageChangedListener(pageChangedListener);
        this.fNavigator.setHelpSynchronizer(this.fHelpSynchronizer);
        if (bl) {
            this.fHelpSynchronizer.selectFirstProduct();
        } else {
            this.finishSetup();
            this.fHelpSynchronizer.syncTOC();
        }
    }

    static void invoke() {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fNavigator.showContents();
                helpBrowser.getHelpSynchronizer().selectFirstProduct();
                HelpBrowser.getDesktop().showClient((Component)((Object)helpBrowser), null, true);
                helpBrowser.fNavigator.requestFocusInWindow();
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void showHelpBrowser() {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                HelpBrowser.getDesktop().showClient((Component)((Object)helpBrowser), null, true);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    ClassicHelpPanel getHelpPanel() {
        return this.fHelpPanel;
    }

    public HelpSynchronizer getHelpSynchronizer() {
        return this.fHelpSynchronizer;
    }

    private static Desktop getDesktop() {
        return MLDesktop.getInstance();
    }

    public void addNotify() {
        super.addNotify();
        if (this.fSplitPane == null) {
            this.finishSetup();
        }
    }

    private void finishSetup() {
        this.fBreadCrumbHelpSyncListener = new BreadCrumbHelpSyncListener();
        this.fBreadCrumbUICallback = new BreadCrumbUICallback();
        ContentsTree contentsTree = new ContentsTree(this.fBreadCrumbUICallback);
        this.fBreadCrumbUICallback.setTree(contentsTree);
        contentsTree.setHelpSynchronizer(this.fHelpSynchronizer);
        contentsTree.addListeners();
        HelpPanelBreadCrumbTrail helpPanelBreadCrumbTrail = new HelpPanelBreadCrumbTrail(this.fHelpPanel, (MJTree)contentsTree);
        this.fBrowserToolBar = new HelpBrowserToolBar((JComponent)helpPanelBreadCrumbTrail.getToolBar());
        this.fBreadCrumbUICallback.setHelpPanelAddressNavigation((HelpPanelAddressNavigation)helpPanelBreadCrumbTrail);
        this.fSplitPane = new MJSplitPane(1, true);
        this.fSplitPane.setLeftComponent((Component)((Object)this.fNavigator));
        this.fSplitPane.setRightComponent((Component)new MJPanel());
        this.fSplitPane.setFocusable(true);
        this.configureSplitPane();
        this.saveDividerLocation();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!HelpBrowser.this.fConfigured || HelpBrowser.this.shouldChangeLayout()) {
                    HelpBrowser.this.configureSplitPane();
                }
            }
        });
        this.fSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (this.shouldSaveDividerLocation()) {
                    HelpBrowser.this.saveDividerLocation();
                }
            }

            private boolean shouldSaveDividerLocation() {
                return HelpBrowser.this.fConfigured && !HelpBrowser.this.shouldChangeLayout();
            }
        });
        FinishSetupThread finishSetupThread = new FinishSetupThread();
        finishSetupThread.start();
    }

    private void saveDividerLocation() {
        if (this.isUsingNarrowLayout()) {
            this.fNavigatorHeight = this.fSplitPane.getDividerLocation();
        } else {
            this.fNavigatorWidth = this.fSplitPane.getDividerLocation();
        }
    }

    private void configureSplitPane() {
        if (this.getWidth() <= 0) {
            return;
        }
        boolean bl = this.shouldUseNarrowLayout();
        int n = bl ? 0 : 1;
        int n2 = bl ? this.fNavigatorHeight : this.fNavigatorWidth;
        this.fSplitPane.setOrientation(n);
        if (n2 > 0) {
            this.fSplitPane.setDividerLocation(n2);
        } else if (bl) {
            this.fSplitPane.setDividerLocation(0.4);
        } else {
            this.fSplitPane.setDividerLocation(0.33);
        }
        this.configureToolBar();
        this.fConfigured = true;
    }

    private boolean isUsingNarrowLayout() {
        return this.fSplitPane.getOrientation() == 0;
    }

    private boolean shouldUseNarrowLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        return n < 450 || n < 585 && n2 > n;
    }

    private boolean shouldChangeLayout() {
        return this.isUsingNarrowLayout() != this.shouldUseNarrowLayout();
    }

    private void showOrHideNavigator(boolean bl) {
        this.fHelpPanel.removeToolbar();
        if (MLHelpServices.isNavigatorShowing()) {
            if (!bl) {
                this.remove((Component)this.fHelpPanel);
            }
            this.fSplitPane.setRightComponent((Component)this.fHelpPanel);
            this.add((Component)this.fSplitPane, "Center");
            this.fSplitPane.setDividerLocation(this.fPrevDividerLocation);
            this.fNavigator.scrollToSelectedContentsTreeNode();
        } else {
            this.fPrevDividerLocation = this.fSplitPane.getDividerLocation();
            if (!bl) {
                this.remove((Component)this.fSplitPane);
            }
            this.add((Component)this.fHelpPanel);
        }
        if (this.fShowHelpNavMenuItem != null) {
            this.fShowHelpNavMenuItem.setSelected(MLHelpServices.isNavigatorShowing());
        }
        this.configureToolBar();
        this.revalidate();
        this.repaint();
    }

    private void configureToolBar() {
        if (this.fSearchToolbar != null) {
            this.remove((Component)this.fSearchToolbar);
            this.fSearchToolbar = null;
        }
        if (MLHelpServices.isNavigatorShowing()) {
            this.fBrowserToolBar.configureAsStandalone();
            this.fHelpPanel.addToolbar(this.fBrowserToolBar.getComponent());
        } else {
            MJToolBar mJToolBar = new MJToolBar();
            mJToolBar.setFloatable(false);
            SearchInputPanel searchInputPanel = new SearchInputPanel(this.fNavigator);
            searchInputPanel.setBackground(mJToolBar.getBackground());
            searchInputPanel.setText(this.fNavigator.getSearchFieldText());
            mJToolBar.add((Component)((Object)searchInputPanel));
            mJToolBar.add((Action)((Object)new ShowHelpNavigatorAction()));
            if (!this.shouldUseNarrowLayout()) {
                searchInputPanel.configureForToolBar();
                mJToolBar.addSeparator();
                this.fBrowserToolBar.configureAsSubToolBar();
                mJToolBar.add((Component)this.fBrowserToolBar.getComponent());
                this.fHelpPanel.addToolbar((JToolBar)mJToolBar);
            } else {
                this.fSearchToolbar = mJToolBar;
                this.add((Component)mJToolBar, "North");
                this.fBrowserToolBar.configureAsStandalone();
                this.fHelpPanel.addToolbar(this.fBrowserToolBar.getComponent());
            }
        }
    }

    private MJMenuBar createMenuBar() {
        MJMenu mJMenu;
        this.fMenu = new MJMenuBar();
        MJMenu mJMenu2 = new MJMenu(Desktop.getString(null, (String)"menu.File"));
        this.fMenu.add((JMenu)mJMenu2);
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu2);
        MJMenuItem mJMenuItem = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fPrintAction);
        DTMenuMergeTag.PRINT.setTag((JMenuItem)mJMenuItem);
        mJMenu2.add((JMenuItem)mJMenuItem);
        MJMenu mJMenu3 = new MJMenu(Desktop.getString(null, (String)"menu.Edit"));
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu3);
        this.fMenu.add((JMenu)mJMenu3);
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fCopyAction);
        DTMenuMergeTag.COPY.setTag((JMenuItem)mJMenuItem2);
        mJMenu3.add((JMenuItem)mJMenuItem2);
        MJMenuItem mJMenuItem3 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fFindAction);
        MLMenuMergeTag.FIND.setTag((JMenuItem)mJMenuItem3);
        mJMenu3.add((JMenuItem)mJMenuItem3);
        MJMenu mJMenu4 = new MJMenu(MJUtilities.intlString((String)"menu.View"));
        mJMenu4.setName("HelpViewMenu");
        this.fMenu.add((JMenu)mJMenu4);
        this.fShowNavAction = new ShowHelpNavigatorAction();
        this.fShowHelpNavMenuItem = new MJCheckBoxMenuItem((Action)((Object)this.fShowNavAction));
        this.fShowHelpNavMenuItem.setSelected(MLHelpServices.isNavigatorShowing());
        mJMenu4.add((JMenuItem)this.fShowHelpNavMenuItem);
        mJMenu4.addSeparator();
        MJMenuItem mJMenuItem4 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fViewSourceAction);
        mJMenu4.add((JMenuItem)mJMenuItem4);
        if (Matlab.isMatlabAvailable()) {
            mJMenu4.addSeparator();
            this.fHelpLocatorAction = new HelpLocatorAction();
            this.fHelpLocatorAction.setEnabled(false);
            mJMenu = new MJMenuItem((Action)this.fHelpLocatorAction);
            mJMenu4.add((JMenuItem)mJMenu);
        }
        mJMenu = new MJMenu(HelpUtils.getLocalizedString((String)"menu.go"));
        mJMenu.setName("HelpGoMenu");
        this.fMenu.add((JMenu)mJMenu);
        MJMenuItem mJMenuItem5 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fGoBackAction);
        mJMenu.add((JMenuItem)mJMenuItem5);
        MJMenuItem mJMenuItem6 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fGoForwardAction);
        mJMenu.add((JMenuItem)mJMenuItem6);
        MJMenuItem mJMenuItem7 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fReloadAction);
        mJMenu.add((JMenuItem)mJMenuItem7);
        if (Matlab.isMatlabAvailable()) {
            mJMenu.addSeparator();
            MJMenuItem mJMenuItem8 = new MJMenuItem((Action)this.fHelpPanel.getHTMLRenderer().getActions().fEvalSelectionAction);
            mJMenu.add((JMenuItem)mJMenuItem8);
        }
        if (Matlab.isMatlabAvailable()) {
            this.fFavMenu = new MJMenu(HelpUtils.getLocalizedString((String)"menu.favorite"));
            this.fNewFavAction = new NewFavoriteAction();
            this.fOrgFavAction = new OrganizeFavoritesAction();
            this.addFavoritesToMenu();
            ShortcutUtils.addFavoritesListener((ActionListener)new ShortcutsListener());
            this.fMenu.add((JMenu)this.fFavMenu);
        }
        return this.fMenu;
    }

    private void addFavoritesToMenu() {
        this.fFavMenu.add((Action)this.fNewFavAction);
        this.fFavMenu.add((Action)this.fOrgFavAction);
        this.fFavMenu.addSeparator();
        Vector vector = ShortcutUtils.getShortcutsByCategory((String)ShortcutUtils.getDefaultHelpCategoryName());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Shortcut shortcut = (Shortcut)vector.elementAt(i);
                MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)new FavMenuAction(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIcon())));
                this.fFavMenu.add((JMenuItem)mJMenuItem);
            }
        }
    }

    public static HelpBrowser getInstance() {
        return HelpBrowser.getInstance(true, true);
    }

    private static HelpBrowser getInstance(boolean bl, boolean bl2) {
        if (sHelpBrowser == null && bl) {
            HelpBrowser.createHelpBrowser(bl2);
        }
        return sHelpBrowser;
    }

    private static synchronized HelpBrowser createHelpBrowser(final boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "The help browser should always be created on the EDT.";
        if (sHelpBrowser == null) {
            sHelpBrowser = new HelpBrowser(bl);
        }
        sHelpBrowser.putClientProperty(DTClientProperty.DONT_REOPEN, Boolean.TRUE);
        Desktop desktop = HelpBrowser.getDesktop();
        DTLocation dTLocation = desktop.hasMainFrame() ? null : DTLocation.createExternal((int)10, (int)10, (int)800, (int)600);
        desktop.addClient((Component)((Object)sHelpBrowser), CLASSIC_HELP_BROWSER_NAME, true, dTLocation, true, null);
        desktop.setClientDocked(CLASSIC_HELP_BROWSER_NAME, false);
        desktop.addClientListener((Component)((Object)sHelpBrowser), (DTClientListener)new DTClientAdapter(){

            public void clientClosed(DTClientEvent dTClientEvent) {
                sHelpBrowser.reset();
            }

            public void clientOpened(DTClientEvent dTClientEvent) {
                HelpSynchronizer helpSynchronizer = HelpBrowser.getInstance().getHelpSynchronizer();
                if (helpSynchronizer != null) {
                    helpSynchronizer.helpOpened(bl);
                }
                if (sHelpBrowser.fNavigator != null) {
                    sHelpBrowser.fNavigator.requestFocusInWindow();
                }
            }
        });
        return sHelpBrowser;
    }

    private void reset() {
        HelpBrowserStateManager.getInstance().saveHelpBrowserState(this.fNavigator.getSearchHistory());
        if (this.fHelpSynchronizer != null) {
            this.fHelpSynchronizer.resetTOC();
        }
        if (this.fNavigator != null) {
            this.fNavigator.reset();
        }
        HelpBrowser.sHelpBrowser.fHelpPanel.getHTMLRenderer().clearBrowser();
    }

    static void showHelpPage(final String string, final String string2, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fHelpPanel.showHelpPage(string, string2);
                if (bl) {
                    helpBrowser.fNavigator.showContents();
                }
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void showHelpPageForFullProductName(final String string, final String string2, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                sHelpBrowser.fHelpPanel.showHelpPageForFullProductName(string, string2);
                if (bl) {
                    sHelpBrowser.fNavigator.showContents();
                }
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void setCurrentLocation(final String string, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                if (bl) {
                    helpBrowser.fNavigator.showContents();
                }
                helpBrowser.getHelpPanel().setCurrentLocation(string);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    public static void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray, boolean bl) {
        HelpBrowser.setCurrentLocationAndHighlightKeywords(string, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray, bl);
    }

    public static void setCurrentLocationAndHighlightKeywords(final String string, final CharsetDetectionStrategy charsetDetectionStrategy, final String[] stringArray, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                if (bl) {
                    helpBrowser.fNavigator.showContents();
                }
                helpBrowser.fHelpPanel.setCurrentLocationAndHighlightKeywords(string, charsetDetectionStrategy, stringArray);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    public static void showHelpPageAndHighlightKeywords(String string, String string2, String[] stringArray, boolean bl) {
        HelpBrowser.showHelpPageAndHighlightKeywords(string, string2, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray, bl);
    }

    public static void showHelpPageAndHighlightKeywords(final String string, final String string2, final CharsetDetectionStrategy charsetDetectionStrategy, final String[] stringArray, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                if (bl) {
                    helpBrowser.fNavigator.showContents();
                }
                helpBrowser.fHelpPanel.showHelpPageAndHighlightKeywords(string, string2, charsetDetectionStrategy, stringArray);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void showReferencePage(final String string, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fNavigator.showContents();
                helpBrowser.fHelpPanel.showReferencePage(string, bl);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static String getCurrentLocation() {
        HelpBrowser helpBrowser = HelpBrowser.getInstance(false, false);
        if (helpBrowser == null || helpBrowser.fHelpPanel == null) {
            return null;
        }
        return helpBrowser.fHelpPanel.getHTMLRenderer().getCurrentLocation();
    }

    static void setHtmlText(final String string) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fHelpPanel.setHtmlText(string);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void setDemoText(final String string) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                HelpBrowser.setHtmlText(string);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void setHtmlTextAndHighlightKeywords(final String string, final String[] stringArray) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fHelpPanel.setHtmlTextAndHighlightKeywords(string, stringArray);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static String getHtmlText() {
        HelpBrowser helpBrowser = HelpBrowser.getInstance(false, false);
        if (helpBrowser != null && helpBrowser.fHelpPanel != null) {
            return helpBrowser.fHelpPanel.getHtmlText();
        }
        return null;
    }

    static void setCurrentDemoId(final String string) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.getHelpSynchronizer().setCurrentDemoId(string);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static String getCurrentDemoId() {
        HelpBrowser helpBrowser = HelpBrowser.getInstance(false, false);
        if (helpBrowser != null && helpBrowser.getHelpSynchronizer() != null) {
            return helpBrowser.getHelpSynchronizer().getCurrentDemoId();
        }
        return null;
    }

    static void showDemos() {
        HelpBrowser.showDemos("", "");
    }

    static void showDemos(String string) {
        HelpBrowser.showDemos("", string);
    }

    static void showDemos(final String string, final String string2) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                MLHelpServices.showNavigator();
                helpBrowser.fNavigator.showContents();
                helpBrowser.fNavigator.showDemosTab(string, string2);
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void docSearch(String string) {
        HelpBrowser.docSearch(string, null);
    }

    static void docSearch(final String string, final String[] stringArray) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                SwingUtilities.invokeLater(new DocSearchThread(string, stringArray));
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    public static void displayTopic(final String string, final String string2, final boolean bl) {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                helpBrowser.fHelpPanel.displayTopic(string, string2);
                if (bl) {
                    helpBrowser.fNavigator.showContents();
                }
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    static void showFirstProductPage() {
        HelpBrowserRunnable helpBrowserRunnable = new HelpBrowserRunnable(){

            @Override
            protected void whenHelpBrowserExists(HelpBrowser helpBrowser) {
                if (helpBrowser.getHelpSynchronizer() != null) {
                    helpBrowser.getHelpSynchronizer().selectFirstProduct();
                }
            }
        };
        helpBrowserRunnable.doHelpBrowserAction();
    }

    void setStatusBar(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (string.length() == 0) {
                    HelpBrowser.this.fStatusBar.clearText();
                } else {
                    HelpBrowser.this.fStatusBar.setText(string);
                }
            }
        });
    }

    public boolean requestFocusInWindow() {
        if (this.isFocusInBrowser()) {
            return true;
        }
        if (this.fNavigator != null && this.fNavigator.isVisible()) {
            return this.fNavigator.requestFocusInWindow();
        }
        if (this.fHelpPanel != null) {
            return this.fHelpPanel.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void requestFocus() {
        this.requestFocusInWindow();
    }

    boolean isFocusInBrowser() {
        Component component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            return this.isAncestorOf(component);
        }
        Desktop desktop = Desktop.getContainingDesktop((Component)((Object)this));
        return desktop.isClientSelected((Component)((Object)this));
    }

    private void addBreadCrumbHelpSyncListenerToHelpSynchronizer() {
        assert (this.fHelpSynchronizer != null) : "sHelpSynchronizer is null, cannot add HelpSyncListener.";
        assert (this.fBreadCrumbHelpSyncListener != null) : "fBreadCrumbHelpSyncListener is null, cannot add to HelpSynchronizer.";
        this.fHelpSynchronizer.addHelpSyncListener((HelpSyncListener)this.fBreadCrumbHelpSyncListener, true);
    }

    private void removeBreadCrumbHelpSyncListenerFromHelpSynchronizer() {
        assert (this.fHelpSynchronizer != null) : "sHelpSynchronizer is null, cannot remove HelpSyncListener.";
        assert (this.fBreadCrumbHelpSyncListener != null) : "fBreadCrumbHelpSyncListener is null, cannot remove from HelpSynchronizer.";
        this.fHelpSynchronizer.removeHelpSyncListener((HelpSyncListener)this.fBreadCrumbHelpSyncListener);
    }

    private class BreadCrumbUICallback
    extends ContentsTreeUICallback {
        private HelpPanelAddressNavigation fAddressNavigation;

        private BreadCrumbUICallback() {
        }

        public void setHelpPanelAddressNavigation(HelpPanelAddressNavigation helpPanelAddressNavigation) {
            this.fAddressNavigation = helpPanelAddressNavigation;
        }

        @Override
        public void updateAfterTreeCleared() {
            HelpBrowser.this.removeBreadCrumbHelpSyncListenerFromHelpSynchronizer();
        }

        @Override
        public void updateAfterTreePopulated() {
            HelpBrowser.this.addBreadCrumbHelpSyncListenerToHelpSynchronizer();
        }

        @Override
        public void updateAfterTreeSelectionChanged(TreePath treePath) {
        }

        @Override
        public void updateForSelectFirstProduct() {
        }

        public void syncToHelpPanelSyncEvent(HelpPanelSyncEvent helpPanelSyncEvent) {
            if (helpPanelSyncEvent == null) {
                return;
            }
            if (helpPanelSyncEvent.isContentsItem()) {
                this.getTree().syncTocToItem(helpPanelSyncEvent.getHelpTreeItem());
            } else if (helpPanelSyncEvent.isOtherItem()) {
                this.getTree().clearSelection();
                this.getTree().setCurrentItem(null);
                String string = helpPanelSyncEvent.getUnigueIdentifier();
                String string2 = helpPanelSyncEvent.getTitle();
                if (string == null || string2 == null) {
                    return;
                }
                if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
                    string = string.substring(0, string.length() - 1);
                }
                if (this.fAddressNavigation != null) {
                    this.fAddressNavigation.addUrlToAddressNavigation(string2, string);
                }
            } else if (helpPanelSyncEvent.isHelpOpenedSelectFirstProduct() || helpPanelSyncEvent.isSelectFirstProduct()) {
                if (this.getTree() != null) {
                    this.getTree().selectFirstProduct();
                }
            } else if (helpPanelSyncEvent.isResetTOC() && this.getTree() != null) {
                this.getTree().setCurrentItem(null);
            }
        }
    }

    private class BreadCrumbHelpSyncListener
    implements HelpSyncListener {
        private BreadCrumbHelpSyncListener() {
        }

        public void syncToHelpPanelSyncEvent(HelpPanelSyncEvent helpPanelSyncEvent) {
            HelpBrowser.this.fBreadCrumbUICallback.syncToHelpPanelSyncEvent(helpPanelSyncEvent);
        }
    }

    private static abstract class HelpBrowserRunnable
    implements Runnable {
        private HelpBrowserRunnable() {
        }

        private void doHelpBrowserAction() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            HelpBrowser helpBrowser = HelpBrowser.getInstance(true, false);
            this.whenHelpBrowserExists(helpBrowser);
        }

        protected abstract void whenHelpBrowserExists(HelpBrowser var1);
    }

    private class HelpLocatorAction
    extends MJAbstractAction {
        HelpLocatorAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HelpBrowser.HELP_BROWSER_CONTEXT, "show-page-location", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpLocator.invokeFromClassicHelp((MJFrame)SwingUtilities.windowForComponent((Component)((Object)HelpBrowser.this)));
        }
    }

    private class ShortcutsListener
    implements ActionListener {
        private ShortcutsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.this.fFavMenu.removeAll();
            HelpBrowser.this.addFavoritesToMenu();
            HelpBrowser.this.setMenuBar((JMenuBar)HelpBrowser.this.fMenu);
        }
    }

    private class OrganizeFavoritesAction
    extends MJAbstractAction {
        OrganizeFavoritesAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HelpBrowser.HELP_BROWSER_CONTEXT, "organize-favorites", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ShortcutsOrganizer.invoke((Frame)((Frame)SwingUtilities.windowForComponent((Component)((Object)HelpBrowser.this))));
                }
            }).start();
        }
    }

    private class NewFavoriteAction
    extends MJAbstractAction {
        NewFavoriteAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HelpBrowser.HELP_BROWSER_CONTEXT, "create-new-favorite", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HelpBrowser.this.fHelpPanel.getHTMLRenderer().getCurrentFilename();
            String string2 = "web('" + string + "', '-helpbrowser')";
            String string3 = HelpBrowser.this.getHelpPanel().getHTMLRenderer().getCurrentPageTitle();
            ShortcutEditor.invoke((String)HelpUtils.getLocalizedString((String)"favorites.editor"), (String)string3, (String)string2, (String)ShortcutUtils.getHelpIconString(), (String)ShortcutUtils.getDefaultHelpCategoryName(), (boolean)true);
        }
    }

    private static class FavMenuAction
    extends MJAbstractAction {
        private String fCallback;
        private static MatlabMCR sMatlab;

        FavMenuAction(String string, String string2, Icon icon) {
            super(string, icon);
            this.fCallback = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sMatlab == null) {
                sMatlab = new MatlabMCR();
            }
            sMatlab.evalConsoleOutput(this.fCallback);
        }
    }

    private class NavigatorListener
    implements ActionListener {
        private NavigatorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.this.showOrHideNavigator(false);
        }
    }

    private class ShowHelpNavigatorAction
    extends MJAbstractAction {
        ShowHelpNavigatorAction() {
            super(true);
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(HelpBrowser.HELP_BROWSER_CONTEXT, "show-help-navigator", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.toggleNavigator();
        }
    }

    private class MouseOverLinkListener
    implements ActionListener {
        private MouseOverLinkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (HelpBrowser.this.fStatusBar != null && !(string = actionEvent.getActionCommand()).equals("Done")) {
                HelpBrowser.this.setStatusBar(string);
            }
        }
    }

    private static class DocSearchThread
    implements Runnable {
        private String fSearchString;
        private String[] fProducts;

        private DocSearchThread(String string, String[] stringArray) {
            this.fSearchString = string;
            this.fProducts = stringArray;
        }

        @Override
        public void run() {
            HelpBrowser helpBrowser = HelpBrowser.getInstance(true, false);
            helpBrowser.fNavigator.docSearch(this.fSearchString, this.fProducts);
        }
    }

    private class MyPageChangedListener
    implements PageChangedListener {
        private MyPageChangedListener() {
        }

        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            String string;
            String string2 = pageChangedEvent.getFullUrl();
            if (string2.startsWith("text://") && (string = HelpBrowser.getCurrentLocation()) != null) {
                string2 = string;
            }
            if (HelpBrowser.this.fNewFavAction != null) {
                HelpBrowser.this.fNewFavAction.setEnabled(!string2.startsWith("text://"));
            }
            if (HelpBrowser.this.fHelpLocatorAction != null) {
                HelpBrowser.this.fHelpLocatorAction.setEnabled(HelpLocator.isValidClassicHelpLocation(string2, MLHelpServices.getDocRoot()));
            }
            HelpBrowser.this.setStatusBar("");
        }
    }

    private class PopulateNavigatorThread
    extends Thread {
        private PopulateNavigatorThread() {
        }

        @Override
        public void run() {
            HelpBrowser.this.fNavigator.populate();
        }
    }

    private class AddComponentsToUIThread
    implements Runnable {
        private AddComponentsToUIThread() {
        }

        @Override
        public void run() {
            HelpBrowser.this.fHelpPanel.setName("Help Panel");
            HelpBrowser.this.fHelpPanel.addMouseOverLinkListener((ActionListener)new MouseOverLinkListener());
            HelpBrowser.this.showOrHideNavigator(true);
            MLHelpServices.addNavigatorListener((ActionListener)new NavigatorListener());
            if (!Matlab.isMatlabAvailable()) {
                HelpBrowser.this.setDontMergeMenu(true);
            }
            MJMenuBar mJMenuBar = HelpBrowser.this.createMenuBar();
            HelpBrowser.this.setMenuBar((JMenuBar)mJMenuBar);
            HelpBrowser.this.validate();
            HelpBrowser.this.fHelpPanel.addPageChangedListener((PageChangedListener)new MyPageChangedListener());
            HelpBrowser.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FinishSetupThread
    extends Thread {
        private FinishSetupThread() {
        }

        @Override
        public void run() {
            PopulateNavigatorThread populateNavigatorThread = new PopulateNavigatorThread();
            populateNavigatorThread.start();
            SwingUtilities.invokeLater(new AddComponentsToUIThread());
        }
    }
}

