/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionhints;

import com.mathworks.mde.functionhints.FunctionHintsContent;
import com.mathworks.mde.functionhints.MFunctionCall;
import com.mathworks.mde.functionhints.QueuedMatlabWorker;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;

public class FunctionHints {
    private static MFunctionCall sFunctionCall;
    private static boolean sIsVisible;
    private static FocusAdapter sFocusListener;
    private static AncestorListener sAncestorListener;
    private static ComponentListener sComponentListener;
    private static MouseListener sMouseListener;
    private static Point sLastTriggerPoint;
    private static String sMCode;
    static JTextComponent sHost;
    private static FunctionHintsContent sCurrentPopupPanel;
    private static QueuedMatlabWorker sQueuedMatlabWorker;
    private static PopupTimer sTimer;
    private static int TIMERDELAY;
    private static int MAXLINES;
    private static char[] TRIGGER_CHARS;
    private static int[] NAVIGATION_IDS;
    private static int[] ACTION_IDS;

    public static boolean isTrigger(char c) {
        for (char c2 : TRIGGER_CHARS) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isNavigation(int n) {
        for (int n2 : NAVIGATION_IDS) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public static boolean isAction(int n) {
        for (int n2 : ACTION_IDS) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public static String[] getClassNames() {
        DocSearchEngine.initialize();
        return new String[0];
    }

    public static void openFunctionHints(JTextComponent jTextComponent, String string, ActionEvent actionEvent) {
        if (!HelpUtils.isDocInstalled()) {
            return;
        }
        if (sHost == jTextComponent && string != null && string.equals(sMCode) && FunctionHints.isOpen()) {
            return;
        }
        int n = -1;
        String string2 = null;
        if (actionEvent != null) {
            string2 = actionEvent.getActionCommand();
        }
        if (string2 != null && string2.length() > 0) {
            n = string2.charAt(0);
        }
        if (n >= 0 && !FunctionHints.isOpen() && string2 != null && (FunctionHints.isAction(n) || FunctionHints.isNavigation(n) || string2.equals("caret-backward") || string2.equals("caret-forward"))) {
            FunctionHints.hidePopup();
            return;
        }
        if (n == 27) {
            FunctionHints.hidePopup();
            return;
        }
        if (sQueuedMatlabWorker != null && sQueuedMatlabWorker.isBusy()) {
            if (string.equals(sQueuedMatlabWorker.getMCode()) && sQueuedMatlabWorker.getTextAreaHost() == jTextComponent) {
                return;
            }
            sQueuedMatlabWorker.cancel();
        }
        if (sTimer == null) {
            sTimer = new PopupTimer(jTextComponent, string);
        } else {
            sTimer.setProperties(jTextComponent, string);
        }
        if (FunctionHints.isOpen()) {
            sTimer.stop();
            FunctionHints.updatePopupAsynchronous(jTextComponent, string);
            return;
        }
        if (string != null && string.length() > 0 && FunctionHints.isTrigger(string.charAt(string.length() - 1))) {
            sTimer.restart();
        } else {
            sTimer.stop();
        }
    }

    public static void openFunctionHints(JTextComponent jTextComponent, String string) {
        FunctionHints.openFunctionHints(jTextComponent, string, null);
    }

    public static void openFunctionHintsSynchronously(JTextComponent jTextComponent, String string) {
        if (FunctionHints.isOpen()) {
            FunctionHints.hidePopup();
            return;
        }
        if (!HelpUtils.isDocInstalled()) {
            return;
        }
        if (sTimer != null) {
            sTimer.stop();
        }
        if (string != null && string.equals(sMCode) && sHost == jTextComponent && FunctionHints.isOpen()) {
            return;
        }
        if (sQueuedMatlabWorker != null && sQueuedMatlabWorker.isBusy()) {
            sQueuedMatlabWorker.cancel();
        }
        FunctionHints.updatePopupSynchronous(jTextComponent, string);
    }

    public static void hidePopup() {
        if (sQueuedMatlabWorker != null && sQueuedMatlabWorker.isBusy()) {
            sQueuedMatlabWorker.cancel();
        }
        if (sTimer != null) {
            sTimer.stop();
        }
        if (FunctionHints.isOpen()) {
            FunctionHints.hidePopupWindow();
        }
    }

    public static boolean isOpen() {
        return sIsVisible;
    }

    public static boolean isOpenOrOpening() {
        return sTimer != null && sTimer.isRunning() || FunctionHints.isOpen();
    }

    public static void dispatchKeyEventToScrollPane(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getActionCommand().equals("page-down")) {
            n = 34;
        } else if (actionEvent.getActionCommand().equals("page-up")) {
            n = 33;
        } else {
            return;
        }
        FunctionHints.dispatchKeyEventToScrollPane(actionEvent, n);
    }

    public static void dispatchKeyEventToScrollPane(ActionEvent actionEvent, int n) {
        if (!FunctionHints.isOpen()) {
            return;
        }
        ActionListener actionListener = sCurrentPopupPanel.getScrollPane().getActionForKeyStroke(KeyStroke.getKeyStroke(n, 0));
        actionEvent.setSource(sCurrentPopupPanel.getScrollPane());
        actionListener.actionPerformed(actionEvent);
    }

    static String getFunctionName() {
        if (sFunctionCall != null) {
            return sFunctionCall.getFunctionName();
        }
        return null;
    }

    static String getFullyQualifiedFuncionName() {
        if (sFunctionCall != null) {
            return sFunctionCall.getFullyQualifiedFuncionName();
        }
        return null;
    }

    static MFunctionCall getMFunctionCall() {
        return sFunctionCall;
    }

    static Point getLastTriggerPoint() {
        return sLastTriggerPoint;
    }

    static Point getLocation() {
        if (sIsVisible) {
            return sCurrentPopupPanel.getPopupWindow().getLocation();
        }
        return null;
    }

    static String getContent() {
        if (sIsVisible) {
            return sCurrentPopupPanel.getContent();
        }
        return null;
    }

    private static int getLineHeight() {
        Font font = FontPrefs.getCodeFont();
        return sHost.getFontMetrics(font).getHeight();
    }

    static void triggerPopup(JTextComponent jTextComponent, FunctionHintsContent functionHintsContent, MFunctionCall mFunctionCall, String string, Point point, boolean bl) {
        Dimension dimension;
        if (sTimer != null && sTimer.isRunning()) {
            return;
        }
        sHost = jTextComponent;
        sCurrentPopupPanel = functionHintsContent;
        sMCode = string;
        sLastTriggerPoint = point;
        sFunctionCall = mFunctionCall;
        if (!(bl || sHost != null && sHost.isFocusOwner())) {
            return;
        }
        sCurrentPopupPanel.createPopup(sHost);
        Window window = sCurrentPopupPanel.getPopupWindow();
        Rectangle rectangle = window.getBounds();
        if (rectangle.height > MAXLINES * FunctionHints.getLineHeight()) {
            dimension = new Dimension(rectangle.width, MAXLINES * FunctionHints.getLineHeight());
            window.setSize(dimension);
        } else {
            dimension = new Dimension(rectangle.width, rectangle.height);
        }
        Rectangle rectangle2 = WindowUtils.computeTextPopupBounds((Rectangle)WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)point), (Dimension)dimension, (Dimension)dimension, (Point)new Point(point.x, point.y), (int)FunctionHints.getLineHeight(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.BELOW_PREFERRED);
        window.setLocation(rectangle2.x, rectangle2.y);
        window.show();
        sIsVisible = true;
        FunctionHints.addFunctionHintsFocusListener();
        FunctionHints.addFunctionHintsAncestorListener();
        FunctionHints.addFunctionHintsComponentListener();
        FunctionHints.addFunctionHintsMouseListener();
    }

    static void hidePopupWindow() {
        FunctionHints.cleanUp();
        if (sCurrentPopupPanel != null && sCurrentPopupPanel.getPopupWindow() != null) {
            sCurrentPopupPanel.getPopupWindow().setVisible(false);
        }
        sIsVisible = false;
        sCurrentPopupPanel = null;
    }

    private static void updatePopupAsynchronous(JTextComponent jTextComponent, String string) {
        if (sQueuedMatlabWorker == null) {
            sQueuedMatlabWorker = new QueuedMatlabWorker();
        }
        if (sQueuedMatlabWorker.isBusy()) {
            sQueuedMatlabWorker.queueAsynchronous(string, jTextComponent);
        } else {
            sQueuedMatlabWorker.startAsynchronous(string, jTextComponent);
        }
    }

    private static void updatePopupSynchronous(JTextComponent jTextComponent, String string) {
        if (sQueuedMatlabWorker == null) {
            sQueuedMatlabWorker = new QueuedMatlabWorker();
        }
        if (sQueuedMatlabWorker.isBusy()) {
            sQueuedMatlabWorker.cancel();
        }
        QueuedMatlabWorker.startSynchronous(string, jTextComponent);
    }

    private static void addFunctionHintsFocusListener() {
        if (sFocusListener == null) {
            sFocusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!FunctionHints.isOpen()) {
                        return;
                    }
                    Window window = sCurrentPopupPanel.getPopupWindow();
                    Component component = focusEvent.getOppositeComponent();
                    if (component == null && focusEvent.isTemporary() && PlatformInfo.isLinux()) {
                        return;
                    }
                    if (component != null && (component == window || SwingUtilities.isDescendingFrom(component, window))) {
                        return;
                    }
                    if (sQueuedMatlabWorker != null && sQueuedMatlabWorker.isBusy()) {
                        sQueuedMatlabWorker.cancel();
                    }
                    FunctionHints.hidePopup();
                }
            };
        }
        sHost.removeFocusListener(sFocusListener);
        sHost.addFocusListener(sFocusListener);
    }

    private static void addFunctionHintsMouseListener() {
        if (sMouseListener == null) {
            sMouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    FunctionHints.hidePopup();
                }
            };
        }
        for (MouseListener mouseListener : sHost.getMouseListeners()) {
            if (mouseListener != sMouseListener) continue;
            return;
        }
        sHost.addMouseListener(sMouseListener);
    }

    private static void addFunctionHintsComponentListener() {
        if (sComponentListener == null) {
            sComponentListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    FunctionHints.hidePopup();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    FunctionHints.hidePopup();
                }
            };
        }
        for (ComponentListener componentListener : sHost.getComponentListeners()) {
            if (componentListener != sComponentListener) continue;
            return;
        }
        sHost.addComponentListener(sComponentListener);
    }

    private static void addFunctionHintsAncestorListener() {
        if (sAncestorListener == null) {
            sAncestorListener = new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                    FunctionHints.hidePopup();
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    FunctionHints.hidePopup();
                }
            };
        }
        for (AncestorListener ancestorListener : sHost.getAncestorListeners()) {
            if (ancestorListener != sAncestorListener) continue;
            return;
        }
        sHost.addAncestorListener(sAncestorListener);
    }

    private static void cleanUp() {
        sHost.removeFocusListener(sFocusListener);
        sHost.removeAncestorListener(sAncestorListener);
        sHost.removeComponentListener(sComponentListener);
        sHost.removeMouseListener(sMouseListener);
        sFocusListener = null;
        sAncestorListener = null;
        sComponentListener = null;
        sMouseListener = null;
        sHost = null;
    }

    static {
        sIsVisible = false;
        sFocusListener = null;
        sAncestorListener = null;
        sComponentListener = null;
        sMouseListener = null;
        sLastTriggerPoint = new Point(0, 0);
        sTimer = null;
        TIMERDELAY = 1100;
        MAXLINES = 14;
        TRIGGER_CHARS = new char[]{'('};
        NAVIGATION_IDS = new int[]{37, 39, 226, 227, 10, 8, 127};
        ACTION_IDS = new int[]{27, 35, 36, 9};
    }

    private static class PopupTimer
    extends Timer {
        private JTextComponent iTextAreaHost;
        private String iMCode;

        public PopupTimer(JTextComponent jTextComponent, String string) {
            super(TIMERDELAY, null);
            this.setRepeats(false);
            this.iTextAreaHost = jTextComponent;
            this.iMCode = string;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupTimer.this.openPopup();
                }
            });
        }

        void setProperties(JTextComponent jTextComponent, String string) {
            this.iTextAreaHost = jTextComponent;
            this.iMCode = string;
        }

        void openPopup() {
            if (!FunctionHints.isOpen() && !MFunctionCall.isValidOpeningString(this.iMCode)) {
                return;
            }
            FunctionHints.updatePopupAsynchronous(this.iTextAreaHost, this.iMCode);
        }
    }
}

