/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableColumnWidthKeeper;
import com.jidesoft.grid.TreeTableModel;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionbrowser.FunctionCellRenderer;
import com.mathworks.mde.functionbrowser.FunctionTableModel;
import com.mathworks.mde.functionbrowser.TargetDialog;
import com.mathworks.mlwidgets.actionbrowser.AbstractActionTable;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.actionbrowser.HelpPopupLauncher;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MMouseEvent;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableModel;

final class FunctionTable
extends AbstractActionTable {
    private MJAbstractAction fFunctionCopyAction;
    private InsertMenu fInsertMenu;
    private MJAbstractAction fHOSAction;
    private TransferHandler fTransferHandler;
    private boolean fIsDraggingColumn = false;
    private boolean fDragBlocked = false;
    private FunctionCellRenderer fRenderer;
    private FunctionTableModel fFunctionTableModel;
    private static Object sColumnWidthCache = null;
    protected static final String resStr = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    protected static final String key = "FunctionTable.";
    protected static final ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");

    public FunctionTable(FunctionTableModel functionTableModel) {
        super((TreeTableModel)functionTableModel);
        this.fFunctionTableModel = functionTableModel;
        this.fRenderer = new FunctionCellRenderer("");
        this.applyRenderer();
        this.getAccessibleContext().setAccessibleName(resources.getString("FunctionTable.AccessName"));
        this.calculateRowHeights();
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                FunctionTable.this.calculateRowHeights();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                FunctionTable.this.calculateRowHeights();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "invoked");
        this.getActionMap().put("invoked", (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FunctionTable.this.getSelectedFunction();
                if (string != null) {
                    FunctionTable.this.insert(string);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copied");
        this.getActionMap().put("copied", (Action)this.getFunctionCopyAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), "HOS");
        this.getActionMap().put("HOS", (Action)this.getHOSAction());
        this.fTransferHandler = new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                String string = FunctionTable.this.getSelectedFunction();
                if (string == null) {
                    return null;
                }
                FunctionTable.this.hideActionToolTip();
                return new StringSelection(string);
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }
        };
        this.setTransferHandler(this.fTransferHandler);
        this.restoreColumnWidths();
        this.addMouseMotionListener(new FunctionBrowserMouseMotionListener());
        this.setIndent(0);
        this.setExpandIconVisible(false);
    }

    public void showHelpOnSelection(URL uRL, Rectangle rectangle) {
        ActionBrowserUtils.showHelpOnSelection((URL)uRL, (Rectangle)rectangle, (AbstractActionTable)this, (HelpPopupLauncher)FunctionBrowser.getInstance());
    }

    public void showHelpOnSelection(String string, Rectangle rectangle) {
        ActionBrowserUtils.showHelpOnSelection((String)string, (Rectangle)rectangle, (AbstractActionTable)this, (HelpPopupLauncher)FunctionBrowser.getInstance());
    }

    FunctionTableModel getFunctionTableModel() {
        return this.fFunctionTableModel;
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
    }

    void updateTableModel() {
        int n = this.getSelectedRow();
        super.setModel((TableModel)((Object)this.fFunctionTableModel));
        this.calculateRowHeights();
        if (n >= 0) {
            super.setRowSelectionInterval(n, n);
        }
        this.restoreColumnWidths();
    }

    protected void updatePopup(Row row) {
        if (this.fPopup == null) {
            this.fPopup = new FunctionTablePopup();
        }
    }

    void setHighlightText(String string) {
        this.fRenderer.setFilterString(string);
        this.applyRenderer();
    }

    protected String getSearchText() {
        if (this.fRenderer != null) {
            return this.fRenderer.getFilterString();
        }
        return "";
    }

    private void restoreColumnWidths() {
        if (sColumnWidthCache == null) {
            return;
        }
        if (this.getTableColumnWidthKeeper() == null) {
            this.setTableColumnWidthKeeper(new ColumnWidthCache());
        }
        this.getTableColumnWidthKeeper().restoreTableColumnWidth((JTable)((Object)this), sColumnWidthCache);
    }

    protected void maybeOpenPopup(MouseEvent mouseEvent) {
        int n;
        super.maybeOpenPopup(mouseEvent);
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent instanceof MMouseEvent && ((MMouseEvent)mouseEvent).isKeyTriggered()) {
            n = this.getSelectedRow();
            if (n < 0) {
                return;
            }
        } else {
            n = this.rowAtPoint(mouseEvent.getPoint());
        }
        if (this.isItemRow(n)) {
            this.getInsertMenuItem().refresh();
        }
    }

    private MJAbstractAction getHOSAction() {
        if (this.fHOSAction == null) {
            this.fHOSAction = new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    URL uRL = FunctionTable.this.getSelectedURL();
                    if (uRL == null) {
                        return;
                    }
                    ActionBrowserUtils.showHelpOnSelection((URL)uRL, (Rectangle)FunctionBrowser.getInstance().getBounds(), (AbstractActionTable)FunctionTable.this, (HelpPopupLauncher)FunctionBrowser.getInstance());
                }
            };
            this.fHOSAction.setName(resources.getString("FunctionTable.HOSContextMenu"));
            this.fHOSAction.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
        }
        return this.fHOSAction;
    }

    private String getSelectedFunction() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.getActionNameForRow(n);
    }

    private URL getSelectedURL() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        String string = this.getURLForRow(n);
        if (string != null) {
            try {
                string = ActionBrowserUtils.correctUrlForFileProtocol((String)string);
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private InsertMenu getInsertMenuItem() {
        if (this.fInsertMenu == null) {
            this.fInsertMenu = new InsertMenu();
        }
        return this.fInsertMenu;
    }

    private MJAbstractAction getFunctionCopyAction() {
        if (this.fFunctionCopyAction == null) {
            this.fFunctionCopyAction = new FunctionCopyAction();
        }
        return this.fFunctionCopyAction;
    }

    protected void execute(int n, boolean bl) {
        String string = this.getActionNameForRow(n);
        if (string != null && string.length() > 0) {
            this.insert(string);
        }
    }

    protected String getURLForRow(int n) {
        Row row = this.getRowAt(n);
        if (!(row instanceof FunctionTableModel.FunctionRow)) {
            return null;
        }
        return ((FunctionTableModel.FunctionSearchResult)this.getValueAt(n, 0)).getFullUrl();
    }

    protected void insert(String string) {
        FunctionBrowser.getInstance().insertFunction(string);
    }

    private void applyRenderer() {
        this.getColumnModel().getColumn(0).setCellRenderer(this.fRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(this.fRenderer);
        this.calculateRowHeights();
        this.repaint();
    }

    protected int getMinimumSelectableRow() {
        if (this.getRowCount() > 1 && this.getRowAt(0) instanceof FunctionTableModel.HeaderRow) {
            return 1;
        }
        return 0;
    }

    protected String getH1LineForRow(int n) {
        if (this.getRowAt(n) instanceof FunctionTableModel.FunctionRow) {
            return ((FunctionTableModel.FunctionRow)this.getRowAt(n)).getSearchResult().getH1Line();
        }
        return "";
    }

    protected String getActionNameForRow(int n) {
        if (n < 0 || !(this.getRowAt(n) instanceof FunctionTableModel.FunctionRow)) {
            return null;
        }
        FunctionTableModel.FunctionRow functionRow = (FunctionTableModel.FunctionRow)this.getRowAt(n);
        Object t = functionRow.getSearchResult();
        String string = t.getRefPageFunction();
        if (string == null && !(string = t.getTitle()).matches("^[a-zA-Z][a-zA-Z0-9]*")) {
            string = null;
        }
        return string;
    }

    protected boolean isCategoryRow(int n) {
        return this.getRowAt(n) instanceof FunctionTableModel.CategoryRow;
    }

    protected boolean isItemRow(int n) {
        return this.getRowAt(n) instanceof FunctionTableModel.FunctionRow;
    }

    private void startDraggingDivider() {
        this.fIsDraggingColumn = true;
        if (!this.fRenderer.isDividerShowing()) {
            this.fRenderer.showDivider(true);
            this.setCursor(new Cursor(10));
            this.repaint();
        }
    }

    private void stopDraggingDivider() {
        this.fIsDraggingColumn = false;
        if (this.fRenderer.isDividerShowing()) {
            this.fRenderer.showDivider(false);
            this.repaint();
        }
    }

    private static class ColumnWidthCache
    implements TableColumnWidthKeeper {
        private ColumnWidthCache() {
        }

        public void restoreTableColumnWidth(JTable jTable, Object object) {
            if (!(object instanceof Integer)) {
                return;
            }
            int n = (Integer)object;
            jTable.getColumnModel().getColumn(0).setMinWidth(n);
            jTable.getColumnModel().getColumn(0).setMaxWidth(n);
            jTable.revalidate();
            jTable.repaint();
        }

        public Object saveTableColumnWidth(JTable jTable) {
            return jTable.getColumnModel().getColumn(0).getWidth();
        }
    }

    private class InsertMenu
    extends MJMenuItem {
        public InsertMenu() {
            super(resources.getString("FunctionTable.InsertFcn"));
            MJAbstractAction mJAbstractAction = new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = FunctionTable.this.getSelectedFunction();
                    if (string != null) {
                        FunctionTable.this.insert(string);
                    }
                }
            };
            this.setAction((Action)mJAbstractAction);
            this.refresh();
        }

        public void refresh() {
            if (FunctionBrowser.getInstance().isFloating()) {
                if (!TargetDialog.isTargetAmbiguous()) {
                    this.setText(resources.getString("FunctionTable.InsertFcnToCmdLine"));
                } else {
                    this.setText(resources.getString("FunctionTable.InsertFcnToTarget"));
                }
                this.setFont(this.getFont().deriveFont(0));
            } else {
                this.setText(resources.getString("FunctionTable.InsertFcn"));
                this.setFont(this.getFont().deriveFont(1));
            }
        }
    }

    private class FunctionBrowserMouseMotionListener
    extends MouseMotionAdapter {
        private FunctionBrowserMouseMotionListener() {
        }

        private boolean isMouseOnDivider(MouseEvent mouseEvent) {
            return mouseEvent.getPoint().x <= FunctionTable.this.getColumnModel().getColumn(0).getWidth() + 5 && mouseEvent.getPoint().x >= FunctionTable.this.getColumnModel().getColumn(0).getWidth() - 5;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Row row;
            FunctionTable.this.fDragBlocked = false;
            if (this.isMouseOnDivider(mouseEvent)) {
                FunctionTable.this.startDraggingDivider();
                FunctionTable.this.fToolTipTimer.stop();
                FunctionTable.this.fShortDelayClickTimer.stop();
                return;
            }
            FunctionTable.this.stopDraggingDivider();
            FunctionTable.this.setCursor(new Cursor(0));
            int n = FunctionTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 && ((row = FunctionTable.this.getRowAt(n)) instanceof FunctionTableModel.FunctionRow || row instanceof FunctionTableModel.CategoryRow)) {
                FunctionTable.this.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            FunctionTable.this.fToolTipTimer.stop();
            FunctionTable.this.fShortDelayClickTimer.stop();
            if (this.isMouseOnDivider(mouseEvent)) {
                FunctionTable.this.startDraggingDivider();
            }
            if (FunctionTable.this.fIsDraggingColumn) {
                int n = mouseEvent.getPoint().x < 96 ? 96 : mouseEvent.getPoint().x;
                FunctionTable.this.getColumnModel().getColumn(0).setMaxWidth(n);
                FunctionTable.this.getColumnModel().getColumn(0).setMinWidth(n);
                if (FunctionTable.this.getTableColumnWidthKeeper() == null) {
                    FunctionTable.this.setTableColumnWidthKeeper(new ColumnWidthCache());
                }
                sColumnWidthCache = FunctionTable.this.getTableColumnWidthKeeper().saveTableColumnWidth((JTable)((Object)FunctionTable.this));
                FunctionTable.this.revalidate();
                FunctionTable.this.repaint();
                return;
            }
            if (!FunctionTable.this.fDragBlocked) {
                FunctionTable.this.fTransferHandler.exportAsDrag((JComponent)((Object)FunctionTable.this), mouseEvent, 1);
            }
        }
    }

    private class FunctionTablePopup
    extends MJPopupMenu {
        public FunctionTablePopup() {
            this.add((JMenuItem)((Object)FunctionTable.this.getInsertMenuItem()));
            this.add((Action)FunctionTable.this.getFunctionCopyAction());
            this.addSeparator();
            this.add((Action)FunctionTable.this.getHOSAction());
            this.setLightWeightPopupEnabled(false);
        }
    }

    private class FunctionCopyAction
    extends MJAbstractAction {
        public FunctionCopyAction() {
            super(resources.getString("FunctionTable.Copy"));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = FunctionTable.this.getSelectedFunction();
            if (string == null) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
    }
}

