/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.explorer.RunConfigurationUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.PickerButton;
import com.mathworks.widgets.grouptable.GroupingTableSelectionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;

final class RunButton {
    private final PickerButton fComponent;
    private final FileTable fTable;

    RunButton(FileTable fileTable) {
        this.fTable = fileTable;
        this.fComponent = new PickerButton((AbstractAction)new MJAbstractAction(null, RunButton.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                for (FileSystemEntry fileSystemEntry : RunButton.this.fTable.getSelectedItems()) {
                    if (fileSystemEntry.isFolder() || !fileSystemEntry.getLocation().checkExtension(new String[]{"m"})) continue;
                    try {
                        FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry((FileSystemEntry)fileSystemEntry);
                        RunConfigurationUtils.runDefaultConfiguration(new File(fileSystemEntry2.getLocation().toString()));
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        this.fComponent.setToolTipText(ExplorerResources.getString((String)"context.run"));
        this.fComponent.setName("runButton");
        this.fComponent.setActionTracking(false);
        this.fComponent.setDropDownToolTipText(EditorUtils.lookup("tooltip.runButton.dropDown"));
        this.fComponent.setPopupMenuCustomizer(RunConfigurationUtils.getPopupMenuCustomizer(fileTable));
        fileTable.addSelectionListener((GroupingTableSelectionListener)new GroupingTableSelectionListener<FileSystemEntry>(){

            public void valueChanged(List<FileSystemEntry> list) {
                RunButton.this.updateEnabledState(list);
            }
        });
        this.updateEnabledState(this.fTable.getSelectedItems());
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void updateEnabledState(List<FileSystemEntry> list) {
        for (FileSystemEntry fileSystemEntry : list) {
            if (!fileSystemEntry.getLocation().checkExtension(new String[]{"m"})) continue;
            this.fComponent.setEnabled(true);
            return;
        }
        this.fComponent.setEnabled(false);
    }

    public static Icon getIcon() {
        return DebuggingIcon.PLAY_DOCUMENT.getIcon();
    }
}

