/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.dataview.UiInfoProvider;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.mde.autosave.AutoSaveImplementor;
import com.mathworks.mde.autosave.AutoSaveTimer;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorView;
import com.mathworks.mde.editor.EditorViewClient;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mde.editor.TextFileBackingStoreAutoSaveImplementor;
import com.mathworks.mde.editor.TextFileUiInfoProvider;
import com.mathworks.mde.editor.breakpoints.DebugAdapter;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.dialog.SpecifyNewFilenameDialog;
import com.mathworks.mlwidgets.mlservices.scc.MWSccManager;
import com.mathworks.mlwidgets.mlservices.scc.SccFileListener;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.FileEvent;
import com.mathworks.util.AbsoluteFile;
import com.mathworks.util.FileSystemAdapter;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.datamodel.AbstractBackingStore;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;

public class MatlabEditorApplication
implements EditorApplication {
    private SccFileListener fSccFileListener;
    private final FileSystemListener fFileSystemListener;
    private static volatile boolean sFirstBPInDebugMode;
    private final SccFileProvider fSccFileProvider = this.createSccFileProvider();
    private static final MatlabEditorApplication INSTANCE;

    private MatlabEditorApplication() {
        MWSccManager.registerSccFileProvider((SccFileProvider)this.fSccFileProvider);
        EditorStartup.getParentDesktop().addClientListener(EditorUtils.getEditorGroupTitle(), this.createSourceControlDesktopClientListener());
        MatlabDebugAdapter matlabDebugAdapter = new MatlabDebugAdapter(){

            public void doDebugMode(boolean bl) {
                sFirstBPInDebugMode = EditorStartup.getInDebugMode();
            }
        };
        EditorStartup.addDebugObserver((MatlabDebugObserver)matlabDebugAdapter);
        MatlabBreakpointUtils.getDebugger().addDebugListener((DebugListener<MatlabBreakpoint>)MatlabEditorApplication.createDebugListener());
        this.fFileSystemListener = MatlabEditorApplication.createFileSystemListener();
        FileSystemUtils.getFileSystemNotifier().addFileSystemListener(this.fFileSystemListener);
    }

    public static MatlabEditorApplication getInstance() {
        return INSTANCE;
    }

    public Editor newEditor(final String string) {
        Editor editor = (Editor)EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                return MatlabEditorApplication.doNewEditor(string);
            }
        });
        editor.bringToFront();
        return editor;
    }

    public Editor openEditor(File file) {
        try {
            return this.doOpenEditorOnEdt(file);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() != null && runtimeException.getCause().getClass() == OutOfMemoryError.class) {
                return null;
            }
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public Editor openEditorForExistingFile(File file) {
        MatlabEditorApplication.checkFileNotNull(file);
        MatlabEditorApplication.checkFileExists(file);
        return this.doOpenEditorOnEdt(file);
    }

    public Editor openEditor(final BackingStore<Document> backingStore, final UiInfoProvider uiInfoProvider) {
        MatlabEditorApplication.checkBackingStoreNotNull(backingStore);
        MatlabEditorApplication.checkUiInfoProvider(uiInfoProvider);
        Editor editor = (Editor)EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                return MatlabEditorApplication.this.isEditorOpen(backingStore.getStorageLocation()) ? MatlabEditorApplication.this.getEditor(backingStore.getStorageLocation()) : MatlabEditorApplication.createEditorViewClient((BackingStore<Document>)backingStore, uiInfoProvider).getEditor();
            }
        });
        editor.bringToFront();
        return editor;
    }

    public Editor openEditorForDebug(final File file, final int n) {
        MatlabEditorApplication.checkFileIsAbsolute(file);
        Object object = EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                return MatlabEditorApplication.this.doOpenEditorForDebug(MFilePathUtil.accountForPFilesAndMakeAbsolute(file), Math.abs(n));
            }
        });
        return (Editor)object;
    }

    public Editor getEditor(StorageLocation storageLocation) {
        Validate.notNull((Object)storageLocation, (String)"The Resource cannot be null.");
        Editor editor = this.findEditor(storageLocation);
        Validate.notNull((Object)editor, (String)"An Editor for the given Resource is not open.");
        return editor;
    }

    public Editor findEditor(StorageLocation storageLocation) {
        Validate.notNull((Object)storageLocation, (String)"The Resource cannot be null.");
        EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient(storageLocation);
        return editorViewClient == null ? null : editorViewClient.getEditor();
    }

    public Editor getActiveEditor() {
        EditorViewClient editorViewClient = MatlabEditorApplication.getLastActiveEditorViewClient();
        return editorViewClient == null ? null : editorViewClient.getEditor();
    }

    public List<Editor> getOpenEditors() {
        List list = (List)EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                for (EditorViewClient editorViewClient : EditorGroup.getInstance().getOpenEditorViewClients()) {
                    arrayList.add(editorViewClient.getEditor());
                }
                return arrayList;
            }
        });
        return Collections.unmodifiableList(list);
    }

    public boolean isEditorOpen(StorageLocation storageLocation) {
        Validate.notNull((Object)storageLocation, (String)"The StorageLocation cannot be null.");
        return this.findEditor(storageLocation) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEditorOpenAndDirty(StorageLocation storageLocation) {
        Editor editor = this.findEditor(storageLocation);
        if (editor != null && editor.lockIfOpen()) {
            try {
                boolean bl = editor.isDirty();
                return bl;
            }
            finally {
                editor.unlock();
            }
        }
        return false;
    }

    public void close() {
        EditorStartup.getParentDesktop().closeGroup(EditorGroup.getTitle());
    }

    public void closeNoPrompt() {
        for (Editor editor : this.getOpenEditors()) {
            editor.closeNoPrompt();
        }
        this.close();
    }

    public void addEditorApplicationListener(EditorApplicationListener editorApplicationListener) {
        EditorGroup.getInstance().addEditorApplicationListener(editorApplicationListener);
    }

    public void removeEditorApplicationListener(EditorApplicationListener editorApplicationListener) {
        EditorGroup.getInstance().removeEditorApplicationListener(editorApplicationListener);
    }

    private static boolean userWantsToOpenNonExistentFile(AbsoluteFile absoluteFile) {
        Object object = MatlabEditorApplication.getLastActiveEditorViewClient();
        object = object != null && MJFrame.getFrame((Component)object) != null ? MJFrame.getFrame((Component)object) : EditorUiUtils.getEditorGroupComponent();
        boolean bl = false;
        if (object == null) {
            object = new MJDialogParent();
            bl = true;
        }
        int n = DialogFactory.getEditorDialogProvider().shouldCreateNonExistentFile((Component)object, absoluteFile.toFile());
        boolean bl2 = false;
        if (n == 0) {
            EditorOptions.setNamedBufferOption(1);
            bl2 = true;
        } else if (n == 1) {
            EditorOptions.setNamedBufferOption(2);
            bl2 = false;
        }
        if (bl) {
            ((Window)object).dispose();
        }
        return bl2;
    }

    private Editor doOpenEditorForDebug(AbsoluteFile absoluteFile, int n) {
        Boolean bl;
        Component component = EditorStartup.getParentDesktop().getSelected();
        boolean bl2 = false;
        if (MatlabDebugServices.isGraphicalDebuggingEnabled() && component instanceof DTClientBase && (bl = (Boolean)((JComponent)component).getClientProperty(DTClientProperty.DEBUGGER_TO_FRONT)) != null && bl.booleanValue()) {
            bl2 = true;
        }
        boolean bl3 = sFirstBPInDebugMode;
        sFirstBPInDebugMode = false;
        Editor editor = null;
        FileStorageLocation fileStorageLocation = new FileStorageLocation(absoluteFile.toFile());
        if (this.isEditorOpen((StorageLocation)fileStorageLocation)) {
            EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient((StorageLocation)fileStorageLocation);
            editor = editorViewClient.getEditor();
            boolean bl4 = false;
            DTFrame dTFrame = EditorStartup.getParentDesktop().getContainingFrame((Component)((Object)editorViewClient));
            if (dTFrame != null && dTFrame.isMinimized() && MatlabDebugServices.isGraphicalDebuggingEnabled()) {
                bl4 = true;
                EditorStartup.getParentDesktop().showClient((Component)((Object)editorViewClient), null, true);
            }
            if (!bl4) {
                if (bl2) {
                    if (dTFrame != null) {
                        dTFrame.toFront();
                    }
                    EditorStartup.getParentDesktop().showClient((Component)((Object)editorViewClient), null, true);
                } else if (bl3 && MatlabDebugServices.isGraphicalDebuggingEnabled()) {
                    if (EditorStartup.getParentDesktop().getContainingFrame(component) != dTFrame) {
                        if (dTFrame != null) {
                            dTFrame.toFront();
                        }
                        EditorStartup.getParentDesktop().showClient((Component)((Object)editorViewClient), null, true);
                    } else {
                        EditorStartup.getParentDesktop().toFront((Component)((Object)editorViewClient));
                    }
                } else if (component instanceof EditorViewClient) {
                    EditorViewClient editorViewClient2 = (EditorViewClient)((Object)component);
                    if (EditorStartup.getParentDesktop().isClientDocked((Component)((Object)editorViewClient2)) && EditorStartup.getParentDesktop().isClientDocked((Component)((Object)editorViewClient))) {
                        EditorStartup.getParentDesktop().toFrontOfGroup((Component)((Object)editorViewClient));
                    } else {
                        EditorStartup.getParentDesktop().showClient((Component)((Object)editorViewClient), null, true);
                    }
                } else {
                    EditorStartup.getParentDesktop().toFrontOfGroup((Component)((Object)editorViewClient));
                }
            }
            editor.goToLine(n, 0);
        } else if ((MatlabDebugServices.isGraphicalDebuggingEnabled() || EditorStartup.wasDebugActivated()) && absoluteFile.exists()) {
            editor = this.doOpenUnopenedEditorForDebug(absoluteFile, n, bl2, component);
        }
        return editor;
    }

    private Editor doOpenUnopenedEditorForDebug(AbsoluteFile absoluteFile, int n, boolean bl, final Component component) {
        assert (absoluteFile != null) : "The given file cannot be null.";
        assert (absoluteFile.exists()) : "The given file must exist.";
        Editor editor = this.openEditor(absoluteFile.toFile());
        if (editor != null) {
            editor.goToLine(n, false);
            EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient(editor.getStorageLocation());
            DTFrame dTFrame = EditorStartup.getParentDesktop().getContainingFrame((Component)((Object)editorViewClient));
            boolean bl2 = false;
            if (dTFrame != null && dTFrame.isMinimized()) {
                bl2 = true;
                EditorStartup.getParentDesktop().showClient((Component)((Object)editorViewClient), null, true);
            }
            if (!bl2 && !bl && component != null && !(component instanceof EditorViewClient) && EditorStartup.getParentDesktop().getContainingFrame(component).equals(dTFrame)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorStartup.getParentDesktop().setClientSelected(component, true);
                    }
                });
            }
        }
        return editor;
    }

    SccFileProvider getSccFileProvider() {
        return this.fSccFileProvider;
    }

    public SccFileListener getSccFileListener() {
        return this.fSccFileListener;
    }

    private void doNotifySccFileListenerOfUntitledBufferClosing(Editor editor) {
        if (this.fSccFileListener != null) {
            String string = (String)editor.getProperty((Object)"untitledBufferName");
            assert (string != null) : "The untitled buffer should have a corresponding client property.";
            this.fSccFileListener.untitledBufferClosed(new FileEvent((Object)this, 8, string));
        }
    }

    private void doNotifySccFileListenerOfEditorClosing(Editor editor) {
        if (this.fSccFileListener != null) {
            this.fSccFileListener.editorClosed(editor);
        }
    }

    public static EditorViewClient getLastActiveEditorViewClient() {
        return (EditorViewClient)((Object)EditorStartup.getParentDesktop().getLastDocumentSelectedInGroup(EditorGroup.getTitle()));
    }

    private static Editor doNewEditor(String string) {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        EditorViewClient editorViewClient = MatlabEditorApplication.createBufferEditorViewClient();
        editorViewClient.setContents(string);
        return editorViewClient.getEditor();
    }

    private Editor doOpenEditorOnEdt(final File file) {
        MatlabEditorApplication.checkFileNotNull(file);
        MatlabEditorApplication.checkFileIsAbsolute(file);
        Editor editor = (Editor)EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                AbsoluteFile absoluteFile = MFilePathUtil.accountForPFilesAndMakeAbsolute(file);
                FileStorageLocation fileStorageLocation = new FileStorageLocation(absoluteFile.toFile());
                Editor editor = null;
                if (MatlabEditorApplication.this.isEditorOpen((StorageLocation)fileStorageLocation)) {
                    editor = MatlabEditorApplication.this.getEditor((StorageLocation)fileStorageLocation);
                } else if (absoluteFile.exists() && absoluteFile.isDirectory()) {
                    editor = MatlabEditorApplication.this.doUserTriedToOpenDirectory(absoluteFile);
                } else if (absoluteFile.exists()) {
                    editor = MatlabEditorApplication.createEditorViewClientFromExistingFile(absoluteFile).getEditor();
                } else if (MatlabEditorApplication.userWantsToOpenNonExistentFile(absoluteFile)) {
                    EditorViewClient editorViewClient = MatlabEditorApplication.createEditorViewClientFromNonExistentFile(absoluteFile);
                    editor = editorViewClient == null ? null : editorViewClient.getEditor();
                }
                return editor;
            }
        });
        if (editor != null) {
            editor.bringToFront();
        }
        return editor;
    }

    private Editor doUserTriedToOpenDirectory(AbsoluteFile absoluteFile) {
        String string = EditorUtils.createCannotOpenDirectoryMessage(absoluteFile.toFile());
        int n = DialogFactory.getEditorDialogProvider().shouldOpenUntitledEditor(EditorUiUtils.getEditorGroupComponent(), string);
        Editor editor = null;
        if (n == 0) {
            editor = this.newEditor("");
        }
        return editor;
    }

    private static void checkBackingStoreNotNull(BackingStore<?> backingStore) {
        if (backingStore == null) {
            throw new IllegalArgumentException("BackingStore cannot be null");
        }
    }

    private static void checkUiInfoProvider(UiInfoProvider uiInfoProvider) {
        if (uiInfoProvider == null) {
            throw new IllegalArgumentException("UiInfoProvider cannot be null");
        }
    }

    private static void checkFileNotNull(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The given File cannot be null.");
        }
    }

    private static void checkFileIsAbsolute(File file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("The given File must have an absolute path: " + file.getAbsolutePath());
        }
    }

    private static void checkFileExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("The given File must exist: " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditorViewClient findEditorViewClient(StorageLocation storageLocation) {
        EditorViewClient editorViewClient = null;
        for (EditorViewClient editorViewClient2 : EditorGroup.getInstance().getOpenEditorViewClients()) {
            Editor editor = editorViewClient2.getEditor();
            if (editor == null || !editor.lockIfOpen()) continue;
            try {
                if (!storageLocation.isTheSameAs(editor.getStorageLocation())) continue;
                editorViewClient = editorViewClient2;
                break;
            }
            finally {
                editor.unlock();
            }
        }
        return editorViewClient;
    }

    private static void installAutoSave(Editor editor, TextFileBackingStore textFileBackingStore, UiInfoProvider uiInfoProvider) {
        TextFileBackingStoreAutoSaveImplementor textFileBackingStoreAutoSaveImplementor = new TextFileBackingStoreAutoSaveImplementor(editor, textFileBackingStore, uiInfoProvider);
        AutoSaveTimer.getInstance().addAutoSaveImplementor(textFileBackingStoreAutoSaveImplementor);
        MatlabEditorApplication.getInstance().addEditorApplicationListener(MatlabEditorApplication.createAutoSaveImplementorUnregisteringListener(editor, textFileBackingStoreAutoSaveImplementor));
    }

    public static void installSaveInterceptor(TextFileBackingStore textFileBackingStore, EditorViewClient editorViewClient) {
        textFileBackingStore.setSaveInterceptor(MatlabEditorApplication.createSaveAsInterceptor(editorViewClient));
    }

    private static void installFileChooserSetupDelegate(TextFileBackingStore textFileBackingStore, EditorView editorView) {
        textFileBackingStore.setFileChooserSetupDelegate(MatlabEditorApplication.createFileChooserSetupDelegate(editorView));
    }

    private static void installEncodingProvider(TextFileBackingStore textFileBackingStore, EditorView editorView) {
        textFileBackingStore.setEncodingProvider(MatlabEditorApplication.createEncodingProvider(editorView));
    }

    private static void installBackingFileListener(TextFileBackingStore textFileBackingStore) {
        textFileBackingStore.addPropertyChangeListener("backingData", MatlabEditorApplication.createPathToBackingFilePropertyChangeListener());
    }

    public static void installDefaultEditorFeatures(TextFileBackingStore textFileBackingStore, UiInfoProvider uiInfoProvider, EditorViewClient editorViewClient) {
        Editor editor = editorViewClient.getEditor();
        assert (editor != null) : "Editor should not be null when being initialized";
        EditorView editorView = editorViewClient.getEditorView();
        assert (editorView != null) : "EditorView should not be null when being initialized";
        MatlabEditorApplication.installAutoSave(editor, textFileBackingStore, uiInfoProvider);
        MatlabEditorApplication.installSaveInterceptor(textFileBackingStore, editorViewClient);
        MatlabEditorApplication.installFileChooserSetupDelegate(textFileBackingStore, editorView);
        MatlabEditorApplication.installEncodingProvider(textFileBackingStore, editorView);
        MatlabEditorApplication.installBackingFileListener(textFileBackingStore);
        textFileBackingStore.setDefaultFileNameProvider(MatlabEditorApplication.createDefaultFileNameProvider(editor));
    }

    private static EditorViewClient createBufferEditorViewClient() {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        TextFileBackingStore textFileBackingStore = TextFileBackingStore.createWithNoBackingFile();
        EditorViewClient editorViewClient = MatlabEditorApplication.createEditorViewClient(textFileBackingStore);
        MatlabEditorApplication.updateUntitledBufferClientProperty(editorViewClient.getEditor(), textFileBackingStore);
        return editorViewClient;
    }

    private static EditorViewClient createEditorViewClientFromNonExistentFile(AbsoluteFile absoluteFile) {
        EditorViewClient editorViewClient;
        block6: {
            assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
            assert (!absoluteFile.exists()) : "The given file should not exist.";
            editorViewClient = null;
            try {
                if (SpecifyNewFilenameDialog.shouldShowDialog((File)absoluteFile.toFile())) {
                    File file = SpecifyNewFilenameDialog.getNewFilenameForBadFilename((File)absoluteFile.toFile(), (String)EditorUtils.EDITOR_TITLE, (Frame)EditorUiUtils.getFrameToCenterDialogOn(absoluteFile.toFile()));
                    if (file == null) {
                        return null;
                    }
                    absoluteFile = new AbsoluteFile(file);
                }
                absoluteFile.createNewFile();
                editorViewClient = MatlabEditorApplication.createEditorViewClientFromExistingFile(absoluteFile);
                EditorUtils.getMatlab().callRehashToolboxIfToolboxFile(absoluteFile.toFile());
            }
            catch (IOException iOException) {
                int n = DialogFactory.getEditorDialogProvider().shouldOpenUntitledEditor(EditorUiUtils.getEditorGroupComponent(), MessageFormat.format(EditorUtils.lookup("error.CannotCreateFileInDir"), MFilePathUtil.getTruncatedFilename(absoluteFile.getPath()), iOException.getLocalizedMessage()));
                if (n != 0) break block6;
                editorViewClient = MatlabEditorApplication.createBufferEditorViewClient();
            }
        }
        return editorViewClient;
    }

    private static EditorViewClient createEditorViewClientFromExistingFile(AbsoluteFile absoluteFile) {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        assert (absoluteFile.exists()) : "The given file does not exist.";
        EditorStartup.getParentDesktop().getRecentFiles().addFile(EditorUtils.getEditorGroupName(), absoluteFile.getPath());
        return MatlabEditorApplication.createEditorViewClient(TextFileBackingStore.createWithExistentBackingFile((File)absoluteFile.toFile()));
    }

    private static EditorViewClient createEditorViewClient(TextFileBackingStore textFileBackingStore) {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        TextFileUiInfoProvider textFileUiInfoProvider = new TextFileUiInfoProvider(textFileBackingStore);
        EditorViewClient editorViewClient = MatlabEditorApplication.createEditorViewClient((BackingStore<Document>)textFileBackingStore, (UiInfoProvider)textFileUiInfoProvider);
        MatlabEditorApplication.installDefaultEditorFeatures(textFileBackingStore, (UiInfoProvider)textFileUiInfoProvider, editorViewClient);
        return editorViewClient;
    }

    private static EditorViewClient createEditorViewClient(BackingStore<Document> backingStore, UiInfoProvider uiInfoProvider) {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        EditorViewClient editorViewClient = null;
        try {
            editorViewClient = new EditorViewClient(backingStore, uiInfoProvider);
            EditorStartup.getParentDesktop().addClient((Component)((Object)editorViewClient), editorViewClient.getLongTitle(), true, null, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = uiInfoProvider.getShortName();
            DialogFactory.showNotEnoughMemoryToOpenResourceDialog(string, (Component)((Object)editorViewClient));
            throw outOfMemoryError;
        }
        return editorViewClient;
    }

    private DTClientListener createSourceControlDesktopClientListener() {
        return new DTClientAdapter(){

            public void clientActivated(DTClientEvent dTClientEvent) {
                if (MatlabEditorApplication.this.fSccFileListener != null) {
                    MatlabEditorApplication.this.fSccFileListener.fileSelectionChanged(new FileEvent((Object)this, 7));
                }
            }

            public void clientClosing(DTClientEvent dTClientEvent) {
                Editor editor = ((EditorViewClient)((Object)dTClientEvent.getClient())).getEditor();
                if (editor.isBuffer()) {
                    MatlabEditorApplication.this.doNotifySccFileListenerOfUntitledBufferClosing(editor);
                } else {
                    MatlabEditorApplication.this.doNotifySccFileListenerOfEditorClosing(editor);
                }
            }
        };
    }

    private SccFileProvider createSccFileProvider() {
        return new SccFileProvider(){

            public void installSccFileListener(SccFileListener sccFileListener) {
                MatlabEditorApplication.this.fSccFileListener = sccFileListener;
            }

            public void uinstallSccFileListener() {
                MatlabEditorApplication.this.fSccFileListener = null;
            }

            public Frame getFrame(String string) {
                return string == null || !MatlabEditorApplication.this.isEditorOpen((StorageLocation)new FileStorageLocation(new File(string))) ? null : EditorStartup.getParentDesktop().getContainingFrame((Component)((Object)MatlabEditorApplication.findEditorViewClient((StorageLocation)new FileStorageLocation(new File(string)))));
            }

            public String[] getSelectedFiles() {
                return MatlabEditorApplication.this.doGetSelectedFiles();
            }

            public boolean save(String string) {
                MatlabEditorApplication.this.getEditor((StorageLocation)new FileStorageLocation(new File(string))).negotiateSave();
                return true;
            }
        };
    }

    private String[] doGetSelectedFiles() {
        Editor editor = this.getActiveEditor();
        String string = null;
        if (editor != null) {
            if (editor.getStorageLocation() instanceof FileStorageLocation) {
                string = ((FileStorageLocation)editor.getStorageLocation()).getFile().getAbsolutePath();
            } else if (editor.getStorageLocation() instanceof FutureFileStorageLocation) {
                string = this.getActiveEditor().getShortName();
            }
        }
        return new String[]{string};
    }

    private static EditorApplicationListener createAutoSaveImplementorUnregisteringListener(final Editor editor, final AutoSaveImplementor autoSaveImplementor) {
        return new EditorApplicationListener(){

            public void editorOpened(Editor editor2) {
            }

            public void editorClosed(Editor editor2) {
                if (editor.equals(editor2)) {
                    AutoSaveTimer.getInstance().removeAutoSaveImplementor(autoSaveImplementor);
                    MatlabEditorApplication.getInstance().removeEditorApplicationListener(this);
                }
            }
        };
    }

    private static TextFileBackingStore.DefaultFileNameProvider createDefaultFileNameProvider(final Editor editor) {
        return new TextFileBackingStore.DefaultFileNameProvider(){

            public String getDefaultFileName() {
                String string = MDocumentUtils.getDefaultFilename((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)editor.getDocument())));
                string = string == null || string.length() == 0 ? editor.getShortName() : string;
                return string + ".m";
            }
        };
    }

    private static TextFileBackingStore.SaveInterceptor createSaveAsInterceptor(final EditorViewClient editorViewClient) {
        return new TextFileBackingStore.SaveInterceptor(){

            public boolean saveAboutToHappen(File file, AbstractBackingStore.UserInteractionModel userInteractionModel) {
                boolean bl = editorViewClient.isBeingDebugged(file);
                if (bl && !userInteractionModel.areDialogsAllowed()) {
                    String string = MessageFormat.format(EditorUtils.lookup("msg.SaveAsWhileDebug"), file.getName());
                    userInteractionModel.communicateError(string, EditorUtils.EDITOR_TITLE);
                    return false;
                }
                return !bl || editorViewClient.promptToExitDebugMode(file);
            }

            public boolean saveAsAboutToHappen(File file, File file2, AbstractBackingStore.UserInteractionModel userInteractionModel) {
                boolean bl;
                Validate.notNull((Object)file2, (String)"The new file cannot be null.");
                boolean bl2 = FileUtils.areFilesTheSame((File)file, (File)file2);
                boolean bl3 = MatlabEditorApplication.getInstance().isEditorOpen((StorageLocation)new FileStorageLocation(file2));
                boolean bl4 = bl = bl2 || !bl3;
                if (!bl) {
                    String string = MessageFormat.format(EditorUtils.lookup("msg.FileAlreadyOpen"), file2.getName());
                    userInteractionModel.communicateError(string, EditorUtils.EDITOR_TITLE);
                }
                return bl;
            }

            public File possiblyModifyFileToSaveAsTo(File file) {
                if (SpecifyNewFilenameDialog.shouldShowDialog((File)file)) {
                    Frame frame = EditorUiUtils.getParentFrame((Component)((Object)editorViewClient));
                    file = SpecifyNewFilenameDialog.getNewFilenameForBadFilename((File)file, (String)EditorUtils.EDITOR_TITLE, (Frame)frame);
                }
                return file;
            }
        };
    }

    private static TextFileBackingStore.FileChooserSetupDelegate createFileChooserSetupDelegate(final EditorView editorView) {
        return new TextFileBackingStore.FileChooserSetupDelegate(){

            public void setupFileChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
                if (SyntaxTextPaneUtilities.isMCode((STPInterface)editorView.getSyntaxTextPane())) {
                    mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)FileExtensionFilter.getMFileFilter());
                } else if (SyntaxTextPaneUtilities.isSimscapeCode((STPInterface)editorView.getSyntaxTextPane())) {
                    mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)FileExtensionFilter.getSimscapeFileFilter());
                }
            }
        };
    }

    private static TextFileBackingStore.EncodingProvider createEncodingProvider(final EditorView editorView) {
        return new TextFileBackingStore.EncodingProvider(){

            public Charset getEncoding(Charset charset) {
                return SyntaxTextPaneUtilities.getContentBasedEncodingOrGivenDefault((STPInterface)editorView.getSyntaxTextPane(), (Charset)charset);
            }
        };
    }

    private static DebugListener createDebugListener() {
        return new DebugAdapter(){

            @Override
            public void errorInBreakpointExpression(int n, File file, String string) {
                Editor editor = MatlabEditorApplication.getInstance().getEditor((StorageLocation)new FileStorageLocation(file));
                if (editor != null) {
                    String string2 = MatlabBreakpointUtils.convertFileToStringPath(file);
                    Frame frame = EditorUiUtils.getParentFrame(editor.getComponent());
                    String string3 = MatlabBreakpointUtils.lookup("errorMessage.file") + " " + MFilePathUtil.getTruncatedFilename(string2) + "\n\n" + string;
                    DialogFactory.showWarningMessage(frame, string3);
                }
            }
        };
    }

    private static FileSystemListener createFileSystemListener() {
        return new FileSystemAdapter(){

            public void fileMoved(final File file, final File file2) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (file2.isDirectory()) {
                            for (EditorViewClient editorViewClient : EditorGroup.getInstance().getOpenEditorViewClients()) {
                                String string;
                                TextFileBackingStore textFileBackingStore;
                                if (!(editorViewClient.getEditorView().getBackingStore() instanceof TextFileBackingStore) || !(textFileBackingStore = (TextFileBackingStore)editorViewClient.getEditorView().getBackingStore()).isPersistenceLocationSet() || (string = FileUtils.getRelativePathFromDirectory((File)file, (File)textFileBackingStore.getFile())) == null) continue;
                                this.setEditorFile(editorViewClient, new File(file2, string));
                            }
                        } else {
                            EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient((StorageLocation)new FileStorageLocation(file));
                            if (editorViewClient != null) {
                                this.setEditorFile(editorViewClient, file2);
                            }
                        }
                    }
                });
            }

            public void fileDeleted(final File file) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient((StorageLocation)new FileStorageLocation(file));
                        if (editorViewClient != null) {
                            this.markEditorDeleted(editorViewClient);
                        } else {
                            for (EditorViewClient editorViewClient2 : EditorGroup.getInstance().getOpenEditorViewClients()) {
                                TextFileBackingStore textFileBackingStore;
                                if (!(editorViewClient2.getEditorView().getBackingStore() instanceof TextFileBackingStore) || !(textFileBackingStore = (TextFileBackingStore)editorViewClient2.getEditorView().getBackingStore()).isPersistenceLocationSet() || FileUtils.getRelativePathFromDirectory((File)file, (File)textFileBackingStore.getFile()) == null) continue;
                                this.markEditorDeleted(editorViewClient2);
                            }
                        }
                    }
                });
            }

            private void markEditorDeleted(EditorViewClient editorViewClient) {
                this.setEditorFile(editorViewClient, null);
                editorViewClient.getEditorView().markAsDifferentFromSource();
            }

            private void setEditorFile(EditorViewClient editorViewClient, File file) {
                BackingStore<Document> backingStore = editorViewClient.getEditorView().getBackingStore();
                assert (backingStore instanceof TextFileBackingStore) : "Backing store for an Editor associated with a File must be a TextFileBackingStore";
                if (file != null) {
                    file = new AbsoluteFile(file).toFile();
                    assert (file.exists()) : "Cannot set Editor to a non-existing file: " + file.getPath();
                }
                ((TextFileBackingStore)backingStore).setFile(file);
            }
        };
    }

    private static PropertyChangeListener createPathToBackingFilePropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                assert (propertyChangeEvent.getNewValue() != null && (propertyChangeEvent.getNewValue() == AbstractBackingStore.BACKING_DATA_EMPTY_VALUE || propertyChangeEvent.getNewValue() instanceof String) && !propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue())) : "The new value should be a non-null String and different from the old value.";
                if (propertyChangeEvent.getNewValue() == AbstractBackingStore.BACKING_DATA_EMPTY_VALUE) {
                    assert (propertyChangeEvent.getSource() instanceof TextFileBackingStore) : "Event source is not instance of text backing store.";
                    TextFileBackingStore textFileBackingStore = (TextFileBackingStore)propertyChangeEvent.getSource();
                    EditorViewClient editorViewClient = MatlabEditorApplication.findEditorViewClient(textFileBackingStore.getStorageLocation());
                    assert (editorViewClient != null) : "Should have an open Editor for " + textFileBackingStore.getStorageLocation();
                    MatlabEditorApplication.updateUntitledBufferClientProperty(editorViewClient.getEditor(), textFileBackingStore);
                } else {
                    String string = (String)propertyChangeEvent.getNewValue();
                    File file = new File(string);
                    if (file.exists()) {
                        assert (file.isFile()) : "The new value is not the path to a File.";
                        EditorStartup.getParentDesktop().getRecentFiles().addFile(EditorUtils.getEditorGroupName(), string);
                    }
                }
            }
        };
    }

    private static void updateUntitledBufferClientProperty(Editor editor, TextFileBackingStore textFileBackingStore) {
        assert (!textFileBackingStore.isPersistenceLocationSet()) : "Persistence location should not be set for buffer case";
        editor.putProperty("untitledBufferName", (Object)new File(textFileBackingStore.getDefaultDirectoryLocationAtTimeOfCreation(), editor.getShortName()).getAbsolutePath());
    }

    static {
        INSTANCE = new MatlabEditorApplication();
    }
}

