/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.TextPrintPanel;
import java.awt.Font;

public class EditorPrefsPrintPanel
extends TextPrintPanel {
    private static EditorPrefsPrintPanel sPrefsPanel = null;

    public EditorPrefsPrintPanel(String string, Font[] fontArray, String string2) {
        super(EditorOptions.getPrintOptions(), true, string, fontArray, string2);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        String string = EditorStartup.intlString("edpt.fontlabel");
        String string2 = PlatformInfo.isWindows() ? EditorStartup.intlString("edpt.previewlabel.win") : EditorStartup.intlString("edpt.previewlabel.other");
        Font[] fontArray = new Font[3];
        if (Prefs.exists((String)"EditorTextFont")) {
            fontArray[0] = Prefs.getFontPref((String)"EditorTextFont");
        }
        if (Prefs.exists((String)"EditorHeaderFont")) {
            fontArray[1] = Prefs.getFontPref((String)"EditorHeaderFont");
        }
        sPrefsPanel = new EditorPrefsPrintPanel(string, fontArray, string2);
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl) {
            EditorPrefsPrintPanel.commitPrefsChanges();
        }
    }

    private void saveOptions() {
        int n = this.getValue();
        EditorOptions.setPrintOptions(n);
        Font[] fontArray = this.getFonts();
        if ((n & 0x8000) == 0) {
            EditorOptions.setPrintingBodyCustomFont(fontArray[0]);
        }
        if ((n & 0x4000) == 0) {
            EditorOptions.setPrintingHeaderCustomFont(fontArray[1]);
        }
    }
}

