/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.editor.EditorMenuID;
import com.mathworks.matlab.api.editor.EditorToolBarGroupID;
import com.mathworks.matlab.api.editor.actions.KeyBindingContributor;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.matlab.api.toolbars.ToolBarBuilder;
import com.mathworks.matlab.api.toolbars.ToolBarContributor;
import com.mathworks.matlab.api.toolbars.ToolBarGroupID;
import com.mathworks.matlab.api.toolbars.ToolBarID;
import com.mathworks.matlab.api.toolbars.ToolBars;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.editor.ActionID;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.SelectionAction;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.functionhints.FunctionHintUtils;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mlwidgets.stack.StackComboBox;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.SplitScreenActions;
import com.mathworks.widgets.SyntaxTextPaneMultiView;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.menus.DefaultMenuBuilder;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.toolbars.DefaultToolBarBuilder;
import com.mathworks.widgets.toolbars.DefaultToolBars;
import com.mathworks.widgets.toolbars.ToolBarItems;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ActionManager {
    private final Map<String, MJAbstractAction> fActionMap;
    private final MJAbstractAction fCloseFileAction;
    private SplitScreenActions fSplitScreenActions;
    private CodeFoldsMenuItemValidationListener fCodeFoldMenuItemValidator;
    private JMenu fTextFoldMenu;
    public static final String STACK_DISPLAY_TOOLBAR_KEY = "Stack";
    private STPInterface fComponent;
    private CodepadActionManager fCodepadActionManager;
    private final Editor fEditor;
    private static final int MAX_OPEN_SELECTION_MENU_ITEM_WIDTH_PX = 300;
    private static Collection<String> sIgnoredContributors = new HashSet<String>();
    private final KeyBindingContributorProvider fKeyBindingContributorProvider;

    private static void ignoreMenuContributor(String string) {
        sIgnoredContributors.add(string);
    }

    private static void clearIgnoredMenuContributors() {
        sIgnoredContributors.clear();
    }

    private static MJAbstractAction createWrapperAction(DTMenuMergeTag dTMenuMergeTag, String string) {
        return DTUtilities.createDTChildAction((DTMenuMergeTag)dTMenuMergeTag, (String)"MATLABEditor", (String)string, (KeyBindingManager)MatlabKeyBindings.getManager());
    }

    public ActionManager(Editor editor, KeyBindingContributorProvider keyBindingContributorProvider) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)keyBindingContributorProvider, (String)"'keyBindingContributorProvider' cannot be null");
        this.fEditor = editor;
        this.fActionMap = new HashMap<String, MJAbstractAction>();
        this.fCodepadActionManager = new CodepadActionManager();
        this.fCloseFileAction = ActionManager.createWrapperAction(DTMenuMergeTag.CLOSE, "close-item");
        this.fKeyBindingContributorProvider = keyBindingContributorProvider;
    }

    public ActionManager(Editor editor) {
        this(editor, new OSGiKeyBindingContributorProvider());
    }

    MJAbstractAction getAction(ActionID actionID) {
        MJAbstractAction mJAbstractAction = this.fActionMap.get(actionID.getId());
        assert (mJAbstractAction != null) : "Not in action map: " + (Object)((Object)actionID);
        return mJAbstractAction;
    }

    public MJAbstractAction getAction(EditorAction editorAction) {
        MJAbstractAction mJAbstractAction = this.fActionMap.get(editorAction.getActionId());
        if (mJAbstractAction == null) {
            mJAbstractAction = editorAction.getAction();
            this.addAction(editorAction.getActionId(), mJAbstractAction);
        }
        return mJAbstractAction;
    }

    STPInterface getSyntaxTextPane() {
        return this.fComponent;
    }

    SplitScreenActions getSplitScreenActions() {
        return this.fSplitScreenActions;
    }

    private void addAction(String string, MJAbstractAction mJAbstractAction) {
        this.fActionMap.put(string, mJAbstractAction);
    }

    void cleanup() {
        if (this.fTextFoldMenu != null && this.fCodeFoldMenuItemValidator != null) {
            this.fTextFoldMenu.removeMenuListener(this.fCodeFoldMenuItemValidator);
            this.fCodeFoldMenuItemValidator = null;
            this.fTextFoldMenu = null;
        }
        this.fCodepadActionManager.cleanup();
        this.fComponent = null;
    }

    private void addComponentActions(STPInterface sTPInterface) {
        this.fComponent = sTPInterface;
        ActionMap actionMap = this.fComponent.getActionMap();
        InputMap inputMap = sTPInterface.getInputMap(0);
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(inputMap);
        MInputMap mInputMap2 = mInputMap;
        for (KeyBindingContributor object : this.getApplicableKeyBindingContributors()) {
            MInputMap mInputMap3 = object.buildInputMap(this.fEditor, actionMap);
            mInputMap3.setParent((InputMap)mInputMap2);
            mInputMap2 = mInputMap3;
        }
        MInputMap mInputMap4 = new MInputMap();
        mInputMap4.setParent((InputMap)mInputMap2);
        sTPInterface.setInputMap(0, (InputMap)mInputMap4);
        this.fCodepadActionManager.addComponentActions(mInputMap4, sTPInterface.getActionMap());
        for (MJAbstractAction mJAbstractAction : this.getEditorInputActions()) {
            actionMap.put(mJAbstractAction.getValue("ActionCommandKey"), (Action)mJAbstractAction);
            MatlabKeyBindings.getManager().addKeyBindings("MATLABEditor", mJAbstractAction.getActionID(), (ExtendedInputMap)mInputMap);
        }
        if (ActionManager.isMatlab(this.fEditor)) {
            FunctionHintUtils.addFunctionHintActions(actionMap);
        }
    }

    private List<KeyBindingContributor> getApplicableKeyBindingContributors() {
        ArrayList<KeyBindingContributor> arrayList = new ArrayList<KeyBindingContributor>();
        for (KeyBindingContributor keyBindingContributor : this.fKeyBindingContributorProvider.getContributors()) {
            if (!keyBindingContributor.isApplicable(this.fEditor)) continue;
            arrayList.add(keyBindingContributor);
        }
        return arrayList;
    }

    private List<MJAbstractAction> getEditorInputActions() {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        linkedList.add(this.getAction(EditorAction.FIND_SELECTION_BACK));
        linkedList.add(this.getAction(EditorAction.FIND_SELECTION));
        linkedList.add(this.getAction(EditorAction.FIND));
        linkedList.add(this.getAction(EditorAction.FIND_AGAIN_BACK));
        linkedList.add(this.getAction(EditorAction.FIND_AGAIN));
        linkedList.add(this.getAction(EditorAction.HELP_ON_SELECTION));
        if (ActionManager.isMatlab(this.fEditor)) {
            linkedList.add(this.getAction(EditorAction.FUNCTION_BROWSER));
            linkedList.add(this.getAction(EditorAction.FUNCTION_HINTS));
        }
        linkedList.add(this.getAction(EditorAction.GOTO));
        linkedList.add(this.getAction(EditorAction.COPY_FULL_PATH));
        linkedList.addAll(this.fSplitScreenActions.getAllActions());
        if (MLDesktop.getInstance().useToolstrip()) {
            linkedList.add(this.getAction(EditorAction.OPEN));
            linkedList.add(this.getAction(EditorAction.SAVE));
            linkedList.add(this.getAction(EditorAction.SAVE_AS));
            linkedList.add(this.getAction(EditorAction.SAVE_ALL));
            linkedList.add(this.getAction(EditorAction.SAVE_BACKUP));
            linkedList.add(this.getAction(EditorAction.PRINT));
            linkedList.add(this.getAction(EditorAction.PRINT_SELECTION));
            linkedList.add(this.getAction(EditorAction.PAGE_SETUP));
            linkedList.add(this.getAction(ActionID.PREVIOUS_LOCATION));
            linkedList.add(this.getAction(ActionID.NEXT_LOCATION));
            linkedList.add(this.getAction(EditorAction.FIND_FILES));
            linkedList.add(this.getAction(EditorAction.EVALUATE_SELECTION));
            linkedList.add(this.getAction(EditorAction.NEXT_BOOKMARK));
            linkedList.add(this.getAction(EditorAction.PREVIOUS_BOOKMARK));
            linkedList.add(this.getAction(EditorAction.TOGGLE_BOOKMARK));
            linkedList.add(this.getAction(EditorAction.OPEN_SELECTION));
        }
        return linkedList;
    }

    public void createSyntaxTextPaneActions(SyntaxTextPaneMultiView syntaxTextPaneMultiView) {
        this.addAction(ActionID.CUT.getId(), syntaxTextPaneMultiView.getCutAction());
        this.addAction(ActionID.COPY.getId(), syntaxTextPaneMultiView.getCopyAction());
        this.addAction(ActionID.PASTE.getId(), syntaxTextPaneMultiView.getPasteAction());
        this.addAction(ActionID.INDENT.getId(), syntaxTextPaneMultiView.getIndentAction());
        this.addAction(ActionID.UNINDENT.getId(), syntaxTextPaneMultiView.getUnindentAction());
        this.addAction(ActionID.SMART_INDENT.getId(), syntaxTextPaneMultiView.getSmartIndentAction());
        this.addAction(ActionID.UNDO.getId(), syntaxTextPaneMultiView.getUndoAction());
        this.addAction(ActionID.REDO.getId(), syntaxTextPaneMultiView.getRedoAction());
        this.addAction(ActionID.SELECT_ALL.getId(), syntaxTextPaneMultiView.getSelectAllAction());
        this.addAction(ActionID.DELETE.getId(), syntaxTextPaneMultiView.getDeleteAction());
        this.addAction(ActionID.COMMENT.getId(), syntaxTextPaneMultiView.getCommentAction());
        this.addAction(ActionID.UNCOMMENT.getId(), syntaxTextPaneMultiView.getUncommentAction());
        this.addAction(ActionID.MERGE_COMMENTS.getId(), syntaxTextPaneMultiView.getWrapCommentsAction());
        this.addAction(ActionID.TO_UPPERCASE.getId(), syntaxTextPaneMultiView.getToUpperCaseAction());
        this.addAction(ActionID.TO_LOWERCASE.getId(), syntaxTextPaneMultiView.getToLowerCaseAction());
        this.addAction(ActionID.NEXT_LOCATION.getId(), syntaxTextPaneMultiView.getNextJumpAction());
        this.addAction(ActionID.PREVIOUS_LOCATION.getId(), syntaxTextPaneMultiView.getPrevJumpAction());
        this.addAction(ActionID.COLLAPSE_ALL_FOLDS.getId(), syntaxTextPaneMultiView.getCollapseAllFoldsAction());
        this.addAction(ActionID.EXPAND_ALL_FOLDS.getId(), syntaxTextPaneMultiView.getExpandAllFoldsAction());
        this.addAction(ActionID.EXPAND_FOLD.getId(), syntaxTextPaneMultiView.getExpandFoldAction());
        this.addAction(ActionID.COLLAPSE_FOLD.getId(), syntaxTextPaneMultiView.getCollapseFoldAction());
        this.addAction(ActionID.FOLDS_MENU.getId(), syntaxTextPaneMultiView.getCodeFoldingMenuAction());
        this.fSplitScreenActions = syntaxTextPaneMultiView.getSplitScreenActions();
        this.addComponentActions((STPInterface)syntaxTextPaneMultiView);
    }

    private void updateOpenSelectionAction() {
        String string = SelectionAction.getOpenSelectionString(this.fEditor);
        String string2 = StringUtils.isEmpty((String)string) ? EditorUtils.lookup("action.openSelection") : MessageFormat.format(EditorUtils.lookup("action.openSelectionDynamic"), ActionManager.trimOpenSelectionMenuItemTextIfNeccessary(string));
        this.getAction(EditorAction.OPEN_SELECTION).setName(string2);
    }

    private static String trimOpenSelectionMenuItemTextIfNeccessary(String string) {
        FontMetrics fontMetrics = new JPopupMenu().getFontMetrics(UIManager.getFont("MenuItem.font"));
        return new SimpleStringTrimmer().shortenString(string, fontMetrics, 300);
    }

    static void setOpenAsTextObserver(Observer observer) {
        EditorAction.OPEN_AS_TEXT.getAction().setObserver(observer);
    }

    static void setOpenObserver(Observer observer) {
        EditorAction.OPEN.getAction().setObserver(observer);
    }

    static void setNewFileObserver(Observer observer) {
        EditorAction.NEW.getAction().setObserver(observer);
    }

    static void setSaveAllObserver(Observer observer) {
        EditorAction.SAVE_ALL.getAction().setObserver(observer);
    }

    void setSaveObserver(Observer observer) {
        this.observeAction(EditorAction.SAVE, observer);
    }

    void setSaveAsObserver(Observer observer) {
        this.observeAction(EditorAction.SAVE_AS, observer);
    }

    void setSaveBackupObserver(Observer observer) {
        this.observeAction(EditorAction.SAVE_BACKUP, observer);
    }

    static void setFindFilesObserver(Observer observer) {
        EditorAction.FIND_FILES.getAction().setObserver(observer);
    }

    static void setFindObserver(Observer observer) {
        EditorAction.FIND.getAction().setObserver(observer);
    }

    static void setFindAgainObserver(Observer observer) {
        EditorAction.FIND_AGAIN.getAction().setObserver(observer);
    }

    static void setFindAgainBackObserver(Observer observer) {
        EditorAction.FIND_AGAIN_BACK.getAction().setObserver(observer);
    }

    void setFindSelObserver(Observer observer) {
        this.observeAction(EditorAction.FIND_SELECTION, observer);
    }

    void setFindSelBackObserver(Observer observer) {
        this.observeAction(EditorAction.FIND_SELECTION_BACK, observer);
    }

    void setGotoObserver(Observer observer) {
        this.observeAction(EditorAction.GOTO, observer);
    }

    void setEvalSelObserver(Observer observer) {
        this.observeAction(EditorAction.EVALUATE_SELECTION, observer);
    }

    void setOpenSelObserver(Observer observer) {
        this.observeAction(EditorAction.OPEN_SELECTION, observer);
    }

    void setPrintSelObserver(Observer observer) {
        this.observeAction(EditorAction.PRINT_SELECTION, observer);
    }

    void setHelpSelObserver(Observer observer) {
        this.observeAction(EditorAction.HELP_ON_SELECTION, observer);
    }

    void setFunctionMenuObserver(Observer observer) {
        this.observeAction(EditorAction.FUNCTION_MENU, observer);
    }

    void setToggleBookmarkObserver(Observer observer) {
        this.observeAction(EditorAction.TOGGLE_BOOKMARK, observer);
    }

    void setNextBookmarkObserver(Observer observer) {
        this.observeAction(EditorAction.NEXT_BOOKMARK, observer);
    }

    void setPrevBookmarkObserver(Observer observer) {
        this.observeAction(EditorAction.PREVIOUS_BOOKMARK, observer);
    }

    void setPrintObserver(Observer observer) {
        this.observeAction(EditorAction.PRINT, observer);
    }

    void setPageSetupObserver(Observer observer) {
        this.observeAction(EditorAction.PAGE_SETUP, observer);
    }

    void setFunctionBrowserObserver(Observer observer) {
        this.observeAction(EditorAction.FUNCTION_BROWSER, observer);
    }

    void setFunctionHintsObserver(Observer observer) {
        this.observeAction(EditorAction.FUNCTION_HINTS, observer);
    }

    void setCopyFullPathObserver(Observer observer) {
        this.observeAction(EditorAction.COPY_FULL_PATH, observer);
    }

    private void observeAction(EditorAction editorAction, Observer observer) {
        EditorAction.ObservableAction observableAction = (EditorAction.ObservableAction)this.getAction(editorAction);
        observableAction.setObserver(observer);
    }

    static void enableSaveAll(boolean bl) {
        EditorAction.SAVE_ALL.getAction().setEnabled(bl);
    }

    static void enableFindAgainActions(boolean bl) {
        EditorAction.FIND_AGAIN.getAction().setEnabled(bl);
        EditorAction.FIND_AGAIN_BACK.getAction().setEnabled(bl);
    }

    void enableSelectionDependentActions(boolean bl) {
        this.getAction(EditorAction.FIND_SELECTION).setEnabled(bl);
        this.getAction(EditorAction.FIND_SELECTION_BACK).setEnabled(bl);
        this.getAction(EditorAction.PRINT_SELECTION).setEnabled(bl);
        this.getAction(EditorAction.EVALUATE_SELECTION).setEnabled(bl);
    }

    void enableBookmarkDependentCommands(boolean bl) {
        this.getAction(EditorAction.NEXT_BOOKMARK).setEnabled(bl);
        this.getAction(EditorAction.PREVIOUS_BOOKMARK).setEnabled(bl);
    }

    void updateDirtyDependentActions(boolean bl) {
        if (!MLDesktop.getInstance().useToolstrip()) {
            this.getAction(EditorAction.SAVE).setEnabled(bl);
        } else {
            this.getAction(EditorAction.SAVE).setEnabled(true);
        }
    }

    MJMenuBar createMenuBar() {
        final MJMenuBar mJMenuBar = new MJMenuBar();
        final HashMap<MenuID, MenuBuilder> hashMap = new HashMap<MenuID, MenuBuilder>();
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.FILE, this.buildFileMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.EDIT, this.buildEditMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.TEXT, this.buildTextMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.GO, this.buildGoMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.DEBUG, ActionManager.buildDebugMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.TOOLS, ActionManager.buildToolsMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.WINDOW, this.buildWindowMenu());
        ActionManager.addMenu(mJMenuBar, hashMap, EditorMenuID.HELP, ActionManager.buildHelpMenu());
        ActionManager.removeProductHelpAccelerator(mJMenuBar);
        MenuContext menuContext = new MenuContext(){
            private int iMenuBarInsertionPoint = 5;

            public MenuBuilder getBuilder(MenuID menuID) {
                MenuBuilder menuBuilder = (MenuBuilder)hashMap.get(menuID);
                assert (menuBuilder != null);
                return menuBuilder;
            }

            public void addNewMenu(MenuID menuID, String string, String string2) {
                if (hashMap.get(menuID) != null) {
                    throw new IllegalArgumentException("Menu \"" + menuID + "\" already exists");
                }
                DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(string, string2, new MenuGroupID[0]);
                hashMap.put(menuID, defaultMenuBuilder);
                mJMenuBar.add((Component)defaultMenuBuilder.getMenu(), this.iMenuBarInsertionPoint++);
            }

            public void refresh() {
                ActionManager.this.fEditor.refreshMenus();
            }
        };
        ActionManager.askMenuContributorsToContribute(this.fEditor, menuContext);
        ActionManager.removeEmptyMenus(mJMenuBar);
        return mJMenuBar;
    }

    private static MenuBuilder buildHelpMenu() {
        return new DefaultMenuBuilder(MLMenuMergeTag.HELP, new MenuGroupID[0]);
    }

    private static void addMenu(MJMenuBar mJMenuBar, Map<MenuID, MenuBuilder> map, EditorMenuID editorMenuID, MenuBuilder menuBuilder) {
        map.put((MenuID)editorMenuID, menuBuilder);
        mJMenuBar.add(menuBuilder.getMenu());
    }

    private static void removeEmptyMenus(MJMenuBar mJMenuBar) {
        for (int i = mJMenuBar.getMenuCount() - 1; i >= 0; --i) {
            if (mJMenuBar.getMenu(i).getMenuComponentCount() != 0) continue;
            mJMenuBar.remove(i);
        }
    }

    private static void askMenuContributorsToContribute(Editor editor, MenuContext menuContext) {
        for (MenuContributor menuContributor : ActionManager.getMenuContributors()) {
            if (sIgnoredContributors.contains(menuContributor.getClass().getName())) continue;
            try {
                menuContributor.contribute((Object)editor, menuContext);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    private static List<MenuContributor> getMenuContributors() {
        List list = (List)ClasspathOSGiManager.getInstance().getImplementors(MenuContributor.class);
        assert (list != null && !list.isEmpty()) : "Error: didn't find any MenuContributor services; check mde.jar";
        return list;
    }

    private MenuBuilder buildFileMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(DTMenuMergeTag.FILE, new MenuGroupID[]{EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, EditorMenuGroupID.FILE_SAVE_GROUP, EditorMenuGroupID.FILE_WORKSPACE_GROUP, EditorMenuGroupID.FILE_PRINT_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Component)ActionManager.createNewMenu());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)this.getAction(EditorAction.OPEN));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)this.getAction(EditorAction.OPEN_AS_TEXT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)this.getAction(EditorAction.OPEN_SELECTION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)this.fCloseFileAction);
        DTMenuMergeTag.OPEN.setTag((Action)this.getAction(EditorAction.OPEN));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Action)this.getAction(EditorAction.SAVE));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Action)this.getAction(EditorAction.SAVE_AS));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Action)this.getAction(EditorAction.SAVE_ALL));
        if (StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)this.fEditor.getStorageLocation())) {
            defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Action)this.getAction(EditorAction.SAVE_BACKUP));
        }
        this.installFileMenuListener(defaultMenuBuilder.getMenu());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_WORKSPACE_GROUP, ActionManager.createSaveWorkspaceAction());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_PRINT_GROUP, (Action)this.getAction(EditorAction.PAGE_SETUP));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_PRINT_GROUP, (Action)this.getAction(EditorAction.PRINT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_PRINT_GROUP, (Action)this.getAction(EditorAction.PRINT_SELECTION));
        DTMenuMergeTag.PAGE_SETUP.setTag((Action)this.getAction(EditorAction.PAGE_SETUP));
        DTMenuMergeTag.PRINT.setTag((Action)this.getAction(EditorAction.PRINT));
        DTMenuMergeTag.PRINT_SELECTION.setTag((Action)this.getAction(EditorAction.PRINT_SELECTION));
        return defaultMenuBuilder;
    }

    private MenuBuilder buildEditMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(DTMenuMergeTag.EDIT, new MenuGroupID[]{EditorMenuGroupID.EDIT_UNDO_REDO_GROUP, EditorMenuGroupID.EDIT_TEXT_GROUP, EditorMenuGroupID.EDIT_FIND_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_UNDO_REDO_GROUP, (Action)this.getAction(ActionID.UNDO));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_UNDO_REDO_GROUP, (Action)this.getAction(ActionID.REDO));
        DTMenuMergeTag.UNDO.setTag((Action)this.getAction(ActionID.UNDO));
        DTMenuMergeTag.REDO.setTag((Action)this.getAction(ActionID.REDO));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_TEXT_GROUP, (Action)this.getAction(ActionID.CUT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_TEXT_GROUP, (Action)this.getAction(ActionID.COPY));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_TEXT_GROUP, (Action)this.getAction(ActionID.PASTE));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_TEXT_GROUP, (Action)this.getAction(ActionID.SELECT_ALL));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_TEXT_GROUP, (Action)this.getAction(ActionID.DELETE));
        DTMenuMergeTag.CUT.setTag((Action)this.getAction(ActionID.CUT));
        DTMenuMergeTag.COPY.setTag((Action)this.getAction(ActionID.COPY));
        DTMenuMergeTag.PASTE.setTag((Action)this.getAction(ActionID.PASTE));
        DTMenuMergeTag.SELECT_ALL.setTag((Action)this.getAction(ActionID.SELECT_ALL));
        MLMenuMergeTag.DELETE.setTag((Action)this.getAction(ActionID.DELETE));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_FIND_GROUP, (Action)this.getAction(EditorAction.FIND));
        MLMenuMergeTag.FIND.setTag((Action)this.getAction(EditorAction.FIND));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_FIND_GROUP, (Action)this.getAction(EditorAction.FIND_AGAIN));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_FIND_GROUP, (Action)this.getAction(EditorAction.FIND_AGAIN_BACK));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_FIND_GROUP, (Action)this.getAction(EditorAction.FIND_SELECTION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.EDIT_FIND_GROUP, (Action)this.getAction(EditorAction.FIND_FILES));
        MLMenuMergeTag.FIND_FILES.setTag((Action)this.getAction(EditorAction.FIND_FILES));
        return defaultMenuBuilder;
    }

    private MenuBuilder buildTextMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(EditorUtils.lookup("menu.Text"), "TextMenu", new MenuGroupID[]{EditorMenuGroupID.TEXT_SELECTION_GROUP, EditorMenuGroupID.TEXT_COMMENT_GROUP, EditorMenuGroupID.TEXT_INDENT_GROUP, EditorMenuGroupID.TEXT_CASE_GROUP, EditorMenuGroupID.TEXT_FOLD_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_SELECTION_GROUP, (Action)this.getAction(EditorAction.EVALUATE_SELECTION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_COMMENT_GROUP, (Action)this.getAction(ActionID.MERGE_COMMENTS));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_COMMENT_GROUP, (Action)this.getAction(ActionID.COMMENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_COMMENT_GROUP, (Action)this.getAction(ActionID.UNCOMMENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_INDENT_GROUP, (Action)this.getAction(ActionID.UNINDENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_INDENT_GROUP, (Action)this.getAction(ActionID.INDENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_INDENT_GROUP, (Action)this.getAction(ActionID.SMART_INDENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_CASE_GROUP, (Action)this.getAction(ActionID.TO_LOWERCASE));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_CASE_GROUP, (Action)this.getAction(ActionID.TO_UPPERCASE));
        DefaultMenuBuilder defaultMenuBuilder2 = new DefaultMenuBuilder((Action)this.getAction(ActionID.FOLDS_MENU), "CodeFoldingMenu", new MenuGroupID[]{EditorMenuGroupID.FOLD_SINGLE_GROUP, EditorMenuGroupID.FOLD_ALL_GROUP});
        this.fTextFoldMenu = defaultMenuBuilder2.getMenu();
        this.fCodeFoldMenuItemValidator = new CodeFoldsMenuItemValidationListener();
        this.fTextFoldMenu.addMenuListener(this.fCodeFoldMenuItemValidator);
        defaultMenuBuilder2.add((MenuGroupID)EditorMenuGroupID.FOLD_SINGLE_GROUP, (Action)this.getAction(ActionID.EXPAND_FOLD));
        defaultMenuBuilder2.add((MenuGroupID)EditorMenuGroupID.FOLD_SINGLE_GROUP, (Action)this.getAction(ActionID.COLLAPSE_FOLD));
        defaultMenuBuilder2.add((MenuGroupID)EditorMenuGroupID.FOLD_ALL_GROUP, (Action)this.getAction(ActionID.EXPAND_ALL_FOLDS));
        defaultMenuBuilder2.add((MenuGroupID)EditorMenuGroupID.FOLD_ALL_GROUP, (Action)this.getAction(ActionID.COLLAPSE_ALL_FOLDS));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.TEXT_FOLD_GROUP, (Component)defaultMenuBuilder2.getMenu());
        return defaultMenuBuilder;
    }

    private MenuBuilder buildGoMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(EditorUtils.lookup("menu.Go"), "GoMenu", new MenuGroupID[]{EditorMenuGroupID.GO_JUMP_GROUP, EditorMenuGroupID.GO_BOOKMARK_GROUP, EditorMenuGroupID.GO_GOTO_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_JUMP_GROUP, (Action)this.getAction(ActionID.PREVIOUS_LOCATION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_JUMP_GROUP, (Action)this.getAction(ActionID.NEXT_LOCATION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_BOOKMARK_GROUP, (Action)this.getAction(EditorAction.TOGGLE_BOOKMARK));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_BOOKMARK_GROUP, (Action)this.getAction(EditorAction.NEXT_BOOKMARK));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_BOOKMARK_GROUP, (Action)this.getAction(EditorAction.PREVIOUS_BOOKMARK));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.GO_GOTO_GROUP, (Action)this.getAction(EditorAction.GOTO));
        return defaultMenuBuilder;
    }

    private static MenuBuilder buildToolsMenu() {
        return new DefaultMenuBuilder(EditorUtils.lookup("menu.Tools"), "ToolsMenu", new MenuGroupID[]{EditorMenuGroupID.TOOLS_REPORT_GROUP});
    }

    private MenuBuilder buildWindowMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(DTMenuMergeTag.WINDOW, new MenuGroupID[]{EditorMenuGroupID.WINDOW_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.WINDOW_GROUP, (Component)new DTMenuBoundary(DTMenuMergeTag.START_OF_MENU));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.WINDOW_GROUP, (Component)this.fSplitScreenActions.createMenu());
        defaultMenuBuilder.getMenu().addSeparator();
        return defaultMenuBuilder;
    }

    private static MenuBuilder buildDebugMenu() {
        MenuBuilder menuBuilder = ActionManager.createBaseDebugMenu();
        menuBuilder.insertGroupAfter((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, (MenuGroupID)EditorMenuGroupID.DEBUG_BREAKPOINTS_GROUP);
        return menuBuilder;
    }

    CodepadActionManager getCodepadActionManager() {
        return this.fCodepadActionManager;
    }

    private static MenuBuilder createBaseDebugMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder((DTMenuMergeTag)MLMenuMergeTag.DEBUG, new MenuGroupID[]{EditorMenuGroupID.DEBUG_RUN_GROUP});
        DebuggerManager debuggerManager = DebuggerManager.getInstance();
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, debuggerManager.getStepActionNoEcho());
        MLMenuMergeTag.STEP.setTag(debuggerManager.getStepActionNoEcho());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, debuggerManager.getStepInActionNoEcho());
        MLMenuMergeTag.STEP_IN.setTag(debuggerManager.getStepInActionNoEcho());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, debuggerManager.getStepOutActionNoEcho());
        MLMenuMergeTag.STEP_OUT.setTag(debuggerManager.getStepOutActionNoEcho());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, debuggerManager.getExitDebugAction());
        MLMenuMergeTag.EXIT_DEBUG.setTag(debuggerManager.getExitDebugAction());
        return defaultMenuBuilder;
    }

    static MJMenuBar createGroupMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(DTMenuMergeTag.FILE, new MenuGroupID[]{EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, EditorMenuGroupID.FILE_WORKSPACE_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Component)ActionManager.createNewMenu());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, ActionManager.createCloseGroupAction());
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)((Object)EditorAction.OPEN.getAction()));
        DTMenuMergeTag.OPEN.setTag((Action)((Object)EditorAction.OPEN.getAction()));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_NEW_OPEN_CLOSE_GROUP, (Action)((Object)EditorAction.OPEN_AS_TEXT.getAction()));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_WORKSPACE_GROUP, ActionManager.createSaveWorkspaceAction());
        mJMenuBar.add(defaultMenuBuilder.getMenu());
        MenuBuilder menuBuilder = ActionManager.createBaseDebugMenu();
        menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, DebugActions.getContinueNoEchoAction());
        MLMenuMergeTag.CONTINUE.setTag(DebugActions.getContinueNoEchoAction());
        mJMenuBar.add(menuBuilder.getMenu());
        ActionManager.removeProductHelpAccelerator(mJMenuBar);
        return mJMenuBar;
    }

    private static JMenu createNewMenu() {
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(DTMenuMergeTag.NEW, new MenuGroupID[]{EditorMenuGroupID.NEW_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.NEW_GROUP, (Action)((Object)EditorAction.NEW.getAction()));
        MLMenuMergeTag.NEW_MFILE.setTag((Action)((Object)EditorAction.NEW.getAction()));
        return defaultMenuBuilder.getMenu();
    }

    private static Action createSaveWorkspaceAction() {
        return ActionManager.createWrapperAction(MLMenuMergeTag.SAVE_WORKSPACE, "save-workspace");
    }

    private static void removeProductHelpAccelerator(MJMenuBar mJMenuBar) {
        MJMenu mJMenu = new MJMenu();
        mJMenu.add((Action)ActionManager.createWrapperAction(MLMenuMergeTag.PRODUCT_HELP, "product-help"));
        DTMenuMergeTag.HELP.setTag((JMenuItem)mJMenu);
        mJMenuBar.add((JMenu)mJMenu);
    }

    DTToolBarInfo[] createToolbarInfo(StackComboBox stackComboBox) {
        return ActionManager.createToolbarInfo(stackComboBox, this);
    }

    static DTToolBarInfo[] createGroupToolbarInfo(StackComboBox stackComboBox) {
        return ActionManager.createToolbarInfo(stackComboBox, null);
    }

    private static DTToolBarInfo[] createToolbarInfo(StackComboBox stackComboBox, ActionManager actionManager) {
        Editor editor = actionManager != null ? actionManager.getEditor() : null;
        ToolBars<ToolBarContributor.ToolBarItem> toolBars = ActionManager.buildToolBars(stackComboBox, actionManager, editor);
        ToolBars<String> toolBars2 = ActionManager.buildToolBarLayouts(editor);
        ArrayList<DTToolBarInfo> arrayList = new ArrayList<DTToolBarInfo>();
        for (ToolBarID toolBarID : toolBars.getToolBarIDs()) {
            DTToolBarConfiguration dTToolBarConfiguration = new DTToolBarConfiguration(toolBars2.getBuilder(toolBarID).getSeparatedItems());
            ToolBarBuilder toolBarBuilder = toolBars.getBuilder(toolBarID);
            DTToolSet dTToolSet = new DTToolSet();
            for (ToolBarContributor.ToolBarItem toolBarItem : toolBarBuilder.getItems()) {
                if (toolBarItem.getAction() != null) {
                    dTToolSet.add(toolBarItem.getID(), toolBarItem.getAction());
                    continue;
                }
                dTToolSet.add(toolBarItem.getID(), toolBarItem.getLabel(), toolBarItem.getComponent(), toolBarItem.getIcon());
            }
            arrayList.add(new DTToolBarInfo(toolBarID.getInternalName(), toolBarID.getDisplayName(), dTToolSet, dTToolBarConfiguration, toolBarID.appendToPreviousRow()));
        }
        if (Codepad.isCodepadEnabled() || actionManager == null) {
            CodepadActionManager.addToToolBar(arrayList, actionManager == null ? null : actionManager.fCodepadActionManager);
        }
        return arrayList.toArray(new DTToolBarInfo[arrayList.size()]);
    }

    private static ToolBars<ToolBarContributor.ToolBarItem> buildToolBars(StackComboBox stackComboBox, ActionManager actionManager, Editor editor) {
        DefaultToolBars defaultToolBars = new DefaultToolBars();
        DefaultToolBarBuilder defaultToolBarBuilder = new DefaultToolBarBuilder((ToolBarGroupID[])EditorToolBarGroupID.values());
        defaultToolBars.addNewToolBar(EditorUtils.MAIN_TOOLBAR_ID, (ToolBarBuilder)defaultToolBarBuilder);
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.FILE_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ActionManager.createToolBarItem(actionManager, EditorAction.NEW), ActionManager.createToolBarItem(actionManager, EditorAction.OPEN), ActionManager.createToolBarItem(actionManager, EditorAction.SAVE), ActionManager.createToolBarItem(actionManager, EditorAction.SAVE_AS), ActionManager.createToolBarItem(actionManager, EditorAction.SAVE_ALL)});
        if (editor == null || StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) {
            defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.FILE_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ActionManager.createToolBarItem(actionManager, EditorAction.SAVE_BACKUP)});
        }
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.TEXT_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ActionManager.createToolBarItem(actionManager, ActionID.CUT), ActionManager.createToolBarItem(actionManager, ActionID.COPY), ActionManager.createToolBarItem(actionManager, ActionID.PASTE), ActionManager.createToolBarItem(actionManager, ActionID.UNDO), ActionManager.createToolBarItem(actionManager, ActionID.REDO)});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.OUTPUT_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ActionManager.createToolBarItem(actionManager, EditorAction.PRINT)});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.NAVIGATION_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createActionToolBarItem((String)EditorAction.FIND.getActionId(), (Action)(actionManager == null ? ActionManager.createDummyAction(EditorAction.FIND.getActionId()) : EditorAction.FIND.getAction())), ActionManager.createToolBarItem(actionManager, ActionID.PREVIOUS_LOCATION), ActionManager.createToolBarItem(actionManager, ActionID.NEXT_LOCATION), ActionManager.createToolBarItem(actionManager, EditorAction.FUNCTION_MENU)});
        DebuggerManager debuggerManager = DebuggerManager.getInstance();
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createActionToolBarItem((String)"debug-step", (Action)debuggerManager.getStepActionNoEcho()), ToolBarItems.createActionToolBarItem((String)"debug-step-in", (Action)debuggerManager.getStepInActionNoEcho()), ToolBarItems.createActionToolBarItem((String)"debug-step-out", (Action)debuggerManager.getStepOutActionNoEcho()), ToolBarItems.createActionToolBarItem((String)"debug-continue", (Action)debuggerManager.getContinueActionNoEcho()), ToolBarItems.createActionToolBarItem((String)"exit-debug", (Action)debuggerManager.getExitDebugAction())});
        ActionManager.addStackComboBoxToToolbarBuilder(stackComboBox, (ToolBarBuilder<ToolBarContributor.ToolBarItem>)defaultToolBarBuilder);
        if (editor == null || ActionManager.isMatlab(editor)) {
            defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.FUNCTION_BROWSER_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ActionManager.createToolBarItem(actionManager, EditorAction.FUNCTION_BROWSER)});
        }
        for (ToolBarContributor toolBarContributor : ActionManager.getToolBarContributors()) {
            if (actionManager == null) {
                toolBarContributor.contributeToEditorGroup((ToolBars)defaultToolBars);
                continue;
            }
            toolBarContributor.contributeToEditor((ToolBars)defaultToolBars, editor);
        }
        return defaultToolBars;
    }

    public static void addStackComboBoxToToolbarBuilder(StackComboBox stackComboBox, ToolBarBuilder<ToolBarContributor.ToolBarItem> toolBarBuilder) {
        if (stackComboBox != null) {
            toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.STACK_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createComponentToolBarItem((String)STACK_DISPLAY_TOOLBAR_KEY, (String)StackComboBox.getStackLabel((boolean)false), (Component)stackComboBox, null)});
        }
    }

    private Editor getEditor() {
        return this.fEditor;
    }

    private static ToolBarContributor.ToolBarItem createToolBarItem(ActionManager actionManager, EditorAction editorAction) {
        EditorAction.ObservableAction observableAction = editorAction.isStatic() ? editorAction.getAction() : (actionManager == null ? editorAction.createDummyAction() : actionManager.getAction(editorAction));
        return ToolBarItems.createActionToolBarItem((String)editorAction.getActionId(), (Action)((Object)observableAction));
    }

    private static ToolBarContributor.ToolBarItem createToolBarItem(ActionManager actionManager, ActionID actionID) {
        Action action = actionManager == null ? ActionManager.createDummyAction(actionID.getId()) : actionManager.getAction(actionID);
        return ToolBarItems.createActionToolBarItem((String)actionID.getId(), (Action)action);
    }

    private static Collection<ToolBarContributor> getToolBarContributors() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(ToolBarContributor.class);
        assert (!collection.isEmpty()) : "Expected at least one ToolBarContributor";
        return collection;
    }

    private static ToolBars<String> buildToolBarLayouts(Editor editor) {
        DefaultToolBars defaultToolBars = new DefaultToolBars();
        ActionManager.addMainToolBarLayout((ToolBars<String>)defaultToolBars, editor);
        for (ToolBarContributor toolBarContributor : ActionManager.getToolBarContributors()) {
            toolBarContributor.layoutItems((ToolBars)defaultToolBars);
        }
        return defaultToolBars;
    }

    public static void addMainToolBarLayout(ToolBars<String> toolBars, Editor editor) {
        DefaultToolBarBuilder defaultToolBarBuilder = new DefaultToolBarBuilder(Arrays.asList(EditorToolBarGroupID.values()));
        toolBars.addNewToolBar(EditorUtils.MAIN_TOOLBAR_ID, (ToolBarBuilder)defaultToolBarBuilder);
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.FILE_GROUP, (Object[])new String[]{EditorAction.NEW.getActionId(), EditorAction.OPEN.getActionId(), EditorAction.SAVE.getActionId()});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.TEXT_GROUP, (Object[])new String[]{ActionID.CUT.getId(), ActionID.COPY.getId(), ActionID.PASTE.getId(), ActionID.UNDO.getId(), ActionID.REDO.getId()});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.OUTPUT_GROUP, (Object[])new String[]{ActionID.PRINT.getId()});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.NAVIGATION_GROUP, (Object[])new String[]{ActionID.FIND.getId(), ActionID.PREVIOUS_LOCATION.getId(), ActionID.NEXT_LOCATION.getId(), EditorAction.FUNCTION_MENU.getActionId()});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new String[]{"set-clear-breakpoint", "clear-all-breakpoints", "debug-step", "debug-step-in", "debug-step-out", "debug-continue", "exit-debug"});
        defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.STACK_GROUP, (Object[])new String[]{STACK_DISPLAY_TOOLBAR_KEY});
        if (editor == null || ActionManager.isMatlab(editor)) {
            defaultToolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.FUNCTION_BROWSER_GROUP, (Object[])new String[]{"function-browser-key"});
        }
    }

    private static Action createDummyAction(String string) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                assert (false) : "this action should never be executed";
            }
        };
        mJAbstractAction.setEnabled(false);
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)mJAbstractAction);
        return mJAbstractAction;
    }

    public void contributeToContextMenu(MJPopupMenu mJPopupMenu) {
        this.updateOpenSelectionAction();
        DefaultMenuBuilder defaultMenuBuilder = new DefaultMenuBuilder(mJPopupMenu, new MenuGroupID[]{EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP, EditorMenuGroupID.CONTEXT_SELECTION_GROUP, EditorMenuGroupID.CONTEXT_EDIT_GROUP, EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, EditorMenuGroupID.CONTEXT_DEBUG_GROUP, EditorMenuGroupID.CONTEXT_FUNCTIONS_GROUP, EditorMenuGroupID.CONTEXT_VIEW_MANAGEMENT_GROUP});
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_SELECTION_GROUP, (Action)this.getAction(EditorAction.EVALUATE_SELECTION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_SELECTION_GROUP, (Action)this.getAction(EditorAction.OPEN_SELECTION));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_SELECTION_GROUP, (Action)this.getAction(EditorAction.HELP_ON_SELECTION));
        for (Component component : mJPopupMenu.getComponents()) {
            JMenuItem jMenuItem;
            EditorMenuGroupID editorMenuGroupID;
            if (component instanceof JMenuItem && (editorMenuGroupID = (EditorMenuGroupID)(jMenuItem = (JMenuItem)component).getClientProperty("EditorMenuGroup")) != null) {
                mJPopupMenu.remove((Component)jMenuItem);
                defaultMenuBuilder.add((MenuGroupID)editorMenuGroupID, (Component)jMenuItem);
            }
            if (!(component instanceof JSeparator) || ((JComponent)component).getClientProperty("EditorMenuGroup") == null) continue;
            mJPopupMenu.remove(component);
        }
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_EDIT_GROUP, (Action)this.getAction(ActionID.CUT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_EDIT_GROUP, (Action)this.getAction(ActionID.COPY));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_EDIT_GROUP, (Action)this.getAction(ActionID.PASTE));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_EDIT_GROUP, (Action)this.getAction(ActionID.SELECT_ALL));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, (Action)this.getAction(ActionID.MERGE_COMMENTS));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, (Action)this.getAction(ActionID.COMMENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, (Action)this.getAction(ActionID.UNCOMMENT));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_COMMENT_INDENT_GROUP, (Action)this.getAction(ActionID.SMART_INDENT));
        if (ActionManager.isMatlab(this.fEditor)) {
            defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_FUNCTIONS_GROUP, (Action)this.getAction(EditorAction.FUNCTION_BROWSER));
            defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_FUNCTIONS_GROUP, (Action)this.getAction(EditorAction.FUNCTION_HINTS));
        }
        MJMenu mJMenu = new MJMenu((Action)this.getAction(ActionID.FOLDS_MENU));
        mJMenu.add((Action)this.getAction(ActionID.EXPAND_FOLD));
        mJMenu.add((Action)this.getAction(ActionID.COLLAPSE_FOLD));
        mJMenu.addSeparator();
        mJMenu.add((Action)this.getAction(ActionID.EXPAND_ALL_FOLDS));
        mJMenu.add((Action)this.getAction(ActionID.COLLAPSE_ALL_FOLDS));
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_VIEW_MANAGEMENT_GROUP, (Component)mJMenu);
        defaultMenuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_VIEW_MANAGEMENT_GROUP, (Component)this.fSplitScreenActions.createMenu());
        for (MenuContributor menuContributor : ActionManager.getMenuContributors()) {
            menuContributor.contributeToContextMenu((Object)this.fEditor, (MenuBuilder)defaultMenuBuilder);
        }
    }

    private void installFileMenuListener(JMenu jMenu) {
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                ActionManager.this.updateOpenSelectionAction();
            }
        });
    }

    private Action getCloseFileAction() {
        return this.fCloseFileAction;
    }

    private Action getSaveAction() {
        return this.getAction(EditorAction.SAVE);
    }

    private static Action createCloseGroupAction() {
        return ActionManager.createWrapperAction(DTMenuMergeTag.CLOSE_GROUP, "close-item");
    }

    private static boolean isMatlab(Editor editor) {
        return editor.getLanguage() instanceof MLanguage;
    }

    private static class OSGiKeyBindingContributorProvider
    implements KeyBindingContributorProvider {
        private OSGiKeyBindingContributorProvider() {
        }

        public Collection<KeyBindingContributor> getContributors() {
            return ClasspathOSGiManager.getInstance().getImplementors(KeyBindingContributor.class);
        }
    }

    public static interface KeyBindingContributorProvider {
        public Collection<? extends KeyBindingContributor> getContributors();
    }

    private class CodeFoldsMenuItemValidationListener
    implements MenuListener {
        private CodeFoldsMenuItemValidationListener() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            ActionManager.this.fComponent.validateCodeFoldActions();
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }
}

