/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.components.TSComboBox;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class RunControlSet {
    private final JComboBox fCodeComboBox;
    private final MJAbstractAction fRunAction = new RunAction();
    private final MJAbstractAction fProfileAction = new ProfileAction();
    private Component fPreviousFocusOwner;
    private static DefaultComboBoxModel sCodeComboModel = new DefaultComboBoxModel();
    private static final String HISTORY_FILE_NAME = "runhistory.m";
    private static final int CODE_HISTORY_LIMIT = 8;

    public RunControlSet() {
        this.fCodeComboBox = new TSComboBox();
        this.fCodeComboBox.setName("CodeComboBox");
        this.fCodeComboBox.setEditable(true);
        this.fCodeComboBox.setModel(sCodeComboModel);
        this.fCodeComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    RunControlSet.this.relinquishFocus();
                } else if (n == 10) {
                    RunControlSet.this.runCode();
                }
            }
        });
        this.fCodeComboBox.getEditor().getEditorComponent().addFocusListener(new FocusHandler());
        ((JTextComponent)this.fCodeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.enableDisableButtons(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.enableDisableButtons(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void enableDisableButtons(DocumentEvent documentEvent) {
                boolean bl = documentEvent.getDocument().getLength() > 0;
                RunControlSet.this.fRunAction.setEnabled(bl);
                RunControlSet.this.fProfileAction.setEnabled(bl);
            }
        });
        this.fCodeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                RunControlSet.this.relinquishFocus();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    public JComboBox getCodeComboBox() {
        return this.fCodeComboBox;
    }

    public Action getRunAction() {
        return this.fRunAction;
    }

    public Action getProfileAction() {
        return this.fProfileAction;
    }

    private void runCode() {
        String string = this.getCodeToRun();
        MLExecuteServices.executeCommand((String)string);
        this.addCodeToComboModel(string);
        this.relinquishFocus();
    }

    private void profileCode() {
        String string = this.getCodeToRun();
        RunControlSet.runProfiler(this.getCodeToRun());
        this.addCodeToComboModel(string);
        this.relinquishFocus();
    }

    public static void runProfiler(String string) {
        final Matlab matlab = new Matlab();
        matlab.evalConsoleOutput("profile on");
        MLExecuteServices.executeCommand((String)string);
        matlab.eval("profile viewer", new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) != 0) {
                    matlab.evalConsoleOutput("profile off");
                }
            }
        });
    }

    private String getCodeToRun() {
        return (String)this.fCodeComboBox.getEditor().getItem();
    }

    private void addCodeToComboModel(String string) {
        sCodeComboModel.removeElement(string);
        sCodeComboModel.insertElementAt(string, 0);
        this.fCodeComboBox.setSelectedItem(string);
        if (sCodeComboModel.getSize() > 8) {
            sCodeComboModel.removeElementAt(sCodeComboModel.getSize() - 1);
        }
        RunControlSet.saveHistory();
    }

    private void relinquishFocus() {
        if (this.fPreviousFocusOwner != null) {
            this.fPreviousFocusOwner.requestFocus();
            this.fPreviousFocusOwner = null;
        }
    }

    private static File getHistoryFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadHistory() {
        File file = RunControlSet.getHistoryFile();
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() <= 0) continue;
                    sCodeComboModel.addElement(string);
                }
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Log.logException((Exception)iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveHistory() {
        File file = RunControlSet.getHistoryFile();
        BufferedWriter bufferedWriter = null;
        try {
            file.delete();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (int i = 0; i < sCodeComboModel.getSize(); ++i) {
                String string = (String)sCodeComboModel.getElementAt(i);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    Log.logException((Exception)iOException);
                }
            }
        }
    }

    static {
        RunControlSet.loadHistory();
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component != null && RunControlSet.this.fPreviousFocusOwner == null && !(component instanceof JRootPane) && SwingUtilities.windowForComponent(component) == SwingUtilities.windowForComponent(focusEvent.getComponent())) {
                RunControlSet.this.fPreviousFocusOwner = component;
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                RunControlSet.this.fPreviousFocusOwner = null;
            }
        }
    }

    private class ProfileAction
    extends MJAbstractAction {
        ProfileAction() {
            super("Profile", (Icon)ProvisionalIcon.PROFILE.getIcon());
            this.setEnabled(sCodeComboModel.getSize() > 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RunControlSet.this.profileCode();
        }
    }

    private class RunAction
    extends MJAbstractAction {
        RunAction() {
            super("Run", (Icon)ProvisionalIcon.RUN_24.getIcon());
            this.setEnabled(sCodeComboModel.getSize() > 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RunControlSet.this.runCode();
        }
    }
}

