/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.desktop.client.Client;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.mlwidgets.graphics.PlotToolSet;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.Previewer;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.widgets.desk.DTOccupant;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class PlotGalleryManager {
    protected final MLDesktop fDesktop;
    protected final PlotToolSet fPlotToolSet;
    protected final DTOccupant fOwner;
    private ToolstripSection fPlotSection;
    private JLabel[] fVariableLabel = new TSLabel[3];
    private Font fPlainLabelFont;
    private Font fItalicLabelFont;
    private JButton fSwapVariablesButton;
    private GalleryView fGalleryView;
    private MessageType fCurrentMessageType;
    private String[] fLastVariables;
    private String[] fLastClasses;
    private PlotableClientBase fVariableSelectionSource;
    private String fEmptyMessage = MLDesktop.sMLRes.getString("message.SelectVariable");

    public PlotGalleryManager(MLDesktop mLDesktop, PlotToolSet plotToolSet) {
        this(mLDesktop, plotToolSet, null);
    }

    public PlotGalleryManager(MLDesktop mLDesktop, PlotToolSet plotToolSet, DTOccupant dTOccupant) {
        this.fDesktop = mLDesktop;
        this.fPlotToolSet = plotToolSet;
        this.fOwner = dTOccupant;
    }

    public void setGalleryView(GalleryView galleryView) {
        this.fGalleryView = galleryView;
        this.updateOverlayMessage();
    }

    public void setPlotSection(ToolstripSection toolstripSection) {
        this.fPlotSection = toolstripSection;
    }

    void setVariableLabel(JLabel jLabel, int n) {
        this.fVariableLabel[n] = jLabel;
        if (this.fPlainLabelFont == null) {
            this.fPlainLabelFont = jLabel.getFont();
        }
        if (this.fItalicLabelFont == null) {
            this.fItalicLabelFont = jLabel.getFont().deriveFont(2);
        }
        if (this.haveAllVariableFields()) {
            this.updateVariableFields();
        }
    }

    void setSwapVariablesButton(JButton jButton) {
        jButton.setAction((Action)((Object)new SwapVariablesAction()));
        jButton.setVisible(false);
        this.fSwapVariablesButton = jButton;
        if (this.haveAllVariableFields()) {
            this.updateVariableFields();
        }
    }

    private boolean haveAllVariableFields() {
        return this.fVariableLabel[0] != null && this.fVariableLabel[1] != null && this.fVariableLabel[2] != null && this.fSwapVariablesButton != null;
    }

    private void updateVariableFields() {
        int n = this.fLastVariables == null ? 0 : this.fLastVariables.length;
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[3];
        boolean[] blArray = new boolean[3];
        boolean bl = false;
        blArray[2] = true;
        blArray[1] = true;
        blArray[0] = true;
        switch (n) {
            case 0: {
                stringArray[1] = MLDesktop.sMLRes.getString("message.NoVariableSelected");
                blArray[1] = false;
                break;
            }
            case 1: {
                stringArray[1] = this.fLastVariables[0];
                stringArray2[1] = this.fLastClasses[0];
                break;
            }
            case 2: {
                stringArray[0] = this.fLastVariables[0];
                stringArray[2] = this.fLastVariables[1];
                stringArray2[0] = this.fLastClasses[0];
                stringArray2[2] = this.fLastClasses[1];
                bl = true;
                break;
            }
            case 3: {
                stringArray[0] = this.fLastVariables[0];
                stringArray[1] = this.fLastVariables[1];
                stringArray[2] = this.fLastVariables[2];
                stringArray2[0] = this.fLastClasses[0];
                stringArray2[1] = this.fLastClasses[1];
                stringArray2[2] = this.fLastClasses[2];
                break;
            }
            default: {
                stringArray[0] = this.fLastVariables[0];
                stringArray[1] = this.fLastVariables[1];
                stringArray2[0] = this.fLastClasses[0];
                stringArray2[1] = this.fLastClasses[1];
                stringArray[2] = MessageFormat.format(MLDesktop.sMLRes.getString("message.MoreVariables"), Integer.toString(n - 2));
                blArray[2] = false;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (stringArray[i] == null) {
                this.fVariableLabel[i].setVisible(false);
                continue;
            }
            this.fVariableLabel[i].setText(stringArray[i]);
            if (blArray[i]) {
                this.fVariableLabel[i].setIcon(WorkspaceIcon.getIcon((String)stringArray2[i]));
                this.fVariableLabel[i].setFont(this.fPlainLabelFont);
            } else {
                this.fVariableLabel[i].setIcon(null);
                this.fVariableLabel[i].setFont(this.fItalicLabelFont);
            }
            this.fVariableLabel[i].setVisible(true);
        }
        this.fSwapVariablesButton.setVisible(bl);
    }

    protected void handleMessageAction() {
    }

    protected void setEmptyVariableMessage(String string) {
        this.fEmptyMessage = string;
    }

    protected String getEmptyVariableMessage() {
        return this.fEmptyMessage;
    }

    protected String getSelectOwnerTip() {
        return null;
    }

    void variableSelectionUpdated(String[] stringArray, String[] stringArray2) {
        boolean bl;
        this.fLastVariables = stringArray;
        this.fLastClasses = stringArray2;
        if (this.haveAllVariableFields()) {
            this.updateVariableFields();
        }
        boolean bl2 = bl = stringArray == null || stringArray.length == 0;
        if (bl) {
            if (this.fPlotSection != null) {
                this.fPlotSection.setAttribute(ToolstripSection.ALTERNATE_TITLE, null);
            }
        } else if (this.fPlotSection != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((String)this.fPlotSection.getAttribute(Client.TITLE)).toUpperCase(Locale.getDefault()));
            stringBuilder.append(": ");
            String string = PlotToolSet.createArgumentString((String[])stringArray);
            stringBuilder.append(string.substring(1, string.length() - 1));
            this.fPlotSection.setAttribute(ToolstripSection.ALTERNATE_TITLE, (Object)stringBuilder.toString());
        }
        this.updateOverlayMessage();
        this.fPlotToolSet.setVariablesToPlot(stringArray, bl ? null : new PlotToolSet.PlotUpdateListener(){

            public void plotsUpdated(int n) {
                PlotGalleryManager.this.updateOverlayMessage();
            }
        });
    }

    void setVariableSelectionSource(PlotableClientBase plotableClientBase) {
        this.fVariableSelectionSource = plotableClientBase;
    }

    private void updateOverlayMessage() {
        if (this.fLastVariables == null || this.fLastVariables.length == 0) {
            this.showOverlayMessage(MessageType.NO_SELECTION);
        } else if (!this.fPlotToolSet.hasPlotsForVariables()) {
            this.showOverlayMessage(MessageType.NO_PLOTS);
        } else {
            this.showOverlayMessage(null);
        }
    }

    private void showOverlayMessage(MessageType messageType) {
        if (this.fGalleryView == null) {
            return;
        }
        if (this.fCurrentMessageType != messageType) {
            if (messageType == null) {
                this.fGalleryView.setOverlayAction(null);
            } else {
                switch (messageType) {
                    case NO_SELECTION: {
                        if (this.fOwner != null) {
                            this.fGalleryView.setOverlayAction((Action)((Object)new SelectOwnerAction(this.getEmptyVariableMessage(), this.getSelectOwnerTip())));
                            break;
                        }
                        this.fGalleryView.setOverlayText(this.getEmptyVariableMessage());
                        break;
                    }
                    case NO_PLOTS: {
                        this.fGalleryView.setOverlayText(MLDesktop.sMLRes.getString("message.NoPlotsForSelection"));
                    }
                }
            }
            this.fCurrentMessageType = messageType;
        }
    }

    private class SelectOwnerAction
    extends MJAbstractAction
    implements Previewer {
        private SelectOwnerAction(String string, String string2) {
            super(string);
            this.setComponentName("OverlayedSelect" + PlotGalleryManager.this.fOwner.getName());
            this.setTip(string2);
            this.putValue("previewer", (Object)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotGalleryManager.this.handleMessageAction();
        }

        public void showPreview() {
            PlotGalleryManager.this.fOwner.setConsideringSelection(true);
        }

        public void hidePreview() {
            PlotGalleryManager.this.fOwner.setConsideringSelection(false);
        }
    }

    private class SwapVariablesAction
    extends MJAbstractAction {
        SwapVariablesAction() {
            super("", (Icon)IconEnumerationUtils.getIcon((String)"swap_variables.png"));
            this.setTip(MLDesktop.sMLRes.getString("Tool.swap_variables.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PlotGalleryManager.this.fLastVariables != null && PlotGalleryManager.this.fLastVariables.length == 2 && PlotGalleryManager.this.fVariableSelectionSource != null) {
                PlotGalleryManager.this.fVariableSelectionSource.setVariablesToPlot(new String[]{PlotGalleryManager.this.fLastVariables[1], PlotGalleryManager.this.fLastVariables[0]}, new String[]{PlotGalleryManager.this.fLastClasses[1], PlotGalleryManager.this.fLastClasses[0]});
            }
        }
    }

    protected static enum MessageType {
        NO_SELECTION,
        NO_PLOTS;

    }
}

