/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.webintegration.startpage.StartPageFactory;
import com.mathworks.util.StringUtils;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class Prompt {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
    static final Prompt DEFAULT_PROMPT = new Prompt(">> ", null, true);
    public static final Prompt KEYBOARD_PROMPT = new Prompt("K>> ", null, false);
    static final Prompt EDU_PROMPT = new Prompt("EDU>> ", null, true);
    static final Prompt TRIAL_PROMPT = new Prompt(sRes.getString("prompt.trial") + ">> ", null, true);
    static final Prompt INCOMPLETE_BLOCK_PROMPT = new Prompt(null, false);
    static final Prompt INPUT_PROMPT = new Prompt(null, false);
    public static final Prompt NULL_PROMPT = new Prompt(null, false);
    static final Prompt PAUSE_PROMPT = new Prompt(null, false);
    static final Prompt TYPEAHEAD_PROMPT = new Prompt("\n", false);
    static final Prompt MORE_PROMPT = new Prompt("--more--", false);
    public static final Prompt SIMEVENTS_DEBUG_PROMPT = new Prompt("sedebug>> ", false);
    public static final Prompt SF_EML_DEBUG_PROMPT = new Prompt("debug>> ", false);
    private static final String FAULT_STRING = "[Please exit and restart MATLAB]>> ";
    private final String fPromptStr;
    private final Icon fIcon;
    private final boolean fChangePrompt;
    private static boolean sIsAfterFault = false;

    private Prompt(String string, boolean bl) {
        this(string, null, bl);
    }

    private Prompt(String string, Icon icon, boolean bl) {
        if (string == null && icon == null) {
            string = new String();
        } else if (string == null) {
            string = "   ";
        }
        this.fPromptStr = string;
        this.fIcon = icon;
        this.fChangePrompt = bl;
    }

    public static String[] getAllPromptStrings() {
        return new String[]{Prompt.DEFAULT_PROMPT.fPromptStr, Prompt.KEYBOARD_PROMPT.fPromptStr, Prompt.EDU_PROMPT.fPromptStr, Prompt.TRIAL_PROMPT.fPromptStr, Prompt.SIMEVENTS_DEBUG_PROMPT.fPromptStr, Prompt.SF_EML_DEBUG_PROMPT.fPromptStr, FAULT_STRING};
    }

    public static Prompt getBasePrompt(boolean bl) {
        if (bl) {
            return EDU_PROMPT;
        }
        if (StartPageFactory.getStartPage().isEnabled()) {
            return TRIAL_PROMPT;
        }
        return DEFAULT_PROMPT;
    }

    public static void setEmergency() {
        sIsAfterFault = true;
    }

    private static void resetEmergency() {
        sIsAfterFault = false;
    }

    static boolean isCommandPrompt(Prompt prompt) {
        return prompt == DEFAULT_PROMPT || prompt == EDU_PROMPT || prompt == TRIAL_PROMPT || prompt == INPUT_PROMPT || prompt == KEYBOARD_PROMPT || prompt == INCOMPLETE_BLOCK_PROMPT;
    }

    public int length() {
        return this.toString().length();
    }

    public static String stripPrompts(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = Prompt.getAllPromptStrings();
        int n = -1;
        for (String string2 : stringArray) {
            if (n != -1) continue;
            n = string.indexOf(string2);
        }
        if (n != -1) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int[] nArray = StringUtils.findPattern((String)"\\r\\n|\\n|\\r", (int)0, (CharSequence)string);
            int n2 = nArray[0];
            int n3 = 0;
            while (n2 != -1) {
                string3 = string.substring(n3, n2);
                string3 = Prompt.removePromptFromString(stringArray, string3);
                stringBuffer.append(string3).append(string.substring(nArray[0], nArray[1]));
                int n4 = nArray[1];
                if (string.length() >= nArray[1]) {
                    nArray = StringUtils.findPattern((String)"\\r\\n|\\n|\\r", (int)nArray[1], (CharSequence)string);
                    n2 = nArray[0];
                } else {
                    n2 = -1;
                }
                n3 = n4;
            }
            if (n3 != string.length()) {
                string3 = string.substring(n3, string.length());
                string3 = Prompt.removePromptFromString(stringArray, string3);
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private static String removePromptFromString(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            string = string.substring(string2.length());
            break;
        }
        return string;
    }

    public String toString() {
        if (this.fChangePrompt && sIsAfterFault) {
            return FAULT_STRING;
        }
        return this.fPromptStr;
    }

    public Icon toIcon() {
        return this.fIcon;
    }
}

