/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import javax.swing.Action;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

class CmdWinUndoManager
extends UndoManager
implements DocumentListener {
    private static CWCompoundEdit sCompoundEdit = null;
    private static CmdWinDocument sCWDoc;
    private static XCmdWndView sCWView;
    private static Action sUndoAction;
    private static Action sRedoAction;
    private static boolean sGroupEdit;
    private static CmdWinUndoManager sCmdWinUndoManager;
    private DocumentEvent.EventType fPreviousType = null;

    private CmdWinUndoManager(CmdWinEditorKit cmdWinEditorKit, CmdWinDocument cmdWinDocument, XCmdWndView xCmdWndView) {
        sCWDoc = cmdWinDocument;
        sCWView = xCmdWndView;
        sUndoAction = CmdWinEditorKit.getActionByName("undo");
        sRedoAction = CmdWinEditorKit.getActionByName("redo");
        sCWDoc.addUndoableEditListener(this);
        sCWDoc.addDocumentListener(this);
        this.startEdit();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void endEdit() {
        assert (sCompoundEdit != null) : "sCompoundEdit is null";
        if (sCompoundEdit.isDirty() || !sCompoundEdit.isInProgress()) {
            sCompoundEdit.end();
            if (this.canRedo()) {
                sCompoundEdit.die();
            }
            this.startEdit();
        }
    }

    void endEditGroup() {
        this.endEdit();
        sGroupEdit = false;
        this.setEnablement();
    }

    static CmdWinUndoManager getInstance() {
        assert (sCmdWinUndoManager != null) : "CmdWinUndoManager is null";
        return sCmdWinUndoManager;
    }

    static CmdWinUndoManager getInstance(CmdWinEditorKit cmdWinEditorKit, CmdWinDocument cmdWinDocument, XCmdWndView xCmdWndView) {
        if (sCmdWinUndoManager == null) {
            sCmdWinUndoManager = new CmdWinUndoManager(cmdWinEditorKit, cmdWinDocument, xCmdWndView);
        }
        return sCmdWinUndoManager;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setEnablement();
    }

    private boolean isSignificantChange(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        if (sGroupEdit) {
            return false;
        }
        assert (sCompoundEdit != null) : "sCompoundEdit is null";
        if (!sCompoundEdit.isInProgress()) {
            return true;
        }
        DocumentEvent.EventType eventType = defaultDocumentEvent.getType();
        if (defaultDocumentEvent.getType() != this.fPreviousType) {
            this.fPreviousType = defaultDocumentEvent.getType();
            return true;
        }
        int n = sCompoundEdit.getOffsetOfPreviousEdit();
        int n2 = 0;
        if (n != -1) {
            n2 = n - defaultDocumentEvent.getOffset();
        }
        return defaultDocumentEvent.getLength() > 1 || Math.abs(n2) > 1;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    void reset() {
        if (sCompoundEdit.isDirty()) {
            assert (sCompoundEdit != null) : "sCompoundEdit is null";
            this.discardAllEdits();
            this.setEnablement();
        }
    }

    private void setEnablement() {
        sUndoAction.setEnabled(this.canUndo());
        sRedoAction.setEnabled(this.canRedo());
    }

    private void startEdit() {
        sCompoundEdit = new CWCompoundEdit();
        this.addEdit(sCompoundEdit);
    }

    void startEditGroup() {
        this.endEdit();
        sGroupEdit = true;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
        if (!defaultDocumentEvent.canUndo()) {
            this.reset();
            return;
        }
        if (this.isSignificantChange(defaultDocumentEvent)) {
            this.endEdit();
        }
        sCompoundEdit.addEdit(undoableEditEvent.getEdit());
        this.setEnablement();
    }

    static {
        sGroupEdit = false;
        sCmdWinUndoManager = null;
    }

    private class CWCompoundEdit
    extends CompoundEdit {
        boolean checkingIfICan = false;
        int fPrevious = -1;

        private CWCompoundEdit() {
        }

        public boolean isDirty() {
            return this.edits.size() > 0;
        }

        @Override
        public boolean canUndo() {
            this.checkingIfICan = true;
            boolean bl = super.canUndo();
            this.checkingIfICan = false;
            return bl;
        }

        @Override
        public boolean canRedo() {
            this.checkingIfICan = true;
            boolean bl = super.canRedo();
            this.checkingIfICan = false;
            return bl;
        }

        int getOffsetOfPreviousEdit() {
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)this.lastEdit();
            if (defaultDocumentEvent != null) {
                return defaultDocumentEvent.getOffset();
            }
            return -1;
        }

        @Override
        public boolean isInProgress() {
            if (this.checkingIfICan) {
                return false;
            }
            return super.isInProgress();
        }

        @Override
        public void redo() throws CannotUndoException {
            Object object;
            int n = -1;
            UndoableEdit undoableEdit = this.lastEdit();
            if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
                object = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
                n = ((AbstractDocument.DefaultDocumentEvent)object).getOffset() + ((AbstractDocument.DefaultDocumentEvent)object).getLength();
            }
            super.redo();
            sCWDoc.syntaxUpdate();
            if (n != -1 && (object = sCWView.getCaret()) instanceof XCaret) {
                object.setDot(n);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            Object object;
            int n = -1;
            int n2 = this.edits.size();
            if (n2 > 0 && (object = (UndoableEdit)this.edits.elementAt(0)) instanceof AbstractDocument.DefaultDocumentEvent) {
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)object;
                n = defaultDocumentEvent.getOffset() + defaultDocumentEvent.getLength();
            }
            super.undo();
            this.end();
            sCWDoc.syntaxUpdate();
            if (n != -1 && (object = sCWView.getCaret()) instanceof XCaret) {
                object.setDot(n);
            }
        }
    }
}

