/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.CmdWinTextUtilities;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mwswing.datatransfer.MWMouseDragGestureRecognizer;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class CWMWMouseDragGestureRecognizer
extends MWMouseDragGestureRecognizer {
    CWMWMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        super(dragSource, component, n, dragGestureListener, mouseListener, mouseMotionListener);
    }

    public boolean isClickInSelection(MouseEvent mouseEvent) {
        int n;
        JTextArea jTextArea = (JTextArea)mouseEvent.getComponent();
        int n2 = jTextArea.getSelectionStart();
        if (n2 == (n = jTextArea.getSelectionEnd())) {
            return false;
        }
        Point point = mouseEvent.getPoint();
        int n3 = jTextArea.viewToModel(point);
        try {
            int n4 = jTextArea.getLineOfOffset(n3);
            int n5 = jTextArea.getLineOfOffset(n2);
            int n6 = jTextArea.getLineOfOffset(n);
            if (n4 == n5) {
                if ((double)jTextArea.modelToView((int)n2).x > point.getX()) {
                    return false;
                }
                return n5 != n6 || !((double)jTextArea.modelToView((int)n).x < point.getX());
            }
            if (n4 < n5) {
                return false;
            }
            if (n4 < n6) {
                return true;
            }
            if (n4 == n6) {
                return !(point.getX() > (double)jTextArea.modelToView((int)n).x);
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public boolean doSelectWordAction(MouseEvent mouseEvent) {
        try {
            if (PlatformInfo.getVersion() != 0 && PlatformInfo.getVersion() < 6 && mouseEvent.getClickCount() == 2) {
                CmdWinEditorKit.getActionByName("select-word").actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean doSelectLineAction(MouseEvent mouseEvent) {
        try {
            CmdWinEditorKit.getActionByName("select-line").actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getOffsetFromEvent(MouseEvent mouseEvent) {
        return XCmdWndView.getInstance().viewToModel(mouseEvent.getPoint());
    }

    public int getWordStart(Object object, int n) {
        try {
            int n2 = CmdWinTextUtilities.getWordStart((JTextComponent)object, n);
            return n2;
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return n;
        }
    }

    public int getWordEnd(Object object, int n) {
        try {
            return CmdWinTextUtilities.getWordEnd((JTextComponent)object, n);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return n;
        }
    }

    public int getLineStart(Object object, int n) {
        try {
            return Utilities.getRowStart((JTextComponent)object, n);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return n;
        }
    }

    public int getLineEnd(Object object, int n) {
        try {
            JTextComponent jTextComponent = (JTextComponent)object;
            int n2 = Utilities.getRowEnd(jTextComponent, n);
            if (jTextComponent.getDocument().getLength() > n2) {
                ++n2;
            }
            return n2;
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return n;
        }
    }
}

