/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.autosave;

import com.mathworks.mde.autosave.AutoSaveImplementor;
import com.mathworks.mde.autosave.AutoSaveUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Log;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AutoSaveTimer {
    private static final int MILLISECONDS_IN_A_MINUTE = 60000;
    private final Timer fTimer = new Timer(0, this.createTimerActionListener());
    private static final String SAVING = AutoSaveUtils.intlString("editorAutoSave.Saving");
    private final Map<AutoSaveImplementor, Set<File>> fAutoSaveImplementorsToSavedFileSets = new HashMap<AutoSaveImplementor, Set<File>>();
    private final Set<AutoSaveImplementor> fAutoSaveImplementors = new HashSet<AutoSaveImplementor>();
    private static final AutoSaveTimer INSTANCE = new AutoSaveTimer();

    private AutoSaveTimer() {
        this.readFromPreferences();
        AutoSaveUtils.registerForAutosavePreferences(this.createPrefsListener());
    }

    public static AutoSaveTimer getInstance() {
        return INSTANCE;
    }

    public void addAutoSaveImplementor(AutoSaveImplementor autoSaveImplementor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called on AWT-event thread.");
        }
        this.fAutoSaveImplementors.add(autoSaveImplementor);
        this.fAutoSaveImplementorsToSavedFileSets.put(autoSaveImplementor, new HashSet());
        if (this.shouldStartTimer()) {
            this.fTimer.start();
        }
    }

    public void removeAutoSaveImplementor(AutoSaveImplementor autoSaveImplementor) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called on AWT-event thread.");
        }
        if (!this.fAutoSaveImplementors.contains(autoSaveImplementor)) {
            throw new IllegalStateException("The given AutoSaveImplementor was never registered.");
        }
        Set<File> set = this.fAutoSaveImplementorsToSavedFileSets.remove(autoSaveImplementor);
        if (AutoSaveUtils.isAutoSaveDeleteFilesOn()) {
            for (File file : set) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
        this.fAutoSaveImplementors.remove(autoSaveImplementor);
        if (this.getAutoSaveImplementorCount() == 0) {
            this.fTimer.stop();
        }
    }

    public Set<AutoSaveImplementor> getAutoSaveImplementors() {
        return Collections.unmodifiableSet(this.fAutoSaveImplementors);
    }

    private void readFromPreferences() {
        this.setTimerInterval((int)((float)AutoSaveUtils.getAutoSaveIntervalInMinutes() * 60000.0f));
        if (this.shouldStartTimer()) {
            this.fTimer.start();
        } else if (this.shouldStopTimer()) {
            this.fTimer.stop();
        }
        this.tellAutoSaveImplementorsThatAutoSaveOptionsChanged();
    }

    private boolean shouldStartTimer() {
        return !this.fTimer.isRunning() && AutoSaveUtils.isAutoSaveOn();
    }

    private boolean shouldStopTimer() {
        return this.fTimer.isRunning() && !AutoSaveUtils.isAutoSaveOn();
    }

    private void setTimerInterval(int n) {
        boolean bl = this.fTimer.isRunning();
        this.fTimer.setDelay(n);
        this.fTimer.setInitialDelay(n);
        if (bl) {
            this.fTimer.restart();
        }
    }

    private PrefListener createPrefsListener() {
        return new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                AutoSaveTimer.this.readFromPreferences();
            }
        };
    }

    public int getAutoSaveImplementorCount() {
        return this.fAutoSaveImplementors.size();
    }

    private void tellAutoSaveImplementorsThatAutoSaveOptionsChanged() {
        for (AutoSaveImplementor autoSaveImplementor : this.fAutoSaveImplementors.toArray(new AutoSaveImplementor[this.fAutoSaveImplementors.size()])) {
            autoSaveImplementor.autoSaveOptionsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tellAutoSaveImplementorsToAutoSave() {
        for (AutoSaveImplementor autoSaveImplementor : this.fAutoSaveImplementors.toArray(new AutoSaveImplementor[this.fAutoSaveImplementors.size()])) {
            try {
                autoSaveImplementor.setStatusText(SAVING);
                File file = autoSaveImplementor.autoSave();
                if (file == null) continue;
                this.fAutoSaveImplementorsToSavedFileSets.get(autoSaveImplementor).add(file);
            }
            finally {
                autoSaveImplementor.setStatusText(null);
            }
        }
    }

    private ActionListener createTimerActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoSaveTimer.this.tellAutoSaveImplementorsToAutoSave();
            }
        };
    }
}

