/*
 * Decompiled with CFR 0.152.
 */
package org.bluez.v4;

import java.util.Map;
import org.bluez.Error;
import org.bluez.dbus.DBusProperties;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;

@DBusInterfaceName(value="org.bluez.Adapter")
public interface Adapter
extends org.bluez.Adapter,
DBusProperties.PropertiesAccess {
    public void RequestSession() throws Error.Rejected;

    public void ReleaseSession() throws Error.DoesNotExist;

    public void StartDiscovery() throws Error.NotReady, Error.Failed;

    public void StopDiscovery() throws Error.NotReady, Error.Failed, Error.NotAuthorized;

    public Path FindDevice(String var1) throws Error.DoesNotExist, Error.InvalidArguments;

    public Path[] ListDevices() throws Error.InvalidArguments, Error.Failed, Error.OutOfMemory;

    public Path CreateDevice(String var1) throws Error.InvalidArguments, Error.Failed;

    public Path CreatePairedDevice(String var1, Path var2, String var3) throws Error.InvalidArguments, Error.Failed;

    public void CancelDeviceCreation(String var1) throws Error.InvalidArguments, Error.NotInProgress;

    public void RemoveDevice(Path var1) throws Error.InvalidArguments, Error.Failed;

    public void RegisterAgent(Path var1, String var2) throws Error.InvalidArguments, Error.AlreadyExists;

    public void UnregisterAgent(Path var1) throws Error.DoesNotExist;

    public static class DeviceRemoved
    extends DBusSignal {
        public DeviceRemoved(String path, Path device) throws DBusException {
            super(path, new Object[]{device});
        }
    }

    public static class DeviceCreated
    extends DBusSignal {
        public DeviceCreated(String path, Path device) throws DBusException {
            super(path, new Object[]{device});
        }
    }

    public static class DeviceDisappeared
    extends DBusSignal {
        public DeviceDisappeared(String path, String address) throws DBusException {
            super(path, new Object[]{address});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeviceFound
    extends DBusSignal {
        private final String address;
        private final Map<String, Variant<?>> devicePoperties;

        public DeviceFound(String path, String address, Map<String, Variant<?>> devicePoperties) throws DBusException {
            super(path, new Object[]{address, devicePoperties});
            this.address = address;
            this.devicePoperties = devicePoperties;
        }

        public String getDeviceAddress() {
            return this.address;
        }

        public Map<String, Variant<?>> getDevicePoperties() {
            return this.devicePoperties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyChanged
    extends DBusSignal {
        public PropertyChanged(String path, String name, Variant<Object> value) throws DBusException {
            super(path, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Properties implements DBusProperties.PropertyEnum
    {
        Address,
        Name,
        Class,
        Powered,
        Discoverable,
        Pairable,
        PaireableTimeout,
        DiscoverableTimeout,
        Discovering,
        Devices;

    }
}

