/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class LookupLocatorDiscovery
implements DiscoveryManagement,
DiscoveryLocatorManagement {
    private static final String COMPONENT_NAME = "net.jini.discovery.LookupLocatorDiscovery";
    private static final Logger logger = Logger.getLogger("net.jini.discovery.LookupLocatorDiscovery");
    private static final int MAX_N_TASKS = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final Method getRegistrarMethod;
    private TaskManager discoveryTaskMgr;
    private WakeupManager discoveryWakeupMgr;
    private final HashSet undiscoveredLocators = new HashSet(11);
    private final ArrayList discoveredLocators = new ArrayList(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private final ArrayList listeners = new ArrayList(1);
    private boolean terminated = false;
    private ProxyPreparer registrarPreparer;
    private Discovery protocol2 = Discovery.getProtocol2(null);

    public LookupLocatorDiscovery(LookupLocator[] lookupLocatorArray) {
        try {
            this.beginDiscovery(lookupLocatorArray, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupLocatorDiscovery(LookupLocator[] lookupLocatorArray, Configuration configuration) throws ConfigurationException {
        this.beginDiscovery(lookupLocatorArray, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.contains(discoveryListener)) {
                return;
            }
            this.listeners.add(discoveryListener);
            if (!this.discoveredLocators.isEmpty()) {
                HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredLocators.size());
                Iterator iterator = this.discoveredLocators.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    LocatorReg locatorReg = (LocatorReg)iterator.next();
                    hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
                    ++n;
                }
                ArrayList<DiscoveryListener> arrayList = new ArrayList<DiscoveryListener>(1);
                arrayList.add(discoveryListener);
                this.addNotify(arrayList, hashMap, false);
            }
        }
    }

    public synchronized void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.listeners.indexOf(discoveryListener);
        if (n != -1) {
            this.listeners.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.discoveredLocators == null || this.discoveredLocators.isEmpty()) {
                return new ServiceRegistrar[0];
            }
            return this.buildServiceRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar serviceRegistrar) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (serviceRegistrar == null) {
                return;
            }
            LookupLocator lookupLocator = this.findRegFromProxy(serviceRegistrar);
            if (lookupLocator == null) {
                return;
            }
            LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocator);
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            locatorReg.proxy = null;
            locatorReg.memberGroups = null;
            locatorReg.fixupNextTryTime();
            this.addToMap(locatorReg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.terminateTaskMgr();
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.clear();
        }
    }

    public synchronized LookupLocator[] getLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.discoveredLocators.size() + this.undiscoveredLocators.size();
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        return lookupLocatorArray;
    }

    public synchronized void addLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        this.discoverLocators(lookupLocatorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LocatorReg locatorReg;
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            Iterator iterator = this.discoveredLocators.iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
                hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
            }
            iterator = this.undiscoveredLocators.iterator();
            while (iterator.hasNext()) {
                locatorReg = (LocatorReg)iterator.next();
                if (this.isArrayContains(lookupLocatorArray, locatorReg.l)) continue;
                iterator.remove();
            }
            this.discoverLocators(lookupLocatorArray);
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocators(LookupLocator[] lookupLocatorArray) {
        this.testSetForNull(lookupLocatorArray);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
            for (int i = 0; i < lookupLocatorArray.length; ++i) {
                LocatorReg locatorReg = this.removeDiscoveredLocator(lookupLocatorArray[i]);
                if (locatorReg != null) {
                    hashMap.put(locatorReg.proxy, locatorReg.memberGroups);
                    continue;
                }
                locatorReg = this.findReg(lookupLocatorArray[i]);
                if (locatorReg == null) continue;
                this.undiscoveredLocators.remove(locatorReg);
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, true);
            }
        }
    }

    public synchronized LookupLocator[] getDiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int n = this.discoveredLocators.size();
        LookupLocator[] lookupLocatorArray = new LookupLocator[n];
        int n2 = 0;
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            lookupLocatorArray[n2++] = ((LocatorReg)iterator.next()).l;
        }
        return lookupLocatorArray;
    }

    public synchronized LookupLocator[] getUndiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        LookupLocator[] lookupLocatorArray = new LookupLocator[this.undiscoveredLocators.size()];
        Iterator iterator = this.undiscoveredLocators.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            lookupLocatorArray[n] = ((LocatorReg)iterator.next()).l;
            ++n;
        }
        return lookupLocatorArray;
    }

    private void discoverLocators(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            return;
        }
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            LocatorReg locatorReg;
            if (this.isDiscovered(lookupLocatorArray[i]) || (locatorReg = this.findReg(lookupLocatorArray[i])) != null) continue;
            locatorReg = new LocatorReg(lookupLocatorArray[i]);
            this.addToMap(locatorReg);
        }
    }

    private LocatorReg findReg(LookupLocator lookupLocator) {
        Iterator iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals((Object)lookupLocator)) continue;
            return locatorReg;
        }
        return null;
    }

    private LookupLocator findRegFromProxy(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.proxy.equals(serviceRegistrar)) continue;
            return locatorReg.l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean regTryGetProxy(LocatorReg locatorReg) {
        boolean bl = locatorReg.tryGetProxy();
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (!this.undiscoveredLocators.contains(locatorReg)) {
                return true;
            }
            if (!bl) {
                return false;
            }
            this.undiscoveredLocators.remove(locatorReg);
            this.discoveredLocators.add(locatorReg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(locatorReg.proxy, locatorReg.memberGroups), false);
            }
            return true;
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.discoveredLocators.size()];
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            serviceRegistrarArray[n++] = locatorReg.proxy;
        }
        return serviceRegistrarArray;
    }

    private void addToMap(LocatorReg locatorReg) {
        this.undiscoveredLocators.add(locatorReg);
        this.queueDiscoveryTask(locatorReg);
    }

    private void queueDiscoveryTask(LocatorReg locatorReg) {
        this.discoveryTaskMgr.add(new DiscoveryTask(locatorReg, this.discoveryTaskMgr, this.discoveryWakeupMgr));
    }

    private boolean isDiscovered(LookupLocator lookupLocator) {
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals((Object)lookupLocator)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(ArrayList arrayList, Map map, boolean bl) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, bl));
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier();
                this.notifierThread.start();
            }
        }
    }

    private LocatorReg removeDiscoveredLocator(LookupLocator lookupLocator) {
        Iterator iterator = this.discoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            if (!locatorReg.l.equals((Object)lookupLocator)) continue;
            iterator.remove();
            return locatorReg;
        }
        return null;
    }

    private void terminateTaskMgr() {
        if (this.discoveryWakeupMgr != null) {
            this.discoveryWakeupMgr.stop();
            this.discoveryWakeupMgr.cancelAll();
        }
        if (this.discoveryTaskMgr != null) {
            ArrayList arrayList = this.discoveryTaskMgr.getPending();
            for (int i = 0; i < arrayList.size(); ++i) {
                RetryTask retryTask = (RetryTask)arrayList.get(i);
                retryTask.cancel();
                this.discoveryTaskMgr.remove(retryTask);
            }
            this.discoveryTaskMgr.terminate();
            this.discoveryTaskMgr = null;
            this.discoveryWakeupMgr = null;
        }
    }

    private boolean isArrayContains(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    private void printMap() {
        Iterator iterator = this.undiscoveredLocators.iterator();
        while (iterator.hasNext()) {
            LocatorReg locatorReg = (LocatorReg)iterator.next();
            System.out.println("printMap reg:" + locatorReg.id);
        }
    }

    private void testSetForNull(LookupLocator[] lookupLocatorArray) {
        if (lookupLocatorArray == null) {
            throw new NullPointerException("null locator array");
        }
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            if (lookupLocatorArray[i] != null) continue;
            throw new NullPointerException("null element in locator array");
        }
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDiscovery(LookupLocator[] lookupLocatorArray, Configuration configuration) throws ConfigurationException {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            this.init(configuration);
            this.discoverLocators(lookupLocatorArray);
        }
    }

    private void init(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("config is null");
        }
        this.registrarPreparer = (ProxyPreparer)configuration.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.discoveryTaskMgr = new TaskManager(15, 15000L, 1.0f);
        try {
            this.discoveryTaskMgr = (TaskManager)configuration.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class, (Object)this.discoveryTaskMgr);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.discoveryWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        try {
            this.discoveryWakeupMgr = (WakeupManager)configuration.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class, (Object)this.discoveryWakeupMgr);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    static {
        try {
            getRegistrarMethod = LookupLocator.class.getDeclaredMethod("getRegistrar", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private class DiscoveryTask
    extends RetryTask {
        private LocatorReg reg;

        public DiscoveryTask(LocatorReg locatorReg, TaskManager taskManager, WakeupManager wakeupManager) {
            super(taskManager, wakeupManager);
            this.reg = locatorReg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            logger.finest("LookupLocatorDiscovery - DiscoveryTask started");
            LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery) {
                if (LookupLocatorDiscovery.this.undiscoveredLocators.isEmpty()) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
                if (!LookupLocatorDiscovery.this.undiscoveredLocators.contains(this.reg)) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
            }
            boolean bl = LookupLocatorDiscovery.this.regTryGetProxy(this.reg);
            if (bl) {
                logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
            } else {
                logger.finest("LookupLocatorDiscovery - DiscoveryTask failed, will retry later");
            }
            return bl;
        }

        public long retryTime() {
            return this.reg.getNextTryTime();
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event notifier");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupLocatorDiscovery - Notifier thread started");
            block5: while (true) {
                NotifyTask notifyTask;
                LinkedList linkedList = LookupLocatorDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupLocatorDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupLocatorDiscovery.this.notifierThread = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupLocatorDiscovery.this.pendingNotifies.removeFirst();
                }
                boolean bl = true;
                Iterator iterator = notifyTask.listeners.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    DiscoveryListener discoveryListener = (DiscoveryListener)iterator.next();
                    DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)LookupLocatorDiscovery.this, LookupLocatorDiscovery.this.deepCopy((HashMap)notifyTask.groupsMap));
                    if (bl && logger.isLoggable(Level.FINEST)) {
                        String string = notifyTask.discard ? "discarded" : "discovered";
                        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                        logger.finest(string + " event  -- " + serviceRegistrarArray.length + " lookup(s)");
                        Map map = discoveryEvent.getGroups();
                        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                            LookupLocator lookupLocator = null;
                            try {
                                lookupLocator = serviceRegistrarArray[i].getLocator();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            String[] stringArray = (String[])map.get(serviceRegistrarArray[i]);
                            logger.finest("    " + string + " locator  = " + lookupLocator);
                            if (stringArray.length == 0) {
                                logger.finest("    " + string + " group    = NO_GROUPS");
                                continue;
                            }
                            for (int j = 0; j < stringArray.length; ++j) {
                                logger.finest("    " + string + " group[" + j + "] " + "= " + stringArray[j]);
                            }
                        }
                    }
                    if (notifyTask.discard) {
                        discoveryListener.discarded(discoveryEvent);
                        continue;
                    }
                    discoveryListener.discovered(discoveryEvent);
                }
                break;
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final boolean discard;

        public NotifyTask(ArrayList arrayList, Map map, boolean bl) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.discard = bl;
        }
    }

    private class LocatorReg {
        public ServiceRegistrar proxy = null;
        public final LookupLocator l;
        public String[] memberGroups = null;
        private int cnt = 0;
        private static final long MIN_RETRY = 15000L;
        private final long[] sleepTime = new long[]{5000L, 10000L, 20000L, 30000L, 60000L, 120000L, 240000L, 480000L, 900000L};
        private int tryIndx = 0;
        private long nextTryTime;
        private final int id = this.cnt++;
        private long time = 0L;

        public LocatorReg(LookupLocator lookupLocator) {
            this.l = lookupLocator;
            this.nextTryTime = System.currentTimeMillis();
        }

        public synchronized long getNextTryTime() {
            return this.nextTryTime;
        }

        public void calcNextTryTime() {
            this.nextTryTime = System.currentTimeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
        }

        public void fixupNextTryTime() {
            long l = System.currentTimeMillis();
            if (l - this.time > 15000L) {
                this.tryIndx = 0;
                this.nextTryTime = l;
            } else {
                this.calcNextTryTime();
            }
        }

        public boolean tryGetProxy() {
            if (this.proxy != null) {
                throw new IllegalArgumentException("LookupLocator has been discovered already");
            }
            try {
                this.doUnicastDiscovery(this.l);
                this.time = System.currentTimeMillis();
                return true;
            }
            catch (Throwable throwable) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, this.getClass().getName(), "doUnicastDiscovery", "exception during unicast discovery", throwable);
                }
                this.calcNextTryTime();
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUnicastDiscovery(LookupLocator lookupLocator) throws IOException, ClassNotFoundException {
            DiscoveryConstraints discoveryConstraints;
            InvocationConstraints invocationConstraints = InvocationConstraints.EMPTY;
            if (lookupLocator instanceof RemoteMethodControl && (discoveryConstraints = ((RemoteMethodControl)lookupLocator).getConstraints()) != null) {
                invocationConstraints = discoveryConstraints.getConstraints(getRegistrarMethod);
            }
            Discovery discovery = (discoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)invocationConstraints)).chooseProtocolVersion() == 1 ? Discovery.getProtocol1() : LookupLocatorDiscovery.this.protocol2;
            Socket socket = new Socket(lookupLocator.getHost(), lookupLocator.getPort());
            try {
                socket.setSoTimeout(discoveryConstraints.getUnicastSocketTimeout(60000));
                UnicastResponse unicastResponse = discovery.doUnicastDiscovery(socket, discoveryConstraints.getUnfulfilledConstraints(), null, null, null);
                this.proxy = (ServiceRegistrar)LookupLocatorDiscovery.this.registrarPreparer.prepareProxy((Object)unicastResponse.getRegistrar());
                logger.log(Level.FINEST, "LookupLocatorDiscovery - prepared lookup service proxy: {0}", this.proxy);
                this.memberGroups = unicastResponse.getGroups();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINEST, "IOException on socket close upon completion of unicast discovery", iOException);
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.log(Level.FINEST, "IOException on socket close upon completion of unicast discovery", iOException);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof LocatorReg)) {
                return false;
            }
            return this.l.equals((Object)((LocatorReg)object).l);
        }

        public int hashCode() {
            return this.l.hashCode();
        }
    }
}

