/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.norm.AdminProxy;
import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.CorruptedStoreException;
import com.sun.jini.norm.CreateLeaseSet;
import com.sun.jini.norm.GetLeasesResult;
import com.sun.jini.norm.InternalNormException;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.norm.LeaseExpirationMgr;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.LoggedOperation;
import com.sun.jini.norm.NormProxy;
import com.sun.jini.norm.NormServer;
import com.sun.jini.norm.PersistentStore;
import com.sun.jini.norm.ProxyVerifier;
import com.sun.jini.norm.SetProxy;
import com.sun.jini.norm.StoreConflictException;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.UIDGenerator;
import com.sun.jini.norm.event.EventType;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import com.sun.jini.norm.lookup.JoinState;
import com.sun.jini.proxy.ThrowThis;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lease.LeaseRenewalService;
import net.jini.lease.LeaseRenewalSet;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

abstract class NormServerBaseImpl
implements NormServer,
LocalLandlord,
ServerProxyTrust,
ProxyAccessor {
    private static final int CURRENT_LOG_VERSION = 2;
    static final String NORM = "com.sun.jini.norm";
    static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    final boolean persistent;
    LoginContext loginContext;
    String persistenceDirectory;
    private ProxyPreparer leasePreparer;
    private ProxyPreparer recoveredLeasePreparer;
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredListenerPreparer;
    private ProxyPreparer locatorPreparer;
    private ProxyPreparer recoveredLocatorPreparer;
    Exporter exporter;
    private LifeCycle lifeCycle;
    private Uuid serverUuid;
    private JoinState joinState;
    private Map setTable = Collections.synchronizedMap(new HashMap());
    private LeaseRenewalManager lrm;
    private LeaseExpirationMgr expMgr;
    private LeaseFactory leaseFactory;
    private LeasePeriodPolicy setLeasePolicy;
    private boolean isolateSets;
    private PersistentStore store;
    private UIDGenerator idGen = new UIDGenerator();
    private List renewedList = new LinkedList();
    private RenewLogThread renewLogger;
    private EventTypeGenerator generator;
    private LRMEventListener lrmEventListener;
    private int logToSnapshotThresh;
    private float snapshotWt;
    NormServer serverProxy = null;
    LeaseRenewalService normProxy = null;
    private AdminProxy adminProxy;
    private SnapshotThread snapshotter;
    private final ReadyState ready = new ReadyState();
    private final CountLeases countLeases = new CountLeases();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewFor(Uuid uuid, Lease lease, long l, long l2) throws RemoteException, ThrowThis {
        Object object;
        LeaseSet leaseSet;
        this.ready.check();
        LeaseSet leaseSet2 = this.getSet(uuid);
        if (lease == null) {
            throw new NullPointerException("LeaseRenewalSet.renewFor:Must pass a non-null lease");
        }
        if (l != Long.MAX_VALUE && l2 == -1L) {
            throw new IllegalArgumentException("LeaseRenewalSet.renewFor:renewDuration can only be Lease.ANY if membershipDuration is Lease.FOREVER");
        }
        if (l2 != -1L && l2 != Long.MAX_VALUE && l2 <= 0L) {
            throw new IllegalArgumentException("LeaseRenewalSet.renewFor:renewDuration can only be Lease.ANY, Lease.FOREVER, or positive");
        }
        if ((lease = (Lease)this.leasePreparer.prepareProxy((Object)lease)) instanceof ReferentUuid && (leaseSet = (LeaseSet)this.setTable.get(object = ((ReferentUuid)lease).getReferentUuid())) != null) {
            LeaseSet leaseSet3 = leaseSet;
            synchronized (leaseSet3) {
                if (NormServerBaseImpl.isCurrent(leaseSet)) {
                    throw new IllegalArgumentException("Cannot add leases granted by a LeaseRenewalService to a set created by that service");
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            object = lease.getClass();
            logger.log(Level.FINE, "Adding lease of class {0} with annotation {1}", new Object[]{lease.getClass(), RMIClassLoader.getClassAnnotation(object)});
        }
        this.add(leaseSet2, lease, l, l2);
    }

    void updateLeaseCount(int n) {
        this.countLeases.updateCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(LeaseSet leaseSet, Lease lease, long l, long l2) throws ThrowThis {
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                NormServerBaseImpl.ensureCurrent(leaseSet);
                long l3 = System.currentTimeMillis();
                ClientLeaseWrapper clientLeaseWrapper = leaseSet.getClientLeaseWrapper(lease);
                if (clientLeaseWrapper == null) {
                    try {
                        clientLeaseWrapper = new ClientLeaseWrapper(lease, this.idGen.newID(), this.renewedList, leaseSet, l, l2, l3);
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("NormServerBaseImpl.renewFor:Handed lease that can't be marshalled");
                    }
                } else {
                    clientLeaseWrapper.update(l, l2, l3);
                }
                leaseSet.update(clientLeaseWrapper);
                this.lrm.renewUntil(clientLeaseWrapper, clientLeaseWrapper.getMembershipExpiration(), clientLeaseWrapper.getRenewDuration(), this.lrmEventListener);
            }
            Object var14_10 = null;
            this.store.releaseMutatorLock();
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lease remove(Uuid uuid, Lease lease) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet leaseSet = this.getSet(uuid);
        if (lease == null) {
            throw new NullPointerException("LeaseRenewalSet.remove:Must pass a non-null lease");
        }
        lease = (Lease)this.leasePreparer.prepareProxy((Object)lease);
        logger.log(Level.FINE, "Removing lease {0}", lease);
        Lease lease2 = null;
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                NormServerBaseImpl.ensureCurrent(leaseSet);
                ClientLeaseWrapper clientLeaseWrapper = leaseSet.getClientLeaseWrapper(lease);
                if (clientLeaseWrapper == null) {
                    Lease lease3 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                    Object var10_10 = null;
                    this.store.releaseMutatorLock();
                    return lease3;
                }
                try {
                    this.lrm.remove(clientLeaseWrapper);
                }
                catch (UnknownLeaseException unknownLeaseException) {
                    // empty catch block
                }
                boolean bl = leaseSet.remove(clientLeaseWrapper);
                if (bl) {
                    lease2 = clientLeaseWrapper.getClientLease();
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
        Object var10_11 = null;
        this.store.releaseMutatorLock();
        if (lease2 == null) {
            return null;
        }
        lease2.setSerialFormat(1);
        return lease2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetLeasesResult getLeases(Uuid uuid) throws ThrowThis {
        LeaseSet leaseSet;
        this.ready.check();
        LeaseSet leaseSet2 = leaseSet = this.getSet(uuid);
        synchronized (leaseSet2) {
            NormServerBaseImpl.ensureCurrent(leaseSet);
            return new GetLeasesResult(leaseSet.getLeases());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventRegistration setExpirationWarningListener(Uuid uuid, RemoteEventListener remoteEventListener, long l, MarshalledObject marshalledObject) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet leaseSet = this.getSet(uuid);
        if (remoteEventListener == null) {
            l = -1L;
            marshalledObject = null;
        } else {
            if (l < 0L) {
                throw new IllegalArgumentException("LeaseRenewalSet.setExpirationWarningListener:minWarning must be positive");
            }
            remoteEventListener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)remoteEventListener);
        }
        try {
            EventRegistration eventRegistration;
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                NormServerBaseImpl.ensureCurrent(leaseSet);
                try {
                    boolean bl = leaseSet.haveWarningRegistration();
                    EventRegistration eventRegistration2 = leaseSet.setExpirationWarningListener(remoteEventListener, l, marshalledObject);
                    boolean bl2 = leaseSet.haveWarningRegistration();
                    if (bl2 || bl != bl2) {
                        this.expMgr.reschedule(leaseSet);
                    }
                    eventRegistration = eventRegistration2;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Passed a listener that could not be serialized");
                }
            }
            Object var14_12 = null;
            this.store.releaseMutatorLock();
            return eventRegistration;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void expireIfTime(LeaseSet leaseSet) {
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                if (NormServerBaseImpl.isCurrent(leaseSet)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    Object var5_3 = null;
                    this.store.releaseMutatorLock();
                    return;
                }
                this.removeSet(leaseSet);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
        Object var5_4 = null;
        this.store.releaseMutatorLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendWarningEvent(LeaseSet leaseSet) {
        LeaseSet leaseSet2 = leaseSet;
        synchronized (leaseSet2) {
            if (!NormServerBaseImpl.isCurrent(leaseSet)) {
                return;
            }
            leaseSet.sendWarningEvent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventRegistration setRenewalFailureListener(Uuid uuid, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet leaseSet = this.getSet(uuid);
        if (remoteEventListener == null) {
            marshalledObject = null;
        } else {
            remoteEventListener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)remoteEventListener);
        }
        try {
            EventRegistration eventRegistration;
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                NormServerBaseImpl.ensureCurrent(leaseSet);
                try {
                    eventRegistration = leaseSet.setRenewalFailureListener(remoteEventListener, marshalledObject);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Passed a listener that could not be serialized");
                }
            }
            Object var9_8 = null;
            this.store.releaseMutatorLock();
            return eventRegistration;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void renewalFailure(ClientLeaseWrapper clientLeaseWrapper) {
        LeaseSet leaseSet = clientLeaseWrapper.getLeaseSet();
        if (leaseSet == null) {
            return;
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                logger.log(Level.INFO, "Lease renewal failed for {0}", clientLeaseWrapper);
                if (!NormServerBaseImpl.isCurrent(leaseSet)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var7_4 = null;
                    this.store.releaseMutatorLock();
                    return;
                }
                leaseSet.renewalFailure(clientLeaseWrapper);
                try {
                    this.lrm.remove(clientLeaseWrapper);
                }
                catch (UnknownLeaseException unknownLeaseException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
        Object var7_5 = null;
        this.store.releaseMutatorLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void desiredExpirationReached(ClientLeaseWrapper clientLeaseWrapper) {
        block18: {
            block17: {
                block16: {
                    block15: {
                        LeaseSet leaseSet = clientLeaseWrapper.getLeaseSet();
                        if (leaseSet == null) {
                            return;
                        }
                        try {
                            this.store.acquireMutatorLock();
                            LeaseSet leaseSet2 = leaseSet;
                            synchronized (leaseSet2) {
                                if (!NormServerBaseImpl.isCurrent(leaseSet)) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 7, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                                    Object var9_4 = null;
                                    this.store.releaseMutatorLock();
                                    return;
                                }
                                if (!leaseSet.doesContainWrapper(clientLeaseWrapper)) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 7, 14] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                                    break block15;
                                }
                                long l = clientLeaseWrapper.getMembershipExpiration();
                                if (l > System.currentTimeMillis()) {
                                    this.lrm.renewUntil(clientLeaseWrapper, clientLeaseWrapper.getMembershipExpiration(), clientLeaseWrapper.getRenewDuration(), this.lrmEventListener);
                                    // MONITOREXIT @DISABLED, blocks:[0, 7, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                                    break block16;
                                }
                                if (clientLeaseWrapper.getExpiration() < l) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 7, 12] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                                    break block17;
                                }
                                logger.log(Level.FINE, "Reached desired expiration for lease {0}", clientLeaseWrapper);
                                leaseSet.remove(clientLeaseWrapper);
                                try {
                                    this.lrm.remove(clientLeaseWrapper);
                                }
                                catch (UnknownLeaseException unknownLeaseException) {
                                    // empty catch block
                                }
                            }
                            break block18;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            this.store.releaseMutatorLock();
                            throw throwable;
                        }
                    }
                    Object var9_5 = null;
                    this.store.releaseMutatorLock();
                    return;
                }
                Object var9_6 = null;
                this.store.releaseMutatorLock();
                return;
            }
            Object var9_7 = null;
            this.store.releaseMutatorLock();
            return;
        }
        Object var9_8 = null;
        this.store.releaseMutatorLock();
    }

    private void removeClientLeases(Iterator iterator) {
        while (iterator.hasNext()) {
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)iterator.next();
            try {
                this.lrm.remove(clientLeaseWrapper);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static void ensureCurrent(LeaseSet leaseSet) throws ThrowThis {
        if (!NormServerBaseImpl.isCurrent(leaseSet)) {
            throw new ThrowThis(new NoSuchObjectException("Set has expired"));
        }
    }

    private static boolean isCurrent(LeaseSet leaseSet) {
        return leaseSet.getExpiration() > System.currentTimeMillis();
    }

    private LeaseSet getSet(Uuid uuid) throws ThrowThis {
        LeaseSet leaseSet = (LeaseSet)this.setTable.get(uuid);
        if (leaseSet == null) {
            throw new ThrowThis(new NoSuchObjectException("Can't find set"));
        }
        return leaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaseRenewalSet createLeaseRenewalSet(long l) {
        Serializable serializable;
        LeasePeriodPolicy.Result result;
        this.ready.check();
        Uuid uuid = UuidFactory.generate();
        LeaseSet leaseSet = new LeaseSet(uuid, this.generator, this.store, this);
        try {
            result = this.setLeasePolicy.grant(leaseSet, l);
        }
        catch (LeaseDeniedException leaseDeniedException) {
            logger.log(Level.WARNING, "Got LeaseDeniedException creating lease -- this should not happen!", leaseDeniedException);
            throw new InternalNormException("Error creating lease", leaseDeniedException);
        }
        LandlordLease landlordLease = this.leaseFactory.newLease(uuid, result.expiration);
        leaseSet.setExpiration(result.expiration);
        try {
            this.store.acquireMutatorLock();
            serializable = new CreateLeaseSet(leaseSet);
            this.store.update(serializable);
            this.expMgr.register(leaseSet);
            this.setTable.put(uuid, leaseSet);
            Object var9_8 = null;
            this.store.releaseMutatorLock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
        serializable = SetProxy.create(this.serverProxy, uuid, landlordLease);
        logger.log(Level.FINE, "Created lease renewal set {0}", serializable);
        return serializable;
    }

    SetProxy newSetProxy(LeaseSet leaseSet) {
        LandlordLease landlordLease = this.leaseFactory.newLease(leaseSet.getUuid(), leaseSet.getExpiration());
        return SetProxy.create(this.serverProxy, leaseSet.getUuid(), landlordLease);
    }

    SendMonitor newSendMonitor(LeaseSet leaseSet) {
        return new SendMonitorImpl(leaseSet);
    }

    public TrustVerifier getProxyVerifier() {
        return new ProxyVerifier(this.serverProxy, this.serverUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long renew(Uuid uuid, long l) throws UnknownLeaseException, LeaseDeniedException {
        this.ready.check();
        LeaseSet leaseSet = (LeaseSet)this.setTable.get(uuid);
        if (leaseSet == null) {
            throw new UnknownLeaseException("No lease for cookie:" + uuid);
        }
        try {
            long l2;
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                if (!NormServerBaseImpl.isCurrent(leaseSet)) {
                    throw new UnknownLeaseException("Lease has already expired");
                }
                long l3 = leaseSet.getExpiration();
                LeasePeriodPolicy.Result result = this.setLeasePolicy.renew(leaseSet, l);
                LeaseSet.ChangeSetExpiration changeSetExpiration = new LeaseSet.ChangeSetExpiration(leaseSet, result.expiration);
                this.store.update(changeSetExpiration);
                leaseSet.setExpiration(result.expiration);
                this.expMgr.reschedule(leaseSet);
                l2 = result.duration;
            }
            Object var14_9 = null;
            this.store.releaseMutatorLock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel(Uuid uuid) throws UnknownLeaseException {
        this.ready.check();
        LeaseSet leaseSet = (LeaseSet)this.setTable.get(uuid);
        if (leaseSet == null) {
            throw new UnknownLeaseException("No lease for cookie:" + uuid);
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                if (!NormServerBaseImpl.isCurrent(leaseSet)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var6_4 = null;
                    this.store.releaseMutatorLock();
                    return;
                }
                this.removeSet(leaseSet);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.store.releaseMutatorLock();
            throw throwable;
        }
        Object var6_5 = null;
        this.store.releaseMutatorLock();
    }

    private void removeSet(LeaseSet leaseSet) {
        this.setTable.remove(leaseSet.getUuid());
        Set set = leaseSet.destroy();
        this.removeClientLeases(set.iterator());
    }

    public Landlord.RenewResults renewAll(Uuid[] uuidArray, long[] lArray) {
        this.ready.check();
        return LandlordUtil.renewAll(this, uuidArray, lArray);
    }

    public Map cancelAll(Uuid[] uuidArray) {
        this.ready.check();
        return LandlordUtil.cancelAll(this, uuidArray);
    }

    void updatePerformed(int n) {
        int n2;
        if (n >= this.logToSnapshotThresh && (float)n >= this.snapshotWt * (float)(n2 = this.setTable.size() + this.countLeases.getCount())) {
            this.snapshotter.takeSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTransientState() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.setTable.values().iterator();
        while (iterator.hasNext()) {
            LeaseSet leaseSet = (LeaseSet)iterator.next();
            if (l > leaseSet.getExpiration()) {
                iterator.remove();
                continue;
            }
            Iterator iterator2 = leaseSet.restoreTransientState(this.generator, this.store, this, this.recoveredListenerPreparer);
            while (iterator2.hasNext()) {
                ClientLeaseWrapper clientLeaseWrapper;
                Object object = this;
                synchronized (object) {
                    clientLeaseWrapper = (ClientLeaseWrapper)iterator2.next();
                    clientLeaseWrapper.recoverTransient(this.renewedList, this.idGen, leaseSet, this.recoveredLeasePreparer);
                }
                object = clientLeaseWrapper.getLastFailure();
                if (object == null || ThrowableConstants.retryable((Throwable)object) == 0) {
                    this.lrm.renewUntil(clientLeaseWrapper, clientLeaseWrapper.getMembershipExpiration(), clientLeaseWrapper.getRenewDuration(), this.lrmEventListener);
                    continue;
                }
                this.lrmEventListener.notify(new LeaseRenewalEvent(this.lrm, clientLeaseWrapper, clientLeaseWrapper.getMembershipExpiration(), (Throwable)object));
            }
        }
    }

    private String inventory() {
        return this.countLeases.getCount() + " client leases, " + this.setTable.size() + " sets.";
    }

    public Object getAdmin() {
        this.ready.check();
        return this.adminProxy;
    }

    public Entry[] getLookupAttributes() {
        this.ready.check();
        return this.joinState.getAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) {
        this.ready.check();
        this.joinState.addAttributes(entryArray, true);
        logger.log(Level.CONFIG, "Added attributes");
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) {
        this.ready.check();
        this.joinState.modifyAttributes(entryArray, entryArray2, true);
        logger.log(Level.CONFIG, "Modified attributes");
    }

    public String[] getLookupGroups() {
        this.ready.check();
        return this.joinState.getGroups();
    }

    public void addLookupGroups(String[] stringArray) {
        this.ready.check();
        this.joinState.addGroups(stringArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Added lookup groups: {0}", NormServerBaseImpl.toString(stringArray));
        }
    }

    public void removeLookupGroups(String[] stringArray) {
        this.ready.check();
        this.joinState.removeGroups(stringArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Removed lookup groups: {0}", NormServerBaseImpl.toString(stringArray));
        }
    }

    public void setLookupGroups(String[] stringArray) {
        this.ready.check();
        this.joinState.setGroups(stringArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Set lookup groups: {0}", NormServerBaseImpl.toString(stringArray));
        }
    }

    public LookupLocator[] getLookupLocators() {
        this.ready.check();
        return this.joinState.getLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.ready.check();
        int n = lookupLocatorArray.length;
        while (--n >= 0) {
            lookupLocatorArray[n] = (LookupLocator)this.locatorPreparer.prepareProxy((Object)lookupLocatorArray[n]);
        }
        this.joinState.addLocators(lookupLocatorArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Added lookup locators: {0}", NormServerBaseImpl.toString(lookupLocatorArray));
        }
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.ready.check();
        int n = lookupLocatorArray.length;
        while (--n >= 0) {
            lookupLocatorArray[n] = (LookupLocator)this.locatorPreparer.prepareProxy((Object)lookupLocatorArray[n]);
        }
        this.joinState.removeLocators(lookupLocatorArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Removed lookup locators: {0}", NormServerBaseImpl.toString(lookupLocatorArray));
        }
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.ready.check();
        int n = lookupLocatorArray.length;
        while (--n >= 0) {
            lookupLocatorArray[n] = (LookupLocator)this.locatorPreparer.prepareProxy((Object)lookupLocatorArray[n]);
        }
        this.joinState.setLocators(lookupLocatorArray);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Set lookup locators: {0}", NormServerBaseImpl.toString(lookupLocatorArray));
        }
    }

    private static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(objectArray[0]));
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(", ").append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public void destroy() throws RemoteException {
        this.ready.shutdown();
        logger.log(Level.INFO, "Destroying Norm service");
        this.joinState.terminateJoin();
        this.lrmEventListener.interrupt();
        this.renewLogger.interrupt();
        this.snapshotter.interrupt();
        this.expMgr.terminate();
        this.generator.terminate();
        this.lrm.clear();
        logger.log(Level.FINEST, "Independent threads interrupted");
        new DestroyThread().start();
        logger.log(Level.FINEST, "Destroy thread started");
    }

    boolean unexport(boolean bl) throws NoSuchObjectException {
        return this.exporter.unexport(bl);
    }

    void postDestroy() {
    }

    public Object getServiceProxy() {
        this.ready.check();
        return this.normProxy;
    }

    public Object getProxy() {
        return this.serverProxy;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "[" + this.serverUuid + "]";
    }

    void init(String[] stringArray, LifeCycle lifeCycle) throws Exception {
        try {
            final Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray, (ClassLoader)this.getClass().getClassLoader());
            this.lifeCycle = lifeCycle;
            this.loginContext = (LoginContext)configuration.getEntry(NORM, "loginContext", LoginContext.class, null);
            if (this.loginContext == null) {
                this.initAsSubject(configuration);
            } else {
                this.loginContext.login();
                try {
                    Subject.doAsPrivileged(this.loginContext.getSubject(), new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            NormServerBaseImpl.this.initAsSubject(configuration);
                            return null;
                        }
                    }, null);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getCause();
                }
            }
            this.ready.ready();
            logger.log(Level.INFO, "Norm service started: {0}", this);
        }
        catch (Throwable throwable) {
            NormServerBaseImpl.initFailed(throwable);
        }
    }

    static void initFailed(Throwable throwable) throws Exception {
        String string = null;
        if (throwable instanceof InitException) {
            string = throwable.getMessage();
            throwable = throwable.getCause();
        }
        if (logger.isLoggable(Level.SEVERE)) {
            if (string != null) {
                NormServerBaseImpl.logThrow(Level.SEVERE, "initFailed", "Unable to start Norm service: {0}", new Object[]{string}, throwable);
            } else {
                logger.log(Level.SEVERE, "Unable to start Norm service", throwable);
            }
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IllegalStateException illegalStateException = new IllegalStateException(throwable.getMessage());
        illegalStateException.initCause(throwable);
        throw illegalStateException;
    }

    private static void logThrow(Level level, String string, String string2, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(NormServerBaseImpl.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initAsSubject(Configuration configuration) throws Exception {
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry(configuration, NORM, "persistenceDirectory", String.class);
            this.snapshotWt = Config.getFloatEntry(configuration, NORM, "persistenceSnapshotWeight", 10.0f, 0.0f, Float.MAX_VALUE);
            this.logToSnapshotThresh = Config.getIntEntry(configuration, NORM, "persistenceSnapshotThreshold", 200, 0, Integer.MAX_VALUE);
        }
        this.leasePreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "leasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "listenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.locatorPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "locatorPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (this.persistent) {
            this.recoveredLeasePreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "recoveredLeasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "recoveredListenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.recoveredLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, NORM, "recoveredLocatorPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        }
        this.setLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(configuration, NORM, "leasePolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(0x6DDD00L, 3600000L));
        this.isolateSets = (Boolean)configuration.getEntry(NORM, "isolateSets", Boolean.TYPE, (Object)Boolean.FALSE);
        try {
            this.lrm = (LeaseRenewalManager)Config.getNonNullEntry(configuration, NORM, "leaseManager", LeaseRenewalManager.class);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.lrm = new LeaseRenewalManager(configuration);
        }
        this.exporter = this.getExporter(configuration);
        this.serverProxy = (NormServer)this.exporter.export((Remote)this);
        boolean bl = false;
        try {
            this.expMgr = new LeaseExpirationMgr(this);
            this.generator = new EventTypeGenerator();
            this.lrmEventListener = new LRMEventListener(this);
            this.renewLogger = new RenewLogThread();
            this.snapshotter = new SnapshotThread();
            try {
                this.store = new PersistentStore(this.persistenceDirectory, new OurLogHandler(), this);
                this.restoreTransientState();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Log recovered: {0}", this.inventory());
                }
            }
            catch (StoreConflictException storeConflictException) {
                throw new InitException("Another Norm Server is using this persistence directory: " + this.persistenceDirectory, storeConflictException);
            }
            catch (CorruptedStoreException corruptedStoreException) {
                throw new InitException("Log corrupted, can't recover ", corruptedStoreException);
            }
            catch (StoreException storeException) {
                throw new InitException("Can't recover log", storeException);
            }
            if (this.serverUuid == null) {
                this.serverUuid = UuidFactory.generate();
            }
            this.normProxy = NormProxy.create(this.serverProxy, this.serverUuid);
            this.adminProxy = AdminProxy.create(this.serverProxy, this.serverUuid);
            try {
                this.store.snapshot();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Completed new baseline snapshot: {0}", this.inventory());
                }
            }
            catch (IOException iOException) {
                throw new InitException("Can't create new baseline snapshot", iOException);
            }
            Entry[] entryArray = new Entry[]{new ServiceInfo("Lease Renewal Service", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.0_002", "", ""), new BasicServiceType("Lease Renewal Service")};
            try {
                this.joinState = new JoinState(this.normProxy, this.lrm, configuration, entryArray, this.recoveredLocatorPreparer, new ServiceID(this.serverUuid.getMostSignificantBits(), this.serverUuid.getLeastSignificantBits()));
                this.store.addSubStore(this.joinState);
            }
            catch (StoreException storeException) {
                throw new InitException("Can't create JoinState", storeException);
            }
            this.leaseFactory = new LeaseFactory(this.serverProxy, this.serverUuid);
            Iterator iterator = this.setTable.values().iterator();
            while (iterator.hasNext()) {
                LeaseSet leaseSet;
                LeaseSet leaseSet2 = leaseSet = (LeaseSet)iterator.next();
                synchronized (leaseSet2) {
                    this.expMgr.schedule(leaseSet);
                }
            }
            this.lrmEventListener.start();
            this.renewLogger.start();
            this.snapshotter.start();
            return;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (bl) throw throwable;
            try {
                this.unexport(true);
                throw throwable;
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Unable to unexport after failure during startup", exception);
            }
            throw throwable;
        }
    }

    boolean isolateSets() {
        return this.isolateSets;
    }

    NormServerBaseImpl(boolean bl) {
        this.persistent = bl;
    }

    Exporter getExporter(Configuration configuration) throws ConfigurationException {
        return (Exporter)Config.getNonNullEntry(configuration, NORM, "serverExporter", Exporter.class, new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory()));
    }

    class InitException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InitException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class DestroyThread
    extends Thread {
        private static final long MAX_DELAY = 120000L;

        private DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        public void run() {
            logger.log(Level.FINEST, "DestroyThread running");
            long l = System.currentTimeMillis() + 120000L;
            boolean bl = false;
            try {
                while (!bl && System.currentTimeMillis() < l) {
                    logger.log(Level.FINEST, "Calling unexport (force=false)...");
                    bl = NormServerBaseImpl.this.unexport(false);
                    logger.log(Level.FINEST, "...rslt = " + bl);
                    if (bl) continue;
                    Thread.yield();
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                logger.log(Level.FINEST, "...rslt = NoSuchObjectException");
                bl = true;
            }
            catch (Throwable throwable) {
                logger.log(Level.FINEST, "...rslt = ", throwable);
            }
            if (!bl) {
                try {
                    logger.log(Level.FINEST, "Calling unexport (force=true)");
                    NormServerBaseImpl.this.unexport(true);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
            }
            try {
                logger.log(Level.FINEST, "Joining independent threads");
                NormServerBaseImpl.this.lrmEventListener.join(120000L);
                NormServerBaseImpl.this.renewLogger.join(120000L);
                NormServerBaseImpl.this.snapshotter.join(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                logger.log(Level.FINEST, "Destroying store");
                NormServerBaseImpl.this.store.destroy();
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "While destroying persistent store -- destroy continuing", exception);
            }
            if (NormServerBaseImpl.this.lifeCycle != null) {
                NormServerBaseImpl.this.lifeCycle.unregister(this);
            }
            logger.log(Level.FINEST, "Calling postDestroy");
            NormServerBaseImpl.this.postDestroy();
            if (NormServerBaseImpl.this.loginContext != null) {
                try {
                    logger.log(Level.FINEST, "Logging out");
                    NormServerBaseImpl.this.loginContext.logout();
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "Exception while logging out", exception);
                }
            }
            logger.log(Level.FINEST, "Ending DestroyThread");
        }
    }

    private class SnapshotThread
    extends Thread {
        private SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        private synchronized void takeSnapshot() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                SnapshotThread snapshotThread = this;
                synchronized (snapshotThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Taking snapshot: {0}", NormServerBaseImpl.this.inventory());
                    }
                    NormServerBaseImpl.this.store.snapshot();
                }
                catch (InterruptedIOException interruptedIOException) {
                    return;
                }
                catch (Exception exception) {
                    if (exception instanceof LogException && ((LogException)exception).detail instanceof InterruptedIOException) {
                        return;
                    }
                    logger.log(Level.WARNING, "Snapshot failed", exception);
                }
            }
        }
    }

    private class OurLogHandler
    extends LogHandler {
        private OurLogHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void snapshot(OutputStream outputStream) throws Exception {
            long l = System.currentTimeMillis();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeInt(2);
            objectOutputStream.writeObject(NormServerBaseImpl.this.serverUuid);
            objectOutputStream.writeObject(NormServerBaseImpl.this.generator);
            objectOutputStream.writeInt(NormServerBaseImpl.this.setTable.size());
            Collection collection = NormServerBaseImpl.this.setTable.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                LeaseSet leaseSet;
                LeaseSet leaseSet2 = leaseSet = (LeaseSet)iterator.next();
                synchronized (leaseSet2) {
                    objectOutputStream.writeObject(leaseSet);
                }
            }
            objectOutputStream.flush();
        }

        public void recover(InputStream inputStream) throws Exception {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            int n = objectInputStream.readInt();
            if (n != 2) {
                throw new CorruptedStoreException("Incompatible version ID in log, looking for 2, got " + n);
            }
            NormServerBaseImpl.this.serverUuid = (Uuid)objectInputStream.readObject();
            NormServerBaseImpl.this.generator = (EventTypeGenerator)objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            NormServerBaseImpl.this.setTable = Collections.synchronizedMap(new HashMap(n2));
            for (int i = 0; i < n2; ++i) {
                LeaseSet leaseSet = (LeaseSet)objectInputStream.readObject();
                NormServerBaseImpl.this.setTable.put(leaseSet.getUuid(), leaseSet);
            }
        }

        public void applyUpdate(Object object) throws Exception {
            LoggedOperation loggedOperation = (LoggedOperation)object;
            loggedOperation.apply(NormServerBaseImpl.this.setTable);
        }
    }

    private class RenewLogThread
    extends Thread {
        private RenewLogThread() {
            super("log renewals thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Object var7_6;
                    Object object = NormServerBaseImpl.this.renewedList;
                    // MONITORENTER : object
                    if (NormServerBaseImpl.this.renewedList.isEmpty()) {
                        try {
                            NormServerBaseImpl.this.renewedList.wait();
                            // MONITOREXIT : object
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // MONITOREXIT : object
                            return;
                        }
                    }
                    ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)NormServerBaseImpl.this.renewedList.remove(0);
                    // MONITOREXIT : object
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Attempting to renew lease {0} at {1}", new Object[]{clientLeaseWrapper, new Long(System.currentTimeMillis())});
                    }
                    if ((object = clientLeaseWrapper.getLeaseSet()) == null) continue;
                    try {
                        NormServerBaseImpl.this.store.acquireMutatorLock();
                        Object object2 = object;
                        // MONITORENTER : object2
                        if (!NormServerBaseImpl.isCurrent((LeaseSet)object)) {
                            // MONITOREXIT : object2
                            var7_6 = null;
                            NormServerBaseImpl.this.store.releaseMutatorLock();
                            continue;
                        }
                        clientLeaseWrapper.clearRenewed();
                        ((LeaseSet)object).logRenewal(clientLeaseWrapper);
                        // MONITOREXIT : object2
                        var7_6 = null;
                        NormServerBaseImpl.this.store.releaseMutatorLock();
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        NormServerBaseImpl.this.store.releaseMutatorLock();
                        throw throwable;
                    }
                    Thread.yield();
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "Runtime exception in RenewLogThread -- restarting", runtimeException);
                }
            }
        }
    }

    private class SendMonitorImpl
    implements SendMonitor {
        private final LeaseSet set;

        private SendMonitorImpl(LeaseSet leaseSet) {
            this.set = leaseSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void definiteException(EventType eventType, RemoteEvent remoteEvent, long l, Throwable throwable) {
            try {
                NormServerBaseImpl.this.store.acquireMutatorLock();
                if (!NormServerBaseImpl.isCurrent(this.set)) {
                    Object var9_5 = null;
                    NormServerBaseImpl.this.store.releaseMutatorLock();
                    return;
                }
                LeaseSet leaseSet = this.set;
                synchronized (leaseSet) {
                    this.set.definiteException(eventType, remoteEvent, l);
                }
            }
            catch (Throwable throwable2) {
                Object var9_7 = null;
                NormServerBaseImpl.this.store.releaseMutatorLock();
                throw throwable2;
            }
            Object var9_6 = null;
            NormServerBaseImpl.this.store.releaseMutatorLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrent() {
            LeaseSet leaseSet = this.set;
            synchronized (leaseSet) {
                return NormServerBaseImpl.isCurrent(this.set);
            }
        }
    }

    private static class CountLeases {
        private int count;
        static final /* synthetic */ boolean $assertionsDisabled;

        private CountLeases() {
        }

        private synchronized void updateCount(int n) {
            this.count += n;
            if (!$assertionsDisabled && this.count < 0) {
                throw new AssertionError();
            }
        }

        private synchronized int getCount() {
            return this.count;
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$norm$NormServerBaseImpl == null ? (class$com$sun$jini$norm$NormServerBaseImpl = NormServerBaseImpl.class$("com.sun.jini.norm.NormServerBaseImpl")) : class$com$sun$jini$norm$NormServerBaseImpl).desiredAssertionStatus();
        }
    }

    private static final class ReadyState {
        private static final int INITIALIZE = 0;
        private static final int READY = 1;
        private static final int SHUTDOWN = 2;
        private int state = 0;

        private ReadyState() {
        }

        synchronized void check() {
            block6: while (true) {
                switch (this.state) {
                    case 0: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block6;
                    }
                    case 1: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Norm service is unavailable");
        }

        synchronized void ready() {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.notifyAll();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Norm service is unavailable");
                }
            }
        }

        synchronized void shutdown() {
            this.check();
            this.state = 2;
            this.notifyAll();
        }
    }
}

