/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.lease.BasicRenewalFailureEvent;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.ClientLeaseMapWrapper;
import com.sun.jini.norm.DeformedClientLeaseMapWrapper;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.UIDGenerator;
import com.sun.jini.norm.event.EventFactory;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.io.MarshalledInstance;
import net.jini.lease.LeaseRenewalSet;
import net.jini.security.ProxyPreparer;

class ClientLeaseWrapper
implements Lease,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private static final Method[] leaseToLeaseMethods;
    private Throwable lastFailure = null;
    private MarshalledInstance marshalledClientLease;
    private long clientLeaseExpiration;
    private long UID;
    private long membershipExpiration;
    private long renewDuration;
    private transient LeaseSet set;
    private transient Lease clientLease;
    private transient ProxyPreparer recoveredLeasePreparer;
    private transient boolean renewed = false;
    private transient List renewedList;

    ClientLeaseWrapper(Lease lease, long l, List list, LeaseSet leaseSet, long l2, long l3, long l4) throws IOException {
        this.renewedList = list;
        this.UID = l;
        this.clientLease = lease;
        this.set = leaseSet;
        this.clientLeaseExpiration = lease.getExpiration();
        lease.setSerialFormat(2);
        this.marshalledClientLease = new MarshalledInstance((Object)lease);
        this.renewDuration = l3;
        this.calcMembershipExpiration(l2, l4);
    }

    private void calcMembershipExpiration(long l, long l2) {
        if (l == Long.MAX_VALUE) {
            this.membershipExpiration = Long.MAX_VALUE;
        } else {
            this.membershipExpiration = l + l2;
            if (this.membershipExpiration < 0L) {
                this.membershipExpiration = Long.MAX_VALUE;
            }
        }
    }

    void update(long l, long l2, long l3) {
        this.renewDuration = l2;
        this.calcMembershipExpiration(l, l3);
    }

    long getMembershipExpiration() {
        return this.membershipExpiration;
    }

    long getRenewDuration() {
        return this.renewDuration;
    }

    synchronized void clearRenewed() {
        this.renewed = false;
    }

    Lease getClientLease() {
        if (this.clientLease == null) {
            Lease lease = null;
            try {
                lease = (Lease)this.marshalledClientLease.get(false);
            }
            catch (IOException iOException) {
                logger.log(Levels.HANDLED, "Problem unmarshalling lease -- will retry later", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Levels.HANDLED, "Problem unmarshalling lease -- will retry later", classNotFoundException);
            }
            if (lease != null) {
                try {
                    this.clientLease = (Lease)this.recoveredLeasePreparer.prepareProxy((Object)lease);
                }
                catch (RemoteException remoteException) {
                    logger.log(Levels.HANDLED, "Problem preparing lease -- will retry later", remoteException);
                }
                catch (SecurityException securityException) {
                    logger.log(Levels.HANDLED, "Problem preparing lease -- will retry later", securityException);
                }
            }
        }
        return this.clientLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MarshalledInstance getMarshalledClientLease() {
        MarshalledInstance marshalledInstance;
        Lease lease = this.getClientLease();
        if (lease == null) {
            return this.marshalledClientLease;
        }
        try {
            lease.setSerialFormat(1);
            marshalledInstance = new MarshalledInstance((Object)lease);
            Object var5_4 = null;
        }
        catch (IOException iOException) {
            MarshalledInstance marshalledInstance2;
            try {
                marshalledInstance2 = this.marshalledClientLease;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                lease.setSerialFormat(2);
                throw throwable;
            }
            lease.setSerialFormat(2);
            return marshalledInstance2;
        }
        lease.setSerialFormat(2);
        return marshalledInstance;
    }

    public boolean equals(Object object) {
        if (object instanceof ClientLeaseWrapper) {
            return this.UID == ((ClientLeaseWrapper)object).UID;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.UID;
    }

    public String toString() {
        return "CLW:" + this.UID + " exp:" + this.clientLeaseExpiration + " dexp:" + this.membershipExpiration + " dur:" + this.renewDuration + " failure:" + this.lastFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiration() {
        Lease lease = this.getClientLease();
        if (lease == null) {
            ClientLeaseWrapper clientLeaseWrapper = this;
            synchronized (clientLeaseWrapper) {
                return this.clientLeaseExpiration;
            }
        }
        return lease.getExpiration();
    }

    public void cancel() {
        throw new UnsupportedOperationException("ClientLeaseWrapper.cancel:LRS should not being canceling client leases ");
    }

    Throwable getLastFailure() {
        return this.lastFailure;
    }

    private synchronized boolean testAndSetRenewed() {
        boolean bl = this.renewed;
        this.renewed = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changed() {
        if (this.testAndSetRenewed()) {
            List list = this.renewedList;
            synchronized (list) {
                this.renewedList.add(this);
                this.renewedList.notifyAll();
            }
        }
    }

    boolean ensureCurrent(long l) {
        return this.set.ensureCurrent(l);
    }

    void failedRenewal(Throwable throwable) {
        this.lastFailure = throwable;
        this.changed();
    }

    boolean renewalsDone() {
        return this.getMembershipExpiration() <= this.getExpiration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void successfulRenewal() {
        this.lastFailure = null;
        try {
            this.marshalledClientLease = new MarshalledInstance((Object)this.clientLease);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "IOException while marshalling client lease after renewal", iOException);
        }
        ClientLeaseWrapper clientLeaseWrapper = this;
        synchronized (clientLeaseWrapper) {
            this.clientLeaseExpiration = this.clientLease.getExpiration();
        }
        this.changed();
    }

    public void renew(long l) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        if (!this.set.ensureCurrent(System.currentTimeMillis())) {
            throw LRMEventListener.EXPIRED_SET_EXCEPTION;
        }
        if (this.clientLease == null) {
            Lease lease;
            try {
                lease = (Lease)this.marshalledClientLease.get(false);
            }
            catch (IOException iOException) {
                UnmarshalException unmarshalException = new UnmarshalException("ClientLeaseWrapper.renew:Could not unmarshal client lease for renewal", iOException);
                this.failedRenewal(unmarshalException);
                throw unmarshalException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                UnmarshalException unmarshalException = new UnmarshalException("ClientLeaseWrapper.renew:Could not unmarshal client lease for renewal", classNotFoundException);
                this.failedRenewal(unmarshalException);
                throw unmarshalException;
            }
            try {
                this.clientLease = (Lease)this.recoveredLeasePreparer.prepareProxy((Object)lease);
            }
            catch (RemoteException remoteException) {
                this.failedRenewal(remoteException);
                throw remoteException;
            }
            catch (SecurityException securityException) {
                this.failedRenewal(securityException);
                throw securityException;
            }
        }
        try {
            this.clientLease.renew(l);
        }
        catch (LeaseDeniedException leaseDeniedException) {
            this.failedRenewal(leaseDeniedException);
            throw leaseDeniedException;
        }
        catch (UnknownLeaseException unknownLeaseException) {
            this.failedRenewal(unknownLeaseException);
            throw unknownLeaseException;
        }
        catch (RemoteException remoteException) {
            this.failedRenewal(remoteException);
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            this.failedRenewal(runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.failedRenewal(error);
            throw error;
        }
        this.successfulRenewal();
    }

    public void setSerialFormat(int n) {
        throw new UnsupportedOperationException("ClientLeaseWrapper.setSerialFormat:LRS should not be setting serial format through the wrapper");
    }

    public int getSerialFormat() {
        throw new UnsupportedOperationException("ClientLeaseWrapper.setSerialFormat:LRS should not be setting serial format through the wrapper");
    }

    public LeaseMap createLeaseMap(long l) {
        if (this.isDeformed()) {
            return new DeformedClientLeaseMapWrapper(this, l);
        }
        return new ClientLeaseMapWrapper(this, l);
    }

    public boolean canBatch(Lease lease) {
        Lease lease2;
        if (!(lease instanceof ClientLeaseWrapper)) {
            return false;
        }
        ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)lease;
        if (this.set.isolateSets() && !this.set.equals(clientLeaseWrapper.set)) {
            return false;
        }
        if (this.isDeformed() || clientLeaseWrapper.isDeformed()) {
            return false;
        }
        Lease lease3 = this.getClientLease();
        return ClientLeaseWrapper.sameConstraints(lease3, lease2 = clientLeaseWrapper.getClientLease()) && lease3.canBatch(lease2);
    }

    private static boolean sameConstraints(Lease lease, Lease lease2) {
        if (!(lease instanceof RemoteMethodControl)) {
            return !(lease2 instanceof RemoteMethodControl);
        }
        if (!(lease2 instanceof RemoteMethodControl)) {
            return false;
        }
        return ConstrainableProxyUtil.equivalentConstraints(((RemoteMethodControl)lease).getConstraints(), ((RemoteMethodControl)lease2).getConstraints(), leaseToLeaseMethods);
    }

    void recoverTransient(List list, UIDGenerator uIDGenerator, LeaseSet leaseSet, ProxyPreparer proxyPreparer) {
        this.renewedList = list;
        this.set = leaseSet;
        uIDGenerator.inUse(this.UID);
        this.recoveredLeasePreparer = proxyPreparer;
        this.getClientLease();
        this.set.addToLeaseTable(this);
    }

    boolean isDeformed() {
        return this.getClientLease() == null;
    }

    LeaseSet getLeaseSet() {
        return this.set;
    }

    EventFactory newFailureFactory(LeaseRenewalSet leaseRenewalSet) throws IOException {
        MarshalledInstance marshalledInstance = this.getMarshalledClientLease();
        MarshalledInstance marshalledInstance2 = null;
        if (this.lastFailure != null) {
            marshalledInstance2 = new MarshalledInstance((Object)this.lastFailure);
        }
        return new FailureFactory(leaseRenewalSet, marshalledInstance, marshalledInstance2);
    }

    static {
        try {
            Method method = Lease.class.getMethod("cancel", new Class[0]);
            Method method2 = Lease.class.getMethod("renew", Long.TYPE);
            leaseToLeaseMethods = new Method[]{method, method, method2, method2};
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private class FailureFactory
    implements EventFactory {
        private LeaseRenewalSet source;
        private final MarshalledInstance marshalledLease;
        private final MarshalledInstance marshalledThrowable;

        private FailureFactory(LeaseRenewalSet leaseRenewalSet, MarshalledInstance marshalledInstance, MarshalledInstance marshalledInstance2) {
            this.source = leaseRenewalSet;
            this.marshalledLease = marshalledInstance;
            this.marshalledThrowable = marshalledInstance2;
        }

        public RemoteEvent createEvent(long l, long l2, MarshalledObject marshalledObject) {
            return new BasicRenewalFailureEvent(this.source, l2, marshalledObject, this.marshalledLease, this.marshalledThrowable);
        }
    }
}

