/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ToolstripScrollBarUI
extends BasicScrollBarUI {
    private static final int PADDING = 1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ToolstripScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        int n = ToolstripIcons.SCROLL_DOWN.getIcon().getIconWidth() + 2;
        int n2 = UIManager.getInt("ScrollBar.width");
        UIManager.getDefaults().put("ScrollBar.width", (Object)n);
        super.installDefaults();
        UIManager.getDefaults().put("ScrollBar.width", (Object)n2);
        this.minimumThumbSize = (Dimension)UIManager.get("ScrollBar.minimumThumbSize");
        this.maximumThumbSize = (Dimension)UIManager.get("ScrollBar.maximumThumbSize");
    }

    @Override
    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return this.createButton(n);
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return this.createButton(n);
    }

    private JButton createButton(int n) {
        switch (n) {
            case 5: {
                return this.createButton(ToolstripIcons.SCROLL_DOWN.getIcon());
            }
            case 1: {
                return this.createButton(ToolstripIcons.SCROLL_UP.getIcon());
            }
            case 7: {
                return this.createButton(ToolstripIcons.SCROLL_LEFT.getIcon());
            }
        }
        return this.createButton(ToolstripIcons.SCROLL_RIGHT.getIcon());
    }

    protected JButton createButton(Icon icon) {
        MJButton mJButton = new MJButton(icon);
        mJButton.setOpaque(false);
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return mJButton;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        Rectangle rectangle = this.getThumbBounds();
        if (rectangle.intersects(graphics.getClipBounds())) {
            this.paintThumb(graphics, jComponent, rectangle);
        }
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(ToolstripTheme.getInstance().getScrollBarColor());
        graphics.fillRoundRect(1, 1, n - 2, n2 - 2, 5, 5);
        graphics.translate(-rectangle.x, -rectangle.y);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

