/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.ClassLoaderBridge;
import com.mathworks.util.Log;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;

public class TSToolSet {
    public static final String DISPOSABLE_PROPERTY_KEY = "disposable";
    private final TSToolSetContents fContents;
    private final Map<String, Action> fActionMap = new HashMap<String, Action>();
    private final Map<String, ToolSupplier> fSupplierMap = new HashMap<String, ToolSupplier>();
    private final ListMultimap<String, ToolDecorator> fDecoratorMap = ArrayListMultimap.create();
    private final Map<String, ListDecorator> fListDecoratorMap = new HashMap<String, ListDecorator>();
    private final Map<String, Listener> fToolSpecificListenerMap = new HashMap<String, Listener>();
    private final List<Listener> fListeners = new ArrayList<Listener>();

    public TSToolSet(TSToolSetContents tSToolSetContents) {
        this.fContents = tSToolSetContents;
    }

    public TSToolSet(TSToolSet tSToolSet) {
        this.fContents = tSToolSet.fContents;
        this.fActionMap.putAll(tSToolSet.fActionMap);
        this.fSupplierMap.putAll(tSToolSet.fSupplierMap);
    }

    public String getName() {
        return this.fContents.getName();
    }

    public TSToolSetContents getContents() {
        return this.fContents;
    }

    public void addAction(String string, Action action) {
        this.fActionMap.put(string, action);
        Listener listener = this.fToolSpecificListenerMap.get(string);
        if (listener != null) {
            listener.actionAdded(this, string);
        }
        for (Listener listener2 : this.fListeners) {
            listener2.actionAdded(this, string);
        }
    }

    public void configureAndAdd(String string, Action action) {
        this.fContents.configure(string, action);
        this.addAction(string, action);
    }

    public void removeAction(String string) {
        this.fActionMap.remove(string);
        Listener listener = this.fToolSpecificListenerMap.get(string);
        if (listener != null) {
            listener.actionRemoved(this, string);
        }
        for (Listener listener2 : this.fListeners) {
            listener2.actionRemoved(this, string);
        }
    }

    public void addSupplier(String string, ToolSupplier toolSupplier) {
        this.fSupplierMap.put(string, toolSupplier);
    }

    public Set<Map.Entry<String, Action>> getActions() {
        return this.fActionMap.entrySet();
    }

    public Action getAction(String string) {
        TSToolSetContents.Tool tool;
        Object object = this.fActionMap.get(string);
        if (object == null && (tool = this.getContents().getTool(string)) != null && tool.getCode() != null) {
            String string2 = tool.getCode();
            if (tool.getCodeType() == TSToolSetContents.CodeType.JAVA_ACTION) {
                object = this.createActionFromClass(string2, string);
            } else if (tool.getCodeType() == TSToolSetContents.CodeType.JAVA_METHOD) {
                object = new MethodInvokerAction(string2, string);
            }
            if (object != null) {
                tool.configure((Action)object);
                this.addAction(string, (Action)object);
            }
        }
        return object;
    }

    public JComponent getComponent(String string, ToolLocation toolLocation) {
        ToolSupplier toolSupplier = this.fSupplierMap.get(string);
        return toolSupplier == null ? null : toolSupplier.createTool(toolLocation);
    }

    public void addDecorator(String string, ToolDecorator toolDecorator) {
        this.fDecoratorMap.put((Object)string, (Object)toolDecorator);
    }

    List<ToolDecorator> getDecorators(String string) {
        return this.fDecoratorMap.get((Object)string);
    }

    public void addListDecorator(String string, ListDecorator listDecorator) {
        this.fListDecoratorMap.put(string, listDecorator);
    }

    ListDecorator getListDecorator(String string) {
        return this.fListDecoratorMap.get(string);
    }

    public void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void addListener(Listener listener, String string) {
        this.fToolSpecificListenerMap.put(string, listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public void removeListener(String string) {
        this.fToolSpecificListenerMap.remove(string);
    }

    private Action createActionFromClass(String string, String string2) {
        Action action = null;
        try {
            action = (Action)ClassLoaderBridge.findClass((String)string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.log((String)("Unable to find class " + string + this.toolString(string2) + "\n"));
        }
        catch (InstantiationException instantiationException) {
            Log.log((String)("Unable to instantiate " + string + this.toolString(string2) + "\n"));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.log((String)("Unable to access " + string + this.toolString(string2) + "\n"));
        }
        catch (ClassCastException classCastException) {
            Log.log((String)("The class provided for " + string2 + ", " + string + " is not an Action instance\n"));
        }
        return action;
    }

    private String toolString(String string) {
        return " for " + string + " in " + this.getName();
    }

    private class MethodInvokerAction
    extends MJAbstractAction {
        private final String iQualifiedMethodName;
        private final String iToolName;

        private MethodInvokerAction(String string, String string2) {
            this.iQualifiedMethodName = string;
            this.iToolName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.iQualifiedMethodName.lastIndexOf(46);
            if (n < 0 || n >= this.iQualifiedMethodName.length() - 1) {
                Log.log((String)("Unqualified or invalid method name " + this.iQualifiedMethodName + TSToolSet.this.toolString(this.iToolName) + "\n"));
            } else {
                String string = this.iQualifiedMethodName.substring(0, n);
                String string2 = this.iQualifiedMethodName.substring(n + 1);
                try {
                    Class clazz = ClassLoaderBridge.findClass((String)string);
                    Method method = clazz.getMethod(string2, new Class[0]);
                    int n2 = method.getModifiers();
                    if (!Modifier.isPublic(n2)) {
                        Log.log((String)("Method " + this.iQualifiedMethodName + TSToolSet.this.toolString(this.iToolName) + " is not public\n"));
                    } else if (!Modifier.isStatic(n2)) {
                        Log.log((String)("Method " + this.iQualifiedMethodName + TSToolSet.this.toolString(this.iToolName) + " is not static\n"));
                    } else {
                        method.invoke(null, new Object[0]);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.log((String)("Unable to find class " + string + TSToolSet.this.toolString(this.iToolName) + "\n"));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Log.log((String)("Unable to find method " + this.iQualifiedMethodName + TSToolSet.this.toolString(this.iToolName) + "\n"));
                }
                catch (Exception exception) {
                    Log.log((String)("An error occurred when attempting to invoke " + this.iQualifiedMethodName + TSToolSet.this.toolString(this.iToolName) + "\n"));
                }
            }
        }
    }

    public static interface Listener {
        public void actionRemoved(TSToolSet var1, String var2);

        public void actionAdded(TSToolSet var1, String var2);
    }

    public static interface ListDecorator {
        public void decorateList(PopupList var1);
    }

    public static interface ToolDecorator {
        public void decorateTool(JComponent var1, ToolLocation var2);
    }

    public static interface ToolSupplier {
        public JComponent createTool(ToolLocation var1);
    }

    public static enum ToolLocation {
        TOOLSTRIP_TAB,
        QUICK_ACCESS_BAR;

    }
}

