/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.toolstrip.accessories.CalloutToolTipManager;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.DisappearingButton;
import com.mathworks.toolstrip.components.gallery.popupview.FavoriteButton;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

final class ItemPanel
implements CalloutToolTipManager.Client {
    private final JPanel fComponent;
    private final Item fItem;
    private final Category fCategory;
    private final GalleryModel fModel;
    private final FavoriteButton fFavoriteButton;
    private final GallerySelectionModel fSelectionModel;
    private final ChangeListener fSelectionModelListener;
    private ActionListener fActionListener;
    private ActionListener fCloseListener;
    private final PropertyChangeListener fPropertyListener;
    private JLabel fMainLabel;
    private JLabel fDescriptionLabel;
    private boolean fIsEnabled;

    ItemPanel(GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, final Category category, final Item item, Runnable runnable) {
        this.fItem = item;
        this.fCategory = category;
        this.fModel = galleryModel;
        this.fSelectionModel = gallerySelectionModel;
        this.fComponent = new MJPanel();
        this.fComponent.setName("Item_" + this.fItem.getName());
        IconLabel iconLabel = new IconLabel();
        iconLabel.setName("ItemIcon_" + this.fItem.getName());
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        this.fMainLabel = new MJLabel();
        this.fMainLabel.setForeground(toolstripTheme.getGalleryTitleColor());
        this.fMainLabel.setFont(toolstripTheme.getGalleryTitleFont());
        this.fDescriptionLabel = new MJLabel(item.getDescription());
        this.fDescriptionLabel.setForeground(toolstripTheme.getGalleryDescriptionColor());
        this.fDescriptionLabel.setFont(toolstripTheme.getGalleryDescriptionFont());
        this.fDescriptionLabel.putClientProperty("item", this.fItem);
        this.fIsEnabled = !item.isEnabled();
        this.handleItemPropertyUpdate();
        this.fFavoriteButton = new FavoriteButton(item, galleryModel, runnable);
        this.fFavoriteButton.setEnabled(galleryModel.isFavorite(item));
        DisappearingButton disappearingButton = null;
        if (item.getAuxiliaryAction() != null) {
            disappearingButton = new DisappearingButton(item.getAuxiliaryAction());
            ((AbstractButton)((Object)disappearingButton)).setMargin(new Insets(1, 1, 1, 1));
        }
        this.fComponent.setLayout((LayoutManager)new FormLayout("8dlu, fill:d, 8dlu, fill:d, 4dlu:grow, fill:d, fill:d, fill:d, 8dlu", "4px, 8px, fill:d, fill:d, 8px, 4px"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)iconLabel, cellConstraints.xywh(2, 2, 1, 4));
        this.fComponent.add((Component)this.fMainLabel, cellConstraints.xy(4, 3, CellConstraints.LEFT, CellConstraints.CENTER));
        this.fComponent.add((Component)this.fDescriptionLabel, cellConstraints.xyw(4, 4, 3, CellConstraints.LEFT, CellConstraints.CENTER));
        if (disappearingButton != null) {
            this.fComponent.add((Component)((Object)disappearingButton), cellConstraints.xywh(7, 3, 1, 2, CellConstraints.CENTER, CellConstraints.CENTER));
        }
        this.fComponent.add((Component)((Object)this.fFavoriteButton), cellConstraints.xywh(8, 3, 1, 2, CellConstraints.CENTER, CellConstraints.CENTER));
        this.fComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(213, 213, 213)));
        this.fComponent.putClientProperty("item", this.fItem);
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.fComponent.addMouseMotionListener(localMouseListener);
        this.fComponent.addMouseListener(localMouseListener);
        this.fPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ItemPanel.this.handleItemPropertyUpdate();
            }
        };
        item.getAction().addPropertyChangeListener(this.fPropertyListener);
        this.fSelectionModelListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ItemPanel.this.setSelected(ItemPanel.this.fSelectionModel.isSelected(category, item));
            }
        };
        this.fSelectionModel.addChangeListener(this.fSelectionModelListener);
        this.setSelected(false);
        CalloutToolTipManager.getInstance().register(this);
    }

    private void handleItemPropertyUpdate() {
        this.fMainLabel.setText(this.fItem.getExtendedLabel() != null ? this.fItem.getExtendedLabel() : this.fItem.getLabel());
        if (this.fIsEnabled != this.fItem.isEnabled()) {
            ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
            if (this.fItem.isEnabled()) {
                this.fMainLabel.setForeground(toolstripTheme.getGalleryTitleColor());
                this.fDescriptionLabel.setForeground(toolstripTheme.getGalleryDescriptionColor());
            } else {
                this.fMainLabel.setForeground(toolstripTheme.getGalleryDisabledColor());
                this.fDescriptionLabel.setForeground(toolstripTheme.getGalleryDisabledColor());
            }
        }
    }

    public Item getItem() {
        return this.fItem;
    }

    public void setSelected(boolean bl) {
        this.fFavoriteButton.setEnabled(bl || this.fModel.isFavorite(this.fItem));
        this.fComponent.setBackground(bl ? ToolstripTheme.getInstance().getGallerySelectedBackgroundColor() : ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor());
    }

    void setActionListener(ActionListener actionListener) {
        this.fActionListener = actionListener;
    }

    void setCloseListener(ActionListener actionListener) {
        this.fCloseListener = actionListener;
    }

    public void dispose() {
        this.fSelectionModel.removeChangeListener(this.fSelectionModelListener);
        this.fItem.getAction().removePropertyChangeListener(this.fPropertyListener);
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public ToolTipContentProvider getToolTipContentProvider() {
        return (ToolTipContentProvider)this.fItem.getAction().getValue("tool-tip-content-provider");
    }

    private class IconLabel
    extends JComponent {
        private IconLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Icon icon = ItemPanel.this.fItem.getIcon();
            if (icon instanceof ResizableIcon) {
                ((ResizableIcon)icon).setToPreferredSize();
            }
            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Icon icon = ItemPanel.this.fItem.getIcon();
            if (icon instanceof ResizableIcon) {
                ((ResizableIcon)icon).setToPreferredSize();
            }
            if (!ItemPanel.this.fItem.isEnabled()) {
                icon = LAFUtil.getDisabledIcon(this, icon);
            }
            super.paintComponent(graphics);
            icon.paintIcon(this, graphics, 0, (this.getHeight() - icon.getIconHeight()) / 2);
        }
    }

    private class LocalMouseListener
    extends MouseInputAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && ItemPanel.this.fItem.isEnabled()) {
                if (mouseEvent.getClickCount() == 1) {
                    ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 1001, null);
                    ItemPanel.this.fItem.getAction().actionPerformed(actionEvent);
                    if (ItemPanel.this.fActionListener != null) {
                        ItemPanel.this.fActionListener.actionPerformed(actionEvent);
                    }
                    TSUtil.toolstripActionProcessed(ItemPanel.this.getComponent());
                } else if (mouseEvent.getClickCount() == 2 && ItemPanel.this.fCloseListener != null) {
                    ItemPanel.this.fCloseListener.actionPerformed(null);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ItemPanel.this.fSelectionModel.deselect();
            if (ItemPanel.this.fItem.isEnabled()) {
                ItemPanel.this.fSelectionModel.setSelectedItem(ItemPanel.this.fCategory, ItemPanel.this.fItem, true);
            }
        }
    }
}

