/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.accessories;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryPanel;
import com.mathworks.toolstrip.components.gallery.popupview.GalleryPopupView;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWrapper;
import com.mathworks.toolstrip.plaf.IconifiedSectionButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;

public class TSRobot {
    private final Toolstrip fToolstrip;
    private Rectangle fLastBounds;

    public TSRobot(Toolstrip toolstrip) {
        this.fToolstrip = toolstrip;
    }

    public boolean isVisible(String[] stringArray) {
        return this.getComponent(stringArray, false, false) != null;
    }

    public Target get(String[] stringArray) {
        JComponent jComponent = this.getComponent(stringArray, false, true);
        return jComponent == null ? null : new Target(jComponent, this.fLastBounds);
    }

    public Target getPreceedingTrigger(String[] stringArray) {
        JComponent jComponent = this.getComponent(stringArray, true, true);
        return jComponent == null ? null : new Target(jComponent, this.fLastBounds);
    }

    public boolean ensureVisible(String[] stringArray) {
        return this.getComponent(stringArray, false, true) != null;
    }

    public void closePopups() {
        OverlayManager overlayManager = OverlayManagers.get((Component)this.fToolstrip.getComponent());
        if (overlayManager != null) {
            overlayManager.removePopups();
        }
    }

    public boolean isToolstripExpanded() {
        return this.fToolstrip.getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.EXPANDED;
    }

    public void setToolstripExpanded(boolean bl) {
        this.fToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)(bl ? Toolstrip.State.EXPANDED : Toolstrip.State.COLLAPSED));
    }

    private void expandAsPopup() {
        this.fToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED_AS_POPUP);
    }

    public static Toolstrip getToolstripFor(Component component) {
        Window window = WindowUtils.getTopmostWindow((Component)component);
        if (window instanceof RootPaneContainer) {
            return (Toolstrip)((RootPaneContainer)((Object)window)).getRootPane().getClientProperty("toolstrip");
        }
        return null;
    }

    public static QuickAccessToolBar getQuickAccessToolBar(Toolstrip toolstrip) {
        return (QuickAccessToolBar)toolstrip.getAttribute(QuickAccessToolBar.QUICK_ACCESS_TOOLBAR_ATTRIBUTE);
    }

    public static QuickAccessToolBar getQuickAccessToolBarAncestor(Component component) {
        while (component != null) {
            QuickAccessToolBar quickAccessToolBar;
            if (component instanceof JToolBar && (quickAccessToolBar = (QuickAccessToolBar)((JComponent)component).getClientProperty("QuickAccessToolBar")) != null) {
                return quickAccessToolBar;
            }
            component = component.getParent();
        }
        return null;
    }

    private JComponent getComponent(String[] stringArray, boolean bl, boolean bl2) {
        this.fLastBounds = null;
        if (stringArray.length == 0) {
            return null;
        }
        ToolstripTab toolstripTab = (ToolstripTab)this.fToolstrip.getModel().get(stringArray[0]);
        if (toolstripTab == null) {
            return null;
        }
        if (stringArray.length == 1 && bl) {
            JComponent jComponent = TSRobot.findChildByName(this.fToolstrip.getComponent(), "toolstrip.header");
            int n = this.fToolstrip.getModel().indexOf((Client)toolstripTab);
            return n == -1 ? null : (JComponent)jComponent.getComponent(n);
        }
        if (!this.isToolstripExpanded() || !stringArray[0].equals(this.fToolstrip.getCurrentTab())) {
            if (!bl2) {
                return null;
            }
            this.fToolstrip.setCurrentTab(stringArray[0]);
            if (!this.isToolstripExpanded()) {
                this.expandAsPopup();
            }
            this.fToolstrip.getComponent().invalidate();
            this.fToolstrip.getComponent().validate();
            this.fToolstrip.getComponent().repaint();
        }
        JComponent jComponent = toolstripTab.getComponent();
        if (stringArray.length == 1) {
            return jComponent;
        }
        ToolstripSection toolstripSection = (ToolstripSection)toolstripTab.getModel().get(stringArray[1]);
        if (toolstripSection == null) {
            return null;
        }
        int n = toolstripTab.getModel().indexOf((Client)toolstripSection);
        ToolstripSectionComponentWrapper toolstripSectionComponentWrapper = (ToolstripSectionComponentWrapper)jComponent.getComponent(n);
        JComponent jComponent2 = toolstripSectionComponentWrapper.getSectionComponent();
        boolean bl3 = jComponent2 instanceof IconifiedSectionButton;
        if (bl && (stringArray.length == 2 || stringArray.length == 3)) {
            return bl3 ? jComponent2 : null;
        }
        if (bl3) {
            if (!bl2) {
                return null;
            }
            ((AbstractButton)jComponent2).getModel().setPressed(true);
        }
        jComponent2 = toolstripSection.getComponent();
        if (stringArray.length == 2) {
            return (JComponent)jComponent2.getParent();
        }
        JComponent jComponent3 = TSRobot.findJComponentByName(jComponent2, stringArray[2]);
        if (stringArray.length == 3) {
            return jComponent3;
        }
        if (jComponent3 instanceof TSDropDownButton) {
            if (bl) {
                return jComponent3;
            }
            JComponent jComponent4 = (JComponent)jComponent3.getClientProperty("PopupComponent");
            if (jComponent4 == null) {
                if (!bl2) {
                    return null;
                }
                ((AbstractButton)jComponent3).getModel().setPressed(true);
            }
            if (!((jComponent4 = (JComponent)jComponent3.getClientProperty("PopupComponent")) instanceof PopupList)) {
                return null;
            }
            PopupList popupList = (PopupList)jComponent4;
            int n2 = TSRobot.findListIndexByName(popupList, stringArray[3]);
            if (n2 == -1) {
                return null;
            }
            if (stringArray.length == 4) {
                this.fLastBounds = popupList.getCellBounds(n2, n2);
                return popupList;
            }
            ListItem listItem = (ListItem)popupList.getModel().getElementAt(n2);
            if (listItem.isHeader()) {
                n2 = TSRobot.findListIndexByName(popupList, stringArray[4]);
                if (n2 == -1) {
                    return null;
                }
                if (stringArray.length == 5) {
                    this.fLastBounds = popupList.getCellBounds(n2, n2);
                    return popupList;
                }
            }
            return null;
        }
        if (jComponent3 instanceof GalleryView) {
            GalleryView galleryView = (GalleryView)((Object)jComponent3);
            JButton jButton = galleryView.getMoreButton();
            if (bl) {
                return jButton;
            }
            String string = stringArray[stringArray.length - 1];
            JComponent jComponent5 = TSRobot.findJComponentByName((Container)((Object)galleryView), string);
            if (jComponent5 != null && jComponent5.getWidth() > 0 || jButton == null) {
                return jComponent5;
            }
            GalleryPopupView galleryPopupView = galleryView.getPopupView();
            if (galleryPopupView == null) {
                if (!bl2) {
                    return null;
                }
                jButton.doClick();
            }
            if ((galleryPopupView = galleryView.getPopupView()) == null) {
                return null;
            }
            CategoryPanel categoryPanel = galleryPopupView.getCategoryPanel(stringArray[3]);
            if (categoryPanel == null) {
                return null;
            }
            if (stringArray.length == 4) {
                return categoryPanel.getComponent();
            }
            JComponent jComponent6 = categoryPanel.getContentPanel();
            jComponent5 = TSRobot.findChildByName(jComponent6, stringArray[4]);
            if (jComponent5 != null) {
                return jComponent5;
            }
            jComponent5 = TSRobot.findChildByName(jComponent6, "Item_" + stringArray[4]);
            if (jComponent5 != null) {
                return jComponent5;
            }
        }
        return null;
    }

    private static int findListIndexByName(PopupList popupList, String string) {
        ListItem listItem;
        int n;
        ListModel listModel = popupList.getModel();
        for (n = 0; n < listModel.getSize() && !string.equals((listItem = (ListItem)listModel.getElementAt(n)).getName()); ++n) {
        }
        return n < listModel.getSize() ? n : -1;
    }

    private static JComponent findChildByName(Container container, String string) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!string.equals(component.getName()) || !(component instanceof JComponent)) continue;
            return (JComponent)component;
        }
        return null;
    }

    private static JComponent findJComponentByName(Container container, String string) {
        Component component = TSRobot.findDescendantByName(container, string);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    private static Component findDescendantByName(Container container, String string) {
        if (string.equals(container.getName())) {
            return container;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (string.equals(component2.getName())) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = TSRobot.findDescendantByName((Container)component2, string)) == null) continue;
            return component;
        }
        return null;
    }

    public static class Target {
        private final JComponent fComponent;
        private final Rectangle fBounds;
        private final Point fHotSpot;

        private Target(JComponent jComponent, Rectangle rectangle) {
            this(jComponent, rectangle, (Point)null);
        }

        private Target(JComponent jComponent, Rectangle rectangle, Point point) {
            this.fComponent = jComponent;
            this.fBounds = rectangle;
            this.fHotSpot = point;
        }

        public JComponent getComponent() {
            return this.fComponent;
        }

        public Rectangle getBounds() {
            return this.fBounds != null ? this.fBounds : new Rectangle(0, 0, this.fComponent.getWidth(), this.fComponent.getHeight());
        }

        public Point getHotSpot() {
            if (this.fHotSpot != null) {
                return this.fHotSpot;
            }
            Rectangle rectangle = this.getBounds();
            return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
    }
}

