/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.xml;

import com.mathworks.widgets.text.MWTokenColoringInitializer;
import com.mathworks.widgets.text.xml.XMLSyntaxHighlighting;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;

public class MWXMLSettingsInitializer
extends Settings.AbstractInitializer {
    private final Class<?> fXmlKitClass;
    public static final String NAME = "xml-settings-initializer";

    public MWXMLSettingsInitializer(Class<?> clazz) {
        super(NAME);
        this.fXmlKitClass = clazz;
    }

    public void updateSettingsMap(Class clazz, Map map) {
        if (clazz == this.fXmlKitClass) {
            new XMLTokenColoringInitializer().updateSettingsMap(clazz, map);
            map.put("abbrev-map", MWXMLSettingsInitializer.getXMLAbbrevMap());
            SettingsUtil.updateListSetting((Map)map, (String)"token-context-list", (Object[])new TokenContext[]{XMLDefaultTokenContext.context});
            map.put("identifier-acceptor", MWXMLSettingsInitializer.getXMLIdentifierAcceptor());
            map.put("abbrev-reset-acceptor", MWXMLSettingsInitializer.getXMLAbbreviationAcceptor());
        }
    }

    static Map<String, String> getXMLAbbrevMap() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("?xm", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        treeMap.put("!do", "<!DOCTYPE ");
        treeMap.put("!cd", "<![CDATA[|]]>");
        treeMap.put("!at", "<!ATTLIST |>");
        treeMap.put("!el", "<!ELEMENT |>");
        treeMap.put("!en", "<!ENTITY |>");
        treeMap.put("pu", "PUBLIC \"|\"");
        treeMap.put("sy", "SYSTEM \"|\"");
        return treeMap;
    }

    static Acceptor getXMLIdentifierAcceptor() {
        return new Acceptor(){

            public boolean accept(char c) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '/': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    static Acceptor getXMLAbbreviationAcceptor() {
        return new Acceptor(){

            public boolean accept(char c) {
                return AcceptorFactory.NON_JAVA_IDENTIFIER.accept(c) && c != '!' && c != '?';
            }
        };
    }

    private static class XMLTokenColoringInitializer
    extends MWTokenColoringInitializer {
        XMLTokenColoringInitializer() {
            super(XMLSyntaxHighlighting.INSTANCE);
        }

        @Override
        public Coloring doGetTokenColoring(TokenCategory tokenCategory) {
            switch (tokenCategory.getNumericID()) {
                case 1: {
                    return SettingsDefaults.emptyColoring;
                }
                case 2: {
                    return SettingsDefaults.emptyColoring;
                }
                case 3: {
                    return new Coloring(null, XMLSyntaxHighlighting.ERROR.getCurrentColor(), null);
                }
                case 4: {
                    return new Coloring(null, XMLSyntaxHighlighting.TAG.getCurrentColor(), null);
                }
                case 5: {
                    return new Coloring(null, XMLSyntaxHighlighting.ARGUMENT.getCurrentColor(), null);
                }
                case 6: {
                    return new Coloring(null, XMLSyntaxHighlighting.OPERATOR.getCurrentColor(), null);
                }
                case 7: {
                    return new Coloring(null, XMLSyntaxHighlighting.VALUE.getCurrentColor(), null);
                }
                case 8: {
                    return new Coloring(null, XMLSyntaxHighlighting.BLOCK_COMMENT.getCurrentColor(), null);
                }
                case 10: {
                    return new Coloring(null, XMLSyntaxHighlighting.DECLARATION.getCurrentColor(), null);
                }
                case 11: {
                    return new Coloring(null, XMLSyntaxHighlighting.CHARACTER.getCurrentColor(), null);
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return new Coloring(null, XMLSyntaxHighlighting.PROCESSING_INSTRUCTION.getCurrentColor(), null);
                }
                case 17: {
                    return new Coloring(null, XMLSyntaxHighlighting.CDATA.getCurrentColor(), null);
                }
            }
            return SettingsDefaults.emptyColoring;
        }
    }
}

