/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.HTMLUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightActions;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightingLayer;
import com.mathworks.widgets.text.mcode.variables.VariableRenameUtils;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class VariableHighlightUtils {
    private static final String ELLIPSIS = "...";
    private static int sToolTipColumnLimit = 75;
    private static final List<String> INVALID_KEYWORD_LIST = new ArrayList<String>();
    private static final ResourceBundle BUNDLE;

    private VariableHighlightUtils() {
    }

    public static boolean isAKeyword(String string) {
        return INVALID_KEYWORD_LIST.contains(string.toLowerCase(Locale.ENGLISH));
    }

    public static MTree.Node getVariableUnderCaret(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent, (String)"The text pane should not be null");
        int n = jTextComponent.getCaretPosition();
        return VariableHighlightUtils.getVariableAtPosition(jTextComponent, n);
    }

    public static boolean isActiveEditor(STPBaseInterface sTPBaseInterface) {
        if (sTPBaseInterface == null) {
            return false;
        }
        JTextComponent jTextComponent = SyntaxTextPaneUtilities.getLastActiveComponent();
        if (jTextComponent != null) {
            return jTextComponent == sTPBaseInterface;
        }
        return true;
    }

    public static MTree.Node getVariableAtPosition(JTextComponent jTextComponent, int n) {
        Validate.notNull((Object)jTextComponent, (String)"The text pane should not be null");
        MTree mTree = VariableHighlightUtils.getMTree(jTextComponent);
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        List<String> list = MDocumentUtils.getFunctionNames((BaseDocument)jTextComponent.getDocument());
        MTree.Node node = VariableHighlightUtils.getVariableAtPosition(mTree, n, baseDocument, list, jTextComponent);
        if (node == null) {
            node = VariableHighlightUtils.getVariableAtPosition(mTree, n - 1, baseDocument, list, jTextComponent);
        }
        return node;
    }

    private static MTree.Node getVariableAtPosition(MTree mTree, int n, BaseDocument baseDocument, List<String> list, JTextComponent jTextComponent) {
        boolean bl;
        MTree.Node node = MTreeUtils.getNodeAtPosition(mTree, n, baseDocument, false);
        if (node == null || !VariableHighlightUtils.isVarOrSubfun(node, list) || MTreeUtils.getMaximumPosition(node, baseDocument) < 0) {
            return null;
        }
        int n2 = jTextComponent.getSelectionStart();
        int n3 = jTextComponent.getSelectionEnd();
        int n4 = MTreeUtils.getPosition(node, baseDocument);
        int n5 = MTreeUtils.getMaximumPosition(node, baseDocument);
        boolean bl2 = n2 != n3;
        boolean bl3 = bl = n2 >= n4 && n3 <= n5;
        if (bl2 && !bl) {
            return null;
        }
        return node;
    }

    private static boolean isVarOrSubfun(MTree.Node node, List<String> list) {
        MTree.Attribute attribute = node.getAttribute();
        return attribute.equals((Object)MTree.Attribute.VARIABLE) || attribute.equals((Object)MTree.Attribute.FUNCTION) && list.contains(node.getText());
    }

    private static MTree getMTree(JTextComponent jTextComponent) {
        MJUtilities.assertIsEventThread();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        return MDocumentUtils.getMTree(baseDocument);
    }

    public static List<Integer> getPositionsForCurrentVariable(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent);
        MTree.Node node = VariableHighlightUtils.getVariableUnderCaret(jTextComponent);
        return VariableHighlightUtils.getPositionsForMatchingID(jTextComponent, node);
    }

    public static boolean wasNavigationKeyPressed(JComponent jComponent) {
        Boolean bl = (Boolean)jComponent.getClientProperty("layeractions.gotomessage");
        jComponent.putClientProperty("layeractions.gotomessage", false);
        return bl != null && bl != false;
    }

    static List<Integer> getPositionsForMatchingID(JTextComponent jTextComponent, MTree.Node node) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (node != null) {
            Collection<MTree.Node> collection = MTreeUtils.getOtherNodesAndPositionsWithSameSymbolIndex(VariableHighlightUtils.getMTree(jTextComponent), node).values();
            for (MTree.Node node2 : collection) {
                arrayList.add(MTreeUtils.getPosition(node2, (BaseDocument)jTextComponent.getDocument()));
            }
        }
        return arrayList;
    }

    static Map<Integer, MTree.Node> getNodesAndPositionsForMatchingID(JTextComponent jTextComponent, MTree.Node node) {
        assert (node != null);
        assert (node.getType() == MTree.NodeType.ID);
        return MTreeUtils.getOtherNodesAndPositionsWithSameSymbolIndex(VariableHighlightUtils.getMTree(jTextComponent), node);
    }

    static Map<Position, String> getIDNodeNamesAndPositionsNotID(JTextComponent jTextComponent, MTree.Node node) {
        assert (node != null);
        assert (node.getType() == MTree.NodeType.ID);
        List<MTree.Node> list = MTreeUtils.getOtherIDNodesWithDifferentSymbolIndex(VariableHighlightUtils.getMTree(jTextComponent), node);
        HashMap<Position, String> hashMap = new HashMap<Position, String>();
        for (MTree.Node node2 : list) {
            int n = MTreeUtils.getPosition(node2, (BaseDocument)jTextComponent.getDocument());
            try {
                Position position = jTextComponent.getDocument().createPosition(n);
                hashMap.put(position, node2.getText());
            }
            catch (BadLocationException badLocationException) {}
        }
        return hashMap;
    }

    public static VariableHighlightingLayer getVariableHighlightLayer(JTextComponent jTextComponent) {
        Validate.isTrue((boolean)(Utilities.getEditorUI((JTextComponent)jTextComponent) instanceof MWEditorUI), (String)"text component must have a MWEditorUI");
        return (VariableHighlightingLayer)((MWEditorUI)Utilities.getEditorUI((JTextComponent)jTextComponent)).getLayer("Variable Highlighting Layer");
    }

    public static String createRenameNowToolTipMessage(String string, String string2, int n) {
        String string3 = VariableRenameUtils.getAdjustedNewVarName(string, string2);
        return MessageFormat.format(VariableHighlightUtils.getBundle().getString("highlight.quickRename"), VariableHighlightActions.getRenameKeyStroke(), n, string2, string3);
    }

    public static String highlightAndTrimLine(int n, int n2, STPBaseInterface sTPBaseInterface, Color color) {
        try {
            int n3 = sTPBaseInterface.getLineFromPos(n);
            StringBuilder stringBuilder = new StringBuilder(sTPBaseInterface.getLineText(n3).trim());
            int n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)sTPBaseInterface.getDocument()), (int)sTPBaseInterface.getLineStart(n3));
            int n5 = n - n4;
            int n6 = VariableHighlightUtils.truncateIfTooLong(n2, n5, stringBuilder);
            String string = "<span style=\"font-weight:bold; background-color:" + HTMLUtils.convertColorToHex((Color)color) + ";\">" + stringBuilder.substring(n6, n6 + n2) + "</span>";
            String string2 = stringBuilder.substring(0, n6);
            String string3 = stringBuilder.substring(n6 + n2);
            String string4 = StringEscapeUtils.escapeHtml((String)string2) + string + StringEscapeUtils.escapeHtml((String)string3);
            String string5 = "<tt>" + string4.trim() + "</tt>";
            return string5;
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return null;
        }
    }

    static boolean variableExists(STPBaseInterface sTPBaseInterface, int n, String string) {
        if (n == -1 || sTPBaseInterface.getDocument().getLength() < n + string.length()) {
            return false;
        }
        try {
            return sTPBaseInterface.getDocument().getText(n, string.length()).equals(string);
        }
        catch (BadLocationException badLocationException) {
            assert (false) : badLocationException;
            return false;
        }
    }

    private static int truncateIfTooLong(int n, int n2, StringBuilder stringBuilder) {
        int n3 = stringBuilder.length();
        if (n3 > sToolTipColumnLimit) {
            int n4 = sToolTipColumnLimit - n;
            int n5 = (int)Math.floor((double)n4 / 2.0);
            int n6 = n2 + n;
            int n7 = n2;
            int n8 = n3 - n6;
            int n9 = n5;
            if (n7 < n8 && n7 < n5) {
                n9 += n5 - n7;
            }
            if (n6 + n9 < n3) {
                stringBuilder.replace(n6 + n9, n3, ELLIPSIS);
            }
            int n10 = n5;
            if (n8 < n7 && n8 < n5) {
                n10 += n5 - n8;
            }
            if (n2 > n10) {
                int n11 = n2 - n10;
                stringBuilder.replace(0, n11, ELLIPSIS);
                n2 = n2 - n11 + ELLIPSIS.length();
            }
        }
        return n2;
    }

    public static void setTooltipLength(int n) {
        sToolTipColumnLimit = n;
    }

    public static int getTooltipLength() {
        return sToolTipColumnLimit;
    }

    public static ResourceBundle getBundle() {
        return BUNDLE;
    }

    static {
        INVALID_KEYWORD_LIST.add("varargin");
        INVALID_KEYWORD_LIST.add("varargout");
        BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.variables.resources.RES_variables");
    }
}

