/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;

public class MLintPrefsUtils {
    private static final String MLINT_CONFIGURATION_PREF = "mlint-configuration-file";
    private static final String MLINT_CONFIGURATIONS_LIST_PREF = "mlint-configurations-list";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.resources.RES_mcode");
    public static final String DEFAULT_SETTINGS = sRes.getString("mlint.defaultSettings");
    public static final String DEFAULT_SETTINGS_MODIFIED = sRes.getString("mlint.defaultSettings.modified");
    public static final File DEFAULT_SETTINGS_FILE = new File(Prefs.getPropertyDirectory(), "MLintDefaultSettings.txt");
    private static File sTestDefaultSettingsFile;
    public static final String DEPLOYMENT_CATEGORY = "MCC";
    private static final String INTERNAL_CATEGORY = "INTER";
    private static final String INFORMATION_AND_METRICS_CATEGORY = "MINFO";
    public static final boolean DEPLOYMENT_ENABLED_DEFAULT = false;
    private static MLintConfiguration sActiveConfiguration;
    private static final List<ChangeListener> sConfigListeners;

    public static synchronized MLintConfiguration getActiveConfiguration() {
        if (sActiveConfiguration == null) {
            if (MLintPrefsUtils.isDefaultConfiguration()) {
                sActiveConfiguration = MLintPrefsUtils.readDefaultConfiguration();
            } else {
                try {
                    sActiveConfiguration = MLintConfiguration.read(MLintPrefsUtils.getConfigurationFile(), true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MLintPrefsUtils.useDefaultConfiguration();
                    sActiveConfiguration = MLintPrefsUtils.readDefaultConfiguration();
                }
                catch (Exception exception) {
                    MLintPrefsUtils.useDefaultConfiguration();
                    sActiveConfiguration = MLintPrefsUtils.readDefaultConfiguration();
                    Log.logException((Exception)exception);
                }
            }
        }
        assert (sActiveConfiguration != null);
        return sActiveConfiguration;
    }

    private static MLintConfiguration readDefaultConfiguration() {
        MLintConfiguration mLintConfiguration;
        try {
            MLintPrefsUtils.ensureDefaultSettingsFileExists();
            mLintConfiguration = MLintConfiguration.read(MLintPrefsUtils.getDefaultConfigurationFile(), true);
        }
        catch (Throwable throwable) {
            mLintConfiguration = MLintConfiguration.createEmpty(MLintPrefsUtils.getDefaultConfigurationFile());
        }
        return mLintConfiguration;
    }

    public static void addConfigurationListener(ChangeListener changeListener) {
        sConfigListeners.add(changeListener);
    }

    public static void removeConfigurationListener(ChangeListener changeListener) {
        sConfigListeners.remove(changeListener);
    }

    public static int getConfigurationListenerCount() {
        return sConfigListeners.size();
    }

    public static void useConfiguration(File file) {
        MLintPrefsUtils.setPreference(file.getAbsolutePath());
    }

    public static synchronized void setConfiguration(MLintConfiguration mLintConfiguration) {
        if (mLintConfiguration == null) {
            throw new IllegalArgumentException("'config' cannot be null");
        }
        sActiveConfiguration = mLintConfiguration;
        MLintPrefsUtils.setPreference(mLintConfiguration.getFile() == null ? "" : mLintConfiguration.getFile().getAbsolutePath());
    }

    public static String getConfigurationFileListPrefKey() {
        return MLINT_CONFIGURATIONS_LIST_PREF;
    }

    public static void useDefaultConfiguration() {
        MLintPrefsUtils.ensureDefaultSettingsFileExists();
        MLintPrefsUtils.setPreference(MLintPrefsUtils.getDefaultConfigurationFile().getAbsolutePath());
    }

    public static void ensureDefaultSettingsFileExists() {
        if (!MLintPrefsUtils.getDefaultConfigurationFile().exists()) {
            MLintPrefsUtils.writeDefaultSettings();
        }
    }

    private static void writeDefaultSettings() {
        try {
            MLintConfiguration mLintConfiguration = MLintConfiguration.createEmpty();
            mLintConfiguration.saveTo(MLintPrefsUtils.getDefaultConfigurationFile());
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
    }

    public static boolean isDefaultConfiguration() {
        return MLintPrefsUtils.getConfigurationFile() == null || MLintPrefsUtils.getDefaultConfigurationFile().equals(MLintPrefsUtils.getConfigurationFile());
    }

    private static File getConfigurationFile() {
        String string = Prefs.getStringPref((String)MLINT_CONFIGURATION_PREF);
        return string.length() == 0 ? null : new File(string);
    }

    private static synchronized void setPreference(String string) {
        Prefs.setStringPref((String)MLINT_CONFIGURATION_PREF, (String)string);
        sActiveConfiguration = null;
        MLintPrefsUtils.notifyListeners();
    }

    private static void notifyListeners() {
        for (ChangeListener changeListener : sConfigListeners) {
            changeListener.stateChanged(null);
        }
    }

    private static void setDefaultConfigurationFile(File file) {
        sTestDefaultSettingsFile = file;
        MLintPrefsUtils.useConfiguration(sTestDefaultSettingsFile);
    }

    private static File getDefaultConfigurationFile() {
        return sTestDefaultSettingsFile != null ? sTestDefaultSettingsFile : DEFAULT_SETTINGS_FILE;
    }

    private MLintPrefsUtils() {
    }

    public static boolean isCategoryEnableable(String string) {
        return string.equals(DEPLOYMENT_CATEGORY);
    }

    public static boolean isEnabledByDefault(String string) {
        return !string.equals(DEPLOYMENT_CATEGORY);
    }

    public static boolean isInternalCategory(MLint.Category category) {
        String string = category.getTag();
        return string.equals(INTERNAL_CATEGORY) || string.equals(INFORMATION_AND_METRICS_CATEGORY);
    }

    static {
        sConfigListeners = new ArrayList<ChangeListener>();
    }
}

