/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.util.List;
import org.apache.commons.lang.Validate;

public class MFoldInfoCollector {
    private MFoldInfoCollector() {
    }

    public static int[] findFunctionClassHelpBlock(MTree.Node node) {
        Validate.notNull((Object)node, (String)"function node should not be null.");
        MTree.NodeType nodeType = node.getType();
        Validate.isTrue((nodeType.isClass() || nodeType.isFunction() ? 1 : 0) != 0, (String)"This method should only be used with function and classdef nodes.");
        if (MTreeUtils.isType(node, MTree.NodeType.CLASSDEF, MTree.NodeType.FUNCTION)) {
            return MFoldInfoCollector.getCommentRangeBelow(node);
        }
        return MFoldInfoCollector.getCommentRangeAbove(node);
    }

    private static int[] getCommentRangeBelow(MTree.Node node) {
        int[] nArray = null;
        List<MTree.Node> list = node.getBody().getListOfNextNodes();
        for (MTree.Node node2 : list) {
            if (!node2.getType().isComment()) break;
            int n = node2.getStartLine();
            if (nArray == null && n > MFoldInfoCollector.findEndOfStatement(node)) {
                nArray = new int[]{n, n};
                continue;
            }
            if (nArray == null) continue;
            if (n > nArray[1] + true) break;
            nArray[1] = n;
        }
        return nArray;
    }

    private static int[] getCommentRangeAbove(MTree.Node node) {
        int[] nArray = null;
        MTree.Node node2 = node.getPrevious();
        while (node2.getType().isComment()) {
            int n = node2.getStartLine();
            if (nArray == null && n == node.getStartLine() - 1) {
                nArray = new int[]{n, n};
            } else {
                if (nArray == null || n != nArray[0] - true) break;
                nArray[0] = n;
            }
            node2 = node2.getPrevious();
        }
        return nArray;
    }

    public static boolean hasCatchNode(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.TRY);
        MTree.Node node2 = MFoldInfoCollector.getCatchNode(node);
        return node2 != null && node2.getType() == MTree.NodeType.CATCH;
    }

    static MTree.Node getCatchNode(MTree.Node node) {
        return node.getRight();
    }

    static int findEndOfStatement(MTree.Node node) {
        return Math.max(node.getStartLine(), node.getLeft().getRightmostNode().getStartLine());
    }
}

