/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.SmartFormatter;
import com.mathworks.widgets.text.matlab.AbstractStripEndWhitespaceLayer;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import com.mathworks.widgets.text.matlab.MatlabIndentingLayer;
import com.mathworks.widgets.text.matlab.MatlabSyntax;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;

public abstract class MatlabFormatter
extends ExtFormatter
implements SmartFormatter {
    private MatlabFunctionIndentingScheme fFunctionIndentingType;
    private IndentingStyle fFormattingType;

    protected MatlabFormatter(Class<?> clazz) {
        super(clazz);
    }

    protected final boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof MatlabSyntax;
    }

    protected abstract String getIndentingLayerName();

    protected abstract MatlabIndentingLayer createIndentingLayer();

    protected abstract AbstractStripEndWhitespaceLayer createStripEndWhitespaceLayer();

    public final MatlabFunctionIndentingScheme getFunctionIndentingType() {
        return this.fFunctionIndentingType;
    }

    @Override
    public final IndentingStyle getFormattingType() {
        return this.fFormattingType;
    }

    public final void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        String string;
        String string2;
        super.settingsChange(settingsChangeEvent);
        String string3 = string2 = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string2 != null && string2.equals("indenting-type") && settingsChangeEvent.getKitClass().isAssignableFrom(this.getKitClass()) && (string = (String)settingsChangeEvent.getNewValue()) != null) {
            this.setFormattingType(IndentingStyle.lookup(string));
        }
        if (string2 != null && string2.equals("function-indenting-type")) {
            this.fFunctionIndentingType = MatlabFunctionIndentingScheme.lookup((String)settingsChangeEvent.getNewValue());
        }
    }

    public final boolean isSimple() {
        return this.fFormattingType == IndentingStyle.NONE;
    }

    public final int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        try {
            int[] nArray = null;
            if (IndentingStyle.SMART == this.getFormattingType()) {
                nArray = this.computeReformatBlock(jTextComponent, string);
            }
            return nArray;
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "Internal error: " + badLocationException;
            return null;
        }
    }

    @Override
    public final void setFormattingType(IndentingStyle indentingStyle) {
        this.fFormattingType = indentingStyle;
    }

    protected final void initFormatLayers() {
        this.addFormatLayer((FormatLayer)this.createStripEndWhitespaceLayer());
        String string = SettingsUtil.getString((Class)this.getKitClass(), (String)"indenting-type", null);
        this.fFormattingType = string != null ? IndentingStyle.lookup(string) : IndentingStyle.SMART;
        this.addFormatLayer((FormatLayer)this.createIndentingLayer());
        String string2 = (String)Settings.getValue((Class)this.getKitClass(), (String)"function-indenting-type");
        this.fFunctionIndentingType = string2 == null ? MatlabFunctionIndentingScheme.MIXED : MatlabFunctionIndentingScheme.lookup(string2);
    }

    private int[] computeReformatBlock(JTextComponent jTextComponent, String string) throws BadLocationException {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null) {
            char c;
            int n2 = -1;
            if (string.length() == 1 && (c = string.charAt(0)) == '\n' && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n)) {
                n2 = n + 1;
            }
            if ((nArray = this.checkTokens(n, string, baseDocument)) == null && string.length() == 1) {
                nArray = this.checkPreviousChar(n, string, baseDocument);
            }
            if (nArray == null) {
                nArray = super.getReformatBlock(jTextComponent, string);
            } else {
                nArray[1] = Math.max(nArray[1], n2);
            }
        }
        return nArray;
    }

    private int[] checkTokens(int n, String string, BaseDocument baseDocument) throws BadLocationException {
        int[] nArray = null;
        if (this.isStringAtEndOfToken(string)) {
            int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            String[] stringArray = this.getTokenImagesEndingInString(string);
            int n3 = 0;
            while (nArray == null && n3 < stringArray.length) {
                nArray = MatlabFormatter.checkForToken(n2, n, stringArray[n3++], (Document)baseDocument);
            }
        }
        return nArray;
    }

    private static int[] checkForToken(int n, int n2, String string, Document document) throws BadLocationException {
        int[] nArray = null;
        if (n >= 0 && n + string.length() == n2 && string.equals(document.getText(n, string.length()))) {
            nArray = new int[]{n, n + string.length()};
        }
        return nArray;
    }

    protected abstract boolean isStringAtEndOfToken(String var1);

    protected abstract String[] getTokenImagesEndingInString(String var1);

    private int[] checkPreviousChar(int n, String string, BaseDocument baseDocument) throws BadLocationException {
        int[] nArray = null;
        char c = string.charAt(0);
        if (baseDocument.isWhitespace(c)) {
            while (baseDocument.isWhitespace(c) && n > 1) {
                c = baseDocument.getChars(--n - 1, 1)[0];
            }
            string = String.valueOf(c);
            nArray = this.checkTokens(n, string, baseDocument);
        } else if (n > 0 && !baseDocument.getText(n - 1, 1).equals(string)) {
            string = baseDocument.getText(n - 1, 1);
            nArray = this.checkTokens(n, string, baseDocument);
        } else if (n > 1) {
            string = baseDocument.getText(--n - 1, 1);
            nArray = this.checkTokens(n, string, baseDocument);
        }
        return nArray;
    }
}

