/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.mwswing.table.PresortedTableModel;
import com.mathworks.mwswing.table.RestrictedSortTableModel;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.ICreationObserver;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IDuplicationObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IOpeningObserver;
import com.mathworks.widgets.recordlist.IRecordCopier;
import com.mathworks.widgets.recordlist.IRecordCreator;
import com.mathworks.widgets.recordlist.IRecordDeleter;
import com.mathworks.widgets.recordlist.IRecordDuplicator;
import com.mathworks.widgets.recordlist.IRecordEditor;
import com.mathworks.widgets.recordlist.IRecordFieldCopier;
import com.mathworks.widgets.recordlist.IRecordFilter;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IRecordOpener;
import com.mathworks.widgets.recordlist.IRecordSecondaryIconProvider;
import com.mathworks.widgets.recordlist.IRecordValueMutator;
import com.mathworks.widgets.recordlist.IRecordlistListener;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.IRecordlistMutator;
import com.mathworks.widgets.recordlist.IRecordlistRefresher;
import com.mathworks.widgets.recordlist.IRestrictedSortRecordlist;
import com.mathworks.widgets.recordlist.RecordFilterFactory;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;
import com.mathworks.widgets.recordlist.RecordlistResources;
import com.mathworks.widgets.spreadsheet.IUndoManagerProvider;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class RecordlistTableModel
extends AbstractTableModel
implements ComboBoxModel,
IRecordlistListener,
IRecordlistMutator,
IRecordIconProvider,
IRecordSecondaryIconProvider,
IGenericNameSupplier,
IRecordValueMutator,
PresortedTableModel,
RestrictedSortTableModel,
IUndoManagerProvider {
    private IRecordlistModel fRecordlistModel;
    private ICopyingObserver fCopyingObserver;
    private ICopyingObserver fPrivateCopyingObserver;
    private IDeletionObserver fDeletionObserver;
    private IDeletionObserver fPrivateDeletionObserver;
    private ICreationObserver fCreationObserver;
    private ICreationObserver fPrivateCreationObserver;
    private IDuplicationObserver fDuplicationObserver;
    private IDuplicationObserver fPrivateDuplicationObserver;
    private IOpeningObserver fOpeningObserver;
    private IOpeningObserver fPrivateOpeningObserver;
    private IEditingObserver fEditingObserver;
    private IEditingObserver fPrivateEditingObserver;
    private String fComboBoxSelection;
    private Vector<ListDataListener> fComboBoxListDataListeners = new Vector();
    private IRecordFilter[] fFilters;
    private int[] fViewToUnderlying;
    private int fViewRecordCount;
    private Runnable fViewUpdater = new ViewUpdater();
    private String fGenericNameSingular;
    private String fGenericNamePlural;

    public RecordlistTableModel(IRecordlistModel iRecordlistModel) {
        if (iRecordlistModel instanceof IGenericNameSupplier) {
            this.fGenericNameSingular = ((IGenericNameSupplier)((Object)iRecordlistModel)).getGenericNameSingular();
            this.fGenericNamePlural = ((IGenericNameSupplier)((Object)iRecordlistModel)).getGenericNamePlural();
        } else {
            this.fGenericNameSingular = RecordlistResources.getRecordSingular();
            this.fGenericNamePlural = RecordlistResources.getRecordPlural();
        }
        this.fRecordlistModel = iRecordlistModel;
        this.fFilters = new IRecordFilter[this.fRecordlistModel.getFieldCount()];
        this.applyFilters();
        this.fRecordlistModel.addRecordlistListener(this);
    }

    private int getUnderlyingRow(int n) {
        if (this.fViewToUnderlying.length > n) {
            return this.fViewToUnderlying[n];
        }
        return -1;
    }

    private void applyFilters() {
        int n;
        int n2;
        int n3 = this.fRecordlistModel.getRecordCount();
        boolean[] blArray = new boolean[n3];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < this.fRecordlistModel.getFieldCount(); ++n2) {
            if (this.fFilters[n2] == null) continue;
            for (n = 0; n < n3; ++n) {
                if (blArray[n]) continue;
                int n4 = n;
                blArray[n4] = blArray[n4] | !this.fFilters[n2].accept(this.fRecordlistModel.getValueAt(n, n2));
            }
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            nArray[n] = !blArray[n] ? n2++ : -1;
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[nArray[i]] = i;
        }
        this.fViewToUnderlying = nArray2;
        this.fViewRecordCount = n2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getUnderlyingRow(n);
        if (n3 == -1) {
            return null;
        }
        return this.fRecordlistModel.getValueAt(n3, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int[] nArray = new int[]{n};
        Object[] objectArray = new Object[]{object};
        this.setRecordValues(nArray, n2, objectArray);
    }

    public Class getColumnClass(int n) {
        return this.fRecordlistModel.getFieldClass(n);
    }

    @Override
    public String getColumnName(int n) {
        return this.fRecordlistModel.getFieldName(n);
    }

    @Override
    public int getRowCount() {
        return this.fViewRecordCount;
    }

    @Override
    public int getColumnCount() {
        return this.fRecordlistModel.getFieldCount();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        int[] nArray = new int[]{n};
        return this.areRecordsEditable(nArray, n2);
    }

    public Object getSemaphore() {
        return this.fRecordlistModel.getSemaphore();
    }

    @Override
    public void recordlistChanged(RecordlistModelEvent recordlistModelEvent) {
        this.applyFilters();
        boolean bl = false;
        if (recordlistModelEvent.getField() != -1) {
            int[] nArray = recordlistModelEvent.getRecords();
            for (int i = 0; i < nArray.length; ++i) {
                SwingUtilities.invokeLater(new CellUpdater(nArray[i], recordlistModelEvent.getField()));
            }
            bl = true;
        }
        if (!bl) {
            SwingUtilities.invokeLater(this.fViewUpdater);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.fComboBoxSelection;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.fComboBoxSelection = (String)object;
        this.fireComboBoxUpdated();
    }

    @Override
    public int getSize() {
        return this.getRowCount();
    }

    @Override
    public Object getElementAt(int n) {
        return this.getValueAt(n, this.fRecordlistModel.getPrimaryFieldIndex());
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.fComboBoxListDataListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.fComboBoxListDataListeners.remove(listDataListener);
    }

    public int getPrimaryFieldIndex() {
        return this.fRecordlistModel.getPrimaryFieldIndex();
    }

    private void fireComboBoxUpdated() {
        Enumeration<ListDataListener> enumeration = this.fComboBoxListDataListeners.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().contentsChanged(new ListDataEvent(this, 0, 0, Math.max(0, this.getRowCount() - 1)));
        }
    }

    @Override
    public void deleteRecords(int[] nArray) {
        ((IRecordDeleter)((Object)this.fRecordlistModel)).deleteRecords(nArray, new DualDeletionObserver(this.fPrivateDeletionObserver, this.fDeletionObserver));
    }

    @Override
    public boolean isRecordDeleter() {
        return this.fRecordlistModel instanceof IRecordDeleter;
    }

    @Override
    public boolean areRecordsDeletable(int[] nArray) {
        boolean bl = false;
        if (this.isRecordDeleter()) {
            bl = ((IRecordDeleter)((Object)this.fRecordlistModel)).areRecordsDeletable(nArray);
        }
        return bl;
    }

    @Override
    public void createRecord() {
        ((IRecordCreator)((Object)this.fRecordlistModel)).createRecord(new DualCreationObserver(this.fPrivateCreationObserver, this.fCreationObserver));
    }

    @Override
    public boolean isRecordCreator() {
        return this.fRecordlistModel instanceof IRecordCreator;
    }

    public void refresh() {
        ((IRecordlistRefresher)((Object)this.fRecordlistModel)).refresh();
    }

    public boolean isRefresher() {
        return this.fRecordlistModel instanceof IRecordlistRefresher;
    }

    @Override
    public void duplicateRecords(int[] nArray) {
        ((IRecordDuplicator)((Object)this.fRecordlistModel)).duplicateRecords(nArray, new DualDuplicationObserver(this.fPrivateDuplicationObserver, this.fDuplicationObserver));
    }

    @Override
    public boolean isRecordDuplicator() {
        return this.fRecordlistModel instanceof IRecordDuplicator;
    }

    @Override
    public boolean areRecordsDuplicatable(int[] nArray) {
        boolean bl = false;
        if (this.isRecordDuplicator()) {
            bl = ((IRecordDuplicator)((Object)this.fRecordlistModel)).areRecordsDuplicatable(nArray);
        }
        return bl;
    }

    @Override
    public boolean isRecordEditor() {
        return this.fRecordlistModel instanceof IRecordEditor;
    }

    @Override
    public boolean areRecordsEditable(int[] nArray, int n) {
        boolean bl = false;
        if (this.isRecordEditor()) {
            bl = ((IRecordEditor)((Object)this.fRecordlistModel)).areRecordsEditable(nArray, n);
        }
        return bl;
    }

    @Override
    public void setRecordValues(int[] nArray, int n, Object[] objectArray) {
        ((IRecordEditor)((Object)this.fRecordlistModel)).setRecordValues(nArray, n, objectArray, new DualEditingObserver(this.fPrivateEditingObserver, this.fEditingObserver));
    }

    @Override
    public String[] getEditingDescriptions() {
        String[] stringArray = this.isRecordEditor() ? ((IRecordEditor)((Object)this.fRecordlistModel)).getEditingDescriptions() : ArrayUtils.EmptyObjects.STRING;
        return stringArray;
    }

    @Override
    public int[] getEditableFields() {
        int[] nArray = this.isRecordEditor() ? ((IRecordEditor)((Object)this.fRecordlistModel)).getEditableFields() : ArrayUtils.EmptyPrimitives.INT;
        return nArray;
    }

    public void openRecords(int[] nArray) {
        ((IRecordOpener)((Object)this.fRecordlistModel)).openRecords(nArray, new DualOpeningObserver(this.fPrivateOpeningObserver, this.fOpeningObserver));
    }

    public boolean isRecordOpener() {
        return this.fRecordlistModel instanceof IRecordOpener;
    }

    public boolean areRecordsOpenable(int[] nArray) {
        boolean bl = false;
        if (this.isRecordOpener()) {
            bl = ((IRecordOpener)((Object)this.fRecordlistModel)).areRecordsOpenable(nArray);
        }
        return bl;
    }

    public void copyRecords(int[] nArray) {
        ((IRecordCopier)((Object)this.fRecordlistModel)).copyRecords(nArray, new DualCopyingObserver(this.fPrivateCopyingObserver, this.fCopyingObserver));
    }

    public void copyRecords(int[] nArray, int n) {
        if (this.isRecordFieldCopier()) {
            ((IRecordFieldCopier)((Object)this.fRecordlistModel)).copyRecords(nArray, n, new DualCopyingObserver(this.fPrivateCopyingObserver, this.fCopyingObserver));
        } else if (n == this.getPrimaryFieldIndex()) {
            ((IRecordCopier)((Object)this.fRecordlistModel)).copyRecords(nArray, new DualCopyingObserver(this.fPrivateCopyingObserver, this.fCopyingObserver));
        } else {
            throw new IllegalStateException("Canot copy a non-prmary field");
        }
    }

    public boolean isRecordCopier() {
        return this.fRecordlistModel instanceof IRecordCopier;
    }

    public boolean isRecordFieldCopier() {
        return this.fRecordlistModel instanceof IRecordFieldCopier;
    }

    public boolean areRecordsCopyable(int[] nArray) {
        boolean bl = false;
        if (this.isRecordCopier()) {
            bl = ((IRecordCopier)((Object)this.fRecordlistModel)).areRecordsCopyable(nArray);
        }
        return bl;
    }

    public boolean isRecordIconProvider() {
        return this.fRecordlistModel instanceof IRecordIconProvider;
    }

    @Override
    public Icon getRecordIcon(int n) {
        int n2;
        Icon icon = null;
        if (this.isRecordIconProvider() && (n2 = this.getUnderlyingRow(n)) != -1) {
            icon = ((IRecordIconProvider)((Object)this.fRecordlistModel)).getRecordIcon(n2);
        }
        return icon;
    }

    @Override
    public int getMaxIconHeight() {
        int n = -1;
        if (this.isRecordIconProvider()) {
            n = ((IRecordIconProvider)((Object)this.fRecordlistModel)).getMaxIconHeight();
        }
        return n;
    }

    public boolean isRecordSecondaryIconProvider() {
        return this.fRecordlistModel instanceof IRecordSecondaryIconProvider;
    }

    @Override
    public boolean hasRecordSecondaryIcons() {
        if (this.isRecordSecondaryIconProvider()) {
            return ((IRecordSecondaryIconProvider)((Object)this.fRecordlistModel)).hasRecordSecondaryIcons();
        }
        return false;
    }

    @Override
    public Icon getRecordSecondaryIcon(int n) {
        int n2;
        Icon icon = null;
        if (this.isRecordSecondaryIconProvider() && (n2 = this.getUnderlyingRow(n)) != -1) {
            icon = ((IRecordSecondaryIconProvider)((Object)this.fRecordlistModel)).getRecordSecondaryIcon(n2);
        }
        return icon;
    }

    @Override
    public int getMaxSecondaryIconHeight() {
        int n = -1;
        if (this.isRecordSecondaryIconProvider()) {
            n = ((IRecordSecondaryIconProvider)((Object)this.fRecordlistModel)).getMaxSecondaryIconHeight();
        }
        return n;
    }

    public void setFilter(IRecordFilter iRecordFilter, int n) {
        this.fFilters[n] = iRecordFilter;
        this.recordlistChanged(new RecordlistModelEvent());
    }

    public IRecordFilter getFilter(int n) {
        IRecordFilter iRecordFilter = this.fFilters[n];
        if (iRecordFilter == null) {
            iRecordFilter = RecordFilterFactory.getConstantFilter(true);
        }
        return iRecordFilter;
    }

    @Override
    public void setDeletionObserver(IDeletionObserver iDeletionObserver) {
        this.fDeletionObserver = iDeletionObserver;
    }

    void setPrivateDeletionObserver(IDeletionObserver iDeletionObserver) {
        this.fPrivateDeletionObserver = iDeletionObserver;
    }

    @Override
    public void setDuplicationObserver(IDuplicationObserver iDuplicationObserver) {
        this.fDuplicationObserver = iDuplicationObserver;
    }

    void setPrivateDuplicationObserver(IDuplicationObserver iDuplicationObserver) {
        this.fPrivateDuplicationObserver = iDuplicationObserver;
    }

    @Override
    public void setCreationObserver(ICreationObserver iCreationObserver) {
        this.fCreationObserver = iCreationObserver;
    }

    void setPrivateCreationObserver(ICreationObserver iCreationObserver) {
        this.fPrivateCreationObserver = iCreationObserver;
    }

    public void setOpeningObserver(IOpeningObserver iOpeningObserver) {
        this.fOpeningObserver = iOpeningObserver;
    }

    void setPrivateOpeningObserver(IOpeningObserver iOpeningObserver) {
        this.fPrivateOpeningObserver = iOpeningObserver;
    }

    public void setCopyingObserver(ICopyingObserver iCopyingObserver) {
        this.fCopyingObserver = iCopyingObserver;
    }

    void setPrivateCopyingObserver(ICopyingObserver iCopyingObserver) {
        this.fPrivateCopyingObserver = iCopyingObserver;
    }

    @Override
    public void setEditingObserver(IEditingObserver iEditingObserver) {
        this.fEditingObserver = iEditingObserver;
    }

    void setPrivateEditingObserver(IEditingObserver iEditingObserver) {
        this.fPrivateEditingObserver = iEditingObserver;
    }

    @Override
    public String getGenericNameSingular() {
        return this.fGenericNameSingular;
    }

    @Override
    public String getGenericNamePlural() {
        return this.fGenericNamePlural;
    }

    public int getPresortedColumn() {
        return this.fRecordlistModel.getPresortFieldIndex();
    }

    public int getPresortedDirection() {
        return this.fRecordlistModel.getPresortFieldOrder();
    }

    public int[] getUnsortableColumns() {
        if (this.fRecordlistModel instanceof IRestrictedSortRecordlist) {
            return ((IRestrictedSortRecordlist)((Object)this.fRecordlistModel)).getUnsortableFields();
        }
        return ArrayUtils.EmptyPrimitives.INT;
    }

    @Override
    public MUndoManager getUndoManager() {
        if (this.fRecordlistModel instanceof IUndoManagerProvider) {
            return ((IUndoManagerProvider)((Object)this.fRecordlistModel)).getUndoManager();
        }
        return null;
    }

    private static class DualEditingObserver
    implements IEditingObserver {
        private IEditingObserver fa;
        private IEditingObserver fb;

        DualEditingObserver(IEditingObserver iEditingObserver, IEditingObserver iEditingObserver2) {
            this.fa = iEditingObserver;
            this.fb = iEditingObserver2;
        }

        @Override
        public int editingStarted(int[] nArray) {
            int n = this.fa == null ? 0 : this.fa.editingStarted(nArray);
            int n2 = this.fb == null ? 0 : this.fb.editingStarted(nArray);
            return Math.max(n, n2);
        }

        @Override
        public void editingCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.editingCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.editingCompleted(n, string);
            }
        }
    }

    private static class DualCopyingObserver
    implements ICopyingObserver {
        private ICopyingObserver fa;
        private ICopyingObserver fb;

        DualCopyingObserver(ICopyingObserver iCopyingObserver, ICopyingObserver iCopyingObserver2) {
            this.fa = iCopyingObserver;
            this.fb = iCopyingObserver2;
        }

        @Override
        public int copyingStarted(int[] nArray) {
            int n = this.fa == null ? 0 : this.fa.copyingStarted(nArray);
            int n2 = this.fb == null ? 0 : this.fb.copyingStarted(nArray);
            return Math.max(n, n2);
        }

        @Override
        public void copyingCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.copyingCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.copyingCompleted(n, string);
            }
        }
    }

    private static class DualOpeningObserver
    implements IOpeningObserver {
        private IOpeningObserver fa;
        private IOpeningObserver fb;

        DualOpeningObserver(IOpeningObserver iOpeningObserver, IOpeningObserver iOpeningObserver2) {
            this.fa = iOpeningObserver;
            this.fb = iOpeningObserver2;
        }

        @Override
        public int openingStarted(int[] nArray) {
            int n = this.fa == null ? 0 : this.fa.openingStarted(nArray);
            int n2 = this.fb == null ? 0 : this.fb.openingStarted(nArray);
            return Math.max(n, n2);
        }

        @Override
        public void openingCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.openingCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.openingCompleted(n, string);
            }
        }
    }

    private static class DualDuplicationObserver
    implements IDuplicationObserver {
        private IDuplicationObserver fa;
        private IDuplicationObserver fb;

        DualDuplicationObserver(IDuplicationObserver iDuplicationObserver, IDuplicationObserver iDuplicationObserver2) {
            this.fa = iDuplicationObserver;
            this.fb = iDuplicationObserver2;
        }

        @Override
        public int duplicationStarted(int[] nArray) {
            int n = this.fa == null ? 0 : this.fa.duplicationStarted(nArray);
            int n2 = this.fb == null ? 0 : this.fb.duplicationStarted(nArray);
            return Math.max(n, n2);
        }

        @Override
        public void duplicationCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.duplicationCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.duplicationCompleted(n, string);
            }
        }
    }

    private static class DualCreationObserver
    implements ICreationObserver {
        private ICreationObserver fa;
        private ICreationObserver fb;

        DualCreationObserver(ICreationObserver iCreationObserver, ICreationObserver iCreationObserver2) {
            this.fa = iCreationObserver;
            this.fb = iCreationObserver2;
        }

        @Override
        public int creationStarted() {
            int n = this.fa == null ? 0 : this.fa.creationStarted();
            int n2 = this.fb == null ? 0 : this.fb.creationStarted();
            return Math.max(n, n2);
        }

        @Override
        public void creationCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.creationCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.creationCompleted(n, string);
            }
        }
    }

    private static class DualDeletionObserver
    implements IDeletionObserver {
        private IDeletionObserver fa;
        private IDeletionObserver fb;

        DualDeletionObserver(IDeletionObserver iDeletionObserver, IDeletionObserver iDeletionObserver2) {
            this.fa = iDeletionObserver;
            this.fb = iDeletionObserver2;
        }

        @Override
        public int deletionStarted(int[] nArray) {
            int n = this.fa == null ? 0 : this.fa.deletionStarted(nArray);
            int n2 = this.fb == null ? 0 : this.fb.deletionStarted(nArray);
            return Math.max(n, n2);
        }

        @Override
        public void deletionCompleted(int n, String string) {
            if (this.fb != null) {
                this.fb.deletionCompleted(n, string);
            }
            if (this.fa != null) {
                this.fa.deletionCompleted(n, string);
            }
        }
    }

    private class ViewUpdater
    implements Runnable {
        private ViewUpdater() {
        }

        @Override
        public void run() {
            RecordlistTableModel.this.fireTableDataChanged();
            RecordlistTableModel.this.fireComboBoxUpdated();
        }
    }

    private class CellUpdater
    implements Runnable {
        private int fRow;
        private int fCol;

        CellUpdater(int n, int n2) {
            this.fRow = n;
            this.fCol = n2;
        }

        @Override
        public void run() {
            RecordlistTableModel.this.fireTableCellUpdated(this.fRow, this.fCol);
        }
    }
}

