/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.messagepanel;

import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.messagepanel.MessageModelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMessageModel
implements MessageModel<Object> {
    private final Set<MessageModelListener> fListeners = new HashSet<MessageModelListener>();
    private List<Object> fMessages;
    private int fLineCount;

    protected AbstractMessageModel() {
        this(Collections.emptyList(), 0);
    }

    protected AbstractMessageModel(List<Object> list, int n) {
        this.update(list, n);
    }

    @Override
    public int getMessageCount() {
        return this.fMessages.size();
    }

    @Override
    public Object getMessageAt(int n) {
        return this.fMessages.get(n);
    }

    @Override
    public void addListener(MessageModelListener messageModelListener) {
        this.fListeners.add(messageModelListener);
    }

    @Override
    public void removeListener(MessageModelListener messageModelListener) {
        this.fListeners.remove(messageModelListener);
    }

    @Override
    public int getLineCount() {
        return this.fLineCount;
    }

    public final void update(List<?> list, int n) {
        if (list == null) {
            throw new IllegalArgumentException("'messages' cannot be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("lineCount cannot be < 0: " + n);
        }
        this.fLineCount = n;
        this.fMessages = new ArrayList(list);
        this.notifyListeners();
    }

    protected void notifyListeners() {
        for (MessageModelListener messageModelListener : this.fListeners) {
            messageModelListener.messagesUpdated();
        }
    }
}

