/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable.transfer;

import com.jidesoft.grid.Row;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.widgets.grouptable.DragToSelectHandler;
import com.mathworks.widgets.grouptable.EditOnClickHandler;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.SendHandler;
import com.mathworks.widgets.grouptable.transfer.Transfer;
import com.mathworks.widgets.grouptable.transfer.TransferUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class TransferController<T> {
    private final GroupingTable<T> fTable;
    private final List<SendHandler<T>> fSendHandlers;
    private final List<ReceiveHandler<T>> fReceiveHandlers;
    private boolean fForceCopy = false;
    private static final Image EMPTY_IMAGE = new BufferedImage(1, 1, 2);
    private static final String ICONKEY = "icon";

    public TransferController(GroupingTable<T> groupingTable) {
        this.fTable = groupingTable;
        this.fSendHandlers = new Vector<SendHandler<T>>();
        this.fReceiveHandlers = new Vector<ReceiveHandler<T>>();
        this.fTable.setDropTarget(new DropTarget((Component)((Object)this.fTable), 3, new DropListener(), true));
        new DragListener();
    }

    public void addSendHandler(SendHandler<T> sendHandler) {
        this.fSendHandlers.add(sendHandler);
    }

    public void addReceiveHandler(ReceiveHandler<T> receiveHandler) {
        this.fReceiveHandlers.add(receiveHandler);
    }

    public boolean canCut() {
        List<T> list = this.fTable.getSelectedItems();
        if (list.isEmpty()) {
            return false;
        }
        for (SendHandler<T> sendHandler : this.fSendHandlers) {
            if (!sendHandler.supportsMove() || !sendHandler.accept(list)) continue;
            return true;
        }
        return false;
    }

    public boolean canCopy() {
        List<T> list = this.fTable.getSelectedItems();
        if (list.isEmpty()) {
            return false;
        }
        for (SendHandler<T> sendHandler : this.fSendHandlers) {
            if (!sendHandler.supportsCopy() || !sendHandler.accept(list)) continue;
            return true;
        }
        return false;
    }

    public boolean canPaste() {
        List<T> list = this.fTable.getSelectedItems();
        Object t = list == null || list.size() != 1 ? null : (Object)list.get(0);
        Transfer transfer = new Transfer(Toolkit.getDefaultToolkit().getSystemClipboard());
        for (ReceiveHandler<Object> receiveHandler : this.fReceiveHandlers) {
            try {
                if (!receiveHandler.accept(t, transfer, true)) continue;
                return true;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return false;
    }

    public void cut() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = null;
        for (SendHandler<T> sendHandler : this.fSendHandlers) {
            if (!sendHandler.supportsMove() || !sendHandler.accept(this.fTable.getSelectedItems())) continue;
            Transferable transferable2 = sendHandler.wrap(this.fTable, this.fTable.getSelectedItems(), true);
            if (transferable == null) {
                transferable = transferable2;
                continue;
            }
            transferable = TransferUtils.combineFlavors(transferable, transferable2);
        }
        if (transferable != null) {
            clipboard.setContents(TransferUtils.addTransferType(2, transferable), null);
        }
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = null;
        for (SendHandler<T> sendHandler : this.fSendHandlers) {
            if (!sendHandler.supportsCopy() || !sendHandler.accept(this.fTable.getSelectedItems())) continue;
            Transferable transferable2 = sendHandler.wrap(this.fTable, this.fTable.getSelectedItems(), true);
            if (transferable == null) {
                transferable = transferable2;
                continue;
            }
            transferable = TransferUtils.combineFlavors(transferable, transferable2);
        }
        if (transferable != null) {
            clipboard.setContents(TransferUtils.addTransferType(1, transferable), null);
        }
    }

    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        int n = TransferUtils.getTransferType(transferable);
        List<T> list = this.fTable.getSelectedItems();
        Object t = list == null || list.size() != 1 ? null : (Object)list.get(0);
        Transfer transfer = new Transfer(transferable);
        boolean bl = n == -1;
        for (ReceiveHandler<Object> receiveHandler : this.fReceiveHandlers) {
            if (!receiveHandler.accept(t, transfer, true)) continue;
            Status status = receiveHandler.transfer(this.fTable, t, transfer, n == 2, bl, true);
            this.fTable.addToWorkMonitor(status);
            break;
        }
    }

    private Transferable createDragToSelectTransferable() {
        return TransferUtils.wrapObjectList(Arrays.asList(this.fTable.getDragToSelectHandler()));
    }

    private boolean isDragToSelectTransferable(Transferable transferable) {
        List<DragToSelectHandler> list = TransferUtils.unwrapObjectList(DragToSelectHandler.class, transferable);
        return list != null && list.size() == 1 && list.get(0) == this.fTable.getDragToSelectHandler();
    }

    private class DragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        DragListener() {
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer((Component)((Object)TransferController.this.fTable), 3, this);
        }

        private boolean isControlDown(DragGestureEvent dragGestureEvent) {
            Iterator<InputEvent> iterator = dragGestureEvent.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isControlDown()) continue;
                return true;
            }
            return false;
        }

        private boolean isShiftDown(DragGestureEvent dragGestureEvent) {
            Iterator<InputEvent> iterator = dragGestureEvent.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isShiftDown()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (TransferController.this.fTable.getEditOnClickHandler() != null) {
                TransferController.this.fTable.getEditOnClickHandler().cancelTimer();
            }
            TransferController.this.fTable.stopOrCancelEditing();
            Component component = dragGestureEvent.getComponent();
            Point point = SwingUtilities.convertPoint(component, dragGestureEvent.getDragOrigin(), (Component)((Object)TransferController.this.fTable));
            boolean bl = TransferController.this.fTable.getDragToSelectHandler().startDragging(point, this.isControlDown(dragGestureEvent), this.isShiftDown(dragGestureEvent));
            if (bl) {
                Transferable transferable = TransferController.this.createDragToSelectTransferable();
                dragGestureEvent.startDrag(Cursor.getDefaultCursor(), EMPTY_IMAGE, new Point(0, 0), transferable, this);
                return;
            }
            Transferable transferable = null;
            EditOnClickHandler editOnClickHandler = TransferController.this.fTable.getEditOnClickHandler();
            if (editOnClickHandler != null) {
                editOnClickHandler.cancelTimer();
            }
            if (!TransferController.this.fTable.getSelectedItems().isEmpty()) {
                for (SendHandler sendHandler : TransferController.this.fSendHandlers) {
                    if (!sendHandler.accept(TransferController.this.fTable.getSelectedItems())) continue;
                    int n = sendHandler.moveByDefault() ? 2 : 1;
                    Transferable transferable2 = sendHandler.wrap(TransferController.this.fTable, TransferController.this.fTable.getSelectedItems(), n == 2);
                    transferable2 = TransferUtils.addTransferType(n, transferable2);
                    if (transferable != null) {
                        transferable = TransferUtils.combineFlavors(transferable2, transferable);
                        continue;
                    }
                    transferable = transferable2;
                }
            }
            if (transferable != null) {
                dragGestureEvent.startDrag(MJDragCursorUtilities.getCursor((int)7563), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), transferable, this);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            Cursor cursor = MJDragCursorUtilities.getCursor((int)7563);
            if (cursor != null) {
                dragSourceEvent.getDragSourceContext().setCursor(cursor);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)dragSourceDragEvent.getDropAction()));
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)dragSourceDragEvent.getDropAction()));
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private T fDropTargetItem;
        private int fDropTargetRow;
        private boolean fSelectedDropTarget;
        private ReceiveHandler<T> fActiveHandler;

        private DropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.dragOver(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n = TransferController.this.fTable.rowAtPoint(dropTargetDragEvent.getLocation());
            if (n != -1) {
                TransferController.this.fTable.scrollRowToVisible(n);
            }
            if (TransferController.this.isDragToSelectTransferable(dropTargetDragEvent.getTransferable())) {
                TransferController.this.fTable.getDragToSelectHandler().drag(dropTargetDragEvent.getLocation());
                return;
            }
            int n2 = this.fDropTargetRow;
            boolean bl = this.fSelectedDropTarget;
            Transferable transferable = dropTargetDragEvent.getTransferable();
            this.updateDropInfo((int)dropTargetDragEvent.getLocation().getX(), (int)dropTargetDragEvent.getLocation().getY(), transferable);
            if (bl && n2 != this.fDropTargetRow && n2 != -1) {
                TransferController.this.fTable.getSelectionModel().removeSelectionInterval(n2, n2);
            }
            if (this.fActiveHandler == null) {
                dropTargetDragEvent.rejectDrag();
            } else {
                if (TransferController.this.fForceCopy) {
                    dropTargetDragEvent.acceptDrag(1);
                } else {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                }
                TransferController.this.fForceCopy = this.fActiveHandler.shouldForceCopy(new Transfer(transferable));
                if (this.fDropTargetRow != n2) {
                    if (this.fSelectedDropTarget && n2 != -1) {
                        TransferController.this.fTable.getSelectionModel().removeSelectionInterval(n2, n2);
                        this.fSelectedDropTarget = false;
                    }
                    if (this.fDropTargetRow != -1) {
                        int[] nArray = TransferController.this.fTable.getSelectedRows();
                        Arrays.sort(nArray);
                        if (Arrays.binarySearch(nArray, this.fDropTargetRow) < 0) {
                            TransferController.this.fTable.getSelectionModel().addSelectionInterval(this.fDropTargetRow, this.fDropTargetRow);
                            this.fSelectedDropTarget = true;
                        }
                    }
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.fSelectedDropTarget && this.fDropTargetRow != -1) {
                TransferController.this.fTable.getSelectionModel().removeSelectionInterval(this.fDropTargetRow, this.fDropTargetRow);
            }
            this.fDropTargetItem = null;
            this.fDropTargetRow = -1;
            this.fSelectedDropTarget = false;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        private void updateDropInfo(int n, int n2, Transferable transferable) {
            Point point = new Point(n, n2);
            this.fDropTargetRow = TransferController.this.fTable.rowAtPoint(point);
            int n3 = TransferController.this.fTable.columnAtPoint(point);
            if (n3 == -1) {
                this.fDropTargetRow = -1;
            } else if (this.fDropTargetRow != -1 && !TransferController.this.fTable.isRowSelected(this.fDropTargetRow)) {
                Iterator iterator = TransferController.this.fTable.setupRenderer(this.fDropTargetRow, n3);
                Object object = iterator.getTableCellRendererComponent((JTable)((Object)TransferController.this.fTable), TransferController.this.fTable.getValueAt(this.fDropTargetRow, n3), false, true, this.fDropTargetRow, n3);
                Rectangle rectangle = TransferController.this.fTable.getCellRect(this.fDropTargetRow, n3, true);
                if (iterator instanceof NonRectangularCellRenderer) {
                    int n4 = 0;
                    if (TransferController.this.fTable.getConfiguration().getVisibleColumns().get(n3).getKey().equalsIgnoreCase(TransferController.ICONKEY)) {
                        n4 = (TransferController.this.fTable.getRowAt(this.fDropTargetRow).getLevel() + 1) * TransferController.this.fTable.getIndent();
                    }
                    point.setLocation(point.getX() - (double)n4, (double)((int)(point.getY() - rectangle.getY())));
                    if (!((NonRectangularCellRenderer)((Object)iterator)).allowRightClickSelection(point)) {
                        this.fDropTargetRow = -1;
                    }
                } else {
                    rectangle.setSize((int)Math.min(rectangle.getWidth(), ((Component)object).getPreferredSize().getWidth()), (int)rectangle.getHeight());
                    if (!rectangle.contains(point)) {
                        this.fDropTargetRow = -1;
                    }
                }
            }
            if (this.fDropTargetRow == -1) {
                this.fDropTargetItem = null;
                this.fActiveHandler = null;
                for (Object object : TransferController.this.fReceiveHandlers) {
                    if (!object.accept(null, new Transfer(transferable), false)) continue;
                    this.fActiveHandler = object;
                    break;
                }
            } else {
                this.fDropTargetItem = TransferController.this.fTable.getItem(this.fDropTargetRow);
                if (!(this.fDropTargetItem instanceof Group)) {
                    for (Object object : TransferController.this.fReceiveHandlers) {
                        if (!object.accept(this.fDropTargetItem, new Transfer(transferable), false)) continue;
                        this.fActiveHandler = object;
                        return;
                    }
                }
                this.fDropTargetRow = -1;
                this.fDropTargetItem = null;
                this.fActiveHandler = null;
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (TransferController.this.isDragToSelectTransferable(transferable)) {
                TransferController.this.fTable.getDragToSelectHandler().drop();
                return;
            }
            boolean bl = TransferUtils.getTransferType(transferable) == -1;
            int n = dropTargetDropEvent.getDropAction();
            if (TransferController.this.fForceCopy) {
                n = 1;
            }
            dropTargetDropEvent.acceptDrop(n);
            Status status = n == 1 ? this.fActiveHandler.transfer(TransferController.this.fTable, this.fDropTargetItem, new Transfer(transferable), false, bl, false) : this.fActiveHandler.transfer(TransferController.this.fTable, this.fDropTargetItem, new Transfer(transferable), true, bl, false);
            int n2 = TransferController.this.fTable.getGroupingModel().rowIndexOf(this.fDropTargetItem);
            if (n2 >= 0) {
                TransferController.this.fTable.setSelectedRow((Row)TransferController.this.fTable.getRowAt(n2));
            }
            TransferController.this.fTable.addToWorkMonitor(status);
        }
    }
}

