/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.TreeExpandablePanel;
import com.jidesoft.grid.TreeTableCellRenderer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableCellRenderer;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.border.Border;

final class GroupingTableExpanderRenderer<T>
extends TreeTableCellRenderer
implements NonRectangularCellRenderer {
    private final GroupingTable<T> fTable;
    private int fRowIndex;
    private boolean fPaintAsHeader;

    GroupingTableExpanderRenderer(GroupingTable<T> groupingTable) {
        this.fTable = groupingTable;
        this._cellRenderer = new TreeExpandablePanel((JTable)((Object)groupingTable)){

            public void paintBackground(Graphics graphics) {
                if (((GroupingTableRow)this._node).getGroup() == null) {
                    super.paintBackground(graphics);
                } else {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(GroupingTableUtils.getGroupHeaderGradient(rectangle));
                    graphics2D.fill(rectangle);
                    graphics2D.setPaint(null);
                }
            }

            protected void paintFocus(Graphics graphics) {
                Border border;
                Color color = super.getBackground();
                if (this.isSelected()) {
                    super.setBackground(this._table.getSelectionBackground());
                } else {
                    super.setBackground(color);
                }
                if (GroupingTableExpanderRenderer.this.fTable.hasFocus() && GroupingTableExpanderRenderer.this.fRowIndex == GroupingTableExpanderRenderer.this.fTable.getSelectionModel().getLeadSelectionIndex() && (border = UIDefaultsLookup.getBorder((Object)"Table.focusCellHighlightBorder")) != null) {
                    Insets insets = border.getBorderInsets((Component)((Object)this));
                    border.paintBorder((Component)((Object)this), graphics, 0, 0, this.getWidth() + insets.right, this.getHeight());
                }
                super.setBackground(color);
            }
        };
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        GroupingTableRow<T> groupingTableRow = this.fTable.getRowAt(n);
        this.fTable.getGroupingModel().getPopulator().notifyVisible(groupingTableRow);
        this.fPaintAsHeader = groupingTableRow.getGroup() != null;
        bl &= !this.fPaintAsHeader;
        this.fRowIndex = n;
        if (this.fTable.get(n) != null && this.fTable.getConfiguration().getExpansionProviders().isEmpty()) {
            return this._actualCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    @Override
    public Rectangle getRightClickSelectionBoundingRect() {
        return ((NonRectangularCellRenderer)this._actualCellRenderer).getRightClickSelectionBoundingRect();
    }

    @Override
    public boolean allowRightClickSelection(Point point) {
        return ((NonRectangularCellRenderer)this._actualCellRenderer).allowRightClickSelection(point);
    }

    @Override
    public boolean allowToolTip(Point point) {
        return ((NonRectangularCellRenderer)this._actualCellRenderer).allowToolTip(point);
    }

    public GroupingTableCellRenderer<T> getGroupingTableCellRenderer() {
        return (GroupingTableCellRenderer)this._actualCellRenderer;
    }
}

