/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.basic.BasicCellSpanTableUI;
import com.jidesoft.swing.MultilineLabel;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.mwswing.table.PlatformDelegatingHeaderRenderer;
import com.mathworks.mwswing.table.SortedTable;
import com.mathworks.mwswing.table.SortedTableHeaderRenderer;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.ClosableToolTipData;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.grouptable.AffordanceManager;
import com.mathworks.widgets.grouptable.ColumnActions;
import com.mathworks.widgets.grouptable.DisplayEffects;
import com.mathworks.widgets.grouptable.DragToSelectHandler;
import com.mathworks.widgets.grouptable.EditOnClickHandler;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableCellRenderer;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableExpanderRenderer;
import com.mathworks.widgets.grouptable.GroupingTableLayout;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.GroupingTableResources;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableSelectionListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.GroupingTableUI;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import com.mathworks.widgets.grouptable.PairingEditorWrapper;
import com.mathworks.widgets.grouptable.ToolTipSupport;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.SendHandler;
import com.mathworks.widgets.grouptable.transfer.TransferController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GroupingTable<T>
extends TreeTable
implements SortedTable {
    private final GroupingTableModel<T> fModel;
    private final List<GroupingTableSelectionListener<T>> fSelectionListeners;
    private final TransferController<T> fTransferController;
    private ColumnActions<T> fColumnActions;
    private final AffordanceManager<T> fAffordanceManager;
    private final Graphics fRendererSetupGraphics;
    private final DragToSelectHandler fDragToSelectHandler;
    private String fMessageText;
    private EditOnClickHandler<T> fEditOnClickHandler;
    private ParameterRunnable<T> fRunAfterNextEdit;
    private Map<Class<?>, PairingEditorWrapper> fEditors;
    private Color fSaveSelectionBackground;
    private Color fSaveSelectionForeground;
    private MouseDragGestureRecognizer fDragListener;
    private boolean fIsSelectionLocked;
    private int fSuppressedIndex = -1;
    private boolean fSelectionEventsSuppressed;
    private boolean fAddedToClient;
    private final GroupingTableUI fUi = new GroupingTableUI();
    private static final double sWidthEstimateBase = 8.475586;
    private Timer fSaveConfigTimer;
    private static final int SAVE_DELAY = 1000;
    private Map<GroupingTableColumn<T>, Integer> fColumnChangedMap;

    public GroupingTable(GroupingTableModel<T> groupingTableModel) {
        super(groupingTableModel);
        this.setUI((TableUI)((Object)this.fUi));
        groupingTableModel.getPopulator().setTable(this);
        groupingTableModel.setRenameHandler(new DefaultEditHandler());
        this.fSelectionListeners = new LinkedList<GroupingTableSelectionListener<T>>();
        this.fModel = groupingTableModel;
        this.fEditors = new HashMap();
        this.fColumnChangedMap = new HashMap<GroupingTableColumn<T>, Integer>();
        this.fDragToSelectHandler = new DragToSelectHandler((JTable)((Object)this));
        this.fDragToSelectHandler.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GroupingTable.this.fSelectionEventsSuppressed = GroupingTable.this.fDragToSelectHandler.isSelecting();
                GroupingTable.this.fireSelectionListenersIfEnabled();
            }
        });
        this.fColumnActions = new ColumnActions<T>(this.fModel);
        this.fAffordanceManager = new AffordanceManager(this);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fRendererSetupGraphics = bufferedImage.getGraphics();
        this.setShowHorizontalLines(false);
        this.setGridColor(ColorUtils.convertToCurrentColorScheme((Color)new Color(239, 239, 239), (Color)UIManager.getColor("control")));
        this.setShowTreeLines(false);
        this.setAutoscrolls(true);
        this.getSelectionModel().setSelectionMode(2);
        this.setSortable(false);
        this.fTransferController = new TransferController(this);
        this.forwardSelectionEventOnSelectionChange();
        this.installSelectionPreservingRefreshWrapper();
        this.updateConfigurationOnExpandOrCollapse();
        this.updateConfigurationOnColumnSizeChange();
        this.updateConfigurationOnColumnMove();
        this.updateGroupExpansionStateOnConfigurationChange();
        this.showGroupHeaderMenuOnGroupRightClick();
        this.showTableHeaderMenuOnTableHeaderRightClick();
        this.setOrReverseSortOnTableHeaderClick();
        this.stopOrCancelEditingOnClickOut();
        this.stopOrCancelEditingOnGroupModeChange();
        this.repaintHeaderOnSortModeChange();
        this.fixDisplayOnVerticalAttributeChange();
        this.fixDisplayOnExpandOrCollapse();
        this.notifyWhenTooManyFiles();
        this.setupColumnModelWhenAddedToClient();
        this.showVerticalAttributesAsColumnsWhenWide();
        this.setupColumnModelOnVisibleColumnChange();
        this.adjustRowHeight();
        this.adjustGridSetting();
        AppearanceFocusDispatcher appearanceFocusDispatcher = new AppearanceFocusDispatcher();
        appearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)new TableAppearanceFocusListener());
        this.addFocusListener((FocusListener)appearanceFocusDispatcher);
        this.updateWidthEstimateScaleFactor();
        this.installCheckBoxHandler();
        ToolTipSupport.install(this);
        this.putClientProperty("TreeTable.paintTreeLineOnTreeTable", false);
        this.setClearSelectionOnTableDataChanges(true);
    }

    public void updateColumnActions() {
        this.fColumnActions = new ColumnActions<T>(this.fModel);
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTable.this.clearConfigTimer();
                GroupingTable.this.getGroupingModel().dispose();
                ToolTipSupport.uninstall(GroupingTable.this);
                GroupingTable.this.setUI((TableUI)new BasicCellSpanTableUI());
                GroupingTable.this.fDragToSelectHandler.dispose();
                if (GroupingTable.this.fEditOnClickHandler != null) {
                    GroupingTable.this.fEditOnClickHandler.destroy();
                }
            }
        });
    }

    public void clearConfigTimer() {
        if (this.fSaveConfigTimer != null) {
            this.fColumnChangedMap.clear();
            this.fSaveConfigTimer.stop();
            this.fSaveConfigTimer = null;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateWidthEstimateScaleFactor();
    }

    public void updateWidthEstimateScaleFactor() {
        Font font = this.getFont();
        if (this.fModel != null && font != null) {
            this.getConfiguration().setWidthEstimateScaleFactor(font.getStringBounds("M", new FontRenderContext(null, false, true)).getWidth() / 8.475586);
        }
    }

    public WorkMonitor getWorkMonitor() {
        return this.fModel.getWorkMonitor();
    }

    public void setMessageText(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTable.this.fMessageText = string;
                GroupingTable.this.revalidate();
                GroupingTable.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        if (this.fMessageText != null) {
            graphics = graphics.create();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            MultilineLabel multilineLabel = new MultilineLabel();
            multilineLabel.setText(this.fMessageText);
            multilineLabel.setSize(this.getWidth(), this.getHeight());
            graphics.translate(this.getWidth() / 2 - multilineLabel.getWidth() / 2, 8);
            multilineLabel.setLocation(0, 0);
            multilineLabel.setForeground(this.getForeground());
            multilineLabel.setOpaque(false);
            multilineLabel.paint(graphics);
            graphics.dispose();
        } else {
            super.paintComponent(graphics);
            this.fDragToSelectHandler.paintSelection(graphics);
        }
    }

    public DragToSelectHandler getDragToSelectHandler() {
        return this.fDragToSelectHandler;
    }

    public void addToWorkMonitor(Status status) {
        WorkMonitor workMonitor = this.getWorkMonitor();
        if (workMonitor != null && status.getLabel() != null) {
            final WorkMonitor.Task task = workMonitor.startTask(status.getLabel(), status.isHeavy());
            status.addCompletionOrCancellationRunnable(new Runnable(){

                @Override
                public void run() {
                    task.finished();
                }
            });
        }
    }

    public void reset() {
        this.clearConfigTimer();
        this.getGroupingModel().reset();
        this.getGroupingModel().refresh();
        this.getGroupingModel().getConfiguration().loadSerializer();
        this.setupColumnModel(false);
    }

    public void setAddedToClient() {
        this.fAddedToClient = true;
    }

    private void stopOrCancelEditingOnClickOut() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (GroupingTable.this.isEditing()) {
                    int n = GroupingTable.this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    int n2 = GroupingTable.this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    int n3 = GroupingTable.this.getSelectedRow();
                    int n4 = GroupingTable.this.getEditingColumn();
                    if (n3 != n || n4 != n2) {
                        GroupingTable.this.stopOrCancelEditing();
                        GroupingTable.this.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
    }

    private void stopOrCancelEditingOnGroupModeChange() {
        this.fModel.getConfiguration().addGroupingWillChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GroupingTable.this.stopOrCancelEditing();
            }
        });
    }

    private void notifyWhenTooManyFiles() {
        this.fModel.addOverflowListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (GroupingTable.this.fModel.inOverflowState()) {
                    GroupingTable.this.setMessageText(GroupingTableResources.getString("table.tooLarge"));
                } else {
                    GroupingTable.this.setMessageText(null);
                }
            }
        });
    }

    private void updateGroupExpansionStateOnConfigurationChange() {
        this.fModel.getConfiguration().addPropertyChangeListener("expanded-groups", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Iterator iterator = GroupingTable.this.getGroupingModel().getGroupRows().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            GroupingTableRow groupingTableRow = GroupingTable.this.getRowAt(entry.getKey());
                            boolean bl = GroupingTable.this.getConfiguration().isGroupExpanded(entry.getValue());
                            if (groupingTableRow == null || bl == groupingTableRow.isExpanded()) continue;
                            GroupingTable.this.expandRow(entry.getKey(), bl);
                            iterator = GroupingTable.this.getGroupingModel().getGroupRows().entrySet().iterator();
                        }
                    }
                });
            }
        });
    }

    public void stopOrCancelEditing() {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    private void repaintHeaderOnSortModeChange() {
        this.fModel.getConfiguration().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("sort-column") || propertyChangeEvent.getPropertyName().equals("sort-descending")) {
                    GroupingTable.this.getTableHeader().revalidate();
                    GroupingTable.this.getTableHeader().repaint();
                }
            }
        });
    }

    private void fixDisplayOnVerticalAttributeChange() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GroupingTable.this.adjustRowHeight();
                GroupingTable.this.revalidate();
                GroupingTable.this.repaint();
            }
        };
        this.getConfiguration().addPropertyChangeListener("visible-vertical-attributes", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                runnable.run();
            }
        });
        this.getConfiguration().addVerticalAttributeDisplayChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                runnable.run();
            }
        });
    }

    private void fixDisplayOnExpandOrCollapse() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                GroupingTable.this.adjustRowHeight();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
    }

    private void showGroupHeaderMenuOnGroupRightClick() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent) && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Map map = GroupingTable.this.fModel.getGroupRows();
                    for (Map.Entry entry : map.entrySet()) {
                        Rectangle rectangle = GroupingTable.this.getCellRect(entry.getKey(), 0, true);
                        if (!(rectangle = new Rectangle((int)rectangle.getX(), (int)rectangle.getY(), GroupingTable.this.getWidth(), (int)rectangle.getHeight())).contains(mouseEvent.getPoint())) continue;
                        GroupingTable.this.showGroupHeaderMenu(mouseEvent.getPoint());
                        break;
                    }
                }
            }
        });
    }

    private void showTableHeaderMenuOnTableHeaderRightClick() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                GroupingTable.this.getTableHeader().setReorderingAllowed(true);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = GroupingTable.this.convertColumnIndexToModel(GroupingTable.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()));
                if (n != -1 && MJUtilities.isRightMouseButton((MouseEvent)mouseEvent)) {
                    GroupingTable.this.showTableHeaderMenu(mouseEvent.getComponent(), mouseEvent.getPoint());
                }
            }
        });
    }

    private void setOrReverseSortOnTableHeaderClick() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = GroupingTable.this.convertColumnIndexToModel(GroupingTable.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()));
                if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && !MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent)) {
                    GroupingTable.this.getConfiguration().setSortColumnOrToggleDirection(GroupingTable.this.getConfiguration().getVisibleColumn(n));
                }
            }
        });
    }

    private void forwardSelectionEventOnSelectionChange() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    GroupingTable.this.fireSelectionListenersIfEnabled();
                }
            }
        });
    }

    private void fireSelectionListenersIfEnabled() {
        if (!this.fSelectionEventsSuppressed) {
            List<T> list = this.getSelectedItems();
            for (GroupingTableSelectionListener<T> groupingTableSelectionListener : new Vector<GroupingTableSelectionListener<T>>(this.fSelectionListeners)) {
                groupingTableSelectionListener.valueChanged(list);
            }
        }
    }

    private void installSelectionPreservingRefreshWrapper() {
        this.getGroupingModel().setRefreshWrapper(new ParameterRunnable<Runnable>(){

            public void run(Runnable runnable) {
                GroupingTable.this.fSelectionEventsSuppressed = true;
                int[] nArray = GroupingTable.this.getSelectedRows();
                int n = GroupingTable.this.getSelectionModel().getAnchorSelectionIndex();
                int n2 = GroupingTable.this.getSelectionModel().getLeadSelectionIndex();
                Object var5_5 = n == -1 ? null : GroupingTable.this.get(n);
                Object var6_6 = n2 == -1 ? null : GroupingTable.this.get(n2);
                List list = GroupingTable.this.getSelectedItems();
                runnable.run();
                GroupingTable.this.adjustRowHeight();
                GroupingTable.this.fSelectionEventsSuppressed = false;
                if (GroupingTable.this.getRowCount() == 0 && GroupingTable.this.isEditing()) {
                    GroupingTable.this.getCellEditor().cancelCellEditing();
                }
                GroupingTable.this.restoreSelection(var5_5, var6_6, nArray, list);
            }
        });
    }

    private void setupColumnModelOnVisibleColumnChange() {
        this.fModel.getConfiguration().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("visible-columns") || propertyChangeEvent.getPropertyName().equals("column-positions")) {
                    if (GroupingTable.this.fAddedToClient) {
                        GroupingTable.this.setupColumnModel(true);
                    }
                    GroupingTable.this.adjustGridSetting();
                }
            }
        });
    }

    private void setupColumnModelWhenAddedToClient() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DTClientBase dTClientBase = (DTClientBase)((Object)TreeUtils.findAncestorComponent((Component)((Object)GroupingTable.this), DTClientBase.class));
                if (dTClientBase != null) {
                    GroupingTable.this.fAddedToClient = true;
                    GroupingTable.this.setupColumnModel(true);
                    GroupingTable.this.removeComponentListener(this);
                }
            }
        });
    }

    private void showVerticalAttributesAsColumnsIfWide(boolean bl) {
        block4: {
            block3: {
                GroupingTableConfiguration<T> groupingTableConfiguration = this.getConfiguration();
                int n = 0;
                for (GroupingTableColumn<T> iterator : groupingTableConfiguration.getVisibleColumns()) {
                    n += groupingTableConfiguration.getScaledWidthEstimate(iterator);
                }
                Object object = null;
                for (VerticalAttribute<T> verticalAttribute : this.getConfiguration().getVisibleVerticalAttributes()) {
                    if (!verticalAttribute.shouldShowInColumnWhenWide()) continue;
                    object = verticalAttribute;
                    n += groupingTableConfiguration.getScaledWidthEstimate(verticalAttribute);
                    break;
                }
                if (this.getWidth() <= n) break block3;
                if (object == null) break block4;
                this.getConfiguration().convertToColumn((VerticalAttribute<T>)object, bl);
                break block4;
            }
            for (GroupingTableColumn<T> groupingTableColumn : this.getConfiguration().getVisibleColumns()) {
                if (!this.getConfiguration().isVerticalAttributeColumn(groupingTableColumn)) continue;
                this.getConfiguration().convertToVerticalAttribute(groupingTableColumn);
                break;
            }
        }
    }

    private void showVerticalAttributesAsColumnsWhenWide() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (GroupingTable.this.fAddedToClient) {
                            GroupingTable.this.showVerticalAttributesAsColumnsIfWide(true);
                        }
                    }
                });
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                runnable.run();
            }
        });
        this.getConfiguration().addPropertyChangeListener("visible-vertical-attributes", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                runnable.run();
            }
        });
        this.getConfiguration().addPropertyChangeListener("visible-columns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                runnable.run();
            }
        });
        runnable.run();
    }

    private void restoreSelection(final T t, final T t2, final int[] nArray, final List<T> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                GroupingTable.this.getSelectionModel().setValueIsAdjusting(true);
                boolean bl = false;
                if (list != null) {
                    for (Object e : list) {
                        int n3 = GroupingTable.this.getGroupingModel().rowIndexOf(e);
                        if (n3 < 0) continue;
                        GroupingTable.this.getSelectionModel().addSelectionInterval(n3, n3);
                        bl = true;
                    }
                }
                if (!bl && nArray != null) {
                    for (Object object : (Object)nArray) {
                        if (object < 0 || object >= GroupingTable.this.getRowCount() || GroupingTable.this.get((int)object) == null) continue;
                        GroupingTable.this.getSelectionModel().setSelectionInterval((int)object, (int)object);
                        bl = true;
                        break;
                    }
                }
                if (!bl && nArray != null && nArray.length > 0) {
                    int n4;
                    for (n4 = GroupingTable.this.getRowCount() - 1; n4 >= 0 && GroupingTable.this.get(n4) == null; --n4) {
                    }
                    if (n4 >= 0) {
                        GroupingTable.this.getSelectionModel().setSelectionInterval(n4, n4);
                    }
                }
                if (t != null && (n2 = GroupingTable.this.getGroupingModel().rowIndexOf(t)) != -1) {
                    GroupingTable.this.getSelectionModel().setAnchorSelectionIndex(n2);
                }
                if (t2 != null && (n = GroupingTable.this.getGroupingModel().rowIndexOf(t2)) != -1) {
                    if (GroupingTable.this.getSelectionModel() instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)GroupingTable.this.getSelectionModel()).moveLeadSelectionIndex(n);
                    } else {
                        GroupingTable.this.getSelectionModel().setLeadSelectionIndex(n);
                    }
                }
                GroupingTable.this.getSelectionModel().setValueIsAdjusting(false);
            }
        });
    }

    private void updateConfigurationOnExpandOrCollapse() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            private void updateConfiguration(TreeExpansionEvent treeExpansionEvent, boolean bl) {
                GroupingTableRow groupingTableRow = (GroupingTableRow)((Object)treeExpansionEvent.getPath().getLastPathComponent());
                if (groupingTableRow.getGroup() != null) {
                    GroupingTable.this.getConfiguration().setExpanded(groupingTableRow.getGroup(), bl);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                this.updateConfiguration(treeExpansionEvent, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                this.updateConfiguration(treeExpansionEvent, false);
            }
        });
    }

    private void updateConfigurationOnColumnSizeChange() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GroupingTableColumn groupingTableColumn;
                TableColumn tableColumn;
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("width") && (object = (tableColumn = (TableColumn)propertyChangeEvent.getSource()).getIdentifier()) != null && propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() != null && (groupingTableColumn = GroupingTable.this.getConfiguration().getColumnByKey(object.toString())) != null && GroupingTable.this.fAddedToClient) {
                    GroupingTable.this.setUI((TableUI)((Object)GroupingTable.this.fUi));
                    GroupingTable.this.fColumnChangedMap.put(groupingTableColumn, (Integer)propertyChangeEvent.getNewValue());
                    if (GroupingTable.this.fSaveConfigTimer == null) {
                        GroupingTable.this.fSaveConfigTimer = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                for (Map.Entry entry : GroupingTable.this.fColumnChangedMap.entrySet()) {
                                    GroupingTable.this.getConfiguration().setColumnSizeIfNotFixed((GroupingTableColumn)entry.getKey(), (Integer)entry.getValue());
                                }
                                GroupingTable.this.clearConfigTimer();
                            }
                        });
                    } else {
                        GroupingTable.this.fSaveConfigTimer.restart();
                    }
                }
            }
        };
        final ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            arrayList.add(this.getColumnModel().getColumn(i));
            this.getColumnModel().getColumn(i).addPropertyChangeListener(propertyChangeListener);
        }
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){
            private boolean iSuppressReaction;

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                arrayList.add(tableColumnModelEvent.getToIndex(), GroupingTable.this.getColumnModel().getColumn(tableColumnModelEvent.getToIndex()));
                GroupingTable.this.getColumnModel().getColumn(tableColumnModelEvent.getToIndex()).addPropertyChangeListener(propertyChangeListener);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                TableColumn tableColumn = (TableColumn)arrayList.get(tableColumnModelEvent.getFromIndex());
                arrayList.remove(tableColumnModelEvent.getFromIndex());
                tableColumn.removePropertyChangeListener(propertyChangeListener);
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                if (!this.iSuppressReaction) {
                    int n = GroupingTable.this.getConfiguration().getFixedPositionColumnCount();
                    if (tableColumnModelEvent.getFromIndex() < n || tableColumnModelEvent.getToIndex() < n) {
                        GroupingTable.this.getTableHeader().setDraggedColumn(null);
                        this.iSuppressReaction = true;
                        GroupingTable.this.getColumnModel().moveColumn(tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getFromIndex());
                        this.iSuppressReaction = false;
                    } else {
                        Collections.swap(arrayList, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
                    }
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    private void updateConfigurationOnColumnMove() {
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnMoved(final TableColumnModelEvent tableColumnModelEvent) {
                if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupingTableColumn groupingTableColumn = GroupingTable.this.getConfiguration().getColumnByKey((String)GroupingTable.this.getColumnModel().getColumn(tableColumnModelEvent.getToIndex()).getIdentifier());
                        GroupingTableLayout groupingTableLayout = GroupingTable.this.getCurrentColumnLayout();
                        GroupingTableColumn groupingTableColumn2 = groupingTableLayout.getPriorColumn(groupingTableColumn);
                        GroupingTableColumn groupingTableColumn3 = groupingTableLayout.getNextColumn(groupingTableColumn);
                        GroupingTable.this.getConfiguration().moveColumn(groupingTableColumn, groupingTableColumn2, groupingTableColumn3);
                    }
                });
            }
        });
    }

    AffordanceManager<T> getAffordanceManager() {
        return this.fAffordanceManager;
    }

    void adjustGridSetting() {
        boolean bl;
        List<GroupingTableColumn<T>> list = this.getConfiguration().getVisibleColumns();
        boolean bl2 = this.getConfiguration().getVisibleVerticalAttributeCount() == 0 && !MJUtilities.isHighContrast() && (list.size() > 2 || list.size() == 2 && this.getConfiguration().getPairedColumn(0) != list.get(1));
        boolean bl3 = bl = this.getShowHorizontalLines() || this.getShowVerticalLines() != bl2;
        if (bl) {
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(bl2);
            this.revalidate();
            this.repaint();
        }
    }

    void adjustRowHeight(GroupingTableRow<T> groupingTableRow) {
        int n = this.fModel.getRowIndex((Row)groupingTableRow);
        if (n >= 0) {
            this.setRowHeight(n, Math.max(this.getMinimumRowHeight(), this.getLineHeight() * this.getLineCountInRow(groupingTableRow)));
            this.adjustGridSetting();
        }
    }

    public void adjustRowHeight() {
        int n = this.getLineHeight();
        int n2 = this.getMinimumRowHeight();
        int n3 = this.getRowCount();
        int n4 = Math.max(n2, n);
        if (this.getConfiguration().getVisibleVerticalAttributeCount() == 0) {
            this.setRowHeight(n4);
        } else {
            for (int i = 0; i < n3; ++i) {
                int n5 = Math.max(n2, n * this.getLineCountInRow(i));
                if (this.getRowHeight(i) == n5) continue;
                this.setRowHeight(i, n5);
            }
        }
        this.adjustGridSetting();
    }

    int getLineCountInRow(int n) {
        return this.getLineCountInRow(this.getRowAt(n));
    }

    int getLineCountInRow(GroupingTableRow<T> groupingTableRow) {
        return 1 + Math.min(groupingTableRow.getLoadedVerticalAttributeCount(), this.getConfiguration().getVisibleVerticalAttributeCount());
    }

    public int getLineHeight() {
        return this.getFontMetrics(this.getFont()).getHeight() + 1;
    }

    int getMinimumRowHeight() {
        int n = FileTypeIcon.M.getIcon().getIconHeight() + 1;
        return Math.max(this.getFontMetrics(this.getFont()).getHeight() + 1, n);
    }

    public GroupingTableLayout<T> getCurrentColumnLayout() {
        GroupingTableLayout<T> groupingTableLayout = new GroupingTableLayout<T>();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            groupingTableLayout.addColumn(this.getConfiguration().getColumnByKey((String)this.getColumnModel().getColumn(i).getIdentifier()), this.getColumnModel().getColumn(i).getWidth());
        }
        return groupingTableLayout;
    }

    public GroupingTableConfiguration<T> getConfiguration() {
        return this.fModel.getConfiguration();
    }

    public void runAfterNextEdit(final ParameterRunnable<T> parameterRunnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTable.this.fRunAfterNextEdit = parameterRunnable;
            }
        });
    }

    public int getHorizontalLegPosition(int n) {
        int n2 = this.getFontMetrics(this.getFont()).getHeight() + 2;
        int n3 = FileTypeIcon.M.getIcon().getIconHeight() + 1;
        return Math.max(n2, n3) / 2;
    }

    public void addNotify() {
        super.addNotify();
        this.setupColumnModel(true);
    }

    public ColumnActions<T> getColumnActions() {
        return this.fColumnActions;
    }

    public void addSendHandler(SendHandler<T> sendHandler) {
        this.fTransferController.addSendHandler(sendHandler);
    }

    public void addReceiveHandler(ReceiveHandler<T> receiveHandler) {
        this.fTransferController.addReceiveHandler(receiveHandler);
    }

    public JTextField getEditorTextField() {
        return this.fEditors.get(String.class).getTextField();
    }

    public void setEditingRow(int n) {
        super.setEditingRow(n);
        if (n == -1 && this.fEditors != null && !this.fEditors.isEmpty()) {
            for (PairingEditorWrapper pairingEditorWrapper : this.fEditors.values()) {
                pairingEditorWrapper.close();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (mouseListener instanceof MouseDragGestureRecognizer) {
            this.fDragListener = (MouseDragGestureRecognizer)mouseListener;
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (mouseListener == this.fDragListener) {
            this.fDragListener = null;
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragListener != null && mouseEvent.getID() == 506 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.fDragListener.mouseDragged(mouseEvent);
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (!this.fIsSelectionLocked) {
            super.changeSelection(n, n2, bl, bl2);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.fDragListener != null) {
            int n = mouseEvent.getID();
            if (n == 501) {
                int n2 = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                int n3 = mouseEvent.getModifiers();
                boolean bl = this.isRowSelected(n2);
                boolean bl2 = (n3 & 0x10) != 0;
                this.fDragToSelectHandler.setPressedOnAlreadySelectedRow(bl);
                if (bl2 && bl && this.getSelectedRows().length > 1) {
                    this.fIsSelectionLocked = true;
                    this.fSuppressedIndex = n2;
                } else {
                    this.fSuppressedIndex = -1;
                }
            } else if (n == 502) {
                this.fDragToSelectHandler.setPressedOnAlreadySelectedRow(false);
                if (this.fSuppressedIndex != -1) {
                    MJUtilities.handleMouseReleased((MouseEvent)mouseEvent, (int)this.fSuppressedIndex, (ListSelectionModel)this.getSelectionModel());
                    this.fSuppressedIndex = -1;
                }
            }
        }
        super.processMouseEvent(mouseEvent);
        this.fIsSelectionLocked = false;
    }

    public synchronized TableCellEditor getDefaultEditor(Class<?> clazz) {
        PairingEditorWrapper pairingEditorWrapper = this.fEditors.get(clazz);
        if (pairingEditorWrapper == null) {
            for (GroupingTableColumn<T> groupingTableColumn : this.getConfiguration().getAllColumns()) {
                if (!groupingTableColumn.getType().equals(clazz) || groupingTableColumn.getEditor() == null) continue;
                pairingEditorWrapper = new PairingEditorWrapper(this, groupingTableColumn.getEditor().createCellEditor(this));
                this.fEditors.put(clazz, pairingEditorWrapper);
            }
        }
        return pairingEditorWrapper;
    }

    public GroupingTableColumn<T> getActualEditingColumn() {
        int n = this.convertColumnIndexToModel(this.getEditingColumn());
        GroupingTablePair<T> groupingTablePair = this.getConfiguration().getPair(n);
        if (groupingTablePair != null) {
            return groupingTablePair.getFirstColumn().getEditor() != null ? groupingTablePair.getFirstColumn() : groupingTablePair.getSecondColumn();
        }
        return n == -1 ? null : this.getConfiguration().getVisibleColumn(n);
    }

    protected TableCellRenderer createCellRenderer() {
        return new GroupingTableExpanderRenderer(this);
    }

    public boolean isRowVisible(GroupingTableRow<T> groupingTableRow) {
        int n = this.getRowIndex((Row)groupingTableRow);
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = this.getCellRect(n, 0, true);
        return rectangle.contains(rectangle2);
    }

    public void setEditOnClickHandler(EditOnClickHandler<T> editOnClickHandler) {
        this.fEditOnClickHandler = editOnClickHandler;
    }

    public EditOnClickHandler<T> getEditOnClickHandler() {
        return this.fEditOnClickHandler;
    }

    public boolean isRightOfIndentation(Point point) {
        int n = this.rowAtPoint(point);
        return n == -1 || point.getX() > (double)((this.getRowAt(n).getLevel() + 1) * this.getIndent());
    }

    public GroupingTableModel<T> getGroupingModel() {
        return this.fModel;
    }

    public T getItem(int n) {
        Row row = this.fModel.getRowAt(n);
        return row == null ? null : (T)((GroupingTableRow)this.fModel.getRowAt(n)).getItem();
    }

    public void addSelectionListener(GroupingTableSelectionListener<T> groupingTableSelectionListener) {
        this.fSelectionListeners.add(groupingTableSelectionListener);
    }

    public void removeSelectionListener(GroupingTableSelectionListener<T> groupingTableSelectionListener) {
        this.fSelectionListeners.remove(groupingTableSelectionListener);
    }

    public List<T> getSelectedItems() {
        ArrayList arrayList = new ArrayList();
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            for (int n : nArray) {
                GroupingTableRow groupingTableRow = (GroupingTableRow)this.fModel.getRowAt(n);
                if (groupingTableRow == null || groupingTableRow.getItem() == null) continue;
                arrayList.add(groupingTableRow.getItem());
            }
        }
        return arrayList;
    }

    public int getSortColumn() {
        return this.getConfiguration().getSortColumnIndex();
    }

    public int getSortDirection() {
        return this.getConfiguration().isSortedDescending() ? 1 : 0;
    }

    public CellSpan getCellSpanAt(SpanModel spanModel, int n, int n2) {
        return this.fModel.getCellSpanAt(n, n2);
    }

    public CellSpan getCellSpanAt(int n, int n2) {
        return this.fModel.getCellSpanAt(n, n2);
    }

    public GroupingTableRow<T> getRowAt(int n) {
        return (GroupingTableRow)super.getRowAt(n);
    }

    public T get(int n) {
        return this.getItem(n);
    }

    public NonRectangularCellRenderer setupRenderer(int n, int n2) {
        return this.setupRenderer(n, n2, false);
    }

    public NonRectangularCellRenderer setupRenderer(int n, int n2, boolean bl) {
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        GroupingTableCellRenderer groupingTableCellRenderer = GroupingTableExpanderRenderer.class.isInstance(tableCellRenderer) ? ((GroupingTableExpanderRenderer)tableCellRenderer).getGroupingTableCellRenderer() : (GroupingTableCellRenderer)tableCellRenderer;
        Component component = groupingTableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(n, n2), bl, true, n, n2);
        component.paint(this.fRendererSetupGraphics);
        return groupingTableCellRenderer;
    }

    protected ClosableToolTipData getToolTipData(MouseEvent mouseEvent) {
        ClosableToolTipData closableToolTipData;
        if (!this.isRightOfIndentation(mouseEvent.getPoint())) {
            return null;
        }
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n == -1 || n2 == -1) {
            return null;
        }
        NonRectangularCellRenderer nonRectangularCellRenderer = this.setupRenderer(n, n2);
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Point point = mouseEvent.getPoint();
        int n3 = 0;
        if (n2 < 1) {
            n3 = (this.getRowAt(n).getLevel() + 1) * this.getIndent();
        }
        point.setLocation(point.getX() - rectangle.getX() - (double)n3, point.getY() - rectangle.getY());
        boolean bl = nonRectangularCellRenderer.allowToolTip(point);
        if (!bl) {
            return null;
        }
        T t = this.getItem(n);
        if (t == null) {
            return null;
        }
        DisplayEffects displayEffects = this.fAffordanceManager.getEffects(t);
        if (displayEffects == null) {
            return null;
        }
        String string = (String)this.getColumnModel().getColumn(n2).getIdentifier();
        if (string != null && (closableToolTipData = displayEffects.getColumnSpecificToolTipData(string)) != null) {
            return closableToolTipData;
        }
        return displayEffects.getToolTipData();
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        return container instanceof JViewport && this.getPreferredSize().height < container.getHeight();
    }

    public boolean canCut() {
        return this.fTransferController.canCut();
    }

    public boolean canCopy() {
        return this.fTransferController.canCopy();
    }

    public boolean canPaste() {
        return this.fTransferController.canPaste();
    }

    public void cut() {
        this.fTransferController.cut();
    }

    public void copy() {
        this.fTransferController.copy();
    }

    public void paste() {
        this.fTransferController.paste();
    }

    private List<Component> getGroupingMenuItems() {
        Vector<Component> vector = new Vector<Component>();
        TreeSet<String> treeSet = new TreeSet<String>();
        GroupingMode<T> groupingMode = this.getConfiguration().getGroupMode();
        for (final GroupingTableColumn<T> groupingTableColumn : this.getConfiguration().getAllColumns()) {
            for (final GroupingMode<T> groupingMode2 : groupingTableColumn.getGroupingModes()) {
                if (!treeSet.add(groupingMode2.getKey())) continue;
                MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(groupingMode2.getName());
                if (groupingMode != null && groupingMode.getKey().equals(groupingMode2.getKey())) {
                    mJCheckBoxMenuItem.setSelected(true);
                }
                if (groupingTableColumn == this.getConfiguration().getGroupColumn()) {
                    mJCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            GroupingTable.this.getConfiguration().ungroup();
                        }
                    });
                } else {
                    mJCheckBoxMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            GroupingTable.this.getConfiguration().setGroupMode(groupingTableColumn, groupingMode2);
                        }
                    });
                }
                vector.add((Component)mJCheckBoxMenuItem);
            }
        }
        return vector;
    }

    private void showGroupHeaderMenu(Point point) {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)new MJAbstractAction(GroupingTableResources.getString("table.collapseAllGroups")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupingTable.this.collapseAll();
                GroupingTable.this.getConfiguration().collapseAllGroups();
            }
        });
        mJPopupMenu.add((Action)new MJAbstractAction(GroupingTableResources.getString("table.expandAllGroups")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupingTable.this.expandFirstLevel();
                GroupingTable.this.getConfiguration().expandAllGroups();
            }
        });
        mJPopupMenu.add((Action)new MJAbstractAction(GroupingTableResources.getString("table.stopGrouping")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupingTable.this.getConfiguration().ungroup();
            }
        });
        mJPopupMenu.addSeparator();
        for (Component component : this.getGroupingMenuItems()) {
            mJPopupMenu.add(component);
        }
        mJPopupMenu.show((Component)((Object)this), (int)point.getX(), (int)point.getY());
    }

    private void showTableHeaderMenu(Component component, Point point) {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDraggedColumn(null);
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((JMenuItem)this.fColumnActions.createGroupingMenu());
        mJPopupMenu.addSeparator();
        this.fColumnActions.addShowItems(mJPopupMenu);
        mJPopupMenu.show(component, (int)point.getX(), (int)point.getY());
    }

    private void installCheckBoxHandler() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n;
                GroupingTableColumn groupingTableColumn;
                Point point = mouseEvent.getPoint();
                int n2 = GroupingTable.this.rowAtPoint(point);
                int n3 = GroupingTable.this.columnAtPoint(point);
                if (n2 >= 0 && n3 >= 0 && (groupingTableColumn = GroupingTable.this.getConfiguration().getVisibleColumn(n3)).getType().equals(Boolean.class) && ((n = GroupingTable.this.getEditingColumn()) == n3 || n == -1)) {
                    GroupingTable.this.editCellAt(n2, n3);
                }
            }
        });
    }

    private void setupColumnModel(boolean bl) {
        TableColumn tableColumn;
        Object object;
        this.showVerticalAttributesAsColumnsIfWide(bl);
        TableColumn tableColumn2 = this.getTableHeader().getDraggedColumn();
        this.getTableHeader().setDraggedColumn(null);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        List<GroupingTableColumn<T>> list = this.getConfiguration().getVisibleColumns();
        for (GroupingTableColumn<T> object22 : list) {
            BaseRenderer baseRenderer;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn3 = new TableColumn(list.indexOf(object22));
            tableColumn3.setIdentifier(object22.getKey());
            linkedHashMap.put(object22, tableColumn3);
            TableCellRenderer tableCellRenderer2 = object22.getCellRenderer(true);
            if (tableCellRenderer2 != null) {
                tableColumn3.setCellRenderer(tableCellRenderer2);
            }
            if ((tableCellRenderer = object22.getSpecialHeaderRenderer((TableCellRenderer)((Object)(baseRenderer = new BaseRenderer(object22))))) != null) {
                tableColumn3.setHeaderRenderer(tableCellRenderer);
                continue;
            }
            tableColumn3.setHeaderRenderer((TableCellRenderer)((Object)new BaseSortableRenderer(object22)));
        }
        while (this.getColumnModel().getColumnCount() > 0) {
            GroupingTableColumn<T> groupingTableColumn;
            object = this.getColumnModel().getColumn(0);
            if (((TableColumn)object).getIdentifier() != null && (groupingTableColumn = this.getConfiguration().getColumnByKey(((TableColumn)object).getIdentifier().toString())) != null && !this.getConfiguration().isColumnVisible(groupingTableColumn) && this.fAddedToClient) {
                this.getConfiguration().setColumnSizeIfNotFixed(groupingTableColumn, ((TableColumn)object).getWidth());
            }
            this.getColumnModel().removeColumn((TableColumn)object);
        }
        if (this.getParent() != null && this.fAddedToClient) {
            GroupingTableUtils.restoreColumnSizes(new Converter<String, Integer>(){

                public Integer convert(String string) {
                    FontRenderContext fontRenderContext = GroupingTable.this.getGraphics() != null ? ((Graphics2D)GroupingTable.this.getGraphics()).getFontRenderContext() : new FontRenderContext(null, false, false);
                    return (int)GroupingTable.this.getFont().getStringBounds(string, fontRenderContext).getWidth() + 10;
                }
            }, this.getConfiguration(), linkedHashMap);
        }
        object = linkedHashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            this.getColumnModel().addColumn((TableColumn)entry.getValue());
            if (!this.fAddedToClient) continue;
            this.getConfiguration().setColumnSizeIfNotFixed((GroupingTableColumn)entry.getKey(), ((TableColumn)entry.getValue()).getPreferredWidth());
        }
        if (tableColumn2 != null && tableColumn2.getIdentifier() != null && (tableColumn = (TableColumn)linkedHashMap.get(object = this.getConfiguration().getColumnByKey((String)tableColumn2.getIdentifier()))) != null) {
            this.getTableHeader().setDraggedColumn(tableColumn);
        }
    }

    private void doModification(GroupingTableColumn<T> groupingTableColumn, JLabel jLabel, boolean bl) {
        if (bl) {
            jLabel.setIcon(null);
        }
        jLabel.setText(groupingTableColumn.getName());
        if (PlatformInfo.isWindows() && !PlatformInfo.isWindowsClassicAppearance()) {
            jLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
        }
    }

    private class BaseSortableRenderer
    extends SortedTableHeaderRenderer {
        private final GroupingTableColumn<T> fColumn;

        BaseSortableRenderer(GroupingTableColumn<T> groupingTableColumn) {
            this.fColumn = groupingTableColumn;
        }

        protected void modifyRenderer(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.modifyRenderer(component, jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                GroupingTable.this.doModification(this.fColumn, (JLabel)component, false);
            }
        }
    }

    private class BaseRenderer
    extends PlatformDelegatingHeaderRenderer {
        private final GroupingTableColumn<T> fColumn;

        BaseRenderer(GroupingTableColumn<T> groupingTableColumn) {
            this.fColumn = groupingTableColumn;
        }

        protected void modifyRenderer(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (component instanceof JLabel) {
                GroupingTable.this.doModification(this.fColumn, (JLabel)component, true);
            }
        }
    }

    private class TableAppearanceFocusListener
    implements AppearanceFocusListener {
        private TableAppearanceFocusListener() {
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            Color color;
            if (GroupingTable.this.fSaveSelectionBackground == null) {
                color = GroupingTable.this.getSelectionBackground();
                GroupingTable.this.setSelectionBackground(ColorUtils.getUnfocusedSelectionBackgroundColor((Component)((Object)GroupingTable.this)));
                GroupingTable.this.fSaveSelectionBackground = color;
            }
            if (GroupingTable.this.fSaveSelectionForeground == null) {
                color = GroupingTable.this.getSelectionForeground();
                GroupingTable.this.setSelectionForeground(ColorUtils.getUnfocusedSelectionForegroundColor((Component)((Object)GroupingTable.this)));
                GroupingTable.this.fSaveSelectionForeground = color;
            }
            GroupingTable.this.repaint();
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            Color color;
            if (GroupingTable.this.fSaveSelectionBackground != null) {
                color = GroupingTable.this.fSaveSelectionBackground;
                GroupingTable.this.fSaveSelectionBackground = null;
                GroupingTable.this.setSelectionBackground(color);
            }
            if (GroupingTable.this.fSaveSelectionForeground != null) {
                color = GroupingTable.this.fSaveSelectionForeground;
                GroupingTable.this.fSaveSelectionForeground = null;
                GroupingTable.this.setSelectionForeground(color);
            }
            GroupingTable.this.repaint();
        }
    }

    private class DefaultEditHandler
    implements GroupingTableModel.EditHandler<T> {
        private final Semaphore iLock = new Semaphore(1);

        private DefaultEditHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rename(T t, GroupingTableColumn<T> groupingTableColumn, String string) {
            if (this.iLock.tryAcquire()) {
                block6: {
                    int n;
                    Object t2;
                    block5: {
                        try {
                            t2 = groupingTableColumn.getEditor().edit((Component)((Object)GroupingTable.this), t, string);
                            if (t2 != null) break block5;
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DefaultEditHandler.this.iLock.release();
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
                    groupingTableTransaction.add(GroupingTableTransaction.Type.REMOVE, t);
                    groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, t2);
                    groupingTableTransaction.add(GroupingTableTransaction.Type.CHANGE, t2);
                    GroupingTable.this.getGroupingModel().applyTransactionImmediately(groupingTableTransaction);
                    if (GroupingTable.this.fRunAfterNextEdit != null) {
                        GroupingTable.this.fRunAfterNextEdit.run(t2);
                        GroupingTable.this.fRunAfterNextEdit = null;
                    }
                    if ((n = GroupingTable.this.getGroupingModel().rowIndexOf(t2)) <= -1) break block6;
                    GroupingTable.this.getSelectionModel().setSelectionInterval(n, n);
                    GroupingTable.this.scrollRowToVisible(n);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }
}

