/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJTiledPane;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropOutlinePainter;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyControlledMover;
import com.mathworks.widgets.desk.DTKeyControlledResizer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuContributor;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTiledLocation;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class DTTiledPane
extends MJTiledPane
implements DTContainer,
MJTiledPane.GridListener,
ItemListener,
DTMenuContributor,
DTDropTarget {
    private DTDocumentContainer fDocumentContainer;
    private DropTarget fDropTarget;
    private int fDropTile = -1;
    private LocationUpdater fLocationUpdater = new LocationUpdater();

    DTTiledPane(DTDocumentContainer dTDocumentContainer) {
        this.init(dTDocumentContainer);
    }

    DTTiledPane(DTDocumentContainer dTDocumentContainer, Dimension dimension) {
        super(dimension);
        this.init(dTDocumentContainer);
    }

    DTTiledPane(DTDocumentContainer dTDocumentContainer, Object object) {
        this.init(dTDocumentContainer);
        if (object != null) {
            this.restoreState(object);
        }
    }

    private void init(DTDocumentContainer dTDocumentContainer) {
        this.setName("DesktopTiledPane");
        this.setOpaque(true);
        this.fDocumentContainer = dTDocumentContainer;
        this.addContainerListener(this.fLocationUpdater);
        this.addItemListener(this);
        this.addGridListener(this);
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient = (DTClient)dTOccupant;
        if (dTLocation == null || !(dTLocation instanceof DTTiledLocation) || dTLocation.getTile() >= this.getTileCount()) {
            dTLocation = DTLocation.create(this.chooseTileForNew(dTClient));
        }
        dTLocation.setContainer(this.fDocumentContainer);
        dTLocation.setFrame(this.fDocumentContainer.getFrame());
        dTClient.setLocation(dTLocation);
        dTClient.getInternalFrame().addComponentListener(this.fLocationUpdater);
        int n = dTLocation.getTile();
        if (n == -1) {
            return;
        }
        dTClient.getInternalFrame().setMaximizeListener(this.fDocumentContainer.getMaximizeListener());
        this.add((Component)((Object)dTClient.getInternalFrame()), n);
        if (dTClient.getInternalFrame().isSelected()) {
            this.setSelectedTile(n);
        }
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        DTClient dTClient;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient2 = (DTClient)dTOccupant;
        boolean bl = dTClient2.isSelected();
        dTClient2.getInternalFrame().removeComponentListener(this.fLocationUpdater);
        this.remove((Component)((Object)dTClient2.getInternalFrame()));
        dTClient2.getInternalFrame().setMaximizeListener(null);
        int n = dTClient2.getLocation().getTile();
        DTClient dTClient3 = dTClient = n == -1 ? null : this.fillVacatedTile(n, dTClient2);
        if (bl) {
            if (dTClient != null) {
                dTClient.setSelected(true);
            } else if (n != -1) {
                this.requestFocus();
            }
        }
        if (dTClient != null) {
            dTClient.getInternalFrame().setMaximizeListener(this.fDocumentContainer.getMaximizeListener());
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        if (!(dTSelectable instanceof DTClient)) {
            return this.getNextByTile(-1);
        }
        DTLocation dTLocation = ((DTClient)dTSelectable).getLocation();
        if (!(dTLocation instanceof DTTiledLocation)) {
            return this.getNextByTile(-1);
        }
        if (bl) {
            return this.getNextByTile(dTLocation.getTile());
        }
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        if (!(dTSelectable instanceof DTClient)) {
            return this.getPreviousByTile(this.getTileCount());
        }
        DTLocation dTLocation = ((DTClient)dTSelectable).getLocation();
        if (!(dTLocation instanceof DTTiledLocation)) {
            return this.getPreviousByTile(this.getTileCount());
        }
        if (bl) {
            return this.getPreviousByTile(dTLocation.getTile());
        }
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        DTClient dTClient;
        assert (dTOccupant instanceof DTClient);
        DTClient dTClient2 = (DTClient)dTOccupant;
        int n = dTClient2.getLocation().getTile();
        if (n == -1) {
            n = this.chooseTileForSelected(dTClient2);
        }
        if (scope == DTContainer.Scope.GROUP && (dTClient = this.getClientInTile(n)) != null && dTClient.getGroup() != dTClient2.getGroup()) {
            return;
        }
        this.moveIntoTile(dTClient2, n);
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
        final KeyControlledMover keyControlledMover = new KeyControlledMover();
        keyControlledMover.activate(dTOccupant);
        keyControlledMover.startDrag(DTDragDetector.DEFAULT_THRESHOLD.width + 1, 0);
        SwingUtilities.invokeLater(new DeferredRunnable(5){

            @Override
            public void doTask() {
                keyControlledMover.startDrag(1, 0);
            }
        });
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return true;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
        new KeyControlledResizer().activate(dTOccupant, (Container)((Object)this));
    }

    int chooseTileForNew(DTClient dTClient) {
        DTGroup dTGroup;
        int n = -1;
        if (this.fDropTile != -1) {
            n = this.fDropTile;
            this.fDropTile = -1;
        }
        int n2 = this.getSelectedTile();
        if (n == -1 && n2 != -1 && this.isTileEmpty(n2)) {
            n = n2;
        }
        if (n == -1) {
            n = this.getFirstEmptyTile();
        }
        if (n == -1 && (dTGroup = dTClient.getGroup()).getDockedDocuments().size() > 0) {
            DTClient dTClient2;
            if (n2 != -1 && (dTClient2 = this.getClientInTile(n2)) != null && dTClient2.getGroup() == dTClient.getGroup()) {
                n = n2;
            }
            if (n == -1) {
                for (int i = 0; n == -1 && i < this.getTileCount(); ++i) {
                    DTClient dTClient3 = this.getClientInTile(i);
                    if (dTClient3 == null || dTClient3.getGroup() != dTGroup) continue;
                    n = i;
                }
            }
        }
        if (n == -1) {
            n = this.getSelectedTile();
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    int chooseTileForSelected(DTClient dTClient) {
        int n = dTClient.getLocation().getTile();
        if (n == -1) {
            n = this.getSelectedTile();
        }
        if (n == -1) {
            n = this.getFirstEmptyTile();
        }
        for (int i = 0; n == -1 && i < this.getTileCount(); ++i) {
            DTClient dTClient2 = this.getClientInTile(i);
            if (dTClient2 == null || dTClient2.getGroup() != dTClient.getGroup()) continue;
            n = i;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    DTClient getClientInSelectedTile() {
        int n = this.getSelectedTile();
        if (n == -1) {
            return null;
        }
        return this.getClientInTile(n);
    }

    DTClient getMostRecentOccupant(int n, DTClient dTClient) {
        List<DTClient> list = this.fDocumentContainer.getDocuments();
        DTClient dTClient2 = null;
        int n2 = -1;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            DTTiledLocation dTTiledLocation;
            DTClient dTClient3 = list.get(i);
            if (dTClient3 == dTClient || (dTTiledLocation = (DTTiledLocation)dTClient3.getLocation()) == null || dTTiledLocation.getTile() != n || dTClient3.getSelectionOrder() <= n2) continue;
            dTClient2 = dTClient3;
            n2 = dTClient3.getSelectionOrder();
        }
        return dTClient2;
    }

    DTClient getClientInTile(int n) {
        Component component = this.getComponentInTile(n);
        if (component instanceof DTClientFrame) {
            return ((DTClientFrame)((Object)component)).getClient();
        }
        return null;
    }

    private DTClient getNextByTile(int n) {
        DTClient dTClient = null;
        ++n;
        while (dTClient == null && n < this.getTileCount()) {
            dTClient = this.getClientInTile(n);
            ++n;
        }
        return dTClient;
    }

    private DTClient getPreviousByTile(int n) {
        DTClient dTClient = null;
        --n;
        while (dTClient == null && n >= 0) {
            dTClient = this.getClientInTile(n);
            --n;
        }
        return dTClient;
    }

    private void moveIntoTile(DTClient dTClient, int n) {
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)this.getComponentInTile(n));
        if (dTClientFrame == dTClient.getInternalFrame()) {
            return;
        }
        int n2 = this.getTileContaining((Component)((Object)dTClient.getInternalFrame()));
        if (n2 != -1) {
            this.remove(n2);
            this.add((Component)((Object)dTClient.getInternalFrame()), n);
            ((DTTiledLocation)dTClient.getLocation()).setTile(n);
            this.fillVacatedTile(n2, dTClient);
            dTClient.locationChanged();
        } else {
            if (dTClientFrame != null) {
                this.remove((Component)((Object)dTClientFrame));
                dTClientFrame.setSelected(false);
            }
            this.add(dTClient, DTLocation.create(n));
        }
        this.revalidate();
        this.repaint();
    }

    private DTClient fillVacatedTile(int n, DTClient dTClient) {
        DTClient dTClient2;
        Object object;
        DTClient dTClient3 = this.getMostRecentOccupant(n, dTClient);
        if (dTClient3 == null && dTClient.getGroup() != null) {
            object = dTClient.getGroup().getDockedDocuments();
            int n2 = object.size();
            for (int i = 0; i < n2 && dTClient3 == null; ++i) {
                dTClient2 = (DTClient)object.get(i);
                if (dTClient2 == dTClient || dTClient2.getLocation().getTile() != -1) continue;
                dTClient3 = dTClient2;
            }
        }
        if (dTClient3 == null) {
            object = this.fDocumentContainer.getGroupIterator();
            while (object.hasNext() && dTClient3 == null) {
                DTGroup dTGroup = (DTGroup)object.next();
                if (dTGroup == dTClient.getGroup()) continue;
                Iterator<DTClient> iterator = dTGroup.getClientIterator();
                while (iterator.hasNext() && dTClient3 == null) {
                    dTClient2 = iterator.next();
                    DTLocation dTLocation = dTClient2.getLocation();
                    if (!dTLocation.isIn(this.fDocumentContainer) || dTLocation.getTile() != -1) continue;
                    dTClient3 = dTClient2;
                }
            }
        }
        if (dTClient3 != null) {
            this.add((Component)((Object)dTClient3.getInternalFrame()), n);
            ((DTTiledLocation)dTClient3.getLocation()).setTile(n);
            dTClient3.locationChanged();
        }
        return dTClient3;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(graphics);
    }

    public void doLayout() {
        super.doLayout();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            DTLocation dTLocation = DTTiledPane.getLocationFromComponent(component);
            if (dTLocation == null) continue;
            dTLocation.setFrameBounds(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        }
    }

    public void gridSizeChanged(MJTiledPane mJTiledPane, Dimension dimension, Dimension dimension2) {
    }

    public void tilesMerged(MJTiledPane mJTiledPane, int n, int n2) {
        if (this.getTileCount() == 1) {
            return;
        }
        List<DTClient> list = this.fDocumentContainer.getDocuments();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            DTTiledLocation dTTiledLocation;
            DTClient dTClient = list.get(i);
            if (!(dTClient.getLocation() instanceof DTTiledLocation) || (dTTiledLocation = (DTTiledLocation)dTClient.getLocation()).getTile() != n2) continue;
            dTTiledLocation.setTile(n);
            dTClient.locationChanged();
        }
        this.updateLocations();
    }

    public void tileSplit(MJTiledPane mJTiledPane, int n, int n2) {
        this.updateLocations();
    }

    private void updateLocations() {
        DTTiledLocation dTTiledLocation;
        DTClient dTClient;
        int n;
        LinkedList<DTClient> linkedList = new LinkedList<DTClient>(this.fDocumentContainer.getDocuments());
        int n2 = this.getTileCount();
        for (n = 0; n < n2; ++n) {
            int n3;
            dTClient = this.getClientInTile(n);
            if (dTClient == null || !(dTClient.getLocation() instanceof DTTiledLocation) || (n3 = (dTTiledLocation = (DTTiledLocation)dTClient.getLocation()).getTile()) == n) continue;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                dTClient = (DTClient)iterator.next();
                dTTiledLocation = (DTTiledLocation)dTClient.getLocation();
                if (dTTiledLocation.getTile() != n3) continue;
                dTTiledLocation.setTile(n);
                dTClient.locationChanged();
                iterator.remove();
            }
        }
        n2 = linkedList.size();
        for (n = 0; n < n2; ++n) {
            dTClient = (DTClient)linkedList.get(n);
            if (!(dTClient.getLocation() instanceof DTTiledLocation) || (dTTiledLocation = (DTTiledLocation)dTClient.getLocation()).getTile() <= this.getTileCount()) continue;
            dTTiledLocation.setTile(-1);
            dTClient.locationChanged();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = (Integer)itemEvent.getItem();
            if (this.isTileEmpty(n)) {
                Desktop desktop = this.fDocumentContainer.getFrame().getDesktop();
                desktop.getSelectionManager().clearSelection();
            } else {
                ((DTInternalFrame)((Object)this.getComponentInTile(n))).setSelected(true);
            }
            this.ensureAtLeastSize(n, new Dimension(100, 100));
        }
    }

    @Override
    public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)this));
        this.getElementAt(point, 0, this.fElementData);
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(this.getSplitNorthSouthAction());
        jPopupMenu.add(this.getSplitEastWestAction());
        jPopupMenu.addPopupMenuListener(this.fPopupListener);
    }

    @Override
    public DTLocation getDropLocation(Object object, int n, int n2, DTLocation dTLocation) {
        int n3 = this.getTileAt(n, n2);
        if (dTLocation instanceof DTTiledLocation) {
            ((DTTiledLocation)dTLocation).setTile(n3);
        } else {
            dTLocation = new DTTiledLocation(n3);
        }
        return dTLocation;
    }

    @Override
    public String getDropHint(Object object, DTLocation dTLocation) {
        DTClient dTClient = (DTClient)object;
        if (dTLocation instanceof DTTiledLocation && dTLocation.getTile() == -1) {
            return DTDragUtilities.getToLeaveHint(dTClient);
        }
        return DTDragUtilities.getToOutlineHint(dTClient);
    }

    @Override
    public void drawDropOutline(DTLocation dTLocation) {
        int n = dTLocation.getTile();
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.getTilePixelRect(n);
        DTDragUtilities.getDropOutlinePainter().show((Component)((Object)this), rectangle.x, rectangle.y, rectangle.width, rectangle.height, DTDropOutlinePainter.OutlineType.RECTANGLE);
    }

    @Override
    public void drop(Object object, DTLocation dTLocation) {
        final DTClient dTClient = (DTClient)object;
        final int n = dTLocation.getTile();
        if (n != -1) {
            dTClient.saveFocus();
            this.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTTiledPane.this.moveIntoTile(dTClient, n);
                    dTClient.requestFocusLater();
                }
            });
        }
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new LocalDropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }

    private static DTLocation getLocationFromComponent(Component component) {
        if (!(component instanceof DTClientFrame)) {
            return null;
        }
        DTClientFrame dTClientFrame = (DTClientFrame)((Object)component);
        DTClient dTClient = dTClientFrame.getClient();
        DTLocation dTLocation = dTClient.getLocation();
        if (!(dTLocation instanceof DTTiledLocation) || dTLocation.getTile() == -1) {
            return null;
        }
        return dTLocation;
    }

    private static class LocationUpdater
    extends ComponentAdapter
    implements ContainerListener {
        private LocationUpdater() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            DTLocation dTLocation = DTTiledPane.getLocationFromComponent(componentEvent.getComponent());
            if (dTLocation != null) {
                dTLocation.setFrameLocation(componentEvent.getComponent().getX(), componentEvent.getComponent().getY());
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DTLocation dTLocation = DTTiledPane.getLocationFromComponent(componentEvent.getComponent());
            if (dTLocation != null) {
                dTLocation.setFrameSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            DTLocation dTLocation = DTTiledPane.getLocationFromComponent(containerEvent.getChild());
            if (dTLocation != null) {
                dTLocation.setFrameBounds(containerEvent.getChild().getX(), containerEvent.getChild().getY(), containerEvent.getChild().getWidth(), containerEvent.getChild().getHeight());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
        }
    }

    class LocalDropTarget
    extends DropTarget {
        LocalDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent == null) {
                return;
            }
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            Point point = dropTargetDropEvent.getLocation();
            if (component != DTTiledPane.this) {
                point = SwingUtilities.convertPoint(component, point, (Component)((Object)DTTiledPane.this));
            }
            if (point != null) {
                DTTiledPane.this.fDropTile = DTTiledPane.this.getTileAt(point);
            }
            super.drop(dropTargetDropEvent);
        }
    }

    private class KeyControlledResizer
    extends DTKeyControlledResizer {
        private KeyControlledResizer() {
        }

        @Override
        protected Point getDragStartPoint() {
            Point point = null;
            int n = DTTiledPane.this.getTileContaining(this.fInvoker);
            Rectangle rectangle = DTTiledPane.this.fTileCellRect[n];
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y + rectangle.height;
            if (n2 < ((DTTiledPane)DTTiledPane.this).fGridSize.width && n3 < ((DTTiledPane)DTTiledPane.this).fGridSize.height) {
                point = new Point(DTTiledPane.this.fColumnLeft[n2], DTTiledPane.this.fRowTop[n3]);
            } else if (rectangle.x > 0 && rectangle.y > 0) {
                point = new Point(DTTiledPane.this.fColumnLeft[rectangle.x], DTTiledPane.this.fRowTop[rectangle.y]);
            } else if (n2 < ((DTTiledPane)DTTiledPane.this).fGridSize.width && rectangle.y > 0) {
                point = new Point(DTTiledPane.this.fColumnLeft[n2], DTTiledPane.this.fRowTop[rectangle.y]);
            } else if (rectangle.x > 0 && n3 < ((DTTiledPane)DTTiledPane.this).fGridSize.height) {
                point = new Point(DTTiledPane.this.fColumnLeft[rectangle.x], DTTiledPane.this.fRowTop[n3]);
            } else {
                Rectangle rectangle2 = DTTiledPane.this.getTilePixelRect(n);
                if (n2 < ((DTTiledPane)DTTiledPane.this).fGridSize.width) {
                    point = new Point(DTTiledPane.this.fColumnLeft[n2], rectangle2.y + rectangle2.height / 4);
                } else if (rectangle.x > 0) {
                    point = new Point(DTTiledPane.this.fColumnLeft[rectangle.x], rectangle2.y + rectangle2.height / 4);
                } else if (n3 < ((DTTiledPane)DTTiledPane.this).fGridSize.height) {
                    point = new Point(rectangle2.x + rectangle2.width / 4, DTTiledPane.this.fRowTop[n3]);
                } else if (rectangle.y > 0) {
                    point = new Point(rectangle2.x + rectangle2.width / 4, DTTiledPane.this.fRowTop[rectangle.y]);
                }
            }
            if (point != null) {
                point.translate(-DTTiledPane.this.fCellSpacing / 2, -DTTiledPane.this.fCellSpacing / 2);
                SwingUtilities.convertPointToScreen(point, (Component)((Object)DTTiledPane.this));
            }
            return point;
        }
    }

    private class KeyControlledMover
    extends DTKeyControlledMover {
        private KeyControlledMover() {
        }

        protected Point getNextPoint(Point point, int n) {
            Point point2 = new Point(point);
            SwingUtilities.convertPointFromScreen(point2, (Component)((Object)DTTiledPane.this));
            int n2 = DTTiledPane.this.getTileAt(point2);
            if (n2 == -1) {
                return super.getNextPoint(point, n);
            }
            int n3 = n2;
            Rectangle rectangle = DTTiledPane.this.fTileCellRect[n2];
            switch (n) {
                case 1: {
                    if (rectangle.y <= 0) break;
                    n3 = DTTiledPane.this.fTileInCell[rectangle.y - 1][rectangle.x];
                    break;
                }
                case 5: {
                    if (rectangle.y + rectangle.height >= ((DTTiledPane)DTTiledPane.this).fGridSize.height) break;
                    n3 = DTTiledPane.this.fTileInCell[rectangle.y + rectangle.height][rectangle.x];
                    break;
                }
                case 3: {
                    if (rectangle.x + rectangle.width >= ((DTTiledPane)DTTiledPane.this).fGridSize.width) break;
                    n3 = DTTiledPane.this.fTileInCell[rectangle.y][rectangle.x + rectangle.width];
                    break;
                }
                case 7: {
                    if (rectangle.x <= 0) break;
                    n3 = DTTiledPane.this.fTileInCell[rectangle.y][rectangle.x - 1];
                }
            }
            if (n3 == n2) {
                return point;
            }
            Rectangle rectangle2 = DTTiledPane.this.getTilePixelRect(n3);
            Point point3 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            SwingUtilities.convertPointToScreen(point3, (Component)((Object)DTTiledPane.this));
            return point3;
        }
    }
}

