/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTUtilities;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class DTSplitPane
extends MJSplitPane
implements DTContainer {
    private boolean fDoLayoutHasBeenCalled;
    private int fPendingFirstComponentSize;
    private int fPendingSecondComponentSize;
    private int fPendingMinimumSize;

    DTSplitPane(int n) {
        super(n, true);
        this.setName("DesktopSplitPane");
        if (!PlatformInfo.isMacintosh()) {
            this.setDividerSize(4);
        }
        LinkedList<KeyStroke> linkedList = new LinkedList<KeyStroke>();
        linkedList.add(KeyStroke.getKeyStroke(9, 2));
        linkedList.add(KeyStroke.getKeyStroke(9, 3));
        if (PlatformInfo.isMacintosh()) {
            linkedList.add(KeyStroke.getKeyStroke(119, 0));
        }
        DTUtilities.blockKeyboardInputs((JComponent)((Object)this), linkedList.toArray(new KeyStroke[linkedList.size()]));
    }

    public void setUI(SplitPaneUI splitPaneUI) {
        super.setUI(splitPaneUI);
        this.setBorder(BorderFactory.createEmptyBorder());
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)splitPaneUI).getDivider();
            basicSplitPaneDivider.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    void setFirstComponentSize(int n, int n2) {
        int n3;
        int n4 = n3 = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        if (n3 <= 0) {
            this.fPendingFirstComponentSize = n;
            this.fPendingMinimumSize = n2;
        } else {
            this.setFirstComponentSize(n3, n, n2);
        }
    }

    private void setFirstComponentSize(int n, int n2, int n3) {
        int n4;
        Insets insets = this.getInsets();
        if (this.getOrientation() == 1) {
            n4 = n2 + insets.left;
            if (n4 + n3 + this.getDividerSize() + insets.right > n) {
                n4 = n - n3 - this.getDividerSize() - insets.right;
            }
        } else {
            n4 = n2 + insets.top;
            if (n4 + n3 + this.getDividerSize() + insets.bottom > n) {
                n4 = n - n3 - this.getDividerSize() - insets.bottom;
            }
        }
        this.setDividerLocation(n4);
    }

    void setSecondComponentSize(int n, int n2) {
        int n3;
        int n4 = n3 = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        if (n3 <= 0) {
            this.fPendingSecondComponentSize = n;
            this.fPendingMinimumSize = n2;
        } else {
            this.setSecondComponentSize(n3, n, n2);
        }
    }

    private void setSecondComponentSize(int n, int n2, int n3) {
        int n4;
        Insets insets = this.getInsets();
        if (this.getOrientation() == 1) {
            int n5 = n - insets.left - insets.right;
            n4 = n5 - n2 - this.getDividerSize() - insets.right;
            if (n4 < n3) {
                n4 = n3;
            }
        } else {
            int n6 = n - insets.top - insets.bottom;
            n4 = n6 - n2 - this.getDividerSize() - insets.bottom;
            if (n4 < n3) {
                n4 = n3;
            }
        }
        this.setDividerLocation(n4);
    }

    public void doLayout() {
        int n;
        int n2 = n = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        if (n > 0 && this.fPendingFirstComponentSize > 0) {
            this.setFirstComponentSize(n, this.fPendingFirstComponentSize, this.fPendingMinimumSize);
            this.fPendingFirstComponentSize = 0;
        }
        if (n > 0 && this.fPendingSecondComponentSize > 0) {
            this.setSecondComponentSize(n, this.fPendingSecondComponentSize, this.fPendingMinimumSize);
            this.fPendingSecondComponentSize = 0;
        }
        double d = this.fPendingDividerProportion;
        super.doLayout();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof DTFrame && ((DTFrame)((Object)window)).isMaximizePending()) {
            this.fPendingDividerProportion = d;
        }
        if (!this.fDoLayoutHasBeenCalled && this.getWidth() > 0 && this.getHeight() > 0) {
            this.fDoLayoutHasBeenCalled = true;
            this.setProportionalResizeEnabled(true);
            this.setDividerLocation(this.getDividerLocation());
        }
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        if (dTLocation instanceof DTNestedLocation) {
            DTNestedLocation dTNestedLocation = (DTNestedLocation)dTLocation;
            int n = dTNestedLocation.getDirection(dTNestedLocation.getPathLength() - 1);
            this.add((Component)((Object)dTOccupant.getInternalFrame()), n);
        }
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        if (this.getLeftComponent() == dTOccupant.getInternalFrame()) {
            this.setLeftComponent(null);
        } else if (this.getRightComponent() == dTOccupant.getInternalFrame()) {
            this.setRightComponent(null);
        }
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        if (dTSelectable == null) {
            DTContainer dTContainer = (DTContainer)((Object)this.getLeftComponent());
            DTSelectable dTSelectable2 = dTContainer.getNext(dTSelectable, bl);
            if (dTSelectable2 == null && dTContainer instanceof DTDocumentContainer) {
                dTSelectable2 = ((DTContainer)((Object)this.getRightComponent())).getNext(null, bl);
            }
            return dTSelectable2;
        }
        Object object = null;
        if (dTSelectable instanceof DTOccupant) {
            object = ((DTOccupant)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof Component) {
            object = (Component)((Object)dTSelectable);
        }
        if (object != null && SwingUtilities.isDescendingFrom((Component)object, this.getLeftComponent())) {
            return ((DTContainer)((Object)this.getRightComponent())).getNext(null, bl);
        }
        return null;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        if (dTSelectable == null) {
            DTContainer dTContainer = (DTContainer)((Object)this.getRightComponent());
            DTSelectable dTSelectable2 = dTContainer.getPrevious(dTSelectable, bl);
            if (dTSelectable2 == null && dTContainer instanceof DTDocumentContainer) {
                dTSelectable2 = ((DTContainer)((Object)this.getLeftComponent())).getPrevious(null, bl);
            }
            return dTSelectable2;
        }
        Object object = null;
        if (dTSelectable instanceof DTOccupant) {
            object = ((DTOccupant)dTSelectable).getInternalFrame();
        } else if (dTSelectable instanceof Component) {
            object = (Component)((Object)dTSelectable);
        }
        if (object != null && SwingUtilities.isDescendingFrom((Component)object, this.getRightComponent())) {
            return ((DTContainer)((Object)this.getLeftComponent())).getPrevious(null, bl);
        }
        return null;
    }

    @Override
    public void replaceChild(Component component, Component component2) {
        int n = this.getDividerLocation();
        if (this.getLeftComponent() == component) {
            this.setLeftComponent(component2);
        } else if (this.getRightComponent() == component) {
            this.setRightComponent(component2);
        }
        this.setDividerLocation(n);
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
    }

    @Override
    public boolean canMoveWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyMove(DTOccupant dTOccupant) {
    }

    @Override
    public boolean canResizeWithKeys(DTOccupant dTOccupant) {
        return false;
    }

    @Override
    public void startKeyResize(DTOccupant dTOccupant) {
    }

    void setComponent(Component component, int n) {
        switch (n) {
            case 1: {
                this.setTopComponent(component);
                break;
            }
            case 5: {
                this.setBottomComponent(component);
                break;
            }
            case 3: {
                this.setRightComponent(component);
                break;
            }
            case 7: {
                this.setLeftComponent(component);
            }
        }
    }

    void setUnoccupiedComponent(Component component) {
        if (this.getLeftComponent() == null) {
            this.setLeftComponent(component);
        } else if (this.getRightComponent() == null) {
            this.setRightComponent(component);
        }
    }

    Component getOtherComponent(Component component) {
        return component == this.getLeftComponent() ? this.getRightComponent() : this.getLeftComponent();
    }
}

