/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class DTNotifyingList<E>
extends ArrayList<E> {
    private List<Listener<E>> fListeners = new ArrayList<Listener<E>>();
    private Comparator<E> fComparator;
    private boolean fIsOrdered;

    DTNotifyingList() {
    }

    void addListener(Listener<E> listener) {
        this.fListeners.add(listener);
    }

    void removeListener(Listener<E> listener) {
        this.fListeners.remove(listener);
    }

    void setOrder(boolean bl) {
        if (bl != this.fIsOrdered) {
            if (!bl && this.fComparator != null) {
                return;
            }
            this.fIsOrdered = bl;
            this.updateOrder();
        }
    }

    void setOrder(Comparator<E> comparator) {
        if (this.fComparator != comparator) {
            this.fComparator = comparator;
            this.fIsOrdered = comparator != null;
            this.updateOrder();
        }
    }

    boolean isOrdered() {
        return this.fIsOrdered;
    }

    @Override
    public boolean add(E e) {
        int n;
        if (this.fIsOrdered && e instanceof Comparable || this.fComparator != null) {
            for (n = this.size(); n > 0 && !(this.fComparator != null ? this.fComparator.compare(e, this.get(n - 1)) > 0 : ((Comparable)e).compareTo(this.get(n - 1)) > 0); --n) {
            }
            super.add(n, e);
        } else {
            n = this.size();
            super.add(e);
        }
        for (Listener<E> listener : this.fListeners) {
            listener.objectAdded(this, e, n);
        }
        return true;
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        for (Listener<E> listener : this.fListeners) {
            listener.objectAdded(this, e, n);
        }
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        for (Listener<Object> listener : this.fListeners) {
            listener.objectRemoved(this, object, n);
        }
        return true;
    }

    void move(int n, int n2) {
        Object e = this.get(n);
        this.remove(n);
        super.add(n2, e);
        for (Listener listener : this.fListeners) {
            listener.objectMoved(this, e, n, n2);
        }
    }

    void updateOrder() {
        if (this.fIsOrdered) {
            if (this.fComparator != null) {
                Collections.sort(this, this.fComparator);
            } else {
                Collections.sort(this);
            }
            for (Listener<E> listener : this.fListeners) {
                listener.objectsReordered(this);
            }
        }
    }

    static interface Listener<E> {
        public void objectAdded(DTNotifyingList var1, E var2, int var3);

        public void objectRemoved(DTNotifyingList var1, E var2, int var3);

        public void objectMoved(DTNotifyingList var1, E var2, int var3, int var4);

        public void objectsReordered(DTNotifyingList<E> var1);
    }
}

