/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJMenu;
import com.mathworks.toolstrip.accessories.CollapseToolstripAction;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLayoutActions;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.Desktop;
import javax.swing.Action;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class DTLayoutMenu
extends MJMenu
implements MenuListener {
    private final Desktop fDesktop;
    private final DTFrame fFrame;

    DTLayoutMenu(Desktop desktop, DTFrame dTFrame) {
        super(desktop.getString("menu.DesktopLayout"));
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.setName("LayouytMenu");
        this.addMenuListener(this);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        DTLayoutLibrary dTLayoutLibrary = this.fDesktop.getLayoutLibrary();
        boolean bl = dTLayoutLibrary.factoryLayoutCount() > 0;
        int n = dTLayoutLibrary.layoutCount();
        for (int i = 0; i < n; ++i) {
            if (bl && dTLayoutLibrary.isUserLayout(i)) {
                this.addSeparator();
                bl = false;
            }
            this.add((Action)((Object)new DTLayoutActions.RestoreAction(this.fDesktop, i)));
        }
        if (this.fDesktop.useToolstrip()) {
            this.addSeparator();
            this.add((Action)((Object)new DTLayoutActions.SaveAction(this.fDesktop)));
            DTLayoutActions.OrganizeAction organizeAction = new DTLayoutActions.OrganizeAction(this.fDesktop);
            organizeAction.setEnabled(this.fDesktop.getLayoutLibrary().userLayoutCount() > 0);
            this.add((Action)((Object)organizeAction));
            if (this.fFrame.usingToolstrip()) {
                this.addSeparator();
                this.add((Action)new CollapseToolstripAction(this.fFrame.getToolstrip()));
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        this.removeAll();
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.menuDeselected(menuEvent);
    }
}

