/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MouseInputLatch;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTComponentResizer;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFloatingPane;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTTitleBar;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

class DTFloatingFrame {
    private DTFloatingPane fFloatingPane;
    private DTClient fClient;
    private DTInternalFrame fInternalFrame;
    private Panel fHeavyParent;
    private MouseInputListener fTitleBarListener;
    private MouseInputListener fBorderListener;
    private ItemListener fSelectionListener;
    private boolean fNeedsHeavyParent;

    DTFloatingFrame(DTFloatingPane dTFloatingPane, DTClient dTClient, ActionListener actionListener) {
        this.fFloatingPane = dTFloatingPane;
        this.fClient = dTClient;
        this.fInternalFrame = dTClient.getInternalFrame();
        this.fNeedsHeavyParent = this.fClient.treatAsHeavyweight();
        this.fInternalFrame.setBorderVisible(true);
        this.fInternalFrame.setMinimizeListener(new FrameMinimizer());
        this.fInternalFrame.setMaximizeListener(actionListener);
        this.fTitleBarListener = new MouseInputLatch((MouseInputListener)((Object)new Mover()));
        this.fInternalFrame.getTitleBar().addMouseListener(this.fTitleBarListener);
        this.fInternalFrame.getTitleBar().addMouseMotionListener(this.fTitleBarListener);
        this.fBorderListener = new MouseInputLatch((MouseInputListener)new Resizer());
        this.fInternalFrame.addMouseListener(this.fBorderListener);
        this.fInternalFrame.addMouseMotionListener(this.fBorderListener);
        this.fSelectionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DTFloatingFrame.this.toFront();
                }
            }
        };
        this.fInternalFrame.addItemListener(this.fSelectionListener);
    }

    DTClient getClient() {
        return this.fClient;
    }

    DTInternalFrame getInternalFrame() {
        return this.fInternalFrame;
    }

    Component getFloatingComponent() {
        if (this.fFloatingPane.isHeavy()) {
            if (this.fHeavyParent == null) {
                this.fHeavyParent = new Panel(){

                    @Override
                    public void doLayout() {
                        DTFloatingFrame.this.fInternalFrame.setBounds(0, 0, this.getWidth(), this.getHeight());
                    }

                    @Override
                    public void update(Graphics graphics) {
                        this.paint(graphics);
                    }
                };
                this.fHeavyParent.setBackground(this.fInternalFrame.getBackground());
                this.fHeavyParent.add((Component)((Object)this.fInternalFrame));
            }
            return this.fHeavyParent;
        }
        if (this.fHeavyParent != null) {
            this.fHeavyParent.remove((Component)((Object)this.fInternalFrame));
            this.fHeavyParent = null;
        }
        return this.fInternalFrame;
    }

    static DTClient clientInFloatingComponent(Component component) {
        if (component instanceof DTClientFrame) {
            return ((DTClientFrame)((Object)component)).getClient();
        }
        if (component instanceof Panel) {
            Component component2 = ((Panel)component).getComponent(0);
            if (component2 instanceof DTClientFrame) {
                return ((DTClientFrame)((Object)component2)).getClient();
            }
            return null;
        }
        return null;
    }

    boolean needsHeavyParent() {
        return this.fNeedsHeavyParent;
    }

    void dispose() {
        this.fInternalFrame.setBorderVisible(false);
        this.fInternalFrame.setMinimizeListener(null);
        this.fInternalFrame.setMaximizeListener(null);
        this.fInternalFrame.setVisible(true);
        this.fInternalFrame.getTitleBar().removeMouseListener(this.fTitleBarListener);
        this.fInternalFrame.getTitleBar().removeMouseMotionListener(this.fTitleBarListener);
        this.fInternalFrame.removeMouseListener(this.fBorderListener);
        this.fInternalFrame.removeMouseMotionListener(this.fBorderListener);
        this.fInternalFrame.removeItemListener(this.fSelectionListener);
        if (this.fHeavyParent != null) {
            this.fHeavyParent.remove((Component)((Object)this.fInternalFrame));
            this.fHeavyParent = null;
        }
        this.fInternalFrame = null;
        this.fClient = null;
    }

    public void toFront() {
        this.fFloatingPane.toFront(this.fClient, DTContainer.Scope.FRAME);
    }

    public boolean isInFront() {
        return this.fFloatingPane.isInFront(this.fClient);
    }

    class MouseRedirector
    implements AWTEventListener {
        Component fTargetComponent;
        MouseInputAdapter fListener;

        MouseRedirector(Component component, MouseInputAdapter mouseInputAdapter) {
            this.fTargetComponent = component;
            this.fListener = mouseInputAdapter;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getComponent() == this.fTargetComponent) {
                    return;
                }
                switch (aWTEvent.getID()) {
                    case 502: {
                        this.fListener.mouseReleased(mouseEvent);
                        break;
                    }
                    case 506: {
                        this.fListener.mouseDragged(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }
    }

    class Resizer
    extends DTComponentResizer {
        private AWTEventListener fRedirector;
        private Dimension fMinimumSize;

        Resizer() {
        }

        @Override
        protected Component getComponentToResize() {
            return DTFloatingFrame.this.getFloatingComponent();
        }

        @Override
        protected Insets getResizeInsets() {
            if (DTFloatingFrame.this.fInternalFrame != null) {
                return DTFloatingFrame.this.fInternalFrame.getInsets();
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected Dimension getMinimumSize() {
            if (this.fMinimumSize == null) {
                Insets insets = DTFloatingFrame.this.fInternalFrame.getInsets();
                DTTitleBar dTTitleBar = DTFloatingFrame.this.fInternalFrame.getTitleBar();
                this.fMinimumSize = dTTitleBar.getPreferredSize();
                this.fMinimumSize.height += insets.top + insets.bottom;
                this.fMinimumSize.width = 100;
            }
            return this.fMinimumSize;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (DTFloatingFrame.this.fInternalFrame == null) {
                return;
            }
            DTFloatingFrame.this.fInternalFrame.setSelected(true);
            super.mousePressed(mouseEvent);
            if (PlatformInfo.isUnix() && DTFloatingFrame.this.fFloatingPane.isHeavy()) {
                this.fRedirector = new MouseRedirector(mouseEvent.getComponent(), this);
                Toolkit.getDefaultToolkit().addAWTEventListener(this.fRedirector, 48L);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)DTFloatingFrame.this.fClient.getLocation();
            dTFloatingLocation.setFrameBounds(this.getComponentToResize().getBounds());
            DTFloatingFrame.this.fClient.locationChanged();
            if (this.fRedirector != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fRedirector);
                this.fRedirector = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)DTFloatingFrame.this.fClient.getLocation();
            dTFloatingLocation.setFrameBounds(this.getComponentToResize().getBounds());
            DTFloatingFrame.this.fClient.locationChanged();
        }
    }

    class Mover
    extends ComponentMover {
        private AWTEventListener fRedirector;

        Mover() {
        }

        protected Component getComponentToMove() {
            return DTFloatingFrame.this.getFloatingComponent();
        }

        protected boolean performSmoothing() {
            return PlatformInfo.isXWindows() && DTFloatingFrame.this.fFloatingPane.isHeavy();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (DTFloatingFrame.this.fInternalFrame == null) {
                return;
            }
            DTFloatingFrame.this.fInternalFrame.setSelected(true);
            super.mousePressed(mouseEvent);
            if (PlatformInfo.isUnix() && DTFloatingFrame.this.fFloatingPane.isHeavy()) {
                this.fRedirector = new MouseRedirector(mouseEvent.getComponent(), (MouseInputAdapter)((Object)this));
                Toolkit.getDefaultToolkit().addAWTEventListener(this.fRedirector, 48L);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)DTFloatingFrame.this.fClient.getLocation();
            dTFloatingLocation.setFrameLocation(this.getComponentToMove().getX(), this.getComponentToMove().getY());
            DTFloatingFrame.this.fClient.locationChanged();
            if (this.fRedirector != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fRedirector);
                this.fRedirector = null;
            }
        }

        protected void moveComponent(Point point) {
            super.moveComponent(point);
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)DTFloatingFrame.this.fClient.getLocation();
            dTFloatingLocation.setFrameLocation(this.getComponentToMove().getX(), this.getComponentToMove().getY());
            DTFloatingFrame.this.fClient.locationChanged();
        }
    }

    class FrameMinimizer
    implements ActionListener {
        FrameMinimizer() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DTFloatingFrame.this.getFloatingComponent().setVisible(false);
            DTFloatingFrame.this.fClient.setSelected(false);
            ((DTFloatingLocation)DTFloatingFrame.this.fClient.getLocation()).setMinimized(true);
            DTFloatingFrame.this.fFloatingPane.selectTopMost();
        }
    }
}

