/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;
import org.apache.commons.lang.Validate;

public class SyntaxTextLabel
extends MJLabel {
    public static final int PLAIN_STYLE = -1;
    public static final int M_STYLE = 0;
    public static final int JAVA_STYLE = 1;
    public static final int C_STYLE = 2;
    public static final int HTML_STYLE = 3;
    private Tokenizer fTokenizer;
    private final ColoredBasicLabelUI fMyUI;
    private Object[] fTokens;
    private boolean fSelected;
    private boolean fUnderlined;

    public SyntaxTextLabel(int n) {
        this(SyntaxTextLabel.getTokenizer(n), "");
    }

    public SyntaxTextLabel(String string, int n) {
        this(SyntaxTextLabel.getTokenizer(n), string);
    }

    public SyntaxTextLabel(Tokenizer tokenizer, String string) {
        Validate.notNull((Object)tokenizer, (String)"'tokenizer' cannot be null");
        this.fTokenizer = tokenizer;
        this.fMyUI = new ColoredBasicLabelUI();
        this.setUI(this.fMyUI);
        this.setText(string);
    }

    private static Tokenizer getTokenizer(int n) {
        if (n == 0) {
            return TokenizerFactory.getMTokenizer();
        }
        if (n == 2) {
            return TokenizerFactory.getCTokenizer();
        }
        if (n == 1) {
            return TokenizerFactory.getJavaTokenizer();
        }
        if (n == 3) {
            return TokenizerFactory.getXMLTokenizer();
        }
        if (n == -1) {
            return TokenizerFactory.getPlainTokenizer();
        }
        throw new IllegalArgumentException("type " + n + " is invalid");
    }

    public void updateUI() {
        this.setUI(this.fMyUI);
        this.invalidate();
    }

    public void setSyntaxType(int n) {
        this.setTokenizer(SyntaxTextLabel.getTokenizer(n));
    }

    public void setTokenizer(Tokenizer tokenizer) {
        Validate.notNull((Object)tokenizer, (String)"'tokenizer' cannot be null");
        this.fTokenizer = tokenizer;
        this.fTokens = this.getStringTokens(this.getText());
    }

    public void setUnderlined(boolean bl) {
        this.fUnderlined = bl;
    }

    private Object[] getStringTokens(String string) {
        return SyntaxTextLabel.getStringTokens(string, this.fTokenizer);
    }

    public void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public void setText(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.fTokens = this.getStringTokens(string);
        super.setText(string, bl);
    }

    public String getCharAtPosition(int n, int n2) {
        return this.getCharAtPosition(n);
    }

    public String getCharAtPosition(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Point point = this.fMyUI.getPosition();
        String string = this.getText();
        int n2 = point.x + fontMetrics.stringWidth(string);
        int n3 = 0;
        int n4 = 0;
        int n5 = point.x;
        while (n3 != -1 && n5 < n2) {
            if ((n5 += fontMetrics.charWidth(string.charAt(n4))) > n) {
                n3 = -1;
            } else {
                ++n4;
            }
            if (n5 <= n2) continue;
            n4 = -1;
            n3 = -1;
        }
        if (n4 == -1 || n4 >= string.length()) {
            return null;
        }
        return string.substring(n4, n4 + 1);
    }

    public static Object[] getStringTokens(String string, int n) {
        return SyntaxTextLabel.getStringTokens(string, SyntaxTextLabel.getTokenizer(n));
    }

    public static Object[] getStringTokens(String string, Tokenizer tokenizer) {
        Validate.notNull((Object)string, (String)"'text' cannot be null");
        Tokenizer.TokenInfo[] tokenInfoArray = tokenizer == null ? TokenizerFactory.getPlainTokenizer().tokenize(string) : tokenizer.tokenize(string);
        return SyntaxTextLabel.convertToOffsetColorArray(tokenInfoArray);
    }

    public static Object[] convertToOffsetColorArray(Tokenizer.TokenInfo[] tokenInfoArray) {
        int[] nArray = new int[tokenInfoArray.length];
        String[] stringArray = new String[tokenInfoArray.length];
        for (int i = 0; i < tokenInfoArray.length; ++i) {
            nArray[i] = tokenInfoArray[i].getOffset();
            stringArray[i] = tokenInfoArray[i].getColor() == null ? null : tokenInfoArray[i].getColorPreferenceName();
        }
        return new Object[]{nArray, stringArray};
    }

    public static void paintFromTokens(Object[] objectArray, FontMetrics fontMetrics, JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        int[] nArray = (int[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        int n4 = n + nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            graphics.setColor(SyntaxTextLabel.getColorFromPrefs(stringArray[i]));
            if (i < nArray.length - 1) {
                if (string.length() < nArray[i]) continue;
                int n5 = Math.min(nArray[i + 1], string.length());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string.substring(nArray[i], n5), n3, n4, n2);
                n4 = n + fontMetrics.stringWidth(string.substring(nArray[0], n5));
                continue;
            }
            if (string.length() < nArray[i]) continue;
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string.substring(nArray[i], string.length()), n3, n4, n2);
            n4 = n + fontMetrics.stringWidth(string.substring(nArray[0], string.length()));
        }
    }

    private static Color getColorFromPrefs(String string) {
        if (string == null) {
            return ColorPrefs.getTextColor();
        }
        return TokenizerFactory.getColorFromName(string);
    }

    private class ColoredBasicLabelUI
    extends BasicLabelUI {
        private int fX;
        private int fY;

        private ColoredBasicLabelUI() {
        }

        public Point getPosition() {
            return new Point(this.fX, this.fY);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
            if (renderingHints != null) {
                ((Graphics2D)graphics).addRenderingHints(renderingHints);
            }
            super.paint(graphics, jComponent);
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            this.fX = n;
            this.fY = n2;
            graphics.setColor(jLabel.getForeground());
            if (SyntaxTextLabel.this.fTokens == null || ((int[])SyntaxTextLabel.this.fTokens[0]).length == 0 || SyntaxTextLabel.this.fSelected) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, jLabel.getDisplayedMnemonicIndex(), n, n2);
            } else {
                SyntaxTextLabel.paintFromTokens(SyntaxTextLabel.this.fTokens, SyntaxTextLabel.this.getFontMetrics(SyntaxTextLabel.this.getFont()), jLabel, graphics, string, n, n2);
            }
            if (SyntaxTextLabel.this.fUnderlined) {
                graphics.drawLine(n, n2 + 2, n + SyntaxTextLabel.this.getFontMetrics(SyntaxTextLabel.this.getFont()).stringWidth(string), n2 + 2);
            }
        }
    }
}

