/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.PanelMenuItemUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.MenuItemUI;
import org.apache.commons.lang.Validate;

public class DropdownButton
extends MJButton {
    protected MJPopupMenu menu;
    protected Object value;
    private PopupMenuCustomizer fCustomizer;
    private boolean fInternalAction;
    private boolean fShowMenuAutomatically = true;
    private JComponent fComponentToAlignWith = this;
    private PopupAlignment fPopupAlignment = PopupAlignment.LEFT;
    private static final int POPUP_MENU_OFFSET_PX = 2;

    public DropdownButton() {
        this.init();
        this.initAsToolbarButton();
        this.setupButton();
        this.setIcon(null);
    }

    public DropdownButton(Action action) {
        super(action);
        this.init();
        this.initAsToolbarButton();
        this.setupButton();
        this.setIcon(null);
        this.setDisabledIcon(null);
    }

    public DropdownButton(String string) {
        super(string);
        this.init();
        this.setupButton();
        this.setIcon(null);
    }

    public DropdownButton(Icon icon) {
        this.init();
        this.setupButton();
        this.setIcon(icon);
    }

    public DropdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        this.fCustomizer = popupMenuCustomizer;
        this.init();
        this.setupButton();
        this.setIcon(icon);
    }

    private void init() {
        this.menu = new MJPopupMenu();
    }

    private void initAsToolbarButton() {
        if (PlatformInfo.getAppearance() == 0) {
            this.setMargin(new Insets(8, 6, 6, 6));
        } else {
            this.setMargin(new Insets(1, 2, 1, 2));
        }
        this.setDefaultCapable(false);
    }

    private void setupButton() {
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DropdownButton.this.fInternalAction && DropdownButton.this.isEnabled()) {
                    if (!DropdownButton.this.menu.isVisible()) {
                        DropdownButton.this.postMenu();
                    } else {
                        DropdownButton.this.hideMenu();
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (DropdownButton.this.isEnabled() && keyEvent.getKeyCode() == 40) {
                    DropdownButton.this.postMenu();
                    keyEvent.consume();
                }
            }
        });
        Object object = new JComboBox().getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", object);
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    protected void postMenu() {
        if (this.fCustomizer != null) {
            this.fCustomizer.customize((JPopupMenu)this.menu);
        }
        if (this.fShowMenuAutomatically) {
            this.doPostMenu();
        }
    }

    public void showMenu() {
        this.doPostMenu();
    }

    public void setShowMenuAutomatically(boolean bl) {
        this.fShowMenuAutomatically = bl;
    }

    private void doPostMenu() {
        this.menu.setName(this.getName() + "Menu");
        JComponent jComponent = this.getComponentToAlignWith();
        Rectangle rectangle = jComponent.getBounds();
        Insets insets = (Insets)jComponent.getClientProperty("visualMargin");
        int n = insets == null ? 0 : insets.bottom;
        int n2 = this.fPopupAlignment.calculateXPosition(jComponent, rectangle.width, this.menu.getPreferredSize().width);
        int n3 = rectangle.height - n + 2;
        this.menu.show((Component)jComponent, n2, n3);
        this.fShowMenuAutomatically = true;
    }

    public JComponent getComponentToAlignWith() {
        return this.fComponentToAlignWith;
    }

    public void setComponentToAlignWith(JComponent jComponent) {
        this.fComponentToAlignWith = jComponent;
    }

    protected void setupMenu() {
        this.menu = new MJPopupMenu();
    }

    protected static MJMenuItem createPanelMenuItem(String string) {
        return DropdownButton.createPanelMenuItem(string, null);
    }

    protected static MJMenuItem createPanelMenuItem(Icon icon) {
        return DropdownButton.createPanelMenuItem(null, icon);
    }

    protected static MJMenuItem createPanelMenuItem(String string, Icon icon) {
        String string2 = string;
        if (string != null && icon != null) {
            string2 = "  " + string;
        }
        MJMenuItem mJMenuItem = new MJMenuItem(string2, icon);
        DropdownButton.setupItemUI(mJMenuItem);
        return mJMenuItem;
    }

    private static void setupItemUI(MJMenuItem mJMenuItem) {
        mJMenuItem.setMargin(new Insets(2, 2, 2, 2));
        mJMenuItem.setUI((MenuItemUI)new PanelMenuItemUI());
    }

    private void hideMenu() {
        this.menu.setVisible(false);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.fireItemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, this.value, 2));
        this.value = object;
        this.revalidate();
        this.repaint();
        this.fireItemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, this.value, 1));
        this.fInternalAction = true;
        this.fireActionPerformed(new ActionEvent((Object)this, 1001, ""));
        this.fInternalAction = false;
    }

    public void setValueWithoutEvents(Object object) {
        this.value = object;
        this.revalidate();
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.value};
    }

    public void setIcon(Icon icon) {
        ArrowIcon arrowIcon = new ArrowIcon(icon);
        super.setIcon((Icon)arrowIcon);
    }

    public void setDisabledIcon(Icon icon) {
        ArrowIcon arrowIcon = new ArrowIcon(icon);
        super.setDisabledIcon((Icon)arrowIcon);
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.fCustomizer = popupMenuCustomizer;
    }

    public void setPopupMenuAlignment(PopupAlignment popupAlignment) {
        Validate.notNull((Object)"The alignment cannot be null.");
        this.fPopupAlignment = popupAlignment;
    }

    private static Icon getEnabledArrowIcon() {
        return MJUtilities.isHighContrast() ? MiscellaneousIcon.DROP_DOWN_ARROW_HIGH_CONTRAST_5x3.getIcon() : MiscellaneousIcon.DROP_DOWN_ARROW_5x3.getIcon();
    }

    private static Icon getDisabledArrowIcon() {
        return MiscellaneousIcon.DROP_DOWN_ARROW_DISABLED_5x3.getIcon();
    }

    public static enum PopupAlignment {
        LEFT{

            @Override
            int calculateXPosition(JComponent jComponent, int n, int n2) {
                Insets insets = (Insets)jComponent.getClientProperty("visualMargin");
                int n3 = insets == null ? 0 : insets.left;
                return n3 + 2;
            }
        }
        ,
        RIGHT{

            @Override
            int calculateXPosition(JComponent jComponent, int n, int n2) {
                Insets insets = (Insets)jComponent.getClientProperty("visualMargin");
                int n3 = insets == null ? 0 : insets.right;
                return -n2 + n - n3 - 2;
            }
        };


        abstract int calculateXPosition(JComponent var1, int var2, int var3);
    }

    private class ArrowIcon
    implements Icon {
        private final Icon fBaseIcon;
        private static final int SPACE_BETWEEN = 2;

        ArrowIcon(Icon icon) {
            this.fBaseIcon = icon;
        }

        private Icon getArrowIcon() {
            return DropdownButton.this.isEnabled() ? DropdownButton.getEnabledArrowIcon() : DropdownButton.getDisabledArrowIcon();
        }

        @Override
        public int getIconHeight() {
            return this.fBaseIcon == null ? this.getArrowIcon().getIconHeight() : Math.max(this.fBaseIcon.getIconHeight(), this.getArrowIcon().getIconWidth());
        }

        @Override
        public int getIconWidth() {
            return this.fBaseIcon == null ? this.getArrowIcon().getIconWidth() : this.fBaseIcon.getIconWidth() + 2 + this.getArrowIcon().getIconWidth();
        }

        private int getArrowX() {
            return this.fBaseIcon == null ? 0 : this.fBaseIcon.getIconWidth() + 2;
        }

        private int getArrowY() {
            return this.fBaseIcon == null ? 0 : this.getIconHeight() / 2 - this.getArrowIcon().getIconHeight() / 2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.fBaseIcon != null) {
                this.fBaseIcon.paintIcon(component, graphics, n, n2);
            }
            this.getArrowIcon().paintIcon(component, graphics, n + this.getArrowX(), n2 + this.getArrowY());
        }
    }
}

