/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.MacLightTexturedButtonPainter;
import com.mathworks.widgets.PopupMenuCustomizer;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class ActionButton
implements ComponentBuilder {
    private final DropdownButton fDropdownButton;

    private ActionButton(PopupMenuCustomizer popupMenuCustomizer) {
        this.fDropdownButton = new DropdownButton(DocumentIcon.ACTIONS.getIcon(), popupMenuCustomizer);
        this.fDropdownButton.setPopupMenuAlignment(DropdownButton.PopupAlignment.RIGHT);
    }

    public static ActionButton create(PopupMenuCustomizer popupMenuCustomizer) {
        ActionButton actionButton = new ActionButton(popupMenuCustomizer);
        actionButton.makeRegularButton();
        return actionButton;
    }

    public static ActionButton createToolBarStyle(PopupMenuCustomizer popupMenuCustomizer) {
        ActionButton actionButton = new ActionButton(popupMenuCustomizer);
        MJToolBar.configureButton((MJButton)actionButton.fDropdownButton);
        return actionButton;
    }

    @Override
    public JComponent getComponent() {
        return this.fDropdownButton;
    }

    private void makeRegularButton() {
        if (PlatformInfo.isMacintosh()) {
            ActionButton.makeRegularMacButton(this.fDropdownButton);
        } else if (PlatformInfo.isWindowsClassicAppearance()) {
            ActionButton.makeRegularWindowsClassicButton((AbstractButton)((Object)this.fDropdownButton));
        } else {
            ActionButton.makeDefaultButton((AbstractButton)((Object)this.fDropdownButton));
        }
    }

    private static void makeRegularMacButton(DropdownButton dropdownButton) {
        MacLightTexturedButtonPainter.make(dropdownButton);
    }

    private static void makeRegularWindowsClassicButton(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        abstractButton.setFocusPainted(false);
    }

    private static void makeDefaultButton(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(3, 3, 3, 3));
        abstractButton.setFocusPainted(false);
    }

    public void leftAlignPopup() {
        this.fDropdownButton.setPopupMenuAlignment(DropdownButton.PopupAlignment.LEFT);
    }
}

