/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.util.DebugUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import org.apache.commons.lang.StringUtils;

abstract class UDDPropertyChangeListener
implements PropertyChangeListener {
    private final UDDObject uddObject;
    private volatile Object oldValue;
    private volatile UDDListener preSetListener;
    private volatile UDDListener postSetListener;

    private boolean isDynamicProperty(String string) {
        PropertyDescriptor[] propertyDescriptorArray = this.uddObject.getDynamicProperties();
        if (propertyDescriptorArray != null) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                if (!string.equals(propertyDescriptor.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected UDDPropertyChangeListener(UDDObject uDDObject, final String string) {
        if (uDDObject == null) {
            throw new IllegalArgumentException("Argument \"uddObj\" must not be null");
        }
        assert (uDDObject.isValid()) : "UDD object is not valid.";
        if (StringUtils.isBlank((String)string)) {
            throw new IllegalArgumentException("Argument \"propName\" must not be empty.");
        }
        this.uddObject = uDDObject;
        MatlabEventQueue.invoke(new MatlabCallable<Void>(){

            @Override
            public void callOnEdt(Void void_, boolean bl) {
            }

            @Override
            public Void call() throws Exception {
                if (!UDDPropertyChangeListener.this.uddObject.isValid()) {
                    return null;
                }
                UDDObject uDDObject = UDDPropertyChangeListener.this.uddObject.findProperty(string);
                if (uDDObject == null) {
                    assert (DebugUtils.warning((String)("Property does not exist: " + string)));
                    return null;
                }
                final boolean bl = UDDPropertyChangeListener.this.isDynamicProperty(string);
                UDDPropertyChangeListener.this.preSetListener = new UDDListener(UDDPropertyChangeListener.this.uddObject, uDDObject, "PropertyPreSet", true){

                    @Override
                    public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
                        assert (UDDPropertyChangeListener.this.uddObject.isValid() && uDDObject2 != null && uDDObject2.isValid());
                        Object object = uDDObject2.getPropertyValue("AffectedObject");
                        assert (object != null);
                        assert (object instanceof UDDObject) : object.getClass().getName();
                        if (!bl) {
                            UDDPropertyChangeListener.this.oldValue = ((UDDObject)object).getPropertyValue(string);
                        } else {
                            UDDPropertyChangeListener.this.oldValue = ((UDDObject)object).getDynamicPropertyValue(string);
                        }
                    }
                };
                assert (UDDPropertyChangeListener.this.preSetListener.isValid());
                UDDPropertyChangeListener.this.postSetListener = new UDDListener(UDDPropertyChangeListener.this.uddObject, uDDObject, "PropertyPostSet", true){

                    @Override
                    public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
                        assert (UDDPropertyChangeListener.this.uddObject.isValid() && uDDObject2 != null && uDDObject2.isValid());
                        Object object = uDDObject2.getPropertyValue("AffectedObject");
                        assert (object != null);
                        assert (object instanceof UDDObject) : object.getClass().getName();
                        Object object2 = null;
                        object2 = !bl ? ((UDDObject)object).getPropertyValue(string) : ((UDDObject)object).getDynamicPropertyValue(string);
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, UDDPropertyChangeListener.this.oldValue, object2);
                        UDDPropertyChangeListener.this.propertyChange(propertyChangeEvent);
                        UDDPropertyChangeListener.this.oldValue = null;
                    }
                };
                assert (UDDPropertyChangeListener.this.postSetListener.isValid());
                return null;
            }
        });
    }

    public void dispose() {
        MatlabEventQueue.invoke(new MatlabCallable<Void>(){

            @Override
            public void callOnEdt(Void void_, boolean bl) {
            }

            @Override
            public Void call() throws Exception {
                if (UDDPropertyChangeListener.this.preSetListener != null && UDDPropertyChangeListener.this.preSetListener.isValid()) {
                    UDDPropertyChangeListener.this.preSetListener.setEnabled(false);
                    UDDPropertyChangeListener.this.preSetListener.dispose();
                    UDDPropertyChangeListener.this.preSetListener = null;
                }
                if (UDDPropertyChangeListener.this.postSetListener != null && UDDPropertyChangeListener.this.postSetListener.isValid()) {
                    UDDPropertyChangeListener.this.postSetListener.setEnabled(false);
                    UDDPropertyChangeListener.this.postSetListener.dispose();
                    UDDPropertyChangeListener.this.postSetListener = null;
                }
                return null;
            }
        });
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);
}

