/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabLooper;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.services.message.MWHandler;
import com.mathworks.services.message.MWMessage;
import java.awt.EventQueue;
import java.util.Enumeration;
import java.util.Hashtable;

public class MatlabMCR {
    private MatlabLooper fDispatcher;
    private int fThreadSafetyCheckLevel = 1;
    private static int sThreadSafetyCheckLevel = 1;
    protected String fClientName;
    private final int optionsMask = -256;
    private Hashtable<Integer, InterestHandler> fInterests;
    private int fNextHash = 0;

    public static void setDefaultThreadSafetyCheckLevel(int n) {
        sThreadSafetyCheckLevel = n;
    }

    public MatlabMCR(String string) {
        this.fClientName = string;
        this.fDispatcher = new MatlabLooper();
    }

    public MatlabMCR() {
        this("Java Client");
    }

    public void evalConsoleOutput(String string) {
        assert (string != null) : "evalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        Matlab.debugEcho(string);
        this.postMatlabMessage(mWMessage);
    }

    public void evalConsoleOutput(String string, CompletionObserver completionObserver) {
        assert (string != null) : "evalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        Matlab.debugEcho(string);
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void evalConsoleOutput(String string, MatlabListener matlabListener) {
        assert (string != null) : "evalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        Matlab.debugEcho(string);
        this.postAsync(mWMessage, null, matlabListener);
    }

    public void evalConsoleOutput(String string, CompletionObserver completionObserver, int n) {
        assert (string != null) : "evalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, n &= 0xFFFFFF00);
        Matlab.debugEcho(string);
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void evalNoOutput(String string) {
        assert (string != null) : "evalNoOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 516);
        Matlab.debugEcho(string);
        this.postMatlabMessage(mWMessage);
    }

    public void evalNoOutput(String string, int n) {
        this.evalNoOutput(string, n, false);
    }

    public void evalNoOutput(String string, int n, boolean bl) {
        assert (string != null) : "evalNoOutput requires non-null string";
        n &= 0xFFFFFF00;
        if (bl) {
            n |= 2;
        }
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 0x204 | n);
        Matlab.debugEcho(string);
        this.postMatlabMessage(mWMessage);
    }

    public void evalNoOutput(String string, CompletionObserver completionObserver) {
        assert (string != null) : "evalNoOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 516);
        Matlab.debugEcho(string);
        this.postMatlabMessage(mWMessage, new CompletionHandler(completionObserver, null));
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver) {
        assert (string != null) : "evalStreamOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 2);
        if (completionObserver == null) {
            this.postMatlabMessage(mWMessage);
        } else {
            this.postAsync(mWMessage, completionObserver, null);
        }
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver, int n) {
        assert (string != null) : "evalStreamOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 2 | (n &= 0xFFFFFF00));
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver, MWMessage mWMessage) {
        assert (string != null) : "evalStreamOutput requires non-null string";
        MWMessage mWMessage2 = this.makeNewMessage(-1);
        mWMessage2.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage2, 2);
        if (mWMessage != null) {
            mWMessage2.put((Object)"result", (Object)mWMessage);
        }
        this.postAsync(mWMessage2, completionObserver, null);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver, MWMessage mWMessage, int n) {
        assert (string != null) : "evalStreamOutput requires non-null string";
        MWMessage mWMessage2 = this.makeNewMessage(-1);
        mWMessage2.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage2, 2 | (n &= 0xFFFFFF00));
        if (mWMessage != null) {
            mWMessage2.put((Object)"result", (Object)mWMessage);
        }
        this.postAsync(mWMessage2, completionObserver, null);
    }

    public void eval(char c) {
        MWMessage mWMessage = new MWMessage(-13);
        mWMessage.put((Object)"arguments", (Object)c);
        this.postMatlabMessage(mWMessage);
    }

    public void eval(String string, CompletionObserver completionObserver) {
        assert (string != null) : "eval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 1);
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void eval(String string, MatlabListener matlabListener) {
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 1);
        this.postAsync(mWMessage, null, matlabListener);
    }

    public void eval(String string, CompletionObserver completionObserver, int n) {
        this.eval(string, completionObserver, n, false);
    }

    public void eval(String string, CompletionObserver completionObserver, int n, boolean bl) {
        assert (string != null) : "eval requires non-null string";
        n &= 0xFFFFFF00;
        if (bl) {
            n |= 2;
        }
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        if ((n & 0x400) == 1024) {
            Matlab.debugEcho(mWMessage);
            this.orWithFlags(mWMessage, n);
            this.postMatlabMessage(mWMessage);
        } else {
            this.orWithFlags(mWMessage, 1 | n);
            this.postAsync(mWMessage, completionObserver, null);
        }
    }

    public void eval(String string, MatlabListener matlabListener, int n) {
        assert (string != null) : "eval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        if (((n &= 0xFFFFFF00) & 0x400) == 1024) {
            this.orWithFlags(mWMessage, n);
        } else {
            this.orWithFlags(mWMessage, 1 | n);
        }
        this.postAsync(mWMessage, null, matlabListener);
    }

    public void fevalNoOutput(String string, Object[] objectArray) {
        assert (string != null) : "fEvalNoOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, null, null);
    }

    public void feval(String string, Object[] objectArray, CompletionObserver completionObserver) {
        assert (string != null) : "feval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void feval(String string, Object[] objectArray, int n, CompletionObserver completionObserver) {
        assert (string != null) : "feval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"nlhs", (Object)n);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void feval(String string, Object[] objectArray, int n, MatlabListener matlabListener) {
        assert (string != null) : "feval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"nlhs", (Object)n);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, null, matlabListener);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray, int n, CompletionObserver completionObserver) {
        assert (string != null) : "fevalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"nlhs", (Object)n);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, completionObserver, null);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray, int n, MatlabListener matlabListener) {
        assert (string != null) : "fevalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"nlhs", (Object)n);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, null, matlabListener);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray) {
        assert (string != null) : "fevalConsoleOutput requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        this.postAsync(mWMessage, null, null);
    }

    @Deprecated
    public String eval(String string) throws InterruptedException, MatlabException {
        assert (string != null) : "eval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-1);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 1);
        String string2 = (String)this.postSync(mWMessage);
        if (string2 == null) {
            string2 = "";
        }
        return string2.trim();
    }

    @Deprecated
    Object feval(String string, Object[] objectArray) throws InterruptedException, MatlabException {
        assert (string != null) : "feval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        return this.postSync(mWMessage);
    }

    @Deprecated
    Object feval(String string, Object[] objectArray, int n) throws InterruptedException, MatlabException {
        assert (string != null) : "feval requires non-null string";
        MWMessage mWMessage = this.makeNewMessage(-3);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"nlhs", (Object)n);
        this.orWithFlags(mWMessage, 516);
        if (objectArray != null) {
            mWMessage.put((Object)"arguments", (Object)objectArray);
        }
        return this.postSync(mWMessage);
    }

    void stderrString(String string) {
        assert (string != null) : "stderrString requires non-null string";
        MWMessage mWMessage = new MWMessage(-5);
        mWMessage.put((Object)"string", (Object)string);
        this.postAsync(mWMessage, null, null);
    }

    void stdoutString(String string) {
        assert (string != null) : "stdoutString requires non-null string";
        MWMessage mWMessage = new MWMessage(-4);
        mWMessage.put((Object)"string", (Object)string);
        this.postAsync(mWMessage, null, null);
    }

    public Object registerInterest(int n, int n2, CompletionObserver completionObserver) {
        if (this.fInterests == null) {
            this.fInterests = new Hashtable(17);
        }
        MWMessage mWMessage = new MWMessage(-8);
        mWMessage.put((Object)"familyid", (Object)n);
        mWMessage.put((Object)"eventid", (Object)n2);
        Integer n3 = this.fNextHash++;
        InterestHandler interestHandler = new InterestHandler(completionObserver, null);
        this.fInterests.put(n3, interestHandler);
        this.fDispatcher.postMatlabMessage(mWMessage, interestHandler);
        return n3;
    }

    public static boolean setEchoEval(boolean bl) {
        return Matlab.setEchoEval(bl);
    }

    public void unregisterInterest(Object object) {
        if (this.fInterests == null) {
            return;
        }
        InterestHandler interestHandler = this.fInterests.get(object);
        if (interestHandler == null) {
            return;
        }
        if (interestHandler.getInterestID() == 0) {
            interestHandler.cancelInterest();
        } else {
            MWMessage mWMessage = new MWMessage(-9);
            mWMessage.put((Object)"interest", (Object)interestHandler.getInterestID());
            this.postMatlabMessage(mWMessage);
        }
        this.fInterests.remove(object);
    }

    public void unregisterAll() {
        if (this.fInterests == null) {
            return;
        }
        Enumeration<InterestHandler> enumeration = this.fInterests.elements();
        while (enumeration.hasMoreElements()) {
            InterestHandler interestHandler = enumeration.nextElement();
            if (interestHandler.getInterestID() == 0) {
                interestHandler.cancelInterest();
                continue;
            }
            MWMessage mWMessage = new MWMessage(-9);
            mWMessage.put((Object)"interest", (Object)interestHandler.getInterestID());
            this.postMatlabMessage(mWMessage);
        }
        this.fInterests = null;
    }

    private void postMatlabMessage(MWMessage mWMessage) {
        this.postMatlabMessage(mWMessage, null);
    }

    private void postMatlabMessage(MWMessage mWMessage, MWHandler mWHandler) {
        this.fDispatcher.postMatlabMessage(mWMessage, mWHandler);
    }

    public void interrupt() {
        Matlab.fireEvent(new MatlabEvent(2));
        MWMessage mWMessage = new MWMessage(-7);
        this.postMatlabMessage(mWMessage);
    }

    public void setWindowSize(int n, int n2) {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        MWMessage mWMessage = new MWMessage(-14);
        mWMessage.put((Object)"lineno", (Object)n);
        if (n2 > 0) {
            mWMessage.put((Object)"arguments", (Object)n2);
        }
        this.postMatlabMessage(mWMessage);
    }

    public void whenMatlabIdle(Runnable runnable) {
        this.fDispatcher.postMatlabRunnable(runnable, true);
    }

    public void whenMatlabReady(Runnable runnable) {
        this.fDispatcher.postMatlabRunnable(runnable, false);
    }

    public void timerRequest(Runnable runnable) {
        this.fDispatcher.postMatlabTimerRunnable(runnable);
    }

    public static void mtEval(String string) throws Exception {
        Matlab.mtEval(string);
    }

    public static Object mtEval(String string, int n) throws Exception {
        return Matlab.mtEval(string, n);
    }

    public static Object mtFeval(String string, Object[] objectArray, int n) throws Exception {
        return Matlab.mtFeval(string, objectArray, n);
    }

    public static Object mtFevalConsoleOutput(String string, Object[] objectArray, int n) throws Exception {
        return Matlab.mtFevalConsoleOutput(string, objectArray, n);
    }

    public static Object mtGet(double d, String[] stringArray) throws Exception {
        return Matlab.mtGet(d, stringArray);
    }

    public static Object mtGet(double d, String string) throws Exception {
        return Matlab.mtGet(d, string);
    }

    public static void mtSet(double d, String[] stringArray, Object[] objectArray) throws Exception {
        Matlab.mtSet(d, stringArray, objectArray);
    }

    public static void mtSet(double d, String string, Object object) throws Exception {
        Matlab.mtSet(d, string, object);
    }

    public int maxTabCompletions() {
        MWMessage mWMessage = new MWMessage(-18);
        this.postMatlabMessage(mWMessage);
        return (Integer)mWMessage.get((Object)"result");
    }

    public String[] mtFindAllTabCompletions1(String string) throws Exception {
        assert (string != null) : "mtFindAllTabCompletions1 requires non-null string";
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)"cmd", (Object)8);
        mWMessage.put((Object)"string", (Object)string);
        return (String[])MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public String[] mtFindAllTabCompletions(String string) throws Exception {
        return this.mtFindAllTabCompletions(string, 0);
    }

    public String[] mtFindAllTabCompletions(String string, int n) throws Exception {
        assert (string != null) : "mtFindAllTabCompletions requires non-null string";
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)"cmd", (Object)8);
        mWMessage.put((Object)"string", (Object)string);
        mWMessage.put((Object)"value", (Object)n);
        return (String[])MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public String mtFormTabCompletion(int n) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)"cmd", (Object)5);
        mWMessage.put((Object)"status", (Object)n);
        return (String)MatlabLooper.sendMatlabMessage(mWMessage);
    }

    protected MWMessage makeNewMessage(int n) {
        MWMessage mWMessage = new MWMessage(n);
        mWMessage.put((Object)"client", (Object)this.fClientName);
        return mWMessage;
    }

    private void orWithFlags(MWMessage mWMessage, int n) {
        Object object = mWMessage.get((Object)"flags");
        if (object != null) {
            int n2 = (Integer)object;
            n = n2 | n;
        }
        mWMessage.put((Object)"flags", (Object)n);
    }

    private Object postSync(MWMessage mWMessage) throws MatlabException, InterruptedException {
        assert (!NativeMatlab.nativeIsMatlabThread()) : "Must not call this synchronous method from the MATLAB main thread. Consider using mtFeval.";
        int n = this.fThreadSafetyCheckLevel;
        if (n == 0) {
            n = sThreadSafetyCheckLevel;
        }
        if (n > 0) assert (!EventQueue.isDispatchThread()) : "Must not call this synchronous method from the AWT event dispatch thread. Consider using a MatlabWorker.";
        BlockingObserver blockingObserver = new BlockingObserver();
        this.postAsync(mWMessage, blockingObserver, null);
        blockingObserver.waitForReply();
        if (blockingObserver.getStatus() < 0) {
            throw new MatlabException();
        }
        return blockingObserver.getResult();
    }

    private void postAsync(MWMessage mWMessage, CompletionObserver completionObserver, MatlabListener matlabListener) {
        Matlab.debugEcho(mWMessage);
        CompletionHandler completionHandler = null;
        if (completionObserver != null || matlabListener != null) {
            completionHandler = new CompletionHandler(completionObserver, matlabListener);
        }
        this.fDispatcher.postMatlabMessage(mWMessage, completionHandler);
    }

    public int setThreadSafetyCheckLevel(int n) {
        int n2 = this.fThreadSafetyCheckLevel;
        this.fThreadSafetyCheckLevel = n;
        return n2;
    }

    private class AWTReplyEvent
    implements Runnable {
        private MatlabListener fListener;
        private Object fResult;
        private int fStatus;

        public AWTReplyEvent(MatlabListener matlabListener, int n, Object object) {
            this.fListener = matlabListener;
            this.fResult = object;
            this.fStatus = n;
        }

        @Override
        public void run() {
            if (this.fListener != null) {
                this.fListener.matlabEvent(new MatlabEvent(3, this.fStatus, this.fResult));
            }
        }
    }

    private class InterestHandler
    extends MWHandler {
        private CompletionObserver fObserver;
        private MatlabListener fListener;
        private int fInterestID;
        private boolean fHaveID = false;

        InterestHandler(CompletionObserver completionObserver, MatlabListener matlabListener) {
            this.fObserver = completionObserver;
            this.fListener = matlabListener;
        }

        public void messageReceived(MWMessage mWMessage) {
            if (mWMessage.getType() == -10) {
                if (!this.fHaveID) {
                    this.fHaveID = true;
                    Integer n = (Integer)mWMessage.get((Object)"interest");
                    if (n != null) {
                        if (this.fInterestID == -1) {
                            MWMessage mWMessage2 = new MWMessage(-9);
                            mWMessage2.put((Object)"interest", (Object)n);
                            MatlabMCR.this.postMatlabMessage(mWMessage2);
                        } else {
                            this.fInterestID = n;
                        }
                    }
                }
                if (this.fObserver != null) {
                    this.fObserver.completed(0, mWMessage);
                } else if (this.fListener != null) {
                    EventQueue.invokeLater(new AWTReplyEvent(this.fListener, 0, mWMessage));
                }
            }
        }

        int getInterestID() {
            return this.fInterestID;
        }

        void cancelInterest() {
            this.fInterestID = -1;
        }
    }

    private class CompletionHandler
    extends MWHandler {
        private CompletionObserver fObserver;
        private MatlabListener fListener;

        CompletionHandler(CompletionObserver completionObserver, MatlabListener matlabListener) {
            this.fObserver = completionObserver;
            this.fListener = matlabListener;
        }

        public void messageReceived(MWMessage mWMessage) {
            int n = 0;
            if (mWMessage.getType() == -2 && (this.fObserver != null || this.fListener != null)) {
                Object object = mWMessage.get((Object)"result");
                Integer n2 = (Integer)mWMessage.get((Object)"status");
                if (n2 != null) {
                    n = n2;
                }
                if (this.fObserver != null) {
                    this.fObserver.completed(n, object);
                } else if (this.fListener != null) {
                    EventQueue.invokeLater(new AWTReplyEvent(this.fListener, n, object));
                }
            }
        }
    }

    private final class BlockingObserver
    implements CompletionObserver {
        private int fStatus;
        private Object fResult;
        private boolean fCompleted = false;

        BlockingObserver() {
        }

        @Override
        public synchronized void completed(int n, Object object) {
            this.fStatus = n;
            this.fResult = object;
            this.fCompleted = true;
            this.notifyAll();
        }

        synchronized void waitForReply() throws InterruptedException {
            while (!this.fCompleted) {
                this.wait();
            }
        }

        int getStatus() {
            return this.fStatus;
        }

        Object getResult() {
            return this.fResult;
        }
    }
}

