/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.DefaultGroupPolicy;
import com.sun.jini.phoenix.GroupPolicy;
import com.sun.jini.phoenix.LocalAccess;
import com.sun.jini.phoenix.SystemPermission;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationSystem;
import java.rmi.server.ExportException;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ServerCapabilities;

public class SystemAccessILFactory
extends BasicILFactory {
    private final GroupPolicy policy;
    private final boolean localAccessCheck;

    public SystemAccessILFactory() {
        this(new DefaultGroupPolicy(), null);
    }

    public SystemAccessILFactory(GroupPolicy groupPolicy, ClassLoader classLoader) {
        super(null, null, classLoader);
        this.policy = groupPolicy;
        this.localAccessCheck = true;
    }

    public SystemAccessILFactory(MethodConstraints methodConstraints) {
        this(methodConstraints, SystemPermission.class, new DefaultGroupPolicy(), null);
    }

    public SystemAccessILFactory(MethodConstraints methodConstraints, Class clazz, GroupPolicy groupPolicy, ClassLoader classLoader) {
        super(methodConstraints, clazz, classLoader);
        this.policy = groupPolicy;
        this.localAccessCheck = false;
    }

    protected InvocationDispatcher createInvocationDispatcher(Collection collection, Remote remote, ServerCapabilities serverCapabilities) throws ExportException {
        if (remote == null) {
            throw new NullPointerException("impl cannot be null");
        }
        if (!(remote instanceof ActivationSystem)) {
            throw new ExportException("cannot create dispatcher", new IllegalArgumentException("impl must be an ActivationSystem"));
        }
        return new SystemDispatcher(collection, remote, serverCapabilities, this.getServerConstraints(), this.getPermissionClass(), this.policy, this.localAccessCheck, this.getClassLoader());
    }

    public static class SystemDispatcher
    extends BasicInvocationDispatcher {
        private final GroupPolicy policy;
        private final boolean localAccessCheck;

        public SystemDispatcher(Collection collection, Remote remote, ServerCapabilities serverCapabilities, MethodConstraints methodConstraints, Class clazz, GroupPolicy groupPolicy, boolean bl, ClassLoader classLoader) throws ExportException {
            super(collection, serverCapabilities, methodConstraints, clazz, classLoader);
            if (remote == null) {
                throw new NullPointerException("impl is null");
            }
            if (!(remote instanceof ActivationSystem)) {
                throw new IllegalArgumentException("impl not an ActivationSystem instance");
            }
            this.policy = groupPolicy;
            this.localAccessCheck = bl;
        }

        protected void checkAccess(Remote remote, Method method, InvocationConstraints invocationConstraints, Collection collection) {
            if (this.localAccessCheck) {
                LocalAccess.check();
            } else {
                super.checkAccess(remote, method, invocationConstraints, collection);
            }
        }

        protected Object invoke(Remote remote, Method method, Object[] objectArray, Collection collection) throws Throwable {
            String string;
            if (this.policy != null && ((string = method.getName()).equals("registerGroup") || string.equals("setActivationGroupDesc"))) {
                this.policy.checkGroup((ActivationGroupDesc)objectArray[objectArray.length - 1]);
            }
            return super.invoke(remote, method, objectArray, collection);
        }
    }
}

