/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.helpers;

import com.mathworks.mvm.MvmImpl;
import com.mathworks.util.PlatformInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public final class MatlabPrintStreamManager {
    private static MatlabPrintStreamManager sInstance = null;
    private final PrintStream fOriginalSystemOut = System.out;
    private final PrintStream fOriginalSystemErr = System.err;

    public static synchronized MatlabPrintStreamManager getInstance() {
        if (null == sInstance) {
            sInstance = new MatlabPrintStreamManager();
        }
        return sInstance;
    }

    public static OutputStream createMatlabOutputStream() {
        return new MatlabOutStream();
    }

    public static OutputStream createMatlabErrorStream() {
        return new MatlabErrStream();
    }

    private MatlabPrintStreamManager() {
    }

    private void installPrintStreams() {
        System.setOut(new PrintStream(MatlabPrintStreamManager.createMatlabOutputStream(), true));
        System.setErr(new PrintStream(MatlabPrintStreamManager.createMatlabErrorStream(), true));
    }

    private void restorePrintStreams() {
        System.setOut(this.getOriginalSystemOut());
        System.setErr(this.getOriginalSystemErr());
    }

    public PrintStream getOriginalSystemOut() {
        return this.fOriginalSystemOut;
    }

    public PrintStream getOriginalSystemErr() {
        return this.fOriginalSystemErr;
    }

    private static final class MatlabErrStream
    extends MatlabStream {
        private MatlabErrStream() {
        }

        private static boolean stackTraceContainsAccessibilityMethod() {
            if (PlatformInfo.isMacintosh()) {
                StackTraceElement[] stackTraceElementArray;
                for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
                    String string = stackTraceElement.toString();
                    if (!string.contains("apple.awt.CAccessible.getCAccessible")) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        void matlabFlush(String string) {
            boolean bl = MatlabErrStream.stackTraceContainsAccessibilityMethod();
            if (!bl) {
                MvmImpl.loadLibrary();
                this.nativeWrite(string);
            }
        }

        private native void nativeWrite(String var1);
    }

    private static final class MatlabOutStream
    extends MatlabStream {
        private MatlabOutStream() {
        }

        @Override
        void matlabFlush(String string) {
            MvmImpl.loadLibrary();
            this.nativeWrite(string);
        }

        private native void nativeWrite(String var1);
    }

    private static abstract class MatlabStream
    extends ByteArrayOutputStream {
        MatlabStream() {
            super(256);
        }

        @Override
        public final void close() {
            this.flush();
        }

        abstract void matlabFlush(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void flush() {
            MatlabStream matlabStream = this;
            synchronized (matlabStream) {
                if (this.size() != 0) {
                    String string = this.toString();
                    this.reset();
                    this.matlabFlush(string);
                }
            }
        }

        @Override
        public final synchronized void write(byte[] byArray, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            if (PlatformInfo.isWindows() && n2 == 2 && byArray[n3] == 13 && byArray[n3 + 1] == 10) {
                ++n3;
                --n4;
            }
            super.write(byArray, n3, n4);
        }
    }
}

