/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.exec.MvmCancellationException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.mvm.exec.MvmInterruptedException;
import com.mathworks.mvm.exec.NativeFutureResult;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class FutureResult<V>
implements Future<V> {
    private final NativeFutureResult<V> fNativeFutureResult;
    private final int fNlhs;
    private volatile CancelState fCancelState = CancelState.NONE;
    private static final double DEFAULT_INTERVAL_SECS = 1.0;

    FutureResult(NativeFutureResult<V> nativeFutureResult) {
        this(nativeFutureResult, 0);
    }

    FutureResult(NativeFutureResult<V> nativeFutureResult, int n) {
        this.fNativeFutureResult = nativeFutureResult;
        this.fNlhs = n;
    }

    public int getNlhs() {
        return this.fNlhs;
    }

    @Override
    public synchronized boolean cancel(boolean bl) {
        if (this.fCancelState != CancelState.NONE) {
            return false;
        }
        boolean bl2 = this.fNativeFutureResult.cancel(bl);
        this.fCancelState = bl2 ? CancelState.SUBMITTED : CancelState.FAILED;
        return bl2;
    }

    public void waitForCompletion() throws InterruptedException, IllegalStateException {
        this.waitInternal(0L, null, false);
    }

    public boolean waitForCompletion(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.waitInternal(l, timeUnit, false);
    }

    @Override
    public synchronized boolean isCancelled() {
        if (this.fCancelState == CancelState.NONE && this.fNativeFutureResult.isCancelled()) {
            this.fCancelState = CancelState.SUBMITTED;
        }
        return this.fCancelState == CancelState.SUBMITTED;
    }

    @Override
    public boolean isDone() {
        return this.fCancelState != CancelState.NONE || this.fNativeFutureResult.isDone();
    }

    public void runWhenDone(@Nullable Runnable runnable) {
        this.fNativeFutureResult.runWhenDone(runnable);
    }

    @Override
    public V get() throws InterruptedException, MvmExecutionException, MvmCancellationException, CancellationException, IllegalStateException {
        this.waitInternal(0L, null, true);
        return this.getInternal();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, MvmExecutionException, MvmCancellationException, CancellationException, IllegalStateException, TimeoutException {
        boolean bl = this.waitInternal(l, timeUnit, true);
        if (!bl) {
            throw new TimeoutException();
        }
        return this.getInternal();
    }

    private boolean waitInternal(long l, @Nullable TimeUnit timeUnit, boolean bl) throws IllegalStateException, InterruptedException, CancellationException {
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (!this.isDone() && SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Blocking in Event Dispatch Thread not allowed");
        }
        long l2 = timeUnit == null ? 0L : System.currentTimeMillis();
        long l3 = timeUnit == null ? 0L : l2 + TimeUnit.MILLISECONDS.convert(l, timeUnit);
        double d = 1.0;
        boolean bl2 = false;
        do {
            boolean bl3 = this.isCancelled();
            if (timeUnit != null) {
                long l4 = l3 - l2;
                double d2 = (double)l4 / 1000.0;
                if (d2 < d) {
                    d = d2;
                }
                if (bl2) {
                    Thread.sleep((long)d);
                }
            }
            if (!bl2) {
                try {
                    boolean bl4 = this.fNativeFutureResult.waitForCompletion(d);
                    if (bl4) {
                        return true;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (timeUnit == null) {
                        throw new IllegalStateException("Call to get() or waitForCompletion() in MATLAB thread would block forever");
                    }
                    bl2 = true;
                    continue;
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
            if (bl && bl3) {
                throw new CancellationException();
            }
            if (timeUnit == null) continue;
            l2 = System.currentTimeMillis();
        } while (timeUnit == null || l2 < l3);
        return false;
    }

    protected V getInternal() throws InterruptedException, MvmExecutionException, CancellationException {
        V v;
        try {
            v = this.fNativeFutureResult.get();
        }
        catch (MvmExecutionException mvmExecutionException) {
            if (mvmExecutionException.getMvmCause() instanceof MvmInterruptedException) {
                throw new MvmCancellationException((MvmInterruptedException)mvmExecutionException.getMvmCause());
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            throw mvmExecutionException;
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        V v2 = v;
        return v2;
    }

    private static enum CancelState {
        NONE,
        SUBMITTED,
        FAILED;

    }
}

