/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsOrganizer;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTMenuContributor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class ShortcutsToolbar
extends MJToolBar
implements DTMenuContributor {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    private static final String SHORTCUT_TOOLBAR = "ShortcutToolbar";
    private static final String SHOW_LABELS = "ShowLabels";
    private MJToolBar fToolbar = this;
    private Matlab fMatlab;
    private boolean fShowFullLabel = true;
    private MJLabel fToolbarLabel;
    private String fCategory;
    private MJPopupMenu fPop;
    private PopupMouseListener fMouseList;
    private DropTargetListener fDropTargetListener = null;

    public ShortcutsToolbar(String string) {
        this(string, false);
    }

    public ShortcutsToolbar(String string, boolean bl) {
        super(sRes.getString("shortcut.WindowTitle"));
        if (bl) {
            this.fPop = new MJPopupMenu();
            this.fMouseList = new PopupMouseListener();
            this.addMouseListener(this.fMouseList);
        }
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab();
        }
        this.fCategory = string;
        this.setFloatable(false);
        this.fShowFullLabel = Prefs.getBooleanPref((String)"ShortcutToolbarShowLabels", (boolean)true);
        this.createButtons();
        ShortcutUtils.addFavoritesListener(new ShortcutsListener());
        this.fDropTargetListener = new DragListener();
        new DropTarget((Component)((Object)this), this.fDropTargetListener);
    }

    private void shortcutsChanged() {
        this.fToolbar.removeAll();
        this.createButtons();
        this.fToolbar.revalidate();
        this.fToolbar.repaint();
    }

    private void savePrefs(boolean bl) {
        Prefs.setBooleanPref((String)"ShortcutToolbarShowLabels", (boolean)bl);
    }

    private void createButtons() {
        this.fToolbarLabel = new MJLabel(sRes.getString("shortcut.ToolbarTitle"));
        this.fToolbarLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.fToolbar.add((Component)this.fToolbarLabel);
        Vector vector = ShortcutUtils.getShortcutsByCategory(this.fCategory);
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component;
            Shortcut shortcut = (Shortcut)enumeration.nextElement();
            if (this.fShowFullLabel) {
                MJButton mJButton = new MJButton((Action)((Object)new ToolbarAction(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIcon(), shortcut.getIconPath(), true)));
                mJButton.setAutoMnemonicEnabled(false);
                mJButton.setText(shortcut.getLabel());
                mJButton.setIcon((Icon)shortcut.getIcon());
                mJButton.setBorderPainted(false);
                mJButton.setMargin(new Insets(1, 1, 1, 1));
                mJButton.setToolTipText(ShortcutsToolbar.getShortcutToolTip(shortcut));
                if (this.fPop != null) {
                    mJButton.addMouseListener((MouseListener)this.fMouseList);
                }
                mJButton.setFocusTraversable(false);
                if (!PlatformInfo.isMacintosh()) {
                    mJButton.setFlyOverAppearance(true);
                    if (PlatformInfo.isWindows() && !PlatformInfo.useWindowsXPAppearance()) {
                        mJButton.setBorder(MJToolBar.getFlyOverBorder());
                    }
                } else {
                    mJButton.setBorderPainted(false);
                    mJButton.setPressedIcon(ShortcutsToolbar.createMacPressedIcon((Icon)mJButton.getIcon()));
                }
                mJButton.setRolloverEnabled(true);
                component = this.fToolbar.add((Component)mJButton);
                continue;
            }
            component = this.fToolbar.add((Action)((Object)new ToolbarAction(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIcon(), shortcut.getIconPath(), true)));
            component.addMouseListener(this.fMouseList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getShortcutToolTip(Shortcut shortcut) {
        if (shortcut == null || shortcut.getCallback() == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new StringReader(shortcut.getCallback()));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("% ")) {
                    string = string.substring(1).trim();
                } else if (string.startsWith("%% ")) {
                    string = string.substring(2).trim();
                }
                if (string.length() <= 0) continue;
                String string2 = string;
                return string2;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Object object;
        int n = 0;
        Component component = mouseEvent.getComponent();
        if (component instanceof JButton && (object = ((JButton)component).getAction()) instanceof ToolbarAction) {
            jPopupMenu.add((Component)new MJMenuItem((Action)((Object)new EditShortcutAction((ToolbarAction)((Object)object)))), n++);
            jPopupMenu.add((Component)new MJMenuItem((Action)((Object)new DeleteShortcutAction((ToolbarAction)((Object)object)))), n++);
            jPopupMenu.add((Component)new JSeparator(), n++);
        }
        object = new ShowLabelAction();
        MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(object);
        mJCheckBoxMenuItem.setSelected(this.fShowFullLabel);
        jPopupMenu.add((Component)mJCheckBoxMenuItem, n++);
        CreateShortcutAction createShortcutAction = new CreateShortcutAction();
        jPopupMenu.add((Component)new MJMenuItem((Action)((Object)createShortcutAction)), n++);
        OrganizeAction organizeAction = new OrganizeAction();
        jPopupMenu.add((Component)new MJMenuItem((Action)((Object)organizeAction)), n++);
        HelpAction helpAction = new HelpAction();
        jPopupMenu.add((Component)new MJMenuItem((Action)((Object)helpAction)), n++);
        if (this.fPop == null) {
            jPopupMenu.add((Component)new JSeparator(), n++);
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJFrame mJFrame = new MJFrame("Test Toolbar Frame");
                mJFrame.setDefaultCloseOperation(3);
                MJTextArea mJTextArea = new MJTextArea(5, 30);
                mJTextArea.setEditable(false);
                MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTextArea);
                mJFrame.setSize(new Dimension(450, 130));
                mJFrame.setLocation(200, 200);
                String string = "Test Toolbar Shortcuts";
                Vector vector = ShortcutUtils.getShortcutsByCategory(string);
                if (vector == null || vector.size() == 0) {
                    ShortcutUtils.addNewCategory(string);
                    ShortcutUtils.addShortcutToBottom("foo", "xyz", null, string, "true");
                    ShortcutUtils.addShortcutToBottom("foobar", "xyz", null, string, "true");
                }
                ShortcutsToolbar shortcutsToolbar = new ShortcutsToolbar(string, true);
                DTClientBase dTClientBase = new DTClientBase();
                dTClientBase.setLayout((LayoutManager)new BorderLayout());
                dTClientBase.add((Component)((Object)shortcutsToolbar), (Object)"First");
                dTClientBase.add((Component)mJScrollPane, (Object)"Center");
                dTClientBase.setOpaque(true);
                mJFrame.setContentPane((Container)dTClientBase);
                mJFrame.pack();
                mJFrame.setVisible(true);
            }
        });
    }

    class DragListener
    implements DropTargetListener {
        DragListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
                Transferable transferable = dropTargetDropEvent.getTransferable();
                String string = null;
                try {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ShortcutsToolbar.this.fToolbar.setCursor(Cursor.getPredefinedCursor(3));
                ShortcutEditor.invoke(sRes.getString("shortcut.AddTitle"), null, string, null, ShortcutsToolbar.this.fCategory);
                ShortcutsToolbar.this.fToolbar.setCursor(Cursor.getDefaultCursor());
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    class OrganizeAction
    extends MJAbstractAction {
        public OrganizeAction() {
            super(sRes.getString("shortcut.OrganizeShortcuts"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsOrganizer.invoke((Frame)SwingUtilities.windowForComponent((Component)ShortcutsToolbar.this.fToolbar));
        }
    }

    class CreateShortcutAction
    extends MJAbstractAction {
        public CreateShortcutAction() {
            super(sRes.getString("shortcut.NewShortcut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.invoke(null, "", null, ShortcutsToolbar.this.fCategory, true);
        }
    }

    class DeleteShortcutAction
    extends MJAbstractAction {
        ToolbarAction fAction;

        public DeleteShortcutAction(ToolbarAction toolbarAction) {
            super(sRes.getString("shortcut.DeleteShortcut"));
            this.fAction = toolbarAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.fAction.getLabel();
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(sRes.getString("shortcut.ConfirmDelete"), objectArray);
            int n = JOptionPane.showConfirmDialog((Component)ShortcutsToolbar.this.fToolbar, string2, sRes.getString("shortcut.ConfirmDeleteTitle"), 2);
            if (n == 0) {
                ShortcutUtils.removeShortcut(ShortcutsToolbar.this.fCategory, string);
            }
        }
    }

    class EditShortcutAction
    extends MJAbstractAction {
        ToolbarAction fAction;

        public EditShortcutAction(ToolbarAction toolbarAction) {
            super(sRes.getString("shortcut.EditShortcut"));
            this.fAction = toolbarAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.fAction.getLabel();
            String string2 = this.fAction.getIcon();
            String string3 = this.fAction.getCallback();
            ShortcutsToolbar.this.fToolbar.setCursor(Cursor.getPredefinedCursor(3));
            ShortcutEditor.invoke(string, string3, string2, ShortcutsToolbar.this.fCategory, false);
            ShortcutsToolbar.this.fToolbar.setCursor(Cursor.getDefaultCursor());
        }
    }

    class HelpAction
    extends MJAbstractAction {
        public HelpAction() {
            super(sRes.getString("shortcut.Help"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"matlab_shortcuts");
        }
    }

    public class ShowLabelAction
    extends MJAbstractAction {
        public ShowLabelAction() {
            super(sRes.getString("shortcut.ToggleLabels"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsToolbar.this.fShowFullLabel = !ShortcutsToolbar.this.fShowFullLabel;
            ShortcutsToolbar.this.savePrefs(ShortcutsToolbar.this.fShowFullLabel);
            ShortcutsToolbar.this.shortcutsChanged();
        }
    }

    public class ShortcutsListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsToolbar.this.shortcutsChanged();
        }
    }

    public class ToolbarAction
    extends MJAbstractAction {
        private String fCallback;
        private String fName;
        private String fIcon;

        public ToolbarAction(String string, String string2, Icon icon, String string3, boolean bl) {
            this.fCallback = string2;
            this.fName = string;
            this.fIcon = string3;
            if (bl) {
                this.setButtonOnlyIcon(icon);
            }
            this.setTip(string);
            this.setName(string, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShortcutsToolbar.this.fMatlab != null) {
                ShortcutsToolbar.this.fMatlab.evalConsoleOutput(this.fCallback);
            }
        }

        public String getCallback() {
            return this.fCallback;
        }

        public String getLabel() {
            return this.fName;
        }

        public String getIcon() {
            return this.fIcon;
        }
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        void showPopup(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component && ShortcutsToolbar.this.fPop != null) {
                ShortcutsToolbar.this.fPop.removeAll();
                ShortcutsToolbar.this.contributeToMenu((JPopupMenu)ShortcutsToolbar.this.fPop, mouseEvent);
                ShortcutsToolbar.this.fPop.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

